/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.util.StringUtilKt;
import com.jetbrains.rider.editorActions.RangePair;
import com.jetbrains.rider.editorActions.TextModificationSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u000e\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"delta", "", "Lcom/jetbrains/rider/editorActions/RangePair;", "getDelta", "(Lcom/jetbrains/rider/editorActions/RangePair;)I", "applyChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "optimize", "initialDocumentText", "", "shiftNewRange", "toTextChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "intellij.rider.rdclient.dotnet"})
public final class RangePairKt {
    public static final int getDelta(@NotNull RangePair $this$delta) {
        Intrinsics.checkNotNullParameter((Object)$this$delta, (String)"<this>");
        boolean bl = false;
        return $this$delta.getNewRange().getLength() - $this$delta.getOldRange().getLength();
    }

    @NotNull
    public static final RangePair shiftNewRange(@NotNull RangePair $this$shiftNewRange, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftNewRange, (String)"<this>");
        TextRange textRange = $this$shiftNewRange.getOldRange();
        TextRange textRange2 = $this$shiftNewRange.getNewRange().shiftRight(delta);
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
        return new RangePair(textRange, textRange2, $this$shiftNewRange.getNewText(), $this$shiftNewRange.getModificationSide());
    }

    @NotNull
    public static final RangePair toTextChange(@NotNull RdTextChange $this$toTextChange) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextChange, (String)"<this>");
        TextRange textRange = TextRange.from((int)$this$toTextChange.getStartOffset(), (int)$this$toTextChange.getOld().length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange textRange2 = textRange;
        TextRange textRange3 = TextRange.from((int)$this$toTextChange.getStartOffset(), (int)$this$toTextChange.getNew().length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"from(...)");
        TextRange textRange4 = textRange3;
        TextModificationSide textModificationSide = switch (WhenMappings.$EnumSwitchMapping$0[$this$toTextChange.getKind().ordinal()]) {
            case 1 -> TextModificationSide.LeftSide;
            case 2 -> TextModificationSide.RightSide;
            case 3 -> throw new IllegalArgumentException("Unexpected kind");
            case 4 -> throw new IllegalArgumentException("Unexpected kind");
            default -> TextModificationSide.NotSpecified;
        };
        return new RangePair(textRange2, textRange4, $this$toTextChange.getNew(), textModificationSide);
    }

    @NotNull
    public static final RangePair optimize(@NotNull RangePair $this$optimize, @NotNull CharSequence initialDocumentText) {
        Intrinsics.checkNotNullParameter((Object)$this$optimize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initialDocumentText, (String)"initialDocumentText");
        if ($this$optimize.isEmpty()) {
            return $this$optimize;
        }
        TextRange textRange = $this$optimize.getOldRange();
        TextRange textRange2 = $this$optimize.getNewRange();
        CharSequence charSequence = initialDocumentText.subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        ImmutableCharSequence immutableCharSequence = $this$optimize.getNewText();
        int n2 = StringUtilKt.getCommonPrefixLength((CharSequence)charSequence, (CharSequence)((CharSequence)immutableCharSequence));
        int n3 = StringUtilKt.getCommonSuffixLength((CharSequence)charSequence, (CharSequence)((CharSequence)immutableCharSequence), (int)n2);
        if (n2 == 0 && n3 == 0) {
            return $this$optimize;
        }
        TextRange textRange3 = new TextRange(textRange.getStartOffset() + n2, textRange.getEndOffset() - n3);
        TextRange textRange4 = new TextRange(textRange2.getStartOffset() + n2, textRange2.getEndOffset() - n3);
        ImmutableCharSequence immutableCharSequence2 = immutableCharSequence.subtext(n2, immutableCharSequence.length() - n3);
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence2, (String)"subtext(...)");
        ImmutableCharSequence immutableCharSequence3 = immutableCharSequence2;
        return new RangePair(textRange3, textRange4, immutableCharSequence3, TextModificationSide.NotSpecified);
    }

    public static final void applyChange(@NotNull RangePair $this$applyChange, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$applyChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange textRange = $this$applyChange.getOldRange();
        TextRange textRange2 = $this$applyChange.getNewRange();
        switch (WhenMappings.$EnumSwitchMapping$1[$this$applyChange.getModificationSide().ordinal()]) {
            case 1: {
                if (!textRange.isEmpty() && !textRange2.isEmpty()) {
                    document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)$this$applyChange.getNewText());
                    break;
                }
                if (!textRange.isEmpty() && textRange2.isEmpty()) {
                    document.deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                    break;
                }
                if (!textRange.isEmpty() || textRange2.isEmpty()) break;
                document.insertString(textRange.getStartOffset(), (CharSequence)$this$applyChange.getNewText());
                break;
            }
            case 2: {
                int n2 = Math.min(document.getTextLength(), textRange.getEndOffset() + 1);
                String string = $this$applyChange.getNewText().toString() + document.getText(new TextRange(textRange.getEndOffset(), n2));
                document.replaceString(textRange.getStartOffset(), n2, (CharSequence)string);
                break;
            }
            case 3: {
                int n3 = Math.max(0, textRange.getStartOffset() - 1);
                String string = document.getText(new TextRange(n3, textRange.getStartOffset())) + $this$applyChange.getNewText();
                document.replaceString(n3, textRange.getStartOffset(), (CharSequence)string);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RdTextChangeKind.values().length];
            try {
                nArray[RdTextChangeKind.InsertLeftSide.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertRightSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.PromoteVersion.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Reset.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextModificationSide.values().length];
            try {
                nArray[TextModificationSide.NotSpecified.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextModificationSide.LeftSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextModificationSide.RightSide.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

