/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rider.editorActions.TextModificationSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/editorActions/RangePair;", "", "oldRange", "Lcom/intellij/openapi/util/TextRange;", "newRange", "newText", "", "modificationSide", "Lcom/jetbrains/rider/editorActions/TextModificationSide;", "(Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Lcom/jetbrains/rider/editorActions/TextModificationSide;)V", "Lcom/intellij/util/text/ImmutableCharSequence;", "(Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/util/text/ImmutableCharSequence;Lcom/jetbrains/rider/editorActions/TextModificationSide;)V", "isEmpty", "", "()Z", "getModificationSide", "()Lcom/jetbrains/rider/editorActions/TextModificationSide;", "getNewRange", "()Lcom/intellij/openapi/util/TextRange;", "getNewText", "()Lcom/intellij/util/text/ImmutableCharSequence;", "getOldRange", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRangePair.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangePair.kt\ncom/jetbrains/rider/editorActions/RangePair\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class RangePair {
    @NotNull
    private final TextRange oldRange;
    @NotNull
    private final TextRange newRange;
    @NotNull
    private final ImmutableCharSequence newText;
    @NotNull
    private final TextModificationSide modificationSide;

    public RangePair(@NotNull TextRange oldRange, @NotNull TextRange newRange, @NotNull ImmutableCharSequence newText, @NotNull TextModificationSide modificationSide) {
        Intrinsics.checkNotNullParameter((Object)oldRange, (String)"oldRange");
        Intrinsics.checkNotNullParameter((Object)newRange, (String)"newRange");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationSide), (String)"modificationSide");
        this.oldRange = oldRange;
        this.newRange = newRange;
        this.newText = newText;
        this.modificationSide = modificationSide;
        if (!(this.newRange.getLength() == this.newText.length())) {
            boolean bl = false;
            String string = "newRange.length == newText.length";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final TextRange getOldRange() {
        return this.oldRange;
    }

    @NotNull
    public final TextRange getNewRange() {
        return this.newRange;
    }

    @NotNull
    public final ImmutableCharSequence getNewText() {
        return this.newText;
    }

    @NotNull
    public final TextModificationSide getModificationSide() {
        return this.modificationSide;
    }

    public RangePair(@NotNull TextRange oldRange, @NotNull TextRange newRange, @NotNull String newText, @NotNull TextModificationSide modificationSide) {
        Intrinsics.checkNotNullParameter((Object)oldRange, (String)"oldRange");
        Intrinsics.checkNotNullParameter((Object)newRange, (String)"newRange");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationSide), (String)"modificationSide");
        ImmutableCharSequence immutableCharSequence = CharArrayUtil.createImmutableCharSequence((CharSequence)newText);
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"createImmutableCharSequence(...)");
        this(oldRange, newRange, immutableCharSequence, modificationSide);
    }

    public final boolean isEmpty() {
        return this.oldRange.isEmpty() && this.newRange.isEmpty();
    }

    @NotNull
    public final TextRange component1() {
        return this.oldRange;
    }

    @NotNull
    public final TextRange component2() {
        return this.newRange;
    }

    @NotNull
    public final ImmutableCharSequence component3() {
        return this.newText;
    }

    @NotNull
    public final TextModificationSide component4() {
        return this.modificationSide;
    }

    @NotNull
    public final RangePair copy(@NotNull TextRange oldRange, @NotNull TextRange newRange, @NotNull ImmutableCharSequence newText, @NotNull TextModificationSide modificationSide) {
        Intrinsics.checkNotNullParameter((Object)oldRange, (String)"oldRange");
        Intrinsics.checkNotNullParameter((Object)newRange, (String)"newRange");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationSide), (String)"modificationSide");
        return new RangePair(oldRange, newRange, newText, modificationSide);
    }

    public static /* synthetic */ RangePair copy$default(RangePair rangePair, TextRange textRange, TextRange textRange2, ImmutableCharSequence immutableCharSequence, TextModificationSide textModificationSide, int n2, Object object) {
        if ((n2 & 1) != 0) {
            textRange = rangePair.oldRange;
        }
        if ((n2 & 2) != 0) {
            textRange2 = rangePair.newRange;
        }
        if ((n2 & 4) != 0) {
            immutableCharSequence = rangePair.newText;
        }
        if ((n2 & 8) != 0) {
            textModificationSide = rangePair.modificationSide;
        }
        return rangePair.copy(textRange, textRange2, immutableCharSequence, textModificationSide);
    }

    @NotNull
    public String toString() {
        return "RangePair(oldRange=" + this.oldRange + ", newRange=" + this.newRange + ", newText=" + this.newText + ", modificationSide=" + this.modificationSide + ")";
    }

    public int hashCode() {
        int n2 = this.oldRange.hashCode();
        n2 = n2 * 31 + this.newRange.hashCode();
        n2 = n2 * 31 + this.newText.hashCode();
        n2 = n2 * 31 + this.modificationSide.hashCode();
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangePair)) {
            return false;
        }
        RangePair rangePair = (RangePair)other;
        if (!Intrinsics.areEqual((Object)this.oldRange, (Object)rangePair.oldRange)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newRange, (Object)rangePair.newRange)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newText, (Object)rangePair.newText)) {
            return false;
        }
        return this.modificationSide == rangePair.modificationSide;
    }
}

