/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.document.RiderDocumentExKt;
import com.jetbrains.rider.editorActions.CustomTypingSessionPolicy;
import com.jetbrains.rider.editorActions.FrontendEditorActionInProgress;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.RiderEditorActionHandler;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendTypingEditorActionHandler;", "Lcom/jetbrains/rider/editorActions/RiderEditorActionHandler;", "frontendId", "", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "isSimpleChar", "char", "", "isSynchronous", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "shouldSkip", "shouldSkipSandboxAction", "sandboxInfo", "Lcom/jetbrains/rd/ide/model/AbstractSandboxInfo;", "intellij.rider.rdclient.dotnet"})
public abstract class FrontendTypingEditorActionHandler
extends RiderEditorActionHandler {
    public FrontendTypingEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super(frontendId, baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        if (CustomTypingSessionPolicy.Companion.forceDisable(project3)) {
            return false;
        }
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project3);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return false;
        }
        RiderDefaultBackend riderDefaultBackend2 = riderDefaultBackend;
        if (this.shouldSkip(riderDefaultBackend2, editor)) {
            return false;
        }
        Caret caret2 = caret;
        if (riderDefaultBackend2.getTypedHandler(editor, caret2 != null ? caret2.getOffset() : editor.getCaretModel().getOffset()) == null) {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext2);
    }

    protected boolean shouldSkip(@NotNull IdeBackend backend, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().getSolutionLifecycle().isReadyForTyping()))) {
            return true;
        }
        if (EditorUtilKt.hasMultipleEditPoints((Editor)editor)) {
            return true;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        AbstractSandboxInfo abstractSandboxInfo = RiderDocumentExKt.getSandBoxInfo(document);
        return abstractSandboxInfo != null && this.shouldSkipSandboxAction(abstractSandboxInfo);
    }

    protected boolean shouldSkipSandboxAction(@NotNull AbstractSandboxInfo sandboxInfo) {
        Intrinsics.checkNotNullParameter((Object)sandboxInfo, (String)"sandboxInfo");
        return sandboxInfo.getDisableTypingActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        FrontendEditorActionInProgress.Companion.getThreadLocalCookie().set(new FrontendEditorActionInProgress((EditorActionHandler)this, editor, dataContext2));
        try {
            boolean bl = this.backendIsEnabledForCaret(editor, caret, dataContext2);
            Project project2 = DataContextKt.getProject((DataContext)dataContext2);
            if (bl && project2 != null && TypingSessions.Companion.isEnabled(project2)) {
                IdeBackend ideBackend = IdeBackend.Companion.getInstance(project2);
                ITypingSessions iTypingSessions = TypingSessions.Companion.getInstance(project2);
                if (!this.isSynchronous(ideBackend, editor, caret)) {
                    iTypingSessions.executeTypedAction(this.getFrontendId(), editor, dataContext2, (Function0<Unit>)((Function0)new Function0<Unit>(this, editor, caret, dataContext2){
                        final /* synthetic */ FrontendTypingEditorActionHandler this$0;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ Caret $caret;
                        final /* synthetic */ DataContext $dataContext;
                        {
                            this.this$0 = $receiver;
                            this.$editor = $editor;
                            this.$caret = $caret;
                            this.$dataContext = $dataContext;
                            super(0);
                        }

                        public final void invoke() {
                            FrontendTypingEditorActionHandler.access$getLogger$s1761158197().info("Executing frontend editor base handler '" + this.this$0.getFrontendId() + "'");
                            FrontendTypingEditorActionHandler.access$executeOnFrontend(this.this$0, this.$editor, this.$caret, this.$dataContext);
                        }
                    }));
                    return;
                }
                iTypingSessions.waitForSessionTermination("sync typed action '" + this.getFrontendId() + "'");
            }
            super.doExecute(editor, caret, dataContext2);
            return;
        }
        finally {
            FrontendEditorActionInProgress.Companion.getThreadLocalCookie().set(null);
        }
    }

    protected boolean isSynchronous(@NotNull IdeBackend backend, @NotNull Editor editor, @Nullable Caret caret) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RiderDefaultBackend cfr_ignored_0 = (RiderDefaultBackend)backend;
        Caret caret2 = caret;
        FrontendTypedHandler frontendTypedHandler = ((RiderDefaultBackend)backend).getTypedHandler(editor, caret2 != null ? caret2.getOffset() : editor.getCaretModel().getOffset());
        if (frontendTypedHandler == null) {
            throw new IllegalStateException("typedHandler".toString());
        }
        FrontendTypedHandler frontendTypedHandler2 = frontendTypedHandler;
        return frontendTypedHandler2.isBackendTypedActionSync(this.getFrontendId(), backend.getProject());
    }

    protected boolean isSimpleChar(char c2) {
        return Character.isLetterOrDigit(c2) || CharsKt.isWhitespace((char)c2) || c2 == '.';
    }

    public static final /* synthetic */ Logger access$getLogger$s1761158197() {
        return FrontendEditorActionHandler.getLogger();
    }

    public static final /* synthetic */ void access$executeOnFrontend(FrontendTypingEditorActionHandler $this, Editor editor, Caret caret, DataContext dataContext2) {
        $this.executeOnFrontend(editor, caret, dataContext2);
    }
}

