/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.DocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdTextBufferDocumentModel;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.impl.RdDeferrableTextBuffer;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.daemon.TextBufferDocumentRangeShifter;
import com.jetbrains.rider.document.DocumentChangeModelConversion;
import com.jetbrains.rider.document.FrontendDocumentSuppressor;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0002NOB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000205H\u0014J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u0002022\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0006\u0010@\u001a\u000202J\b\u0010A\u001a\u00020BH\u0016J\u000e\u0010C\u001a\u0002022\u0006\u0010D\u001a\u000207J\u0010\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020=H\u0002J\u0010\u0010G\u001a\u0002022\u0006\u0010H\u001a\u000205H\u0002J\u0014\u0010I\u001a\b\u0012\u0004\u0012\u0002070J2\u0006\u0010K\u001a\u00020LJ\u001a\u0010M\u001a\u0002022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000205H\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006P"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "suppressor", "Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;)V", "autoRecoverEnabled", "", "backendUpdateInProgressMarker", "getBackendUpdateInProgressMarker", "()Z", "setBackendUpdateInProgressMarker", "(Z)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "documentConsistencyAssertionsEnabled", "getDocumentConsistencyAssertionsEnabled", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "hasRecoverRequest", "isReceivingChange", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;", "getProjectSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getSuppressor", "()Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;", "textBuffer", "Lcom/jetbrains/rd/rdtext/impl/RdDeferrableTextBuffer;", "j", "()Lcom/jetbrains/rd/rdtext/impl/RdDeferrableTextBuffer;", "version", "Lcom/jetbrains/rd/ide/model/DocumentVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/DocumentVersion;", "accumulateRecoverRequests", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$AccumulatedRecoverRequests;", "assertEmptyChangesQueue", "", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "createModelChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "change", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "documentChanged", "j", "", "s", "", "flushChanges", "getPriority", "", "receiveDocumentChange", "modelChange", "j", "text", "j", "ideaChange", "startTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "verifyMayUpdateDocument", "AccumulatedRecoverRequests", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextBufferDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBufferDocumentSynchronizer.kt\ncom/jetbrains/rider/document/TextBufferDocumentSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n65#2,4:196\n65#2,4:200\n65#2,4:204\n65#2,4:208\n1#3:212\n*S KotlinDebug\n*F\n+ 1 TextBufferDocumentSynchronizer.kt\ncom/jetbrains/rider/document/TextBufferDocumentSynchronizer\n*L\n100#1:196,4\n110#1:200,4\n128#1:204,4\n143#1:208,4\n*E\n"})
public abstract class TextBufferDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession projectSession;
    @NotNull
    private final Document document;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final RdTextBufferDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final FrontendDocumentSuppressor suppressor;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    private final boolean isReceivingChange;
    private boolean autoRecoverEnabled;
    private boolean hasRecoverRequest;
    private static int debugId;

    public TextBufferDocumentSynchronizer(@NotNull ClientProjectSession projectSession, @NotNull Document document, @Nullable VirtualFile file2, @NotNull RdTextBufferDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull FrontendDocumentSuppressor suppressor2) {
        Intrinsics.checkNotNullParameter((Object)projectSession, (String)"projectSession");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)modelDocument, (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)suppressor2, (String)"suppressor");
        this.projectSession = projectSession;
        this.document = document;
        this.file = file2;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.suppressor = suppressor2;
        String string = com.jetbrains.rd.ide.document.DocumentExKt.createLogCategory((RdDocumentId)this.documentId);
        int n2 = debugId;
        debugId = n2 + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rdclient.document.Document#" + n2 + "(" + string + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.autoRecoverEnabled = true;
    }

    @NotNull
    protected final ClientProjectSession getProjectSession() {
        return this.projectSession;
    }

    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @NotNull
    public RdTextBufferDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @NotNull
    public final RdDocumentId getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final FrontendDocumentSuppressor getSuppressor() {
        return this.suppressor;
    }

    protected final boolean getBackendUpdateInProgressMarker() {
        return this.backendUpdateInProgressMarker;
    }

    protected final void setBackendUpdateInProgressMarker(boolean bl) {
        this.backendUpdateInProgressMarker = bl;
    }

    public boolean isReceivingChange() {
        return this.isReceivingChange;
    }

    private final RdDeferrableTextBuffer j() {
        return this.getModelDocument().getText();
    }

    public final void assertEmptyChangesQueue() {
        this.logger.assertTrue(this.j().isQueueEmpty(), (Object)"TextBuffer must be flushed before.");
    }

    @NotNull
    public DocumentVersion getVersion() {
        return new DocumentVersion(this.j().getBufferVersion());
    }

    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new TextBufferDocumentRangeShifter(this.getDocumentLifetime(), (RdTextBuffer)this.j());
    }

    @NotNull
    public final ITypingSession<RdTextChange> startTypingSession(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        RLifetimeKt.assertAlive((Lifetime)lifetime2);
        ITypingSession iTypingSession = this.j().startTypingSession();
        lifetime2.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ TextBufferDocumentSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TextBufferDocumentSynchronizer.access$getTextBuffer(this.this$0).finishTypingSession();
            }
        });
        return iTypingSession;
    }

    protected void verifyMayUpdateDocument(@Nullable VirtualFile file2, @NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    protected boolean getDocumentConsistencyAssertionsEnabled() {
        return false;
    }

    public final void flushChanges() {
        if (this.j().isQueueEmpty()) {
            return;
        }
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            VirtualFile virtualFile2 = this.file;
            logger2.trace("Flushing deferred '" + (virtualFile2 != null ? virtualFile2.getName() : null) + "' document changes.");
        }
        this.j().flush();
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.backendUpdateInProgressMarker) {
            return;
        }
        this.verifyMayUpdateDocument(this.file, event);
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            VirtualFile virtualFile2 = this.file;
            String string = virtualFile2 != null ? virtualFile2.getName() : null;
            CharSequence charSequence = event.getNewFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
            String string2 = this.j(charSequence);
            CharSequence charSequence2 = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
            logger2.trace("Document '" + string + "' changed from IDEA side. New fragment: '" + string2 + "', OldFragment: '" + this.j(charSequence2) + "'");
        }
        this.j(event);
    }

    @NotNull
    protected RdTextChange createModelChange(@NotNull DocumentEvent change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return DocumentChangeModelConversion.INSTANCE.createModelChange(change);
    }

    private final void j(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        RdTextChange rdTextChange = this.createModelChange(documentEvent);
        boolean bl = this.suppressor.shouldSuppressSendDocumentChanges();
        Logger logger = this.logger;
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl3 = false;
            logger2.trace(bl ? "Queueing change " + rdTextChange + "." : "Firing change " + rdTextChange + ".");
        }
        if (bl) {
            this.j().queue(rdTextChange);
        } else {
            this.assertEmptyChangesQueue();
            this.j().fire(rdTextChange);
        }
        if (this.getDocumentConsistencyAssertionsEnabled()) {
            RdDeferrableTextBuffer rdDeferrableTextBuffer = this.j();
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            rdDeferrableTextBuffer.assertState(string);
        }
    }

    public final void receiveDocumentChange(@NotNull RdTextChange modelChange) {
        Intrinsics.checkNotNullParameter((Object)modelChange, (String)"modelChange");
        WriteCommandAction.writeCommandAction((Project)this.projectSession.getProject()).run(() -> TextBufferDocumentSynchronizer.j(this, modelChange));
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 119;
    }

    private final void j(String string) {
        this.hasRecoverRequest = false;
        this.logger.warn("Firing recovering text change.");
        this.j().reset(string);
    }

    @NotNull
    public final AccumulatedRecoverRequests accumulateRecoverRequests() {
        return new AccumulatedRecoverRequests(this);
    }

    private final String j(CharSequence charSequence) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)charSequence).toString(), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void j(TextBufferDocumentSynchronizer textBufferDocumentSynchronizer, RdTextChange rdTextChange) {
        Intrinsics.checkNotNullParameter((Object)textBufferDocumentSynchronizer, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)rdTextChange, (String)"$modelChange");
        Logger logger = textBufferDocumentSynchronizer.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Applying document change from backend '" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)textBufferDocumentSynchronizer.documentId) + "':\n" + rdTextChange + ", buffer version: " + textBufferDocumentSynchronizer.j().getBufferVersion() + ".");
        }
        textBufferDocumentSynchronizer.getDocument().startGuardedBlockChecking();
        if (!(!textBufferDocumentSynchronizer.backendUpdateInProgressMarker)) {
            bl = false;
            String string = "inconsistent currentBackendUpdate value";
            throw new IllegalArgumentException(string.toString());
        }
        textBufferDocumentSynchronizer.backendUpdateInProgressMarker = true;
        try {
            DocumentChangeModelConversion.INSTANCE.applyModelChange(rdTextChange, textBufferDocumentSynchronizer.getDocument(), textBufferDocumentSynchronizer.getDocumentConsistencyAssertionsEnabled());
            if (textBufferDocumentSynchronizer.getDocumentConsistencyAssertionsEnabled()) {
                RdDeferrableTextBuffer rdDeferrableTextBuffer = textBufferDocumentSynchronizer.j();
                String string = textBufferDocumentSynchronizer.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                rdDeferrableTextBuffer.assertState(string);
            }
        }
        catch (Throwable throwable) {
            textBufferDocumentSynchronizer.logger.error("Exception while applying document change to idea's document", throwable);
            textBufferDocumentSynchronizer.hasRecoverRequest = true;
        }
        finally {
            textBufferDocumentSynchronizer.backendUpdateInProgressMarker = false;
            textBufferDocumentSynchronizer.getDocument().stopGuardedBlockChecking();
        }
        if (textBufferDocumentSynchronizer.hasRecoverRequest && textBufferDocumentSynchronizer.autoRecoverEnabled) {
            String string = textBufferDocumentSynchronizer.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            textBufferDocumentSynchronizer.j(string);
        }
    }

    public static final /* synthetic */ RdDeferrableTextBuffer access$getTextBuffer(TextBufferDocumentSynchronizer $this) {
        return $this.j();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$AccumulatedRecoverRequests;", "Lcom/intellij/openapi/Disposable;", "documentSynchronizer", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "(Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;)V", "hasRequests", "", "getHasRequests", "()Z", "dispose", "", "intellij.rider.rdclient.dotnet"})
    public static final class AccumulatedRecoverRequests
    implements Disposable {
        @NotNull
        private final TextBufferDocumentSynchronizer documentSynchronizer;

        public AccumulatedRecoverRequests(@NotNull TextBufferDocumentSynchronizer documentSynchronizer2) {
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer2, (String)"documentSynchronizer");
            this.documentSynchronizer = documentSynchronizer2;
            if (!this.documentSynchronizer.autoRecoverEnabled) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.documentSynchronizer.autoRecoverEnabled = false;
        }

        public final boolean getHasRequests() {
            return this.documentSynchronizer.hasRecoverRequest;
        }

        public void dispose() {
            if (!(!this.documentSynchronizer.autoRecoverEnabled)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.documentSynchronizer.autoRecoverEnabled = true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$Companion;", "", "()V", "debugId", "", "isBackendUpdateInProgress", "", "document", "Lcom/intellij/openapi/editor/Document;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "recoverDocumentModelSynchronization", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final void recoverDocumentModelSynchronization(@NotNull RdDocumentId documentId, @NotNull ClientAppSession session2) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (!(documentId instanceof RdFileDocumentId) || !com.jetbrains.rd.ide.document.DocumentExKt.isLocalFile((RdDocumentId)documentId)) {
                    return;
                }
                String string = ((RdFileDocumentId)documentId).getFilePath();
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(string), (boolean)true);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile2;
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile3);
                if (document == null) {
                    return;
                }
                Document document2 = document;
                DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getDocumentSynchronizer((Document)document2, (ClientAppSession)session2);
                TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer2 instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer2 : null;
                if (textBufferDocumentSynchronizer == null) break block3;
                String string2 = document2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                textBufferDocumentSynchronizer.j(string2);
            }
        }

        public final boolean isBackendUpdateInProgress(@NotNull Document document, @NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getDocumentSynchronizer((Document)document, (ClientAppSession)session2);
            TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer2 instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer2 : null;
            return textBufferDocumentSynchronizer != null ? textBufferDocumentSynchronizer.getBackendUpdateInProgressMarker() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

