/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0017\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/document/RiderReloadVetoer;", "Lcom/intellij/openapi/fileEditor/FileDocumentSynchronizationVetoer;", "()V", "N", "", "j", "mayReloadFileContent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "maySaveDocument", "isSaveExplicit", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderReloadVetoer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n1855#2,2:128\n13#3:130\n13#4:131\n*S KotlinDebug\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer\n*L\n74#1:128,2\n22#1:130\n22#1:131\n*E\n"})
public final class RiderReloadVetoer
extends FileDocumentSynchronizationVetoer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    private static boolean isDocumentLoading;
    @NotNull
    private static final Set<Document> documentsToReload;

    @RequiresEdt
    public boolean maySaveDocument(@NotNull Document document, boolean isSaveExplicit) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        logger.debug("maySaveDocument for " + StringsKt.take((String)string, (int)15));
        if (ApplicationManager.getApplication().isDisposed() || isSaveExplicit) {
            return true;
        }
        boolean bl = this.N();
        return !bl;
    }

    private final boolean j() {
        Iterable iterable = ClientSessionsManager.Companion.getAppSessions(ClientKind.FRONTEND);
        boolean bl = false;
        for (Object t10 : iterable) {
            ClientAppSession clientAppSession = (ClientAppSession)t10;
            boolean bl2 = false;
            RdCommandProcessor rdCommandProcessor = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol((ClientAppSession)clientAppSession)));
            if (rdCommandProcessor.getCurrentCommand().getValue() == null) continue;
            return true;
        }
        return false;
    }

    @RequiresEdt
    public boolean mayReloadFileContent(@NotNull VirtualFile file2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        logger.debug("mayReloadFileContent for " + file2);
        boolean bl = this.N();
        if (bl) {
            return false;
        }
        if (file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) != null) {
            return false;
        }
        boolean bl2 = this.j();
        logger.debug("isUnderBackendCommand = " + bl2);
        if (bl2) {
            return false;
        }
        logger.debug("isDocumentLoading = " + isDocumentLoading);
        if (isDocumentLoading) {
            Companion.rememberReloadRequest(document);
            return false;
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return true;
        }
        return true;
    }

    private final boolean N() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            Intrinsics.checkNotNull((Object)project2);
            if (!RiderBackendInteractionHelper.Companion.getInstance(project2).isAnyGatewaySyncing()) continue;
            return true;
        }
        return false;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RiderReloadVetoer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderReloadVetoer.logger = logger;
        documentsToReload = new LinkedHashSet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u000bH\u0002J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/document/RiderReloadVetoer$Companion;", "", "()V", "documentsToReload", "", "Lcom/intellij/openapi/editor/Document;", "isDocumentLoading", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "rememberReloadRequest", "", "document", "j", "runWithReloadSuppress", "createdFilePath", "", "action", "Lkotlin/Function0;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderReloadVetoer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1855#2,2:128\n*S KotlinDebug\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer$Companion\n*L\n47#1:128,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final void runWithReloadSuppress(@NotNull String createdFilePath, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)createdFilePath, (String)"createdFilePath");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            try {
                logger.debug("runWithReloadSuppress: Add suppression for: " + createdFilePath);
                isDocumentLoading = true;
                action2.invoke();
                logger.debug("runWithReloadSuppress: Remove suppression for: " + createdFilePath);
            }
            finally {
                isDocumentLoading = false;
                this.j();
            }
        }

        public final void rememberReloadRequest(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            documentsToReload.add(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void j() {
            try {
                Iterable iterable = documentsToReload;
                boolean bl = false;
                for (Object t10 : iterable) {
                    Document document = (Document)t10;
                    boolean bl2 = false;
                    FileDocumentManager.getInstance().reloadFromDisk(document);
                }
            }
            finally {
                documentsToReload.clear();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

