/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rider.document.RiderDocumentExKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/document/DocumentChangeModelConversion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "applyModelChange", "", "modelChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "document", "Lcom/intellij/openapi/editor/Document;", "assertionEnabled", "", "createModelChange", "ideaChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDocumentChangeModelConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentChangeModelConversion.kt\ncom/jetbrains/rider/document/DocumentChangeModelConversion\n+ 2 Logger.kt\ncom/jetbrains/rdclient/util/idea/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n6#2:104\n13#3:105\n13#4:106\n*S KotlinDebug\n*F\n+ 1 DocumentChangeModelConversion.kt\ncom/jetbrains/rider/document/DocumentChangeModelConversion\n*L\n18#1:104\n18#1:105\n18#1:106\n*E\n"})
public final class DocumentChangeModelConversion {
    @NotNull
    public static final DocumentChangeModelConversion INSTANCE = new DocumentChangeModelConversion();
    @NotNull
    private static final Logger logger;

    private DocumentChangeModelConversion() {
    }

    @NotNull
    public final RdTextChange createModelChange(@NotNull DocumentEvent ideaChange) {
        RdTextChangeKind rdTextChangeKind;
        Intrinsics.checkNotNullParameter((Object)ideaChange, (String)"ideaChange");
        Document document = ideaChange.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        boolean bl = RiderDocumentExKt.isSandbox(document2);
        int n2 = ideaChange.getOffset();
        String string = ((Object)ideaChange.getNewFragment()).toString();
        String string2 = ((Object)ideaChange.getOldFragment()).toString();
        int n3 = bl ? -1 : document2.getTextLength();
        if (((CharSequence)string2).length() == 0) {
            if (ideaChange instanceof DocumentEventImpl) {
                if (((DocumentEventImpl)ideaChange).getInitialStartOffset() < n2) {
                }
                if (((DocumentEventImpl)ideaChange).getInitialStartOffset() + ((DocumentEventImpl)ideaChange).getInitialOldLength() > n2) {
                }
            }
            rdTextChangeKind = RdTextChangeKind.Insert;
        } else {
            rdTextChangeKind = ((CharSequence)string).length() == 0 ? RdTextChangeKind.Remove : RdTextChangeKind.Replace;
        }
        RdTextChangeKind rdTextChangeKind2 = rdTextChangeKind;
        return new RdTextChange(rdTextChangeKind2, n2, string2, string, n3);
    }

    public final void applyModelChange(@NotNull RdTextChange modelChange, @NotNull Document document, boolean assertionEnabled) {
        Intrinsics.checkNotNullParameter((Object)modelChange, (String)"modelChange");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (modelChange.getFullTextLength() != -1) {
            RdTextChangeKt.assertDocumentLength((RdTextChange)modelChange, (int)document.getTextLength());
        }
        int n2 = modelChange.getStartOffset();
        String string = modelChange.getOld();
        String string2 = modelChange.getNew();
        int n3 = n2 + string.length();
        switch (WhenMappings.$EnumSwitchMapping$0[modelChange.getKind().ordinal()]) {
            case 1: {
                document.insertString(n2, (CharSequence)string2);
                break;
            }
            case 2: {
                int n4 = Math.min(document.getTextLength(), n3 + 1);
                String string3 = string2 + document.getText(new TextRange(n3, n4));
                document.replaceString(n2, n4, (CharSequence)string3);
                break;
            }
            case 3: {
                int n5 = Math.max(0, n2 - 1);
                String string4 = document.getText(new TextRange(n5, n2)) + string2;
                document.replaceString(n5, n2, (CharSequence)string4);
                break;
            }
            case 4: {
                String string5;
                if (assertionEnabled && !Intrinsics.areEqual((Object)(string5 = ((Object)document.getImmutableCharSequence().subSequence(n2, n3)).toString()), (Object)string)) {
                    throw new IllegalStateException("Expected old: " + string + ", but document old: " + string5);
                }
                document.deleteString(n2, n3);
                break;
            }
            case 5: {
                String string6;
                if (assertionEnabled && !Intrinsics.areEqual((Object)(string6 = ((Object)document.getImmutableCharSequence().subSequence(n2, n3)).toString()), (Object)string)) {
                    throw new IllegalStateException("Expected old: " + string + ", but document old: " + string6);
                }
                document.replaceString(n2, n3, (CharSequence)string2);
                break;
            }
            case 6: {
                String string7 = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
                String string8 = string7;
                if (Intrinsics.areEqual((Object)string8, (Object)string2)) break;
                int n6 = 1280000;
                if (string8.length() > n6 || string2.length() > n6) {
                    logger.warn("Client text differs from backend text.\nClient.length:\n " + string8.length() + " \nBackend.length:\n " + string2.length() + " \nChoosing backend text.");
                } else {
                    logger.warn("Client text differs from backend text.\nClient:\n " + string8 + " \nBackend:\n " + string2 + " \nChoosing backend text.");
                }
                UndoUtil.disableUndoIn((Document)document, () -> DocumentChangeModelConversion.j(document, string2));
            }
        }
    }

    private static final void j(Document document, String string) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$newText");
        document.setText((CharSequence)string);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Logger logger = Logger.getInstance(DocumentChangeModelConversion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DocumentChangeModelConversion.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdTextChangeKind.values().length];
            try {
                nArray[RdTextChangeKind.Insert.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertLeftSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertRightSide.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Remove.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Replace.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Reset.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.PromoteVersion.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

