/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.model.RdMemoryUsageState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/diagnostics/RiderMemoryUsagePresenter;", "", "()V", "getDetailedText", "", "state", "Lcom/jetbrains/rider/model/RdMemoryUsageState;", "lineSeparator", "wrapInPre", "", "getStatusBarText", "j", "memory", "", "intellij.rider.rdclient.dotnet"})
public final class RiderMemoryUsagePresenter {
    @NotNull
    public static final RiderMemoryUsagePresenter INSTANCE = new RiderMemoryUsagePresenter();

    private RiderMemoryUsagePresenter() {
    }

    @NlsSafe
    private final String j(long l2) {
        return l2 / (long)1024 / (long)1024 + "M";
    }

    @NlsSafe
    @NotNull
    public final String getStatusBarText(@NotNull RdMemoryUsageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.j(state.getAllocatedManagedMemory());
        String string2 = this.j(state.getWorkingSet());
        return string + " in " + string2;
    }

    @NlsSafe
    @NotNull
    public final String getDetailedText(@NotNull RdMemoryUsageState state, @NotNull String lineSeparator, boolean wrapInPre) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (wrapInPre) {
            stringBuilder2.append("<pre>");
        }
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "*** Backend Memory Usage ***");
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "Allocated managed memory : " + INSTANCE.j(state.getAllocatedManagedMemory()));
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "Working set              : " + INSTANCE.j(state.getWorkingSet()));
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "Private memory size      : " + INSTANCE.j(state.getPrivateMemorySize()));
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "Virtual memory size      : " + INSTANCE.j(state.getVirtualMemorySize()));
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "GC(0)   : " + state.getCollectionCount0());
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "GC(1)   : " + state.getCollectionCount1());
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "GC(2)   : " + state.getCollectionCount2());
        RiderMemoryUsagePresenter.j(stringBuilder2, lineSeparator, "GC(LOH) : " + state.getCollectionCountLoh());
        if (wrapInPre) {
            stringBuilder2.append("</pre>");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDetailedText$default(RiderMemoryUsagePresenter riderMemoryUsagePresenter, RdMemoryUsageState rdMemoryUsageState, String string, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return riderMemoryUsagePresenter.getDetailedText(rdMemoryUsageState, string, bl);
    }

    private static final StringBuilder j(StringBuilder stringBuilder, String string, String string2) {
        return stringBuilder.append(string2 + string);
    }
}

