/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DocumentVersion;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.rdtext.intrinsics.TextBufferVersion;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J2\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textBuffer", "Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;)V", "history", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rd/rdtext/intrinsics/TextBufferVersion;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "Lkotlin/collections/LinkedHashMap;", "latestKnownSlaveVersion", "j", "", "version", "j", "", "bufferVersion", "shiftOnePoint", "", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "offset", "isStickingToRight", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "shrinkHistory", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextBufferDocumentRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBufferDocumentRangeShifter.kt\ncom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n1#2:148\n65#3,4:149\n13#3:153\n*S KotlinDebug\n*F\n+ 1 TextBufferDocumentRangeShifter.kt\ncom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter\n*L\n42#1:149,4\n23#1:153\n*E\n"})
public final class TextBufferDocumentRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RdTextBuffer textBuffer;
    @NotNull
    private final LinkedHashMap<TextBufferVersion, RdTextChange> history;
    @NotNull
    private TextBufferVersion latestKnownSlaveVersion;
    @NotNull
    private static final Logger LOG;

    public TextBufferDocumentRangeShifter(@NotNull Lifetime lifetime2, @NotNull RdTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.history = new LinkedHashMap(20, 0.75f, false);
        this.latestKnownSlaveVersion = this.textBuffer.getBufferVersion();
        boolean bl = this.textBuffer.isMaster();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "DocumentRangeShifter works only on the master side";
            throw new AssertionError((Object)string);
        }
        ((Map)this.history).put(this.textBuffer.getBufferVersion(), new RdTextChange(RdTextChangeKind.Insert, 0, "", "", 0));
        this.textBuffer.getHistoryChanged().advise(lifetime2, (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(@NotNull RdTextChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Map)history).put(textBuffer.getBufferVersion(), it);
                Logger logger = LOG;
                TextBufferDocumentRangeShifter textBufferDocumentRangeShifter = this;
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("Adding change " + it + " to version " + textBufferDocumentRangeShifter.textBuffer.getBufferVersion());
                }
            }
        });
        this.textBuffer.getDiscardedBufferVersion().advise(lifetime2, (Function1)new Function1<TextBufferVersion, Unit>(){

            public final void invoke(@NotNull TextBufferVersion it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("Discarding change with version " + it);
                }
                history.remove(it);
            }
        });
    }

    public void shrinkHistory() {
        Logger logger = LOG;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Clearing change history before " + this.latestKnownSlaveVersion);
        }
        this.j(this.latestKnownSlaveVersion);
    }

    private final void j(TextBufferVersion textBufferVersion) {
        Iterator<TextBufferVersion> iterator = this.history.keySet().iterator();
        while (iterator.hasNext()) {
            TextBufferVersion textBufferVersion2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (textBufferVersion2.compareTo(textBufferVersion) >= 0) break;
            iterator.remove();
        }
    }

    @Nullable
    public TextRange shiftRange(@NotNull AbstractDocumentVersion v10, @NotNull TextRange range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)v10, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl2 = bl = range.getStartOffset() <= range.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)string);
        }
        TextBufferVersion textBufferVersion = ((DocumentVersion)v10).getValue();
        if (!this.j(textBufferVersion)) {
            return null;
        }
        int n2 = range.getStartOffset();
        int n3 = range.getEndOffset();
        for (Map.Entry entry2 : ((Map)this.history).entrySet()) {
            TextBufferVersion textBufferVersion2 = (TextBufferVersion)entry2.getKey();
            RdTextChange rdTextChange = (RdTextChange)entry2.getValue();
            if (textBufferVersion2.compareTo(textBufferVersion) <= 0 || rdTextChange.getKind() == RdTextChangeKind.PromoteVersion) continue;
            if (rdTextChange.getKind() == RdTextChangeKind.Reset) {
                return null;
            }
            int n4 = rdTextChange.getOld().length();
            int n5 = rdTextChange.getStartOffset();
            int n6 = n5 + n4;
            int n7 = RdTextChangeKt.delta((RdTextChange)rdTextChange);
            if (n2 == n6 && (rdTextChange.getKind() == RdTextChangeKind.InsertRightSide || isGreedyToRight)) {
                n3 += n7;
                continue;
            }
            if (n3 <= n5) continue;
            if (n2 == n6 && (rdTextChange.getKind() == RdTextChangeKind.InsertLeftSide || isGreedyToLeft)) {
                n3 += n7;
                continue;
            }
            if (n2 >= n6) {
                n2 += n7;
                n3 += n7;
                continue;
            }
            if (n2 <= n5 && n6 <= n3 && !isVerifiable) {
                n3 += n7;
                continue;
            }
            return null;
        }
        return new TextRange(n2, n3);
    }

    public int shiftOnePoint(@NotNull AbstractDocumentVersion v10, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v10, (String)"v");
        TextBufferVersion textBufferVersion = ((DocumentVersion)v10).getValue();
        if (!this.j(textBufferVersion)) {
            return -1;
        }
        int n2 = offset;
        for (Map.Entry entry2 : ((Map)this.history).entrySet()) {
            TextBufferVersion textBufferVersion2 = (TextBufferVersion)entry2.getKey();
            RdTextChange rdTextChange = (RdTextChange)entry2.getValue();
            if (textBufferVersion2.compareTo(textBufferVersion) <= 0 || rdTextChange.getKind() == RdTextChangeKind.PromoteVersion) continue;
            if (rdTextChange.getKind() == RdTextChangeKind.Reset) {
                return -1;
            }
            int n3 = rdTextChange.getOld().length();
            int n4 = rdTextChange.getStartOffset();
            int n5 = n4 + n3;
            int n6 = RdTextChangeKt.delta((RdTextChange)rdTextChange);
            if (n2 < n4) continue;
            if (n2 > n5 || isStickingToRight && n3 == 0) {
                n2 += n6;
                continue;
            }
            return -1;
        }
        return n2;
    }

    private final boolean j(TextBufferVersion textBufferVersion) {
        if (!this.history.containsKey(textBufferVersion)) {
            LOG.error("Change " + textBufferVersion + " cannot be found in history. ");
            return false;
        }
        if (this.latestKnownSlaveVersion.compareTo(textBufferVersion) < 0) {
            this.latestKnownSlaveVersion = textBufferVersion;
        }
        return true;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(TextBufferDocumentRangeShifter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

