/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.fileType.daemon;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.rider.cpp.fileType.CppFileType;
import com.jetbrains.rider.cpp.fileType.lexer.CppTokenTypes;
import com.jetbrains.rider.cpp.fileType.psi.CppStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CppBaseFrontendAnnotator
implements Annotator {
    private AnnotationHolder myHolder;
    public static final HighlightSeverity MARKUP = new HighlightSeverity("MARKUP", 0, InspectionsBundle.messagePointer((String)"information.severity", (Object[])new Object[0]), InspectionsBundle.messagePointer((String)"information.severity.capitalized", (Object[])new Object[0]), InspectionsBundle.messagePointer((String)"information.severity.count.message", (Object[])new Object[0]));

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            CppBaseFrontendAnnotator.j(0);
        }
        if (holder == null) {
            CppBaseFrontendAnnotator.j(1);
        }
        this.myHolder = holder;
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile2 != null && virtualFile2.getFileType() instanceof CppFileType) {
            element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.j(0);
                    }
                    if (element instanceof CppStringLiteralExpression) {
                        CppBaseFrontendAnnotator.this.visitLiteralExpression((CppStringLiteralExpression)element);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void j(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/rider/cpp/fileType/daemon/CppBaseFrontendAnnotator$1", "visitElement"));
                }
            });
        }
    }

    public void visitLiteralExpression(@NotNull CppStringLiteralExpression expression) {
        List list;
        if (expression == null) {
            CppBaseFrontendAnnotator.j(2);
        }
        if ((list = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles((PsiElement)expression)) != null && !list.isEmpty()) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = null;
        Lexer lexer = null;
        String string = null;
        for (ASTNode aSTNode = expression.getNode().getFirstChildNode(); aSTNode != null; aSTNode = aSTNode.getTreeNext()) {
            if (!CppTokenTypes.STRING_LITERALS.contains(aSTNode.getElementType())) continue;
            if (syntaxHighlighter == null) {
                syntaxHighlighter = CppBaseFrontendAnnotator.j(expression);
                lexer = syntaxHighlighter.getHighlightingLexer();
                string = expression.getContainingFile().getText();
            }
            TextRange textRange = aSTNode.getTextRange();
            lexer.start((CharSequence)string, textRange.getStartOffset(), textRange.getEndOffset());
            while (lexer.getTokenType() != null) {
                TextRange textRange2 = new TextRange(lexer.getTokenStart(), lexer.getTokenEnd());
                TextAttributesKey[] textAttributesKeyArray = syntaxHighlighter.getTokenHighlights(lexer.getTokenType());
                if (textAttributesKeyArray.length > 0) {
                    this.highlight(textRange2, textAttributesKeyArray[0]);
                }
                lexer.advance();
            }
        }
    }

    @NotNull
    private static SyntaxHighlighter j(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CppBaseFrontendAnnotator.j(3);
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)psiElement.getLanguage(), (Project)psiElement.getProject(), (VirtualFile)psiElement.getContainingFile().getVirtualFile());
        if (syntaxHighlighter == null) {
            CppBaseFrontendAnnotator.j(4);
        }
        return syntaxHighlighter;
    }

    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range == null) {
            CppBaseFrontendAnnotator.j(5);
        }
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(MARKUP).range(range).textAttributes(key).create();
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rider/cpp/fileType/daemon/CppBaseFrontendAnnotator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rider/cpp/fileType/daemon/CppBaseFrontendAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitLiteralExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSyntaxHighlighter";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

