/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.completion;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.rider.completion.CustomCharPattern;
import com.jetbrains.rider.completion.ICompletionHelper;
import com.jetbrains.rider.cpp.fileType.lexer.CppLexer;
import com.jetbrains.rider.cpp.fileType.lexer.CppTokenTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J0\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/cpp/completion/CppCompletionHelperBase;", "Lcom/jetbrains/rider/completion/ICompletionHelper;", "()V", "getIdentifierPart", "Lcom/intellij/patterns/ElementPattern;", "", "documentOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/psi/PsiElement;", "completionOffset", "getIdentifierStart", "isApplicable", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Companion", "intellij.rider.cpp.core"})
public abstract class CppCompletionHelperBase
implements ICompletionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Character> NotAllowedCharactersInFilename;

    public abstract boolean isApplicable(@NotNull FileType var1);

    @Override
    @Nullable
    public ElementPattern<Character> getIdentifierPart(int documentOffset, @NotNull Document document, @NotNull PsiElement element, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider fileViewProvider2 = fileViewProvider;
        FileType fileType = fileViewProvider2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        if (!this.isApplicable(fileType)) {
            return null;
        }
        boolean bl = Companion.isInFileNameContext(document, documentOffset);
        return (ElementPattern)CustomCharPattern.customCharacter().with((PatternCondition)new PatternCondition<Character>(bl){
            final /* synthetic */ boolean $inFileNameContext;
            {
                this.$inFileNameContext = $inFileNameContext;
                super("csharpIdentifierPart");
            }

            public boolean accepts(char character, @NotNull ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (this.$inFileNameContext) {
                    return !CppCompletionHelperBase.Companion.getNotAllowedCharactersInFilename().contains(Character.valueOf(character));
                }
                return Character.isJavaIdentifierPart(character) || Character.isDigit(character) || character == '#';
            }
        });
    }

    @Override
    @Nullable
    public ElementPattern<Character> getIdentifierStart(int documentOffset, @NotNull Document document, @NotNull PsiElement element, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider fileViewProvider2 = fileViewProvider;
        FileType fileType = fileViewProvider2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        if (!this.isApplicable(fileType)) {
            return null;
        }
        boolean bl = Companion.isInFileNameContext(document, documentOffset);
        return (ElementPattern)CustomCharPattern.customCharacter().with((PatternCondition)new PatternCondition<Character>(bl){
            final /* synthetic */ boolean $inFileNameContext;
            {
                this.$inFileNameContext = $inFileNameContext;
                super("csharpIdentifierPart");
            }

            public boolean accepts(char character, @NotNull ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (this.$inFileNameContext) {
                    return !CppCompletionHelperBase.Companion.getNotAllowedCharactersInFilename().contains(Character.valueOf(character));
                }
                return Character.isJavaIdentifierStart(character) || Character.isDigit(character) || character == '#';
            }
        });
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|')};
        NotAllowedCharactersInFilename = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/cpp/completion/CppCompletionHelperBase$Companion;", "", "()V", "NotAllowedCharactersInFilename", "", "", "getNotAllowedCharactersInFilename", "()Ljava/util/List;", "isInFileNameContext", "", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "intellij.rider.cpp.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Character> getNotAllowedCharactersInFilename() {
            return NotAllowedCharactersInFilename;
        }

        public final boolean isInFileNameContext(@NotNull Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            int n2 = document.getLineNumber(offset);
            CppLexer cppLexer = new CppLexer();
            cppLexer.start(document.getCharsSequence(), document.getLineStartOffset(n2), document.getLineEndOffset(n2));
            while (cppLexer.getTokenType() != null) {
                if (cppLexer.getTokenEnd() > offset) {
                    if (!Intrinsics.areEqual((Object)cppLexer.getTokenType(), (Object)((Object)CppTokenTypes.INCLUDE_DIRECTIVE_CONTENT))) {
                        return false;
                    }
                    CppLexer cppLexer2 = new CppLexer();
                    cppLexer2.start(document.getCharsSequence(), cppLexer.getTokenStart(), cppLexer.getTokenEnd());
                    boolean bl = false;
                    while (cppLexer2.getTokenType() != null) {
                        if (Intrinsics.areEqual((Object)cppLexer2.getTokenType(), (Object)((Object)CppTokenTypes.LT))) {
                            bl = true;
                        } else if (Intrinsics.areEqual((Object)cppLexer2.getTokenType(), (Object)((Object)CppTokenTypes.GT))) {
                            bl = false;
                        } else if (cppLexer2.getTokenEnd() > offset) {
                            if (CppTokenTypes.STRING_LITERALS.contains(cppLexer2.getTokenType())) {
                                return true;
                            }
                            return bl;
                        }
                        cppLexer2.advance();
                    }
                }
                cppLexer.advance();
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

