/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion.summaryInfo;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupPositionManager;
import com.jetbrains.rider.completion.summaryInfo.SummaryInfoPositionAdjuster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/completion/summaryInfo/SummaryInfoPositionAdjuster;", "Lcom/intellij/ui/popup/PopupPositionManager$PositionAdjuster;", "rectangle", "Ljava/awt/Rectangle;", "component", "Ljava/awt/Component;", "gap", "", "(Ljava/awt/Rectangle;Ljava/awt/Component;I)V", "y", "adjust", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "traversalPolicy", "", "Lcom/intellij/ui/popup/PopupPositionManager$Position;", "(Lcom/intellij/openapi/ui/popup/JBPopup;[Lcom/intellij/ui/popup/PopupPositionManager$Position;)V", "calculatePopupRectangle", "(Lcom/intellij/openapi/ui/popup/JBPopup;[Lcom/intellij/ui/popup/PopupPositionManager$Position;)Ljava/awt/Rectangle;", "positionLeft", "d", "Ljava/awt/Dimension;", "positionRight", "intellij.rider.rdclient.dotnet"})
public final class SummaryInfoPositionAdjuster
extends PopupPositionManager.PositionAdjuster {
    private final int y;

    public SummaryInfoPositionAdjuster(@NotNull Rectangle rectangle, @NotNull Component component, int gap) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(component, gap);
        this.y = component.getLocationOnScreen().y + rectangle.y;
    }

    public void adjust(@NotNull JBPopup popup2) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        PopupPositionManager.Position[] positionArray = new PopupPositionManager.Position[]{PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT};
        this.adjust(popup2, positionArray);
    }

    @NotNull
    protected Rectangle positionRight(@NotNull Dimension d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        return new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.y, d2.width, d2.height);
    }

    @NotNull
    protected Rectangle positionLeft(@NotNull Dimension d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        return new Rectangle(this.myRelativeOnScreen.x - this.myGap - d2.width, this.y, d2.width, d2.height);
    }

    public void adjust(@NotNull JBPopup popup2, PopupPositionManager.Position ... traversalPolicy) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)traversalPolicy, (String)"traversalPolicy");
        Rectangle rectangle = this.calculatePopupRectangle(popup2, Arrays.copyOf(traversalPolicy, traversalPolicy.length));
        popup2.setSize(rectangle.getSize());
        if (popup2.isVisible()) {
            popup2.setLocation(rectangle.getLocation());
        } else {
            popup2.show(new RelativePoint(this.myRelativeTo, new Point(rectangle.getLocation().x - this.myRelativeOnScreen.x, rectangle.getLocation().y - this.myRelativeOnScreen.y)));
        }
    }

    @NotNull
    public final Rectangle calculatePopupRectangle(@NotNull JBPopup popup2, PopupPositionManager.Position ... traversalPolicy) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)traversalPolicy, (String)"traversalPolicy");
        Dimension dimension = PopupPositionManager.PositionAdjuster.getPopupSize((JBPopup)popup2);
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPopupSize(...)");
        Dimension dimension2 = dimension;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        for (PopupPositionManager.Position position : traversalPolicy) {
            Rectangle rectangle3 = rectangle2 = (switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1 -> this.positionAbove(dimension2);
                case 2 -> this.positionUnder(dimension2);
                case 3 -> this.positionLeft(dimension2);
                case 4 -> this.positionRight(dimension2);
                default -> throw new NoWhenBranchMatchedException();
            });
            Intrinsics.checkNotNull((Object)rectangle3);
            if (!this.myScreenRect.contains(rectangle3)) continue;
            rectangle = rectangle2;
            break;
        }
        if (rectangle != null) {
            Rectangle rectangle4 = rectangle2;
            Intrinsics.checkNotNull(rectangle4);
            return rectangle4;
        }
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        arrayList.add(PopupPositionManager.PositionAdjuster.crop((Rectangle)this.myScreenRect, (Rectangle)new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.y, this.myScreenRect.width, this.myScreenRect.height)));
        arrayList.add(PopupPositionManager.PositionAdjuster.crop((Rectangle)this.myScreenRect, (Rectangle)new Rectangle(this.myScreenRect.x, this.y, this.myRelativeOnScreen.x - this.myScreenRect.x - this.myGap, this.myScreenRect.height)));
        CollectionsKt.sortWith((List)arrayList, (arg_0, arg_1) -> SummaryInfoPositionAdjuster.j(calculatePopupRectangle.1.INSTANCE, arg_0, arg_1));
        Object e2 = arrayList.get(arrayList.size() - 1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
        Rectangle rectangle5 = (Rectangle)e2;
        int n2 = rectangle5.x < this.myRelativeOnScreen.x ? rectangle5.x + rectangle5.width - dimension2.width : rectangle5.x;
        int n3 = rectangle5.y < this.y ? rectangle5.y + rectangle5.height - dimension2.height : rectangle5.y;
        Rectangle rectangle6 = PopupPositionManager.PositionAdjuster.crop((Rectangle)rectangle5, (Rectangle)new Rectangle(n2, n3, dimension2.width, dimension2.height));
        Intrinsics.checkNotNullExpressionValue((Object)rectangle6, (String)"crop(...)");
        return rectangle6;
    }

    private static final int j(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PopupPositionManager.Position.values().length];
            try {
                nArray[PopupPositionManager.Position.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

