/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.FocusBehaviour;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendAutoPopupHost;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.FrontendLookupListener;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.QuickDocLookupListener;
import com.jetbrains.rider.completion.RiderLookupAsyncPresenter;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.completion.summaryInfo.SummaryInfoTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/completion/RiderLookupListener;", "Lcom/jetbrains/rider/completion/FrontendLookupListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "handleBackendLookupShown", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class RiderLookupListener
extends FrontendLookupListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Boolean> forceSoftSelectionKey;

    public RiderLookupListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
    }

    @Override
    protected void handleBackendLookupShown(@NotNull LookupImpl lookup, @NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (codeInsightSettings.AUTO_POPUP_JAVADOC_INFO) {
            SummaryInfoTracker.Companion.addSummaryInfoTracker((LookupEx)lookup);
        }
        super.handleBackendLookupShown(lookup, backend);
        RiderLookupAsyncPresenter riderLookupAsyncPresenter = RiderLookupAsyncPresenter.Companion.getInstance(this.getProject());
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FrontendAutoPopupHost.AutoPopupState autoPopupState = FrontendAutoPopupHost.Companion.getAutoPopupState(editor);
        boolean bl = autoPopupState != null ? autoPopupState.isNextLookupSoft() : false;
        if (bl) {
            lookup.putUserData(forceSoftSelectionKey, (Object)true);
        }
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(this.getProject());
        lookup.addLookupListener(new LookupListener(lookup, frontendCompletionHost, riderLookupAsyncPresenter){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ FrontendCompletionHost $completionHost;
            final /* synthetic */ RiderLookupAsyncPresenter $updater;
            {
                this.$lookup = $lookup;
                this.$completionHost = $completionHost;
                this.$updater = $updater;
            }

            public boolean beforeItemSelected(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem((LookupElement)event.getItem()) == null;
            }

            public void uiRefreshed() {
                boolean bl;
                int n2;
                Object object;
                RiderLookupListener.Companion.getLogger().trace("refreshUI " + this.hashCode());
                Editor editor = this.$lookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                CompletionStateData completionStateData2 = FrontendCompletionHostKt.getCompletionStateData(editor);
                boolean bl2 = completionStateData2.getHasSession();
                if (bl2) {
                    Editor editor2 = this.$lookup.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    if (this.$completionHost.getBackendFocusBehaviour(editor2) == FocusBehaviour.SoftWhenEmpty) {
                        String string = this.$lookup.getAdditionalPrefix();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAdditionalPrefix(...)");
                        if (((CharSequence)string).length() > 0) {
                            boolean bl3;
                            block10: {
                                String string2 = this.$lookup.getAdditionalPrefix();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAdditionalPrefix(...)");
                                object = string2;
                                boolean bl4 = false;
                                for (n2 = 0; n2 < object.length(); ++n2) {
                                    char c2;
                                    char c3 = c2 = object.charAt(n2);
                                    bl = false;
                                    boolean bl5 = !Character.isDigit(c3);
                                    if (!bl5) continue;
                                    bl3 = true;
                                    break block10;
                                }
                                bl3 = false;
                            }
                            if (bl3 && CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars()) {
                                this.$lookup.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
                            }
                        }
                    }
                }
                if (bl2 && !ApplicationKt.getApplication().isUnitTestMode()) {
                    Object object2;
                    Object object322;
                    List list = this.$lookup.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                    Iterable iterable = list;
                    n2 = 0;
                    Iterable iterable2 = iterable;
                    Iterable<Pair> iterable3 = new ArrayList<E>();
                    bl = false;
                    Iterable iterable4 = iterable2;
                    boolean bl6 = false;
                    for (Object object322 : iterable4) {
                        Pair pair2;
                        object2 = object322;
                        boolean bl7 = false;
                        LookupElement lookupElement = (LookupElement)object2;
                        boolean bl8 = false;
                        if (TuplesKt.to((Object)lookupElement, (Object)com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem((LookupElement)lookupElement)) == null) continue;
                        boolean bl9 = false;
                        iterable3.add(pair2);
                    }
                    object = (List)iterable3;
                    Iterable iterable5 = (Iterable)object;
                    boolean bl10 = false;
                    iterable3 = iterable5;
                    Collection collection = new ArrayList<E>();
                    boolean bl11 = false;
                    Iterable<Pair> iterable6 = iterable3;
                    boolean bl12 = false;
                    object322 = iterable6.iterator();
                    while (object322.hasNext()) {
                        ProtocolLookupItemBase protocolLookupItemBase;
                        Object object4 = object2 = object322.next();
                        boolean bl13 = false;
                        Pair pair3 = (Pair)object4;
                        boolean bl14 = false;
                        if ((ProtocolLookupItemBase)pair3.getSecond() == null) continue;
                        boolean bl15 = false;
                        collection.add(protocolLookupItemBase);
                    }
                    iterable5 = (List)collection;
                    bl10 = false;
                    iterable3 = iterable5;
                    collection = new ArrayList<E>();
                    bl11 = false;
                    for (E e2 : iterable3) {
                        object322 = (ProtocolLookupItemBase)e2;
                        boolean bl16 = false;
                        if (!object322.shouldRequestUpdate()) continue;
                        collection.add(e2);
                    }
                    iterable = (List)collection;
                    if (!((Collection)iterable).isEmpty()) {
                        this.$updater.updatePresentation((List<? extends ProtocolLookupItemBase>)iterable, this.$lookup, (Function0<Unit>)((Function0)new Function0<Unit>(this.$lookup, (List<? extends Pair<? extends LookupElement, ? extends ProtocolLookupItemBase>>)object){
                            final /* synthetic */ LookupImpl $lookup;
                            final /* synthetic */ List<Pair<LookupElement, ProtocolLookupItemBase>> $lookupToResharperItems;
                            {
                                this.$lookup = $lookup;
                                this.$lookupToResharperItems = $lookupToResharperItems;
                                super(0);
                            }

                            public final void invoke() {
                                List list = this.$lookup.getItems();
                                Iterable iterable = this.$lookupToResharperItems;
                                LookupImpl lookupImpl = this.$lookup;
                                boolean bl = false;
                                for (T t10 : iterable) {
                                    ProtocolLookupItemBase protocolLookupItemBase;
                                    Pair pair2 = (Pair)t10;
                                    boolean bl2 = false;
                                    if (list.contains(pair2.getFirst())) {
                                        lookupImpl.scheduleItemUpdate((LookupElement)pair2.getFirst());
                                        continue;
                                    }
                                    RiderLookupListener.Companion.getLogger().trace("Skip updating item " + ((protocolLookupItemBase = (ProtocolLookupItemBase)pair2.getSecond()) != null && (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) != null ? protocolLookupItemBase.getShortText() : null) + " because it doesn't shown in lookup anymore");
                                }
                            }
                        }));
                    }
                }
            }
        });
        lookup.addLookupListener(new LookupListener(lookup, this){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ RiderLookupListener this$0;
            {
                this.$lookup = $lookup;
                this.this$0 = $receiver;
            }

            public void lookupCanceled(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCanceledExplicitly()) {
                    Editor editor = this.$lookup.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    if (FrontendCompletionHostKt.getCompletionStateData(editor).getHasSession()) {
                        PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(this.this$0.getProject());
                        Editor editor2 = this.$lookup.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        preemptiveCompletionHost.tryScheduleCompletion(editor2, "Lookup was cancelled");
                    }
                }
            }
        });
        lookup.addLookupListener((LookupListener)new QuickDocLookupListener(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)lookup)), lookup));
    }

    static {
        Logger logger = Logger.getInstance(RiderLookupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderLookupListener.logger = logger;
        forceSoftSelectionKey = new Key("ForceSoft");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/completion/RiderLookupListener$Companion;", "", "()V", "forceSoftSelectionKey", "Lcom/intellij/openapi/util/Key;", "", "getForceSoftSelectionKey", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Boolean> getForceSoftSelectionKey() {
            return forceSoftSelectionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

