/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.completion.AutoPopupBackendSupportPolicy;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.QuickDocLookupListener;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/completion/FrontendLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "handleBackendLookupShown", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendLookupListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendLookupListener.kt\ncom/jetbrains/rider/completion/FrontendLookupListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n13#2:112\n13#3:113\n*S KotlinDebug\n*F\n+ 1 FrontendLookupListener.kt\ncom/jetbrains/rider/completion/FrontendLookupListener\n*L\n31#1:112\n31#1:113\n*E\n"})
public class FrontendLookupListener
implements LookupManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public FrontendLookupListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        LookupImpl lookupImpl = (LookupImpl)newLookup;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl lookupImpl2 = lookupImpl;
        Editor editor = lookupImpl2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        IdeBackend ideBackend = IdeBackend.Companion.getInstance(this.project);
        if (ideBackend.isCompletionEnabled(editor2)) {
            this.handleBackendLookupShown(lookupImpl2, ideBackend);
        }
    }

    protected void handleBackendLookupShown(@NotNull LookupImpl lookup, @NotNull IdeBackend backend) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        logger.trace("handle backend lookup shown...");
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Lifetime lifetime2 = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)lookup)).getLifetime();
        if (RLifetimeKt.isAlive((Lifetime)lifetime2)) {
            document2.addDocumentListener(new DocumentListener(lifetime2, editor2){
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Editor $editor;
                {
                    this.$lifetime = $lifetime;
                    this.$editor = $editor;
                }

                public void documentChanged(@NotNull DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                        return;
                    }
                    if (event.getDocument().isInBulkUpdate()) {
                        FrontendLookupListener.Companion.getLogger().trace("Skip vanishing highlighters during bulk update. Event : " + event);
                        return;
                    }
                    TextRange textRange = TextRange.from((int)event.getOffset(), (int)event.getNewLength());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                    TextRange textRange2 = textRange;
                    HighlightersUtilKt.vanishHighlighters((Lifetime)this.$lifetime, (TextRange)textRange2, (Editor)this.$editor);
                }

                public void beforeDocumentChange(@NotNull DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime2, null, (int)1, null));
            lookup.addLookupListener((LookupListener)new QuickDocLookupListener(lifetime2, lookup));
        }
        RiderDefaultBackend cfr_ignored_0 = (RiderDefaultBackend)backend;
        if (PatchEngineRegistryKt.isTypingSessionEnabled() && ((RiderDefaultBackend)backend).getTypedHandler(editor2, editor2.getCaretModel().getOffset()) != null && TypingSessions.Companion.isEnabled(this.project)) {
            object = TypingSessions.Companion.getInstance(this.project);
            if (EditorUtilKt.hasMultipleEditPoints((Editor)editor2)) {
                if (object.hasActiveSession()) {
                    logger.error("There are multiple edit points, but typing session doesn't support this mode.");
                    object.forceCloseActiveSession("multiple edit points is not supported");
                }
            } else {
                lookup.addPrefixChangeListener(new PrefixChangeListener((ITypingSessions)object, editor2, this, lookup){
                    @Nullable
                    private Disposable tracker;
                    final /* synthetic */ ITypingSessions $typingSessions;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ FrontendLookupListener this$0;
                    final /* synthetic */ LookupImpl $lookup;
                    {
                        this.$typingSessions = $typingSessions;
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        this.$lookup = $lookup;
                    }

                    public void beforeAppend(char c2) {
                        this.tracker = this.$typingSessions.typeCharCookie(c2, this.$editor, this.this$0.getProject());
                        Disposable disposable = (Disposable)this.$lookup;
                        Disposable disposable2 = this.tracker;
                        Intrinsics.checkNotNull((Object)disposable2);
                        Disposer.register((Disposable)disposable, (Disposable)disposable2);
                    }

                    public void afterAppend(char c2) {
                        Disposable disposable = this.tracker;
                        this.tracker = null;
                        Disposable disposable2 = disposable;
                        Intrinsics.checkNotNull((Object)disposable2);
                        Disposer.dispose((Disposable)disposable2);
                    }
                }, (Disposable)lookup);
            }
        }
        Language language = DocumentUtilKt.getLanguage((Editor)editor2);
        if (language == null) {
            return;
        }
        object = language;
        boolean bl = ((RiderDefaultBackend)backend).getAutoPopupBackendSupportPolicy((Language)object) == AutoPopupBackendSupportPolicy.TRUST_BACKEND;
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(this.project);
        if (FrontendCompletionHostKt.getCompletionStateData(editor2).getHasSession()) {
            frontendCompletionHost.onCurrentSessionTerminated(editor2, (Function0<Unit>)((Function0)new Function0<Unit>(editor2, lookup, bl){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ LookupImpl $lookup;
                final /* synthetic */ boolean $autopopupTrustsBackend;
                {
                    this.$editor = $editor;
                    this.$lookup = $lookup;
                    this.$autopopupTrustsBackend = $autopopupTrustsBackend;
                    super(0);
                }

                public final void invoke() {
                    if (!EditorUtilKt.hasMultipleEditPoints((Editor)this.$editor) && this.$lookup.getItems().isEmpty() && this.$autopopupTrustsBackend) {
                        FrontendLookupListener.Companion.getLogger().trace("hiding lookup due to session termination");
                        this.$lookup.hideLookup(false);
                    }
                }
            }));
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(FrontendLookupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendLookupListener.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/completion/FrontendLookupListener$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

