/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.completion.CompletionSessionMarkerKt;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionSessionModel;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.CompletionSessionHeuristics;
import com.jetbrains.rider.completion.CompletionSessionState;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.MyEditorTypingListener;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J/\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0012\u0010#\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010&\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J,\u0010)\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "adviceTerminateIfNoResults", "", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "j", "", "(Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "j", "offset", "newPosition", "oldPosition", "j", "", "j", "completionHost", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "j", "psiFile", "Lcom/intellij/psi/PsiFile;", "char", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Ljava/lang/Character;I)Z", "shouldRescheduleDefaultStrategy", "(Ljava/lang/Character;)Z", "j", "N", "j", "language", "Lcom/intellij/lang/Language;", "shouldTerminateOnRemove", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "terminateCompletionSessionIfNeeded", "currentOffset", "j", "reason", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n13#2:407\n13#3:408\n65#3,4:412\n65#3,4:416\n1747#4,3:409\n1726#4,3:420\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n*L\n85#1:407\n85#1:408\n356#1:412,4\n359#1:416,4\n325#1:409,3\n386#1:420,3\n*E\n"})
public class CompletionSessionHeuristics
extends LifetimedProjectComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;

    public CompletionSessionHeuristics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(CompletionSessionHeuristics.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        ApplicationKt.getApplication().invokeLater(() -> CompletionSessionHeuristics.j(this, project2));
    }

    protected void adviceTerminateIfNoResults(@NotNull Lifetime textControlLifetime, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().view(textControlLifetime, (Function2)new Function2<Lifetime, CompletionTuple, Unit>(this, editor, textControlModel2){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ TextControlModel $textControlModel;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$textControlModel = $textControlModel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime completionSessionLifetime, @Nullable CompletionTuple completionTuple) {
                Intrinsics.checkNotNullParameter((Object)completionSessionLifetime, (String)"completionSessionLifetime");
                CompletionTuple completionTuple2 = completionTuple;
                if (completionTuple2 == null || (completionTuple2 = completionTuple2.getSession()) == null) {
                    return;
                }
                CompletionTuple completionTuple3 = completionTuple2;
                Logger logger = CompletionSessionHeuristics.access$getLogger$p(this.this$0);
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("ReleaseChangesIfNotUsedStrategy: viewing new completion session: " + completionTuple.getSession().hashCode());
                }
                logger = new SequentialLifetimes(completionSessionLifetime);
                DocumentListener documentListener2 = new DocumentListener(completionSessionLifetime, this.$editor, (SequentialLifetimes)logger, this.this$0, this.$textControlModel, (CompletionSessionModel)completionTuple3){
                    final /* synthetic */ Lifetime $completionSessionLifetime;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ SequentialLifetimes $typingSeqLifetime;
                    final /* synthetic */ CompletionSessionHeuristics this$0;
                    final /* synthetic */ TextControlModel $textControlModel;
                    final /* synthetic */ CompletionSessionModel $session;
                    {
                        this.$completionSessionLifetime = $completionSessionLifetime;
                        this.$editor = $editor;
                        this.$typingSeqLifetime = $typingSeqLifetime;
                        this.this$0 = $receiver;
                        this.$textControlModel = $textControlModel;
                        this.$session = $session;
                    }

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!RLifetimeKt.isAlive((Lifetime)this.$completionSessionLifetime)) {
                            return;
                        }
                        TextControlId textControlId = DocumentExKt.getTextControlId((Editor)this.$editor);
                        if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                            return;
                        }
                        LifetimeDefinition lifetimeDefinition = this.$typingSeqLifetime.next();
                        CompletionStateData completionStateData2 = FrontendCompletionHostKt.getCompletionStateData(this.$editor);
                        completionStateData2.getState().advise((Lifetime)lifetimeDefinition, (Function1)new Function1<CompletionSessionState, Unit>(lifetimeDefinition, this.this$0, completionStateData2, this.$textControlModel, this.$session, this.$editor){
                            final /* synthetic */ LifetimeDefinition $currentTypingLifetime;
                            final /* synthetic */ CompletionSessionHeuristics this$0;
                            final /* synthetic */ CompletionStateData $completionStateData;
                            final /* synthetic */ TextControlModel $textControlModel;
                            final /* synthetic */ CompletionSessionModel $session;
                            final /* synthetic */ Editor $editor;
                            {
                                this.$currentTypingLifetime = $currentTypingLifetime;
                                this.this$0 = $receiver;
                                this.$completionStateData = $completionStateData;
                                this.$textControlModel = $textControlModel;
                                this.$session = $session;
                                this.$editor = $editor;
                                super(1);
                            }

                            public final void invoke(@NotNull CompletionSessionState completionSessionState) {
                                Intrinsics.checkNotNullParameter((Object)((Object)completionSessionState), (String)"completionSessionState");
                                if (completionSessionState.getOrder() < CompletionSessionState.Completed.getOrder()) {
                                    return;
                                }
                                ApplicationKt.getApplication().invokeLater(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.j(this.$currentTypingLifetime, this.this$0, this.$completionStateData, this.$textControlModel, this.$session, this.$editor));
                            }

                            private static final void N(LifetimeDefinition lifetimeDefinition, CompletionSessionHeuristics completionSessionHeuristics, CompletionStateData completionStateData2, TextControlModel textControlModel, CompletionSessionModel completionSessionModel, Editor editor) {
                                Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"$currentTypingLifetime");
                                Intrinsics.checkNotNullParameter((Object)((Object)completionSessionHeuristics), (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)completionStateData2, (String)"$completionStateData");
                                Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"$textControlModel");
                                Intrinsics.checkNotNullParameter((Object)completionSessionModel, (String)"$session");
                                Intrinsics.checkNotNullParameter((Object)editor, (String)"$editor");
                                lifetimeDefinition.executeIfAlive((Function0)new Function0<Unit>(completionSessionHeuristics, lifetimeDefinition, completionStateData2, textControlModel, completionSessionModel, editor){
                                    final /* synthetic */ CompletionSessionHeuristics this$0;
                                    final /* synthetic */ LifetimeDefinition $currentTypingLifetime;
                                    final /* synthetic */ CompletionStateData $completionStateData;
                                    final /* synthetic */ TextControlModel $textControlModel;
                                    final /* synthetic */ CompletionSessionModel $session;
                                    final /* synthetic */ Editor $editor;
                                    {
                                        this.this$0 = $receiver;
                                        this.$currentTypingLifetime = $currentTypingLifetime;
                                        this.$completionStateData = $completionStateData;
                                        this.$textControlModel = $textControlModel;
                                        this.$session = $session;
                                        this.$editor = $editor;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        Logger logger = CompletionSessionHeuristics.access$getLogger$p(this.this$0);
                                        boolean bl = false;
                                        if (logger.isTraceEnabled()) {
                                            Logger logger2 = logger;
                                            boolean bl2 = false;
                                            logger2.trace("ReleaseChangesIfNotUsedStrategy: document has changed and is committed, completion is calculated, waiting for 1 sec...");
                                        }
                                        new Alarm(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.$currentTypingLifetime), null, (int)1, null)).addRequest(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.1.1.j(this.$completionStateData, this.$textControlModel, this.$session, this.this$0, this.$editor), 1000);
                                    }

                                    private static final void j(CompletionStateData completionStateData2, TextControlModel textControlModel, CompletionSessionModel completionSessionModel, CompletionSessionHeuristics completionSessionHeuristics, Editor editor) {
                                        Intrinsics.checkNotNullParameter((Object)completionStateData2, (String)"$completionStateData");
                                        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"$textControlModel");
                                        Intrinsics.checkNotNullParameter((Object)completionSessionModel, (String)"$session");
                                        Intrinsics.checkNotNullParameter((Object)((Object)completionSessionHeuristics), (String)"this$0");
                                        Intrinsics.checkNotNullParameter((Object)editor, (String)"$editor");
                                        if (completionStateData2.getHasSession()) {
                                            CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel).getCompletionSession().getValue();
                                            if (Intrinsics.areEqual((Object)(completionTuple != null ? completionTuple.getSession() : null), (Object)completionSessionModel) && LookupManagerImpl.getInstance((Project)completionSessionHeuristics.getProject()).getActiveLookup() == null && CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() == null && !CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)editor)) {
                                                PreemptiveCompletionHost.Companion.getInstance(completionSessionHeuristics.getProject()).terminateCurrentCompletion(editor, "All items are calculated and still no lookup is shown after 1 second");
                                            }
                                        }
                                    }
                                });
                            }

                            private static final void j(LifetimeDefinition lifetimeDefinition, CompletionSessionHeuristics completionSessionHeuristics, CompletionStateData completionStateData2, TextControlModel textControlModel, CompletionSessionModel completionSessionModel, Editor editor) {
                                Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"$currentTypingLifetime");
                                Intrinsics.checkNotNullParameter((Object)((Object)completionSessionHeuristics), (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)completionStateData2, (String)"$completionStateData");
                                Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"$textControlModel");
                                Intrinsics.checkNotNullParameter((Object)completionSessionModel, (String)"$session");
                                Intrinsics.checkNotNullParameter((Object)editor, (String)"$editor");
                                if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)lifetimeDefinition))) {
                                    return;
                                }
                                PsiDocumentManager.getInstance((Project)completionSessionHeuristics.getProject()).performWhenAllCommitted(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.N(lifetimeDefinition, completionSessionHeuristics, completionStateData2, textControlModel, completionSessionModel, editor));
                            }
                        });
                    }
                };
                this.$editor.getDocument().addDocumentListener(documentListener2, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)completionSessionLifetime, null, (int)1, null));
            }
        });
    }

    private final boolean j(Editor editor, PsiFile psiFile, Character c2, int n2) {
        if (this.j(editor, n2)) {
            return false;
        }
        Document document = psiFile.getViewProvider().getDocument();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel != null) {
            String string = FrontendCompletionHost.getCompletionPrefix$default(PreemptiveCompletionHost.Companion.getInstance(this.getProject()), n2, document2, psiFile, ModelUtilKt.getCurrentOffsetSafe(textControlModel), null, false, 48, null);
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List list2 = list;
            for (CompletionSessionStrategy completionSessionStrategy : list2) {
                try {
                    Boolean bl = completionSessionStrategy.shouldRescheduleCompletion(string, psiFile, c2, n2);
                    if (bl == null) continue;
                    return bl;
                }
                catch (Throwable throwable) {
                    this.logger.error("Error while calling shouldRescheduleCompletion API for '" + completionSessionStrategy.getClass().getName() + "' for char '" + c2 + "' for offset '" + n2 + "'");
                }
            }
        }
        return this.shouldRescheduleDefaultStrategy(c2);
    }

    public boolean shouldRescheduleDefaultStrategy(@Nullable Character c2) {
        return c2 == null || !Character.isLetterOrDigit(c2.charValue());
    }

    public final void terminateCompletionSessionIfNeeded(@NotNull Editor editor, int currentOffset, @Nullable Language language, @Nullable DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean bl = this.j(language);
        boolean bl2 = this.shouldTerminateOnRemove(event);
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstanceOrNull(this.getProject());
        if (frontendCompletionHost == null) {
            return;
        }
        FrontendCompletionHost frontendCompletionHost2 = frontendCompletionHost;
        Integer n2 = this.j(editor);
        if (n2 != null) {
            if (currentOffset < n2 || bl2 || bl && currentOffset == n2) {
                frontendCompletionHost2.terminateCurrentCompletion(editor, "Modification offset [" + currentOffset + "] < hideOffset [" + n2 + "]");
            } else if (!this.j(editor, frontendCompletionHost2)) {
                frontendCompletionHost2.terminateCurrentCompletion(editor, "Caret is moved outside identifier");
            }
        }
    }

    public static /* synthetic */ void terminateCompletionSessionIfNeeded$default(CompletionSessionHeuristics completionSessionHeuristics, Editor editor, int n2, Language language, DocumentEvent documentEvent, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: terminateCompletionSessionIfNeeded");
        }
        if ((n3 & 8) != 0) {
            documentEvent = null;
        }
        completionSessionHeuristics.terminateCompletionSessionIfNeeded(editor, n2, language, documentEvent);
    }

    private final boolean j(Editor editor, FrontendCompletionHost frontendCompletionHost) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return true;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().getValue();
        if (completionTuple == null || (completionTuple = completionTuple.getParameters()) == null) {
            return true;
        }
        CompletionTuple completionTuple2 = completionTuple;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile(editor);
        if (psiFile == null) {
            return true;
        }
        PsiFile psiFile2 = psiFile;
        int n2 = PlatformTextControlUtilsKt.getStartOffset(editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String string = FrontendCompletionHost.getCompletionPrefix$default(frontendCompletionHost, n2, document, psiFile2, ModelUtilKt.getCurrentOffsetSafe(textControlModel2), editor, false, 32, null);
        String string2 = completionTuple2.getPrefix();
        int n3 = completionTuple2.getOffset() - (string2 != null ? string2.length() : 0);
        int n4 = n2 - string.length();
        return n4 == n3;
    }

    protected boolean shouldTerminateOnRemove(@Nullable DocumentEvent event) {
        if (event == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)event.getNewFragment()).toString(), (Object)"") && Intrinsics.areEqual((Object)((Object)event.getOldFragment()).toString(), (Object)"\n");
    }

    private final boolean j(Language language) {
        boolean bl;
        block6: {
            if (language == null) {
                return false;
            }
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(language);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List list2 = list;
            Iterable iterable = list2;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t10 : iterable) {
                    boolean bl3;
                    CompletionSessionStrategy completionSessionStrategy = (CompletionSessionStrategy)t10;
                    boolean bl4 = false;
                    try {
                        bl3 = completionSessionStrategy.shouldTerminateOnEmptyPrefix();
                    }
                    catch (Throwable throwable) {
                        this.logger.error("Error while calling shouldTerminateOnEmptyPrefix API for '" + completionSessionStrategy.getClass().getName() + "'");
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Integer j(Editor editor) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return null;
        }
        TextControlModel textControlModel2 = textControlModel;
        int n2 = ModelUtilKt.getCurrentOffsetSafe(textControlModel2);
        if (n2 < 0) {
            return null;
        }
        String string = ModelUtilKt.getCurrentSessionPrefix(textControlModel2);
        if (string == null) {
            string = "";
        }
        return n2 - string.length();
    }

    private final void j(Editor editor, int n2, int n3, int n4) {
        boolean bl;
        Logger logger;
        Character c2;
        if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)this.getProject())) {
            return;
        }
        TextControlId textControlId = DocumentExKt.getTextControlId((Editor)editor);
        if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        if (!ClientCompletionSupport.Companion.getInstance().preemptiveCompletionEnabled(psiFile2, n2)) {
            CompletionSessionHeuristics.terminateCompletionSessionIfNeeded$default(this, editor, editor.getCaretModel().getOffset(), DocumentUtilKt.getLanguage((Editor)editor), null, 8, null);
            return;
        }
        if (n3 - n4 == 1) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            c2 = DocumentExKt.getCharAt((Document)document, (int)n4);
        } else {
            c2 = null;
        }
        Character c3 = c2;
        Logger logger2 = this.logger;
        boolean bl2 = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            bl = false;
            logger.trace("Viewing new caret change. Typed Char is '" + c3 + "'");
        }
        if (this.j(editor, n2)) {
            logger2 = this.logger;
            bl2 = false;
            if (logger2.isTraceEnabled()) {
                logger = logger2;
                bl = false;
                logger.trace("Caret " + n2 + " was moved within the active frontend completion. Don't interrupt the session...");
            }
            return;
        }
        if (c3 != null && !this.j(editor, psiFile2, c3, n2)) {
            this.logger.trace("Caret was moved due to the simple letter typing. Don't interrupt the session...");
            return;
        }
        this.j(editor, "New completion session is coming for offset " + n2 + " and char " + c3 + ".");
    }

    private final void j(Editor editor, String string) {
        if (PowerSaveMode.isEnabled()) {
            this.logger.debug("skipping preemptive completion session, cause PowerSave mode is on");
            return;
        }
        PreemptiveCompletionHost.Companion.getInstance(this.getProject()).tryScheduleCompletion(editor, string);
    }

    private final boolean N(Editor editor, int n2) {
        boolean bl;
        block4: {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return false;
            }
            PsiFile psiFile2 = psiFile;
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile2.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List list2 = list;
            Iterable iterable = list2;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t10 : iterable) {
                    CompletionSessionStrategy completionSessionStrategy = (CompletionSessionStrategy)t10;
                    boolean bl3 = false;
                    if (completionSessionStrategy.shouldSaveWhenActiveSession(editor, psiFile2, n2)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean j(Editor editor, int n2) {
        return this.N(editor, n2) && (CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)editor) || CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() != null && this.j(n2));
    }

    private final boolean j(int n2) {
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        if (completionProgressIndicator == null) {
            return false;
        }
        CompletionProgressIndicator completionProgressIndicator2 = completionProgressIndicator;
        LookupImpl lookupImpl = completionProgressIndicator2.getLookup();
        Intrinsics.checkNotNullExpressionValue((Object)lookupImpl, (String)"getLookup(...)");
        LookupImpl lookupImpl2 = lookupImpl;
        if (lookupImpl2.getLookupOriginalStart() < 0) {
            return false;
        }
        Editor editor = lookupImpl2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Integer n3 = this.j(editor);
        int n4 = n3 != null ? n3.intValue() : lookupImpl2.getLookupStart();
        return n4 <= n2;
    }

    private static final void j(CompletionSessionHeuristics completionSessionHeuristics, Project project2) {
        Intrinsics.checkNotNullParameter((Object)((Object)completionSessionHeuristics), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"$project");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster editorEventMulticaster2 = editorEventMulticaster;
        CaretListener caretListener = new CaretListener(completionSessionHeuristics, project2){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void caretPositionChanged(@NotNull CaretEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                ApplicationKt.getApplication().assertIsDispatchThread();
                Editor editor = e2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                LogicalPosition logicalPosition = e2.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                LogicalPosition logicalPosition2 = logicalPosition;
                LogicalPosition logicalPosition3 = e2.getOldPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"getOldPosition(...)");
                LogicalPosition logicalPosition4 = logicalPosition3;
                Caret caret = e2.getCaret();
                Intrinsics.checkNotNull((Object)caret);
                int n2 = caret.getOffset();
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor2, n2, editor2.logicalPositionToOffset(logicalPosition2), editor2.logicalPositionToOffset(logicalPosition4));
            }

            public void caretAdded(@NotNull CaretEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.j(e2);
            }

            public void caretRemoved(@NotNull CaretEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.j(e2);
            }

            private final void j(CaretEvent caretEvent) {
                PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(this.$project);
                Editor editor = caretEvent.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                preemptiveCompletionHost.tryScheduleCompletion(editor, "onAddRemove caret event");
            }
        };
        SelectionListener selectionListener2 = new SelectionListener(completionSessionHeuristics){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SelectionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                super.selectionChanged(e2);
                ApplicationKt.getApplication().assertIsDispatchThread();
                if (e2.getOldRange().isEmpty()) {
                    return;
                }
                Editor editor = e2.getEditor();
                int n2 = e2.getNewRange().getStartOffset();
                int n3 = e2.getOldRange().getStartOffset();
                int n4 = n2;
                Intrinsics.checkNotNull((Object)editor);
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor, n4, n2, n3);
            }
        };
        DocumentListener documentListener2 = new DocumentListener(project2, completionSessionHeuristics){
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                if (DocumentExKt.getDocumentSynchronizer((Document)document, (Project)this.$project) == null) {
                    return;
                }
                FileEditor fileEditor = FileEditorManager.getInstance((Project)this.$project).getSelectedEditor();
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null) {
                    return;
                }
                TextEditor textEditor2 = textEditor;
                Editor editor = textEditor2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (!Intrinsics.areEqual((Object)editor2.getDocument(), (Object)event.getDocument())) {
                    return;
                }
                TextControlId textControlId = DocumentExKt.getTextControlId((Editor)editor2);
                if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                    return;
                }
                if (CompletionSessionHeuristics.access$shouldSaveWhenActiveSession(this.this$0, editor2, event.getOffset())) {
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(event.getDocument());
                if (psiFile == null) {
                    return;
                }
                fileEditor = psiFile;
                if (event.getOldLength() == 1 && event.getNewLength() == 0) {
                    this.this$0.terminateCompletionSessionIfNeeded(editor2, event.getOffset(), fileEditor.getLanguage(), event);
                } else if (event.getOldLength() == 0 && event.getNewLength() == 1) {
                    CharSequence charSequence = event.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    if (CompletionSessionHeuristics.access$shouldRescheduleCompletion(this.this$0, editor2, (PsiFile)fileEditor, Character.valueOf(StringsKt.single((CharSequence)charSequence)), event.getOffset())) {
                        CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor2, "documentModel changed with param: " + event);
                    }
                } else {
                    CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor2, "documentModel changed with param: " + event);
                }
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        };
        editorEventMulticaster2.addSelectionListener(selectionListener2, (Disposable)completionSessionHeuristics);
        editorEventMulticaster2.addCaretListener(caretListener, (Disposable)completionSessionHeuristics);
        editorEventMulticaster2.addDocumentListener(documentListener2, (Disposable)completionSessionHeuristics);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MyEditorTypingListener());
        Project project3 = completionSessionHeuristics.getProject();
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)project3).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(project3, completionSessionHeuristics){
            final /* synthetic */ Project $myProject;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.$myProject = $myProject;
                this.this$0 = $receiver;
            }

            public void editorBound(@NotNull Lifetime lifetime2, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)this.$myProject)) {
                    return;
                }
                this.this$0.adviceTerminateIfNoResults(lifetime2, editor);
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(CompletionSessionHeuristics $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$handleCaretChange(CompletionSessionHeuristics $this, Editor editor, int offset, int newPosition, int oldPosition) {
        $this.j(editor, offset, newPosition, oldPosition);
    }

    public static final /* synthetic */ boolean access$shouldSaveWhenActiveSession(CompletionSessionHeuristics $this, Editor editor, int offset) {
        return $this.j(editor, offset);
    }

    public static final /* synthetic */ boolean access$shouldRescheduleCompletion(CompletionSessionHeuristics $this, Editor editor, PsiFile psiFile, Character c2, int offset) {
        return $this.j(editor, psiFile, c2, offset);
    }

    public static final /* synthetic */ void access$tryScheduleCompletion(CompletionSessionHeuristics $this, Editor editor, String reason) {
        $this.j(editor, reason);
    }

    static {
        CompletionProgressIndicator.setAutopopupTriggerTime((int)10);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,406:1\n19#2,2:407\n13#3:409\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n*L\n72#1:407,2\n76#1:409\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompletionSessionHeuristics getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager componentManager = (ComponentManager)project2;
            boolean bl = false;
            Object object = componentManager.getComponent(CompletionSessionHeuristics.class);
            if (object == null) {
                throw new IllegalStateException("Component " + CompletionSessionHeuristics.class + " not found in container " + componentManager);
            }
            return (CompletionSessionHeuristics)((Object)object);
        }

        @Nullable
        public final CompletionSessionHeuristics tryGetInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager componentManager = (ComponentManager)project2;
            boolean bl = false;
            return (CompletionSessionHeuristics)((Object)componentManager.getComponent(CompletionSessionHeuristics.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

