/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rider.completion.ICompletionHelper;
import com.jetbrains.rider.completion.PreemptiveCompletionSuppressor;
import com.jetbrains.rider.completion.ProtocolCompletionContributor;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/completion/ClientCompletionSupport;", "", "()V", "HELPERS", "Lcom/intellij/lang/LanguageExtension;", "Lcom/jetbrains/rider/completion/ICompletionHelper;", "backendCompletionEnabled", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "backendCompletionEnabledInFile", "getIdentifierPart", "Lcom/intellij/patterns/ElementPattern;", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "completionOffset", "getIdentifierStart", "preemptiveCompletionEnabled", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nClientCompletionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1747#2,3:84\n1747#2,3:87\n1747#2,3:90\n*S KotlinDebug\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport\n*L\n60#1:84,3\n65#1:87,3\n78#1:90,3\n*E\n"})
public class ClientCompletionSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageExtension<ICompletionHelper> HELPERS = new LanguageExtension("com.intellij.frontend.completion.helper");

    @NotNull
    public ElementPattern<Character> getIdentifierStart(@NotNull PsiElement element, int offset, @NotNull Document document, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (ICompletionHelper iCompletionHelper : this.HELPERS.allForLanguageOrAny(element.getLanguage())) {
            ElementPattern<Character> elementPattern2 = iCompletionHelper.getIdentifierStart(offset, document, element, completionOffset);
            if (elementPattern2 == null) continue;
            return elementPattern2;
        }
        throw new IllegalStateException("no suitable completion helper was found!".toString());
    }

    @NotNull
    public ElementPattern<Character> getIdentifierPart(@NotNull PsiElement element, int offset, @NotNull Document document, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (ICompletionHelper iCompletionHelper : this.HELPERS.allForLanguageOrAny(element.getLanguage())) {
            ElementPattern<Character> elementPattern2 = iCompletionHelper.getIdentifierPart(offset, document, element, completionOffset);
            if (elementPattern2 == null) continue;
            return elementPattern2;
        }
        throw new IllegalStateException("no suitable completion helper was found!".toString());
    }

    public boolean backendCompletionEnabled(@Nullable Editor editor, int offset) {
        if (editor == null) {
            return false;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project3).getPsiFile(document2);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        return this.backendCompletionEnabled(psiFile2, offset);
    }

    public static /* synthetic */ boolean backendCompletionEnabled$default(ClientCompletionSupport clientCompletionSupport, Editor editor, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: backendCompletionEnabled");
        }
        if ((n3 & 2) != 0) {
            Editor editor2 = editor;
            n2 = editor2 != null ? PlatformTextControlUtilsKt.getStartOffset(editor2) : 0;
        }
        return clientCompletionSupport.backendCompletionEnabled(editor, n2);
    }

    public boolean backendCompletionEnabled(@NotNull PsiFile file2, int offset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageAtOffset(...)");
            Language language2 = language;
            List list = CompletionContributor.forLanguage((Language)language2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"forLanguage(...)");
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t10 : iterable) {
                    CompletionContributor completionContributor = (CompletionContributor)t10;
                    boolean bl3 = false;
                    if (!(completionContributor instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)completionContributor).isAvailable(file2, offset))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preemptiveCompletionEnabled(@NotNull PsiFile file2, int offset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageAtOffset(...)");
        Language language2 = language;
        List list = CompletionContributor.forLanguage((Language)language2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"forLanguage(...)");
        Iterable iterable = list;
        boolean bl2 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object t10 = iterator.next();
            CompletionContributor completionContributor = (CompletionContributor)t10;
            boolean bl3 = false;
            if (completionContributor instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)completionContributor).isAvailable(file2, offset) && ((ProtocolCompletionContributor)completionContributor).isPreemptive()) {
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        boolean bl4 = true;
        if (!bl4) return false;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (PreemptiveCompletionSuppressor.Companion.shouldSuppressPreemptiveCompletion(project2)) return false;
        return true;
    }

    public boolean backendCompletionEnabledInFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Set set = file2.getViewProvider().getLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLanguages(...)");
        Set set2 = set;
        for (Language language : set2) {
            boolean bl;
            block4: {
                List list;
                Intrinsics.checkNotNullExpressionValue((Object)CompletionContributor.forLanguage((Language)language), (String)"forLanguage(...)");
                Iterable iterable = list;
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t10 : iterable) {
                        CompletionContributor completionContributor = (CompletionContributor)t10;
                        boolean bl3 = false;
                        if (!(completionContributor instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)completionContributor).isAvailable(file2, 0))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/completion/ClientCompletionSupport$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/completion/ClientCompletionSupport;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nClientCompletionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,83:1\n40#2,3:84\n*S KotlinDebug\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport$Companion\n*L\n19#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientCompletionSupport getInstance() {
            boolean bl = false;
            Class<ClientCompletionSupport> clazz = ClientCompletionSupport.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ClientCompletionSupport)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

