/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.requests;

import com.intellij.ide.j.p.vt;
import com.jetbrains.N.N.j1;
import com.jetbrains.ls.requests.RequestMethod;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRequest<Response> {
    public static final String AUTH_TOKEN_HEADER_NAME = "Authorization";
    private long salt;
    private String machineId;
    private String hostName;
    private String userName;
    private String productCode;
    private boolean isSecure;
    private String ip;
    private int clientVersion = 1;
    private String buildNumber;
    private Map<String, String> headers;
    private String ideProductCode;
    private static final long a = vt.a(-6759280745867486666L, 7892837606242087560L, MethodHandles.lookup().lookupClass()).a(143253624334981L);

    public AbstractRequest() {
    }

    public AbstractRequest(String productCode) {
        this.productCode = productCode;
    }

    protected AbstractRequest(long salt, String productCode, @NotNull UserIdentification userIdentification) {
        this(salt, productCode, userIdentification.getMachineId(), userIdentification.getHostName(), userIdentification.getUserName(), userIdentification.getIdeProductCode());
    }

    protected AbstractRequest(long salt, String productCode, String machineId, String hostName, String userName, String ideProductCode) {
        this.salt = salt;
        this.productCode = productCode;
        this.machineId = machineId;
        this.hostName = hostName;
        this.userName = userName;
        this.ideProductCode = ideProductCode;
    }

    public long getSalt() {
        return this.salt;
    }

    public void setSalt(long salt) {
        this.salt = salt;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Deprecated
    public String getProductFamilyId() {
        return this.productCode;
    }

    @Deprecated
    public void setProductFamilyId(String productFamilyId) {
        this.productCode = productFamilyId;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(int clientVersion) {
        this.clientVersion = clientVersion;
    }

    public abstract String getActionName();

    public RequestMethod getRequestMethod() {
        return RequestMethod.GET;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nullable
    public String getIdeProductCode() {
        return this.ideProductCode;
    }

    public void setIdeProductCode(String ideProductCode) {
        this.ideProductCode = ideProductCode;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getAuthToken() {
        return this.headers != null ? this.headers.get(AUTH_TOKEN_HEADER_NAME) : null;
    }

    public void setAuthToken(String authToken) {
        this.headers = authToken != null ? Map.of(AUTH_TOKEN_HEADER_NAME, authToken) : null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers != null ? Map.copyOf(headers) : null;
    }

    public String toString() {
        long l2 = a ^ 0x445D8906563L;
        long l3 = l2 ^ 0xA851EC1944L;
        int n2 = (int)(l3 >>> 32);
        int n3 = (int)(l3 << 32 >>> 48);
        int n4 = (int)(l3 << 48 >>> 48);
        return j1.j(this, n2, (short)n3, (short)n4);
    }

    public String getPropertyValueString(String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            return "N/A";
        }
        return propertyValue.toString();
    }

    public static final class UserIdentification {
        private final String machineId;
        private final String machineId2 = UUID.randomUUID().toString();
        private final String hostName;
        private final String userName;
        private final String ideProductCode;

        public UserIdentification(String machineId, String hostName, String userName, String ideProductCode) {
            this.machineId = machineId;
            this.hostName = hostName;
            this.userName = userName;
            this.ideProductCode = ideProductCode;
        }

        public String getMachineId() {
            return this.machineId;
        }

        public String getMachineId2() {
            return this.machineId2;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getIdeProductCode() {
            return this.ideProductCode;
        }
    }
}

