/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.zipcache.CidrWritableZipBackedCache;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J/\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\r*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aH\u0007J*\u0010\u001b\u001a\u00020\r*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001dH\u0007J$\u0010\u001e\u001a\u00020\r*\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\r0\u0016H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipCacheUtil;", "", "()V", "j", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "expectedName", "", "findFile", "cacheDir", "name", "writeToFile", "", "dir", "Ljava/nio/file/Path;", "fileName", "content", "", "readBytes", "T", "block", "Lkotlin/Function1;", "Ljava/io/DataInputStream;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "refreshAllFilesInCacheRootSynchronously", "Lcom/jetbrains/cidr/zipcache/CidrWritableZipBackedCache;", "refreshVfsForCacheRootSynchronously", "onCompletion", "Lkotlin/Function0;", "writeBytes", "Ljava/io/DataOutputStream;", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrZipCacheUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipCacheUtil.kt\ncom/jetbrains/cidr/zipcache/CidrZipCacheUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class CidrZipCacheUtil {
    @NotNull
    public static final CidrZipCacheUtil INSTANCE = new CidrZipCacheUtil();

    private CidrZipCacheUtil() {
    }

    @RequiresBackgroundThread
    public final void refreshVfsForCacheRootSynchronously(@NotNull CidrWritableZipBackedCache<?, ?, ?> $this$refreshVfsForCacheRootSynchronously, @Nullable Function0<Unit> onCompletion) {
        Intrinsics.checkNotNullParameter($this$refreshVfsForCacheRootSynchronously, (String)"<this>");
        VirtualFile virtualFile2 = $this$refreshVfsForCacheRootSynchronously.getWritableCacheRoot();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        long l2 = System.currentTimeMillis();
        Semaphore semaphore = new Semaphore(1);
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile3};
        RefreshQueue.getInstance().refresh(false, true, () -> CidrZipCacheUtil.N(onCompletion, semaphore), virtualFileArray);
        if (onCompletion != null) {
            semaphore.waitFor();
        }
        long l3 = System.currentTimeMillis() - l2;
        CidrZipBackedCache.Companion.getLOG().info("VFS refresh after " + $this$refreshVfsForCacheRootSynchronously.getClass().getName() + " took " + StringUtil.formatDuration((long)l3));
    }

    public static /* synthetic */ void refreshVfsForCacheRootSynchronously$default(CidrZipCacheUtil cidrZipCacheUtil, CidrWritableZipBackedCache cidrWritableZipBackedCache, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            function0 = null;
        }
        cidrZipCacheUtil.refreshVfsForCacheRootSynchronously(cidrWritableZipBackedCache, (Function0<Unit>)function0);
    }

    @RequiresBackgroundThread
    public final void refreshAllFilesInCacheRootSynchronously(@NotNull CidrWritableZipBackedCache<?, ?, ?> $this$refreshAllFilesInCacheRootSynchronously) {
        Intrinsics.checkNotNullParameter($this$refreshAllFilesInCacheRootSynchronously, (String)"<this>");
        VirtualFile virtualFile2 = $this$refreshAllFilesInCacheRootSynchronously.getWritableCacheRoot();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile3};
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        CidrZipCacheUtil.refreshVfsForCacheRootSynchronously$default(this, $this$refreshAllFilesInCacheRootSynchronously, null, 1, null);
    }

    public final void writeToFile(@NotNull Path dir, @NotNull String fileName, @NotNull CharSequence content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path path = dir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
    }

    @Nullable
    public final VirtualFile findFile(@NotNull VirtualFile cacheDir, @NotNull String name) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VirtualFile virtualFile4 = cacheDir.findChild(name);
        if (virtualFile4 == null) {
            return null;
        }
        VirtualFile virtualFile5 = virtualFile3 = (virtualFile2 = virtualFile4);
        boolean bl = false;
        return INSTANCE.j(virtualFile2, name) ? virtualFile3 : null;
    }

    private final boolean j(VirtualFile virtualFile2, String string) {
        return Intrinsics.areEqual((Object)string, (Object)virtualFile2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readBytes(@NotNull Path $this$readBytes, @NotNull Function1<? super DataInputStream, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean bl = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$readBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = new DataInputStream(inputStream);
        Throwable throwable = null;
        try {
            object = block.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBytes(@NotNull Path $this$writeBytes, @NotNull Function1<? super DataOutputStream, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean bl = false;
        Closeable closeable = new DataOutputStream(PathKt.outputStream$default((Path)$this$writeBytes, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null));
        Throwable throwable = null;
        try {
            Object object = block.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void j(Function0 function0, Semaphore semaphore) {
        Intrinsics.checkNotNullParameter((Object)semaphore, (String)"$semaphore");
        try {
            function0.invoke();
        }
        finally {
            semaphore.up();
        }
    }

    private static final void N(Function0 function0, Semaphore semaphore) {
        Intrinsics.checkNotNullParameter((Object)semaphore, (String)"$semaphore");
        if (function0 != null) {
            ApplicationKt.getApplication().executeOnPooledThread(() -> CidrZipCacheUtil.j(function0, semaphore));
        }
    }
}

