/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.xcspec;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.appExtensions.ApplicationExtensionDebugMode;
import com.jetbrains.cidr.execution.appExtensions.ExtensionTypeInfoCache;
import com.jetbrains.cidr.execution.simulatorSupport.HostApplicationInfo;
import com.jetbrains.cidr.execution.simulatorSupport.SentinelHostApplicationXcodeExtension;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class XcodeExtensionsManagerEx
extends XcodeExtensionsManager {
    private final Map<String, List<SentinelHostApplicationXcodeExtension>> mySentinelHostApplicationXcodeExtensionMap = new HashMap<String, List<SentinelHostApplicationXcodeExtension>>();
    private final ExtensionTypeInfoCache myExtensionTypeInfoCache = new ExtensionTypeInfoCache();

    public XcodeExtensionsManagerEx() {
        super(false);
        this.init();
    }

    @Override
    @Nullable
    protected Boolean processPluginExtension(@NotNull String point, @NotNull Dictionary extensionDictionary, @NotNull File xcPluginDataFile) {
        Boolean bl;
        if (point == null) {
            XcodeExtensionsManagerEx.N(0);
        }
        if (extensionDictionary == null) {
            XcodeExtensionsManagerEx.N(1);
        }
        if (xcPluginDataFile == null) {
            XcodeExtensionsManagerEx.N(2);
        }
        if ((bl = super.processPluginExtension(point, extensionDictionary, xcPluginDataFile)) != null) {
            return bl;
        }
        try {
            switch (point) {
                case "Xcode.IDEKit.ExtensionSentinelHostApplications": {
                    this.N(extensionDictionary);
                    return true;
                }
                case "Xcode.IDEKit.ExtensionPointIdentifierToBundleIdentifier": {
                    this.myExtensionTypeInfoCache.cacheXcodeExtensionEntry(extensionDictionary);
                    return true;
                }
            }
        }
        catch (InvalidSpecException invalidSpecException) {
            XCLog.LOG.warn((Throwable)invalidSpecException);
            return true;
        }
        return null;
    }

    @NotNull
    public static XcodeExtensionsManagerEx getInstance() {
        XcodeExtensionsManagerEx xcodeExtensionsManagerEx = (XcodeExtensionsManagerEx)XcodeExtensionsManager.getInstance();
        if (xcodeExtensionsManagerEx == null) {
            XcodeExtensionsManagerEx.N(3);
        }
        return xcodeExtensionsManagerEx;
    }

    @NotNull
    public List<HostApplicationInfo> getSentinelHostAppsInfoList(@NotNull @NonNls String platformFamily) {
        List<SentinelHostApplicationXcodeExtension> list;
        if (platformFamily == null) {
            XcodeExtensionsManagerEx.N(4);
        }
        if ((list = this.mySentinelHostApplicationXcodeExtensionMap.get(platformFamily)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                XcodeExtensionsManagerEx.N(5);
            }
            return list2;
        }
        List list3 = ContainerUtil.flatten((Iterable)ContainerUtil.map(list, SentinelHostApplicationXcodeExtension::getHostApplicationList));
        if (list3 == null) {
            XcodeExtensionsManagerEx.N(6);
        }
        return list3;
    }

    @NotNull
    public ApplicationExtensionDebugMode getDebugMode(@NotNull @NonNls String platformFamilyId, @NotNull @NonNls String extensionTypeId) {
        if (platformFamilyId == null) {
            XcodeExtensionsManagerEx.N(7);
        }
        if (extensionTypeId == null) {
            XcodeExtensionsManagerEx.N(8);
        }
        ApplicationExtensionDebugMode applicationExtensionDebugMode = this.myExtensionTypeInfoCache.getDebugMode(platformFamilyId, extensionTypeId);
        if (applicationExtensionDebugMode == null) {
            XcodeExtensionsManagerEx.N(9);
        }
        return applicationExtensionDebugMode;
    }

    @TestOnly
    @Nullable
    public String getPostLaunchActionId(@NotNull @NonNls String platformFamilyId, @NotNull @NonNls String extensionTypeId, @NotNull @NonNls String hostAppBundleId) {
        if (platformFamilyId == null) {
            XcodeExtensionsManagerEx.N(10);
        }
        if (extensionTypeId == null) {
            XcodeExtensionsManagerEx.N(11);
        }
        if (hostAppBundleId == null) {
            XcodeExtensionsManagerEx.N(12);
        }
        return this.myExtensionTypeInfoCache.getPostLaunchActionId(platformFamilyId, extensionTypeId, hostAppBundleId);
    }

    private void N(@NotNull Dictionary dictionary) {
        SentinelHostApplicationXcodeExtension sentinelHostApplicationXcodeExtension;
        if (dictionary == null) {
            XcodeExtensionsManagerEx.N(13);
        }
        if ((sentinelHostApplicationXcodeExtension = SentinelHostApplicationXcodeExtension.Companion.create(dictionary)) == null) {
            return;
        }
        List list = this.mySentinelHostApplicationXcodeExtensionMap.computeIfAbsent(sentinelHostApplicationXcodeExtension.getPlatformFamily(), string -> new SmartList());
        list.add(sentinelHostApplicationXcodeExtension);
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 5, 6, 9 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcPluginDataFile";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManagerEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformFamily";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformFamilyId";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionTypeId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostAppBundleId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManagerEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentinelHostAppsInfoList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPluginExtension";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSentinelHostAppsInfoList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDebugMode";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPostLaunchActionId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cacheXCSentinelHostApplicationExtensionInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

