/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.xcspec;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecDomainComposition;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XCSpecProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XcodeExtensionsManager {
    private static final Pattern XCPLUGINDATA_PATTERN = Pattern.compile(".*\\.xcplugindata");
    private final Map<String, List<XCSpecProvider>> myXCSpecProviderMap = new HashMap<String, List<XCSpecProvider>>();
    private final Map<String, List<String>> myDomainCompositionMap = new HashMap<String, List<String>>();
    private final Map<String, Dictionary> myExtendedPlatformInfoMap = new HashMap<String, Dictionary>();

    public XcodeExtensionsManager() {
        this(true);
    }

    protected XcodeExtensionsManager(boolean mayStartProcessing) {
        if (mayStartProcessing) {
            this.init();
        }
    }

    protected void init() {
        for (File file2 : XcodeExtensionsManager.j(XcodeBase.getInstance().getInstallation())) {
            try {
                List<Dictionary> list = PlistDriver.readAnyFormat(file2).getDictionary("plug-in", Dictionary.EMPTY_DICTIONARY).getDictionary("extensions", Dictionary.EMPTY_DICTIONARY).getObjects(Dictionary.class);
                for (Dictionary dictionary : list) {
                    String string = dictionary.getString("point");
                    if (string == null || this.processPluginExtension(string, dictionary, file2) != Boolean.FALSE) continue;
                }
            }
            catch (InvalidSpecException | IOException exception) {
                XCLog.LOG.warn((Throwable)exception);
            }
        }
    }

    @Nullable
    protected Boolean processPluginExtension(@NotNull String point, @NotNull Dictionary extensionDictionary, @NotNull File xcPluginDataFile) {
        if (point == null) {
            XcodeExtensionsManager.j(0);
        }
        if (extensionDictionary == null) {
            XcodeExtensionsManager.j(1);
        }
        if (xcPluginDataFile == null) {
            XcodeExtensionsManager.j(2);
        }
        try {
            switch (point) {
                case "Xcode.XCSpecProvider": {
                    this.j(extensionDictionary, xcPluginDataFile.getParent().intern());
                    return true;
                }
                case "Xcode.XCSpecDomainComposition": {
                    this.j(extensionDictionary);
                    return true;
                }
                case "Xcode.IDEFoundation.ExtendedPlatformInfo": {
                    this.myExtendedPlatformInfoMap.put(extensionDictionary.getNotNullString("platform"), extensionDictionary);
                    return true;
                }
            }
        }
        catch (InvalidSpecException invalidSpecException) {
            XCLog.LOG.warn((Throwable)invalidSpecException);
            return true;
        }
        return null;
    }

    @NotNull
    public static XcodeExtensionsManager getInstance() {
        XcodeExtensionsManager xcodeExtensionsManager = (XcodeExtensionsManager)ApplicationManager.getApplication().getService(XcodeExtensionsManager.class);
        if (xcodeExtensionsManager == null) {
            XcodeExtensionsManager.j(3);
        }
        return xcodeExtensionsManager;
    }

    @NotNull
    public List<XCSpecFile> getXCSpecFileList(@NotNull String domain) {
        if (domain == null) {
            XcodeExtensionsManager.j(4);
        }
        ArrayList<XCSpecFile> arrayList = new ArrayList<XCSpecFile>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(domain);
        linkedHashSet.addAll(this.getAllCompositionDomains(domain));
        for (String string : linkedHashSet) {
            List<XCSpecProvider> list = this.myXCSpecProviderMap.get(string);
            if (list == null) continue;
            for (XCSpecProvider xCSpecProvider : list) {
                for (String string2 : xCSpecProvider.getFiles()) {
                    arrayList.add(new XCSpecFile(new File(string2), string));
                }
            }
        }
        ArrayList<XCSpecFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            XcodeExtensionsManager.j(5);
        }
        return arrayList2;
    }

    @NotNull
    public List<String> getCompositionDomains(@NotNull String domain) {
        List<String> list;
        if (domain == null) {
            XcodeExtensionsManager.j(6);
        }
        List<String> list2 = (list = this.myDomainCompositionMap.get(domain)) != null ? Collections.unmodifiableList(list) : ContainerUtil.emptyList();
        if (list2 == null) {
            XcodeExtensionsManager.j(7);
        }
        return list2;
    }

    @NotNull
    public List<String> getAllCompositionDomains(@NotNull String domain) {
        if (domain == null) {
            XcodeExtensionsManager.j(8);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addLast(domain);
        while (!linkedList.isEmpty()) {
            String string = (String)linkedList.removeFirst();
            for (String string2 : this.getCompositionDomains(string)) {
                if (!linkedHashSet.add(string2)) continue;
                linkedList.addFirst(string2);
            }
        }
        linkedHashSet.add("default");
        List<String> list = List.copyOf(linkedHashSet);
        if (list == null) {
            XcodeExtensionsManager.j(9);
        }
        return list;
    }

    @Nullable
    public String getExtendedPlatformInfo(@NotNull String platformId, @NotNull String key) {
        Dictionary dictionary;
        if (platformId == null) {
            XcodeExtensionsManager.j(10);
        }
        if (key == null) {
            XcodeExtensionsManager.j(11);
        }
        return (dictionary = this.myExtendedPlatformInfoMap.get(platformId)) == null ? null : dictionary.getString(key);
    }

    @NotNull
    private static Collection<File> j(@NotNull XcodeInstallation xcodeInstallation) {
        if (xcodeInstallation == null) {
            XcodeExtensionsManager.j(12);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : xcodeInstallation.getXcodePluginsFolders()) {
            File[] fileArray = file2.listFiles();
            if (fileArray == null) continue;
            for (File file3 : fileArray) {
                arrayList.addAll(FileUtil.findFilesByMask((Pattern)XCPLUGINDATA_PATTERN, (File)new File(file3, "Contents/Resources")));
                arrayList.addAll(FileUtil.findFilesByMask((Pattern)XCPLUGINDATA_PATTERN, (File)new File(file3, "Resources")));
            }
        }
        ArrayList<File> arrayList2 = arrayList;
        if (arrayList2 == null) {
            XcodeExtensionsManager.j(13);
        }
        return arrayList2;
    }

    private void j(@NotNull Dictionary dictionary, @NotNull String string2) {
        if (dictionary == null) {
            XcodeExtensionsManager.j(14);
        }
        if (string2 == null) {
            XcodeExtensionsManager.j(15);
        }
        XCSpecProvider xCSpecProvider = new XCSpecProvider(dictionary, string2);
        List list = this.myXCSpecProviderMap.computeIfAbsent(xCSpecProvider.getDomain(), string -> new ArrayList());
        list.add(xCSpecProvider);
    }

    private void j(@NotNull Dictionary dictionary) throws InvalidSpecException {
        if (dictionary == null) {
            XcodeExtensionsManager.j(16);
        }
        XCSpecDomainComposition xCSpecDomainComposition = new XCSpecDomainComposition(dictionary);
        List list = this.myDomainCompositionMap.computeIfAbsent(xCSpecDomainComposition.getDomain(), string -> new ArrayList());
        list.addAll(xCSpecDomainComposition.getIncludedDomains());
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 5, 7, 9, 13 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcPluginDataFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManager";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installation";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginContentPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXCSpecFileList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositionDomains";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositionDomains";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectXCPluginDataFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPluginExtension";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXCSpecFileList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompositionDomains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllCompositionDomains";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedPlatformInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectXCPluginDataFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheXCSpecProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cacheDomainComposition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9, 13 -> new IllegalStateException(string);
        };
    }
}

