/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.SpecParsingException;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XMLPlistDriverImpl<T extends Dictionary> {
    @NotNull
    public T doRead(@NotNull ElementLoader loader) throws IOException, InvalidSpecException {
        if (loader == null) {
            XMLPlistDriverImpl.j(0);
        }
        Dictionary dictionary = (Dictionary)this.doRead(loader, true);
        if (dictionary == null) {
            XMLPlistDriverImpl.j(1);
        }
        return (T)dictionary;
    }

    @NotNull
    public Object doRead(@NotNull ElementLoader loader, @NotNull boolean convertArrayToDict) throws IOException, InvalidSpecException {
        block16: {
            Element element;
            block17: {
                T t10;
                Element element2;
                block15: {
                    block14: {
                        if (loader == null) {
                            XMLPlistDriverImpl.j(2);
                        }
                        element2 = loader.loadElement();
                        if (element2 != null) break block14;
                        T t11 = this.createDict();
                        if (t11 == null) {
                            XMLPlistDriverImpl.j(3);
                        }
                        return t11;
                    }
                    if (!"plist".equals(element2.getName())) {
                        throw new SpecParsingException("Unknown xml format. Root element is '" + element2.getName() + "'");
                    }
                    Element element3 = element2.getChild("dict");
                    if (element3 == null) break block15;
                    T t12 = this.readDict("", element3);
                    if (t12 == null) {
                        XMLPlistDriverImpl.j(4);
                    }
                    return t12;
                }
                try {
                    element = element2.getChild("array");
                    if (element == null) break block16;
                    if (!convertArrayToDict) break block17;
                    T t13 = this.createDict();
                    List<Object> list = this.j("", element);
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        ((Dictionary)t13).put("Item" + i2, list.get(i2));
                    }
                    t10 = t13;
                }
                catch (JDOMException jDOMException) {
                    throw new SpecParsingException(jDOMException);
                }
                if (t10 == null) {
                    XMLPlistDriverImpl.j(5);
                }
                return t10;
            }
            List<Object> list = this.j("", element);
            if (list == null) {
                XMLPlistDriverImpl.j(6);
            }
            return list;
        }
        T t14 = this.createDict();
        if (t14 == null) {
            XMLPlistDriverImpl.j(7);
        }
        return t14;
    }

    @NotNull
    protected abstract T createDict();

    @Nullable
    protected Object readValue(@NotNull @NonNls String key, @NotNull Element valueElement) {
        String string;
        if (key == null) {
            XMLPlistDriverImpl.j(8);
        }
        if (valueElement == null) {
            XMLPlistDriverImpl.j(9);
        }
        if ("dict".equals(string = valueElement.getName())) {
            return this.readDict(key, valueElement);
        }
        if ("array".equals(string)) {
            return this.j(key, valueElement);
        }
        return this.readBasicValue(string, valueElement);
    }

    @Nullable
    protected Object readBasicValue(@NotNull @NonNls String type, @NotNull Element valueElement) {
        if (type == null) {
            XMLPlistDriverImpl.j(10);
        }
        if (valueElement == null) {
            XMLPlistDriverImpl.j(11);
        }
        return switch (type) {
            case "string" -> valueElement.getValue();
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            case "integer" -> Long.parseLong(valueElement.getValue());
            case "real" -> Double.parseDouble(valueElement.getValue());
            case "date" -> Plist.parseDate(valueElement.getValue());
            case "data" -> {
                String var5_5 = valueElement.getValue().replaceAll("[^A-Za-z0-9+=/]", "");
                yield Base64.getDecoder().decode(var5_5);
            }
            default -> null;
        };
    }

    @NotNull
    protected T readDict(@NotNull @NonNls String key, @NotNull Element dictElement) {
        if (key == null) {
            XMLPlistDriverImpl.j(12);
        }
        if (dictElement == null) {
            XMLPlistDriverImpl.j(13);
        }
        T t10 = this.createDict();
        List list = dictElement.getChildren();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Element element;
            Object object;
            Object e2;
            Element element2;
            Object e3 = list.get(i2);
            if (!(e3 instanceof Element) || !"key".equals((element2 = (Element)e3).getName())) continue;
            String string = element2.getValue();
            if (!((e2 = list.get(++i2)) instanceof Element) || (object = this.readValue(string, element = (Element)e2)) == null) continue;
            ((Dictionary)t10).setAttribute(string, object);
        }
        T t11 = t10;
        if (t11 == null) {
            XMLPlistDriverImpl.j(14);
        }
        return t11;
    }

    private List<Object> j(@NotNull @NonNls String string, @NotNull Element element) {
        if (string == null) {
            XMLPlistDriverImpl.j(15);
        }
        if (element == null) {
            XMLPlistDriverImpl.j(16);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Element element2 : element.getChildren()) {
            Object object = this.readValue(string, element2);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    @NotNull
    public static Element elementWithObject(@NotNull Object object) throws IOException {
        if (object == null) {
            XMLPlistDriverImpl.j(17);
        }
        if (object instanceof String) {
            String string = (String)object;
            return XMLPlistDriverImpl.j(string);
        }
        if (object instanceof Boolean) {
            return XMLPlistDriverImpl.j((Boolean)object);
        }
        if (object instanceof Number) {
            return XMLPlistDriverImpl.j((Number)object);
        }
        if (object instanceof Date) {
            return XMLPlistDriverImpl.j((Date)object);
        }
        if (object instanceof byte[]) {
            return XMLPlistDriverImpl.j((byte[])object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return XMLPlistDriverImpl.j(map);
        }
        if (object instanceof List) {
            List list = (List)object;
            return XMLPlistDriverImpl.j(list);
        }
        throw new IOException("Cannot save element: " + object + "(class=" + object.getClass() + ")");
    }

    @NotNull
    private static Element j(@NotNull String string) {
        if (string == null) {
            XMLPlistDriverImpl.j(18);
        }
        return XMLPlistDriverImpl.j("string", string);
    }

    @NotNull
    private static Element j(@NotNull Boolean bl) {
        if (bl == null) {
            XMLPlistDriverImpl.j(19);
        }
        return new Element(bl == Boolean.TRUE ? "true" : "false");
    }

    @NotNull
    private static Element j(@NotNull Number number) {
        if (number == null) {
            XMLPlistDriverImpl.j(20);
        }
        return XMLPlistDriverImpl.j(number instanceof Float || number instanceof Double ? "real" : "integer", number.toString());
    }

    @NotNull
    private static Element j(@NotNull Date date) {
        if (date == null) {
            XMLPlistDriverImpl.j(21);
        }
        return XMLPlistDriverImpl.j("date", Plist.XCODE_DATE_FORMAT.format(date));
    }

    @NotNull
    private static Element j(@NotNull byte[] byArray) {
        if (byArray == null) {
            XMLPlistDriverImpl.j(22);
        }
        return XMLPlistDriverImpl.j("data", DatatypeConverter.printBase64Binary((byte[])byArray));
    }

    @NotNull
    private static Element j(@NotNull List list) throws IOException {
        if (list == null) {
            XMLPlistDriverImpl.j(23);
        }
        Element element = new Element("array");
        for (Object e2 : list) {
            element.addContent(XMLPlistDriverImpl.elementWithObject(e2));
        }
        Element element2 = element;
        if (element2 == null) {
            XMLPlistDriverImpl.j(24);
        }
        return element2;
    }

    @NotNull
    private static Element j(@NotNull Map map) throws IOException {
        if (map == null) {
            XMLPlistDriverImpl.j(25);
        }
        Element element = new Element("dict");
        for (Object k2 : map.keySet()) {
            Object v10 = map.get(k2);
            if (v10 == null) continue;
            element.addContent(XMLPlistDriverImpl.j("key", String.valueOf(k2)));
            element.addContent(XMLPlistDriverImpl.elementWithObject(v10));
        }
        Element element2 = element;
        if (element2 == null) {
            XMLPlistDriverImpl.j(26);
        }
        return element2;
    }

    @NotNull
    private static Element j(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            XMLPlistDriverImpl.j(27);
        }
        if (string2 == null) {
            XMLPlistDriverImpl.j(28);
        }
        Element element = new Element(string);
        element.setText(string2);
        Element element2 = element;
        if (element2 == null) {
            XMLPlistDriverImpl.j(29);
        }
        return element2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 14, 24, 26, 29 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/plist/XMLPlistDriverImpl";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/plist/XMLPlistDriverImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRead";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readDict";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithArray";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithDict";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readBasicValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readDict";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readArray";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "elementWithObject";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "elementWithString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "elementWithBoolean";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "elementWithNumber";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "elementWithDate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "elementWithData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "elementWithArray";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "elementWithDict";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "elementWithText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 14, 24, 26, 29 -> new IllegalStateException(string);
        };
    }

    public static interface ElementLoader {
        @Nullable
        public Element loadElement() throws JDOMException, IOException;
    }
}

