/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;

public abstract class PlistXmlWriter {
    public static PlistXmlWriter forXcode() {
        return new XcodePlistXmlWriter();
    }

    public static PlistXmlWriter forVisualStudio() {
        return new VisualStudioPlistXmlWriter();
    }

    public void write(@NotNull Object plist, @NotNull OutputStream stream) throws IOException {
        if (plist == null) {
            PlistXmlWriter.j(0);
        }
        if (stream == null) {
            PlistXmlWriter.j(1);
        }
        Element element = this.elementWithObject(plist);
        Format format = Format.getRawFormat().setIndent("\t").setTextMode(Format.TextMode.PRESERVE).setOmitEncoding(false).setOmitDeclaration(false).setExpandEmptyElements(false);
        StringWriter stringWriter = new StringWriter();
        new XMLOutputter(format).output(element, (Writer)stringWriter);
        String string = stringWriter.toString().replace(" />", "/>");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n";
            outputStreamWriter.write(string2);
            outputStreamWriter.write(string);
            outputStreamWriter.write("\n</plist>\n");
        }
    }

    @NotNull
    protected Element elementWithObject(@NotNull Object object) throws IOException {
        if (object == null) {
            PlistXmlWriter.j(2);
        }
        if (object instanceof String) {
            String string = (String)object;
            Element element = this.elementWithString(string);
            if (element == null) {
                PlistXmlWriter.j(3);
            }
            return element;
        }
        if (object instanceof Boolean) {
            Element element = this.elementWithBoolean((Boolean)object);
            if (element == null) {
                PlistXmlWriter.j(4);
            }
            return element;
        }
        if (object instanceof Number) {
            Element element = this.elementWithNumber((Number)object);
            if (element == null) {
                PlistXmlWriter.j(5);
            }
            return element;
        }
        if (object instanceof Date) {
            Element element = this.elementWithDate((Date)object);
            if (element == null) {
                PlistXmlWriter.j(6);
            }
            return element;
        }
        if (object instanceof byte[]) {
            Element element = this.elementWithData((byte[])object);
            if (element == null) {
                PlistXmlWriter.j(7);
            }
            return element;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Element element = this.elementWithDict(map);
            if (element == null) {
                PlistXmlWriter.j(8);
            }
            return element;
        }
        if (object instanceof List) {
            List list = (List)object;
            Element element = this.elementWithArray(list);
            if (element == null) {
                PlistXmlWriter.j(9);
            }
            return element;
        }
        throw new IOException("Cannot save element: " + object + "(class=" + object.getClass() + ")");
    }

    @NotNull
    protected Element elementWithString(@NotNull String value2) {
        if (value2 == null) {
            PlistXmlWriter.j(10);
        }
        Element element = this.elementWithText("string", value2);
        if (element == null) {
            PlistXmlWriter.j(11);
        }
        return element;
    }

    @NotNull
    protected Element elementWithBoolean(@NotNull Boolean value2) {
        if (value2 == null) {
            PlistXmlWriter.j(12);
        }
        return new Element(value2 == Boolean.TRUE ? "true" : "false");
    }

    @NotNull
    protected abstract Element elementWithNumber(@NotNull Number var1);

    @NotNull
    protected Element elementWithDate(@NotNull Date value2) {
        if (value2 == null) {
            PlistXmlWriter.j(13);
        }
        Element element = this.elementWithText("date", Plist.XCODE_DATE_FORMAT.format(value2));
        if (element == null) {
            PlistXmlWriter.j(14);
        }
        return element;
    }

    @NotNull
    protected Element elementWithData(@NotNull byte[] value2) {
        if (value2 == null) {
            PlistXmlWriter.j(15);
        }
        Element element = this.elementWithText("data", DatatypeConverter.printBase64Binary((byte[])value2));
        if (element == null) {
            PlistXmlWriter.j(16);
        }
        return element;
    }

    @NotNull
    protected Element elementWithArray(@NotNull List value2) throws IOException {
        if (value2 == null) {
            PlistXmlWriter.j(17);
        }
        Element element = new Element("array");
        for (Object e2 : value2) {
            element.addContent(this.elementWithObject(e2));
        }
        Element element2 = element;
        if (element2 == null) {
            PlistXmlWriter.j(18);
        }
        return element2;
    }

    @NotNull
    protected Element elementWithDict(@NotNull Map map) throws IOException {
        if (map == null) {
            PlistXmlWriter.j(19);
        }
        Element element = new Element("dict");
        for (Object k2 : map.keySet()) {
            Object v10 = map.get(k2);
            if (v10 == null) continue;
            element.addContent(this.elementWithText("key", String.valueOf(k2)));
            element.addContent(this.elementWithObject(v10));
        }
        Element element2 = element;
        if (element2 == null) {
            PlistXmlWriter.j(20);
        }
        return element2;
    }

    @NotNull
    protected Element elementWithText(@NotNull String elementName, @NotNull String value2) {
        if (elementName == null) {
            PlistXmlWriter.j(21);
        }
        if (value2 == null) {
            PlistXmlWriter.j(22);
        }
        Element element = new Element(elementName);
        element.setText(value2);
        Element element2 = element;
        if (element2 == null) {
            PlistXmlWriter.j(23);
        }
        return element2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 11, 14, 16, 18, 20, 23 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithObject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithDate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithArray";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithDict";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "elementWithText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "elementWithObject";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "elementWithString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "elementWithBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "elementWithDate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "elementWithData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "elementWithArray";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "elementWithDict";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "elementWithText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 11, 14, 16, 18, 20, 23 -> new IllegalStateException(string);
        };
    }

    private static final class XcodePlistXmlWriter
    extends PlistXmlWriter {
        private XcodePlistXmlWriter() {
        }

        @Override
        @NotNull
        protected Element elementWithNumber(@NotNull Number value2) {
            if (value2 == null) {
                XcodePlistXmlWriter.N(0);
            }
            if (value2 instanceof Float || value2 instanceof Double) {
                Element element = this.elementWithText("real", new DecimalFormat("0.################", new DecimalFormatSymbols(Locale.US)).format(value2));
                if (element == null) {
                    XcodePlistXmlWriter.N(1);
                }
                return element;
            }
            Element element = this.elementWithText("integer", value2.toString());
            if (element == null) {
                XcodePlistXmlWriter.N(2);
            }
            return element;
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter$XcodePlistXmlWriter";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter$XcodePlistXmlWriter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elementWithNumber";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "elementWithNumber";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class VisualStudioPlistXmlWriter
    extends PlistXmlWriter {
        private VisualStudioPlistXmlWriter() {
        }

        @Override
        @NotNull
        protected Element elementWithNumber(@NotNull Number value2) {
            if (value2 == null) {
                VisualStudioPlistXmlWriter.N(0);
            }
            Element element = this.elementWithText(value2 instanceof Float || value2 instanceof Double ? "real" : "integer", value2.toString());
            if (element == null) {
                VisualStudioPlistXmlWriter.N(1);
            }
            return element;
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter$VisualStudioPlistXmlWriter";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/plist/PlistXmlWriter$VisualStudioPlistXmlWriter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elementWithNumber";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "elementWithNumber";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

