/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.plist.BinaryPlistDriver;
import com.jetbrains.cidr.xcode.plist.NSPlistDriver;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriverBase;
import com.jetbrains.cidr.xcode.plist.XMLPlistDriver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlistDriver {
    @Nullable
    public static Plist readAnyFormatSafe(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PlistDriver.j(0);
        }
        try {
            return PlistDriver.readAnyFormat(file2);
        }
        catch (InvalidSpecException | IOException exception) {
            XCLog.LOG.info("Cannot read plist file: " + file2, (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public static Plist readAnyFormatSafe(@NotNull File file2) {
        if (file2 == null) {
            PlistDriver.j(1);
        }
        try {
            return PlistDriver.readAnyFormat(file2);
        }
        catch (InvalidSpecException | IOException exception) {
            XCLog.LOG.info("Cannot read plist file: " + file2, (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public static Plist readAnyFormatSafe(@NotNull InputStream stream) {
        if (stream == null) {
            PlistDriver.j(2);
        }
        try {
            return PlistDriver.readAnyFormat(stream);
        }
        catch (InvalidSpecException | IOException exception) {
            XCLog.LOG.info("Cannot read plist", (Throwable)exception);
            return null;
        }
    }

    @NotNull
    public static Plist readAnyFormat(@NotNull VirtualFile file2) throws IOException, InvalidSpecException {
        if (file2 == null) {
            PlistDriver.j(3);
        }
        return PlistDriver.readAnyFormat(file2.getInputStream());
    }

    @NotNull
    public static Plist readAnyFormat(@NotNull File file2) throws IOException, InvalidSpecException {
        if (file2 == null) {
            PlistDriver.j(4);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        Plist plist = PlistDriver.readAnyFormat(bufferedInputStream);
        Plist plist2 = plist;
        if (plist2 == null) {
            PlistDriver.j(5);
        }
        return plist2;
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    @NotNull
    public static Plist readAnyFormat(@NotNull InputStream stream) throws IOException, InvalidSpecException {
        if (stream == null) {
            PlistDriver.j(6);
        }
        byte[] byArray = StreamUtil.loadFromStream((InputStream)stream);
        Exception exception = null;
        for (PlistDriverBase plistDriverBase : Arrays.asList(new BinaryPlistDriver(), new NSPlistDriver(), new XMLPlistDriver())) {
            Plist plist;
            try {
                plist = plistDriverBase.read(byArray);
            }
            catch (InvalidSpecException | IOException exception2) {
                exception = exception2;
                continue;
            }
            if (plist == null) {
                PlistDriver.j(7);
            }
            return plist;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (InvalidSpecException)exception;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/plist/PlistDriver";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/plist/PlistDriver";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readAnyFormat";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readAnyFormatSafe";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readAnyFormat";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

