/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.SpecParsingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Plist
extends Dictionary {
    public static final Plist EMPTY_PLIST = new Plist(true);
    public static final SimpleDateFormat XCODE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat VISUAL_STUDIO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private static final SimpleDateFormat VISUAL_STUDIO_DATE_WRONG_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Plist() {
    }

    private Plist(boolean empty) {
        super(true);
    }

    @Override
    protected boolean isValidAttribute(Object value2) {
        return value2 == null || value2 instanceof String || value2 instanceof Number || value2 instanceof Boolean || value2 instanceof Date || value2 instanceof byte[] || value2 instanceof List || value2 instanceof Plist;
    }

    @Nullable
    public Boolean getBoolean(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(0);
        }
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(@NotNull @NonNls String key, @Nullable Boolean defValue) {
        Object object;
        if (key == null) {
            Plist.N(1);
        }
        if ((object = this.getAttribute(key, Object.class)) instanceof String) {
            String string = (String)object;
            if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
                return true;
            }
            if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
                return false;
            }
        } else if (object instanceof Number) {
            return ((Number)object).intValue() > 0;
        }
        return object == null ? defValue : this.checked(object, Boolean.class);
    }

    @NotNull
    public Boolean getNotNullBoolean(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(2);
        }
        Boolean bl = this.notNull(key, this.getBoolean(key));
        if (bl == null) {
            Plist.N(3);
        }
        return bl;
    }

    @Nullable
    public Long getInteger(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(4);
        }
        return this.getInteger(key, null);
    }

    public Long getInteger(@NotNull @NonNls String key, @Nullable Integer defValue) {
        Object object;
        if (key == null) {
            Plist.N(5);
        }
        if ((object = this.getAttribute(key, Object.class)) instanceof String) {
            try {
                Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object == null ? (defValue == null ? null : Long.valueOf(defValue.longValue())) : this.checked(object, Long.class);
    }

    @NotNull
    public Long getNotNullInteger(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(6);
        }
        Long l2 = this.notNull(key, this.getInteger(key));
        if (l2 == null) {
            Plist.N(7);
        }
        return l2;
    }

    @Nullable
    public Double getFloat(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(8);
        }
        return this.getFloat(key, null);
    }

    public Double getFloat(@NotNull @NonNls String key, @Nullable Double defValue) {
        Object object;
        if (key == null) {
            Plist.N(9);
        }
        if ((object = this.getAttribute(key, Object.class)) instanceof String) {
            try {
                Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object == null ? defValue : this.checked(object, Double.class);
    }

    @NotNull
    public Double getNotNullFloat(@NotNull @NonNls String key) {
        if (key == null) {
            Plist.N(10);
        }
        Double d2 = this.notNull(key, this.getFloat(key));
        if (d2 == null) {
            Plist.N(11);
        }
        return d2;
    }

    public static Date parseDate(String dateString) {
        try {
            return XCODE_DATE_FORMAT.parse(dateString);
        }
        catch (ParseException parseException) {
            try {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateString).withOffsetSameInstant(ZoneOffset.UTC);
                return new GregorianCalendar(offsetDateTime.getYear(), offsetDateTime.getMonth().ordinal(), offsetDateTime.getDayOfMonth(), offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond()).getTime();
            }
            catch (Exception exception) {
                try {
                    return VISUAL_STUDIO_DATE_WRONG_FORMAT.parse(dateString);
                }
                catch (ParseException parseException2) {
                    throw new SpecParsingException(parseException2);
                }
            }
        }
    }

    @Nullable
    public static Date parseDateOrNull(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return Plist.parseDate(dateString);
        }
        catch (SpecParsingException specParsingException) {
            return null;
        }
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 7, 11 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/plist/Plist";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/plist/Plist";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullBoolean";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullInteger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullFloat";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullBoolean";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullInteger";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFloat";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullFloat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 11 -> new IllegalStateException(string);
        };
    }
}

