/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.xcode.SpecParser;
import com.jetbrains.cidr.xcode.pbxproj.PbxLexer;
import com.jetbrains.cidr.xcode.pbxproj.PbxTokenType;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NSPlistParser
extends SpecParser {
    private static Plist j() {
        return new Plist();
    }

    public static Plist parse(PbxLexer lexer) {
        for (int i2 = 0; i2 < 2; ++i2) {
            IElementType iElementType = lexer.getTokenType();
            if (iElementType == PbxTokenType.LBRACE) {
                return NSPlistParser.parseObject(lexer, NSPlistParser.j());
            }
            if (iElementType == PbxTokenType.LPAR) {
                List<Object> list = NSPlistParser.j(lexer);
                Plist plist = NSPlistParser.j();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    plist.setAttribute("Item" + i3, list.get(i3));
                }
                return plist;
            }
            lexer.nextToken();
        }
        throw NSPlistParser.unexpectedTokenError(lexer, PbxTokenType.LBRACE, PbxTokenType.LPAR);
    }

    public static Plist parseObject(PbxLexer lexer, Plist plist) {
        NSPlistParser.expectAndNext(lexer, PbxTokenType.LBRACE);
        if (lexer.getTokenType() != PbxTokenType.RBRACE) {
            NSPlistParser.j(lexer, plist);
            while (lexer.getTokenType() != PbxTokenType.RBRACE) {
                NSPlistParser.j(lexer, plist);
            }
        }
        lexer.nextToken();
        return plist;
    }

    private static void j(PbxLexer pbxLexer, Plist plist) {
        IElementType iElementType = pbxLexer.getTokenType();
        String string = null;
        if (iElementType == PbxTokenType.VALUE || iElementType == PbxTokenType.STRING_LITERAL) {
            string = pbxLexer.getTokenText();
            if (iElementType == PbxTokenType.STRING_LITERAL) {
                string = StringUtil.unescapeStringCharacters((String)string.substring(1, string.length() - 1));
            }
        }
        if (string == null) {
            throw NSPlistParser.error(pbxLexer, "Object attribute key expected");
        }
        pbxLexer.nextToken();
        NSPlistParser.expectAndNext(pbxLexer, PbxTokenType.EQ);
        Object object = NSPlistParser.j(pbxLexer, NSPlistParser.j());
        NSPlistParser.expectAndNext(pbxLexer, PbxTokenType.SEMICOLON);
        try {
            plist.setAttribute(string, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Object j(PbxLexer pbxLexer, Plist plist) {
        IElementType iElementType = pbxLexer.getTokenType();
        if (iElementType == PbxTokenType.LBRACE) {
            return NSPlistParser.parseObject(pbxLexer, plist);
        }
        if (iElementType == PbxTokenType.LPAR) {
            return NSPlistParser.j(pbxLexer);
        }
        if (iElementType == PbxTokenType.VALUE) {
            String string = pbxLexer.getTokenText();
            pbxLexer.nextToken();
            return string;
        }
        if (iElementType == PbxTokenType.STRING_LITERAL || iElementType == PbxTokenType.HEX_LITERAL) {
            String string = pbxLexer.getTokenText();
            pbxLexer.nextToken();
            return StringUtil.unescapeStringCharacters((String)string.substring(1, string.length() - 1));
        }
        throw NSPlistParser.error(pbxLexer, "Cannot parse attribute value, unexpectedToken");
    }

    private static List<Object> j(PbxLexer pbxLexer) {
        NSPlistParser.expectAndNext(pbxLexer, PbxTokenType.LPAR);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (pbxLexer.getTokenType() != PbxTokenType.RPAR) {
            arrayList.add(NSPlistParser.j(pbxLexer, NSPlistParser.j()));
            if (pbxLexer.getTokenType() != PbxTokenType.COMMA) continue;
            pbxLexer.nextToken();
        }
        NSPlistParser.expectAndNext(pbxLexer, PbxTokenType.RPAR);
        return arrayList;
    }
}

