/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.plist;

import com.intellij.openapi.util.io.StreamUtil;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.SpecParsingException;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BinaryPlistParser {
    private static final long DATE_BASE = new GregorianCalendar(2001, 0, 1, 1, 0, 0).getTimeInMillis();
    private boolean isBig;
    private final List<Object> myObjectTable = new ArrayList<Object>();

    public Plist parse(InputStream stream) throws IOException {
        byte[] byArray;
        int n2;
        MyByteArrayInputStream myByteArrayInputStream = new MyByteArrayInputStream(StreamUtil.loadFromStream((InputStream)stream));
        try (Object object = new DataInputStream(myByteArrayInputStream);){
            int n3 = ((DataInputStream)object).readInt();
            int n4 = ((DataInputStream)object).readInt();
            if (n3 != 1651534953 || n4 != 1936994352) {
                throw new SpecParsingException("Not a binary plist");
            }
            myByteArrayInputStream.setPos(myByteArrayInputStream.length() - 32);
            n2 = (int)((DataInputStream)object).readLong();
            int n5 = (int)((DataInputStream)object).readLong();
            int n6 = (int)((DataInputStream)object).readLong();
            int n7 = (int)((DataInputStream)object).readLong();
            myByteArrayInputStream.setPos(8);
            byArray = myByteArrayInputStream.readNBytes(n7 - 8);
            this.isBig = n5 > 255;
        }
        this.j(new DataInputStream(new ByteArrayInputStream(byArray)));
        object = this.myObjectTable.get(0);
        if (object instanceof MyDictionary) {
            return this.j((MyDictionary)object);
        }
        if (object instanceof MyArray) {
            Plist plist = new Plist();
            List list = (List)this.j(object);
            for (n2 = 0; n2 < list.size(); ++n2) {
                plist.setAttribute("Item" + n2, list.get(n2));
            }
            return plist;
        }
        throw new InvalidSpecException("Unknown root type: " + object);
    }

    private Plist j(MyDictionary myDictionary) {
        Plist plist = new Plist();
        for (int i2 = 0; i2 < myDictionary.keyRefs.length; ++i2) {
            Object object = this.j(this.myObjectTable.get(myDictionary.objectRefs[i2]));
            if (object == null) continue;
            plist.put(this.myObjectTable.get(myDictionary.keyRefs[i2]).toString(), object);
        }
        return plist;
    }

    private Object j(Object object) {
        if (object instanceof MyDictionary) {
            return this.j((MyDictionary)object);
        }
        if (object instanceof MyArray) {
            MyArray myArray = (MyArray)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(myArray.objectRefs.length);
            for (int i2 = 0; i2 < myArray.objectRefs.length; ++i2) {
                Object object2 = this.j(this.myObjectTable.get(myArray.objectRefs[i2]));
                if (object2 == null) continue;
                arrayList.add(object2);
            }
            return arrayList;
        }
        return object;
    }

    private void j(DataInputStream dataInputStream) throws IOException {
        int n2;
        block12: while ((n2 = dataInputStream.read()) != -1) {
            switch ((n2 & 0xF0) >> 4) {
                case 0: {
                    this.j(n2 & 0xF);
                    continue block12;
                }
                case 1: {
                    int n3 = 1 << (n2 & 0xF);
                    this.w(dataInputStream, n3);
                    continue block12;
                }
                case 2: {
                    int n3 = 1 << (n2 & 0xF);
                    this.N(dataInputStream, n3);
                    continue block12;
                }
                case 3: {
                    if ((n2 & 0xF) != 3) {
                        throw new SpecParsingException("Invalid marker byte: " + Integer.toBinaryString(n2));
                    }
                    this.N(dataInputStream);
                    continue block12;
                }
                case 4: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = BinaryPlistParser.j(dataInputStream);
                    }
                    this.v(dataInputStream, n3);
                    continue block12;
                }
                case 5: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = BinaryPlistParser.j(dataInputStream);
                    }
                    this.j(dataInputStream, n3);
                    continue block12;
                }
                case 6: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = BinaryPlistParser.j(dataInputStream);
                    }
                    this.t(dataInputStream, n3);
                    continue block12;
                }
                case 8: {
                    int n3 = (n2 & 0xF) + 1;
                    this.s(dataInputStream, n3);
                    continue block12;
                }
                case 10: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = BinaryPlistParser.j(dataInputStream);
                    }
                    this.j(dataInputStream, n3, this.isBig);
                    continue block12;
                }
                case 13: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = BinaryPlistParser.j(dataInputStream);
                    }
                    this.N(dataInputStream, n3, this.isBig);
                    continue block12;
                }
            }
            throw new SpecParsingException("Invalid marker byte: " + Integer.toBinaryString(n2));
        }
    }

    private static int j(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.read();
        if (n2 == -1 || (n2 & 0xF0) >> 4 != 1) {
            throw new SpecParsingException("Cannot read size: " + Integer.toBinaryString(n2));
        }
        int n3 = 1 << (n2 & 0xF);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = dataInputStream.read();
            if (n5 == -1) {
                throw new SpecParsingException("Cannot read size at position" + i2);
            }
            n4 = n4 << 8 | n5;
        }
        return n4;
    }

    private void j(int n2) {
        switch (n2) {
            case 0: {
                this.myObjectTable.add(null);
                break;
            }
            case 8: {
                this.myObjectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.myObjectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new SpecParsingException("Invalid marker byte: " + Integer.toBinaryString(n2));
            }
        }
    }

    private void w(DataInputStream dataInputStream, int n2) throws IOException {
        if (n2 > 8) {
            throw new SpecParsingException("Unexpected int size: " + n2);
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = dataInputStream.read();
            if (n3 == -1) {
                throw new SpecParsingException("Cannot parse int in position: " + i2);
            }
            l2 = l2 << 8 | (long)n3;
        }
        this.myObjectTable.add(l2);
    }

    private void N(DataInputStream dataInputStream, int n2) throws IOException {
        switch (n2) {
            case 4: {
                this.myObjectTable.add(dataInputStream.readFloat());
                break;
            }
            case 8: {
                this.myObjectTable.add(dataInputStream.readDouble());
                break;
            }
            default: {
                throw new SpecParsingException("Unexpected real size: " + n2);
            }
        }
    }

    private void v(DataInputStream dataInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        this.myObjectTable.add(Base64.getEncoder().encodeToString(byArray));
    }

    private void N(DataInputStream dataInputStream) throws IOException {
        this.myObjectTable.add(new Date(DATE_BASE + (long)dataInputStream.readDouble() * 1000L));
    }

    private void j(DataInputStream dataInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        this.myObjectTable.add(new String(byArray, StandardCharsets.US_ASCII));
    }

    private void t(DataInputStream dataInputStream, int n2) throws IOException {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = dataInputStream.readChar();
        }
        this.myObjectTable.add(new String(cArray));
    }

    private void s(DataInputStream dataInputStream, int n2) throws IOException {
        if (n2 > 4) {
            throw new SpecParsingException("Unexpected uid size: " + n2);
        }
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        this.myObjectTable.add(new BigInteger(byArray).intValue());
    }

    private void j(DataInputStream dataInputStream, int n2, boolean bl) throws IOException {
        MyArray myArray = new MyArray();
        myArray.objectRefs = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = myArray.objectRefs[i2] = bl ? dataInputStream.readShort() & 0xFFFF : dataInputStream.readByte() & 0xFF;
            if (myArray.objectRefs[i2] != -1) continue;
            throw new SpecParsingException("Cannot read array of size: " + n2 + " at position: " + i2);
        }
        this.myObjectTable.add(myArray);
    }

    private void N(DataInputStream dataInputStream, int n2, boolean bl) throws IOException {
        int n3;
        MyDictionary myDictionary = new MyDictionary();
        myDictionary.keyRefs = new int[n2];
        myDictionary.objectRefs = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = myDictionary.keyRefs[n3] = bl ? dataInputStream.readShort() & 0xFFFF : dataInputStream.readByte() & 0xFF;
            if (myDictionary.keyRefs[n3] != -1) continue;
            throw new SpecParsingException("Cannot read dict of size: " + n2 + " at position: " + n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n5 = myDictionary.objectRefs[n3] = bl ? dataInputStream.readShort() & 0xFFFF : dataInputStream.readByte() & 0xFF;
            if (myDictionary.objectRefs[n3] != -1) continue;
            throw new SpecParsingException("Cannot read dict of size: " + n2 + " at position: " + n3);
        }
        this.myObjectTable.add(myDictionary);
    }

    private static class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public int length() {
            return this.count;
        }
    }

    private static class MyDictionary {
        int[] keyRefs;
        int[] objectRefs;

        private MyDictionary() {
        }
    }

    private static class MyArray {
        int[] objectRefs;

        private MyArray() {
        }
    }
}

