/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.util.JdomKt;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.NSPbxParser;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.plist.XMLPlistDriverImpl;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XMLPbxParser
extends XMLPlistDriverImpl<PBXDictionary> {
    private final boolean isPbxUserFile;
    private final CharSequence myText;
    private final PBXProjectFile myProjectFile;
    private final LinkedHashMap<PbxId, PBXObject> myFinalObjectsMap;
    private int myDepth = 0;
    private boolean isReadingObjectsSection = false;
    private final LinkedHashMap<PbxId, PBXObject> myObjectsMap = PBXProjectFile.createObjectsMap();

    XMLPbxParser(CharSequence text, boolean pbxuserFile, PBXProjectFile file2, LinkedHashMap<PbxId, PBXObject> objectsMap) {
        this.isPbxUserFile = pbxuserFile;
        this.myText = text;
        this.myProjectFile = file2;
        this.myFinalObjectsMap = objectsMap;
    }

    @NotNull
    public PBXDictionary parseFile() throws IOException, IllegalStateException {
        PBXDictionary pBXDictionary = (PBXDictionary)this.doRead(new XMLPlistDriverImpl.ElementLoader(){

            @Override
            @NotNull
            public Element loadElement() throws JDOMException, IOException {
                Element element = JdomKt.loadElementAndKeepBoundaryWhitespace((CharSequence)XMLPbxParser.this.myText);
                if (element == null) {
                    1.j(0);
                }
                return element;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser$1", "loadElement"));
            }
        });
        NSPbxParser.initObjectReferences(pBXDictionary, this.myProjectFile, this.myObjectsMap);
        this.myFinalObjectsMap.putAll(this.myObjectsMap);
        PBXDictionary pBXDictionary2 = pBXDictionary;
        if (pBXDictionary2 == null) {
            XMLPbxParser.N(0);
        }
        return pBXDictionary2;
    }

    @Override
    @NotNull
    protected PBXDictionary createDict() {
        return new PBXDictionary(this.myProjectFile);
    }

    @Override
    @NotNull
    protected PBXDictionary readDict(@NotNull String key, @NotNull Element dictElement) {
        if (key == null) {
            XMLPbxParser.N(1);
        }
        if (dictElement == null) {
            XMLPbxParser.N(2);
        }
        ++this.myDepth;
        boolean bl = false;
        if (!this.isPbxUserFile && this.myDepth == 2 && "objects".equals(key)) {
            bl = true;
            this.isReadingObjectsSection = true;
        }
        PBXDictionary pBXDictionary = (PBXDictionary)super.readDict(key, dictElement);
        if (this.myDepth == 3 && this.isReadingObjectsSection) {
            pBXDictionary = NSPbxParser.convertToObject(pBXDictionary, PbxId.fromString(key), PBXObject.getKind(pBXDictionary), this.myProjectFile, this.myObjectsMap);
        }
        if (bl) {
            this.isReadingObjectsSection = false;
        }
        --this.myDepth;
        PBXDictionary pBXDictionary2 = pBXDictionary;
        if (pBXDictionary2 == null) {
            XMLPbxParser.N(3);
        }
        return pBXDictionary2;
    }

    @Override
    @Nullable
    protected Object readBasicValue(@NotNull String type, @NotNull Element valueElement) {
        Object object;
        if (type == null) {
            XMLPbxParser.N(4);
        }
        if (valueElement == null) {
            XMLPbxParser.N(5);
        }
        return (object = super.readBasicValue(type, valueElement)) == null ? null : object.toString();
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readDict";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readDict";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readBasicValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

