/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PbxWriter {
    public static final Pattern QUOTED_VALUE_PATTERN = Pattern.compile("[\\w\\./$]+");
    private int indent = 0;
    private int indentsToWrite = 0;
    private final StringBuilder myBuilder = new StringBuilder();
    private static final Set<@NonNls String> myInlineSections = Set.of("PBXFileReference", "PBXBuildFile");

    private void j() {
        ++this.indent;
        this.indentsToWrite = this.indent;
    }

    private void N() {
        --this.indent;
        this.indentsToWrite = this.indent;
    }

    private void j(@NonNls String string) {
        this.myBuilder.append(string);
    }

    private void N(@NonNls String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("\n".equals(string2)) {
                this.indentsToWrite = this.indent;
            } else {
                for (int i2 = 0; i2 < this.indentsToWrite; ++i2) {
                    this.j("\t");
                }
                this.indentsToWrite = 0;
            }
            this.j(string2);
        }
    }

    public String getResult() {
        return this.myBuilder.toString();
    }

    public void write(PBXProjectFile file2) {
        this.N("// !$*UTF8*$!\n");
        this.N("{\n");
        this.j();
        this.N("archiveVersion = " + file2.getArchiveVersion() + ";\n");
        this.N("classes = {\n};\n");
        this.N("objectVersion = " + file2.getObjectVersion() + ";\n");
        this.N("objects = {\n");
        this.j(file2);
        this.N("};\n");
        this.N("rootObject = " + PbxWriter.j(file2.getProjectObject(), false) + ";\n");
        this.N();
        this.N("}\n");
    }

    private static String j(PBXObject pBXObject, boolean bl) {
        String string = bl ? null : pBXObject.getComment();
        return PbxWriter.j(pBXObject.getId().asString()) + (String)(string == null ? "" : " /* " + string + " */");
    }

    private void j(PBXProjectFile pBXProjectFile) {
        String string;
        MultiMap multiMap = new MultiMap();
        for (PBXObject object2 : pBXProjectFile.getObjects()) {
            string = object2.getKind();
            if (string == null) {
                throw new RuntimeException("Unknown object: " + object2.getDebugString());
            }
            multiMap.putValue((Object)string, (Object)object2);
        }
        ArrayList arrayList = new ArrayList(multiMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.j("\n/* Begin ");
            this.j(string);
            this.j(" section */\n");
            ArrayList<PBXObject> arrayList2 = new ArrayList<PBXObject>(multiMap.get((Object)string));
            arrayList2.sort(PBXObject.ID_COMPARATOR);
            this.j();
            for (PBXObject pBXObject : arrayList2) {
                this.writeObject(pBXObject, false);
            }
            this.N();
            this.j("/* End ");
            this.j(string);
            this.j(" section */\n");
        }
    }

    public void writeObject(PBXObject object, boolean debug) {
        this.N(PbxWriter.j(object, debug));
        this.N(" = ");
        this.j(object, debug);
        this.N(";\n");
    }

    private void j(PBXObject pBXObject, boolean bl) {
        String string = pBXObject.getKind();
        boolean bl2 = string == null || myInlineSections.contains(string);
        this.j(pBXObject, bl2, bl);
    }

    private void j(PBXObject pBXObject, boolean bl, boolean bl2) {
        ArrayList<String> arrayList;
        boolean bl3;
        this.N("{");
        if (!bl) {
            this.N("\n");
            this.j();
        }
        if (bl3 = (arrayList = new ArrayList<String>(pBXObject.keySet())).remove("isa")) {
            this.j(pBXObject, "isa", bl, bl2);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            this.j(pBXObject, string, bl, bl2);
        }
        if (!bl) {
            this.N();
        }
        this.N("}");
    }

    private void j(PBXObject pBXObject, @NonNls String string, boolean bl, boolean bl2) {
        this.N(PbxWriter.j(string));
        this.N(" = ");
        boolean bl3 = true;
        if ("remoteGlobalIDString".equals(string) || pBXObject instanceof PBXProject && "attributes".equals(string)) {
            bl3 = false;
        }
        this.j(pBXObject.get(string), bl, bl3, bl2);
        this.N(";");
        if (bl) {
            this.N(" ");
        } else {
            this.N("\n");
        }
    }

    private void j(Object object, boolean bl, boolean bl2, boolean bl3) {
        if (object instanceof String) {
            String string = (String)object;
            this.N(PbxWriter.j(string));
        } else if (object instanceof ObjectReference) {
            PBXObject pBXObject = ((ObjectReference)object).resolveObject();
            if (pBXObject != null && bl2) {
                this.N(PbxWriter.j(pBXObject, bl3));
            } else {
                this.N(((ObjectReference)object).getId().asString());
            }
        } else if (object instanceof PBXObject) {
            this.j((PBXObject)object, bl, bl3);
        } else if (object instanceof Collection) {
            this.N("(");
            if (!bl) {
                this.j();
                this.N("\n");
            }
            for (Object e2 : (Collection)object) {
                this.j(e2, bl, bl2, bl3);
                this.N(",");
                if (bl) {
                    this.N(" ");
                    continue;
                }
                this.N("\n");
            }
            if (!bl) {
                this.N();
            }
            this.N(")");
        } else if (object instanceof Map) {
            this.N("{");
            if (!bl) {
                this.j();
                this.N("\n");
            }
            Map map = (Map)object;
            ArrayList arrayList = new ArrayList(map.keySet());
            ContainerUtil.sort(arrayList);
            for (String string : arrayList) {
                this.N(PbxWriter.j(string));
                this.N(" = ");
                this.j(map.get(string), bl, bl2, bl3);
                this.N(";");
                if (bl) {
                    this.N(" ");
                    continue;
                }
                this.N("\n");
            }
            if (!bl) {
                this.N();
            }
            this.N("}");
        }
    }

    private static String j(String string) {
        if (QUOTED_VALUE_PATTERN.matcher(string).matches() && !string.contains("___")) {
            return string;
        }
        int n2 = string.length();
        return "\"" + StringUtil.escapeStringCharacters((int)n2, (String)string, (String)"\"", (boolean)true, (boolean)false, (StringBuilder)new StringBuilder(n2 + 42)) + "\"";
    }
}

