/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Random;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PbxId {
    private static final String USER_PREFIX = StringUtil.toUpperCase((String)StringUtil.first((String)Integer.toHexString(SystemProperties.getUserName().hashCode()), (int)5, (boolean)false));
    @NonNls
    private static final String CHARS = "0123456789ABCDEF";
    private static final Random RANDOM = new Random();
    public static final PbxId NONE = PbxId.fromString("");
    public static final Comparator<PbxId> COMPARATOR = (pbxId, pbxId2) -> {
        if (pbxId == null) {
            return pbxId2 == null ? 0 : -1;
        }
        if (pbxId2 == null) {
            return 1;
        }
        String string = pbxId.asString();
        String string2 = pbxId2.asString();
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2;
            char c3 = string.charAt(i2);
            if (c3 == (c2 = string2.charAt(i2))) continue;
            if (c3 == '_') {
                return 1;
            }
            if (c2 == '_') {
                return -1;
            }
            return c3 - c2;
        }
        return n2 - n3;
    };
    @NotNull
    private final String text;

    private PbxId(@NotNull String text) {
        if (text == null) {
            PbxId.j(0);
        }
        this.text = text;
    }

    public static PbxId fromString(@NotNull String text) {
        if (text == null) {
            PbxId.j(1);
        }
        return new PbxId(text);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PbxId)) {
            return false;
        }
        return this.text.equals(((PbxId)o2).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @NotNull
    public String asString() {
        String string = this.text;
        if (string == null) {
            PbxId.j(2);
        }
        return string;
    }

    public String toString() {
        return this.text;
    }

    public PbxId nextUniqueId() {
        return PbxId.fromString(StringUtil.toUpperCase((String)new BigInteger(this.text, 16).add(BigInteger.valueOf(1L)).toString(16)));
    }

    public static PbxId newUniqueId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(USER_PREFIX);
        int n2 = 24 - stringBuilder.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(CHARS.charAt(RANDOM.nextInt(CHARS.length())));
        }
        return PbxId.fromString(stringBuilder.toString());
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/PbxId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/PbxId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

