/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.xcode.SpecParser;
import com.jetbrains.cidr.xcode.SpecParsingException;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFactory;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxLexer;
import com.jetbrains.cidr.xcode.pbxproj.PbxTokenType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NSPbxParser
extends SpecParser {
    private final boolean myPbxuserFile;
    private final PbxLexer myLexer;
    private final PBXProjectFile myFile;
    private final LinkedHashMap<PbxId, PBXObject> myFinalObjectsMap;
    private final LinkedHashMap<PbxId, PBXObject> myObjectsMap = PBXProjectFile.createObjectsMap();
    private int myDepth = 0;

    NSPbxParser(CharSequence text, boolean pbxuserFile, PBXProjectFile file2, LinkedHashMap<PbxId, PBXObject> objectsMap) {
        this.myPbxuserFile = pbxuserFile;
        this.myLexer = new PbxLexer();
        this.myLexer.start(text);
        this.myFile = file2;
        this.myFinalObjectsMap = objectsMap;
    }

    public PBXDictionary parseFile() {
        if (this.myLexer.getTokenType() != PbxTokenType.LBRACE) {
            this.myLexer.nextToken();
        }
        PBXDictionary pBXDictionary = this.j(this.myPbxuserFile);
        if (this.myLexer.getTokenType() != null) {
            throw new SpecParsingException("Cannot parse to the end of file");
        }
        NSPbxParser.initObjectReferences(pBXDictionary, this.myFile, this.myObjectsMap);
        this.myFinalObjectsMap.putAll(this.myObjectsMap);
        return pBXDictionary;
    }

    @NotNull
    static Object initObjectReferences(@NotNull Object object2, @NotNull PBXProjectFile projectFile, @NotNull Map<PbxId, PBXObject> objects) {
        if (object2 == null) {
            NSPbxParser.N(0);
        }
        if (projectFile == null) {
            NSPbxParser.N(1);
        }
        if (objects == null) {
            NSPbxParser.N(2);
        }
        if (object2 instanceof String) {
            PbxId pbxId = PbxId.fromString((String)object2);
            if (objects.containsKey(pbxId)) {
                return new ObjectReference(pbxId, projectFile);
            }
        } else if (object2 instanceof PBXDictionary) {
            for (Map.Entry<String, Object> entry2 : ((PBXDictionary)object2).entrySet()) {
                if ("name".equals(entry2.getKey())) continue;
                entry2.setValue(NSPbxParser.initObjectReferences(entry2.getValue(), projectFile, objects));
            }
        } else if (object2 instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object2;
            arrayList.replaceAll(object -> NSPbxParser.initObjectReferences(object, projectFile, objects));
        }
        Object object3 = object2;
        if (object3 == null) {
            NSPbxParser.N(3);
        }
        return object3;
    }

    private PBXDictionary j(boolean bl) {
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.LBRACE);
        ++this.myDepth;
        PBXDictionary pBXDictionary = new PBXDictionary(this.myFile);
        while (this.myLexer.getTokenType() != PbxTokenType.RBRACE) {
            this.j(pBXDictionary, bl);
        }
        --this.myDepth;
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.RBRACE);
        return pBXDictionary;
    }

    private void j(PBXDictionary pBXDictionary, boolean bl) {
        String string;
        PbxId pbxId = null;
        IElementType iElementType = this.myLexer.getTokenType();
        if (iElementType == PbxTokenType.VALUE || iElementType == PbxTokenType.STRING_LITERAL) {
            string = this.myLexer.getTokenText();
            if (iElementType == PbxTokenType.STRING_LITERAL) {
                string = StringUtil.unescapeStringCharacters((String)string.substring(1, string.length() - 1));
            }
            if (bl) {
                pbxId = PbxId.fromString(string);
            }
        } else {
            throw NSPbxParser.error(this.myLexer, "Object attribute key expected");
        }
        this.myLexer.nextTokenOrComment();
        if (this.myLexer.getTokenType() == PbxTokenType.COMMENT) {
            if (bl) {
                this.myLexer.getTokenText();
            }
            this.myLexer.nextToken();
        }
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.EQ);
        Object object = this.j(!this.myPbxuserFile && this.myDepth == 1 && "objects".equals(string), bl);
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.SEMICOLON);
        if (bl && object instanceof PBXDictionary) {
            PBXDictionary pBXDictionary2 = (PBXDictionary)object;
            object = NSPbxParser.convertToObject(pBXDictionary2, pbxId, PBXObject.getKind(pBXDictionary2), this.myFile, this.myObjectsMap);
        }
        pBXDictionary.setAttribute(string, object);
    }

    @NotNull
    public static PBXObject convertToObject(@NotNull PBXDictionary from, @Nullable PbxId id, @Nullable @NonNls String kind, @NotNull PBXProjectFile file2, @NotNull Map<PbxId, PBXObject> addTo) {
        PBXObject pBXObject;
        if (from == null) {
            NSPbxParser.N(4);
        }
        if (file2 == null) {
            NSPbxParser.N(5);
        }
        if (addTo == null) {
            NSPbxParser.N(6);
        }
        PBXObject pBXObject2 = pBXObject = kind == null ? new PBXObject(file2) : PBXFactory.createObject(kind, file2);
        if (!from.isEmpty()) {
            pBXObject.putAll(from);
        }
        if (id != null) {
            pBXObject.setId(id);
            addTo.put(id, pBXObject);
        }
        PBXObject pBXObject3 = pBXObject;
        if (pBXObject3 == null) {
            NSPbxParser.N(7);
        }
        return pBXObject3;
    }

    private Object j(boolean bl, boolean bl2) {
        IElementType iElementType = this.myLexer.getTokenType();
        if (iElementType == PbxTokenType.LBRACE) {
            return this.j(bl);
        }
        if (!bl2) {
            if (iElementType == PbxTokenType.LPAR) {
                return this.j();
            }
            if (iElementType == PbxTokenType.VALUE) {
                String string = this.myLexer.getTokenText();
                this.myLexer.nextToken();
                return string;
            }
            if (iElementType == PbxTokenType.STRING_LITERAL) {
                String string = this.myLexer.getTokenText();
                this.myLexer.nextToken();
                try {
                    return StringUtil.unescapeStringCharacters((String)string.substring(1, string.length() - 1));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw NSPbxParser.error(this.myLexer, "cannot unescape string: " + string);
                }
            }
        }
        throw NSPbxParser.error(this.myLexer, "Cannot parse value, unexpected token type");
    }

    private Object j() {
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.LPAR);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.myLexer.getTokenType() != PbxTokenType.RPAR) {
            arrayList.add(this.j(false, false));
            if (this.myLexer.getTokenType() != PbxTokenType.COMMA) continue;
            this.myLexer.nextToken();
        }
        NSPbxParser.expectAndNext(this.myLexer, PbxTokenType.RPAR);
        return arrayList;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/NSPbxParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/NSPbxParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initObjectReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToObject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initObjectReferences";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

