/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.util.io.DigestUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class XcodeProjectsUtil {
    private static final Pattern ESCAPE_WHITESPACES_PATTERN = Pattern.compile("\\s+");

    private XcodeProjectsUtil() {
    }

    @NotNull
    public static String getEscapedProjectName(@NotNull String projectName) {
        if (projectName == null) {
            XcodeProjectsUtil.j(0);
        }
        String string = ESCAPE_WHITESPACES_PATTERN.matcher(projectName).replaceAll("_");
        if (string == null) {
            XcodeProjectsUtil.j(1);
        }
        return string;
    }

    @NotNull
    public static String getUniqueProjectHash(@NotNull String fullPath) {
        if (fullPath == null) {
            XcodeProjectsUtil.j(2);
        }
        char[] cArray = new char[28];
        byte[] byArray = fullPath.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = DigestUtil.md5().digest(byArray);
        BigInteger bigInteger = BigInteger.valueOf(26L);
        BigInteger bigInteger2 = XcodeProjectsUtil.j(byArray2, 8, 16);
        for (int i2 = 27; i2 >= 0; --i2) {
            cArray[i2] = (char)(bigInteger2.remainder(bigInteger).byteValue() + 97);
            bigInteger2 = bigInteger2.divide(bigInteger);
            if (i2 != 14) continue;
            bigInteger2 = XcodeProjectsUtil.j(byArray2, 0, 8);
        }
        return new String(cArray);
    }

    private static BigInteger j(byte[] byArray, int n2, int n3) {
        return new BigInteger(1, Arrays.copyOfRange(byArray, n2, n3));
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XcodeProjectsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XcodeProjectsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedProjectName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedProjectName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueProjectHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

