/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.project.Project;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.CachingBuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XCCoreBuildSettings
extends CachingBuildSettingsResolver {
    protected XCCoreBuildSettings(@NotNull Project project2) {
        if (project2 == null) {
            XCCoreBuildSettings.w(0);
        }
        super(project2);
    }

    @Nullable
    public AppleSdk getBaseSdk() {
        return this.getSdk();
    }

    @Nullable
    public String getDeploymentTarget() {
        BuildSetting buildSetting = this.getDeploymentTargetSetting();
        return buildSetting != null ? buildSetting.getString() : null;
    }

    @Nullable
    public BuildSetting getDeploymentTargetSetting() {
        AppleSdk appleSdk = this.getBaseSdk();
        if (appleSdk == null) {
            return null;
        }
        return this.getBuildSetting(XCCoreBuildSettings.getDeploymentTargetSettingName(appleSdk));
    }

    @NotNull
    public static String getDeploymentTargetSettingName(@NotNull AppleSdk sdk) {
        if (sdk == null) {
            XCCoreBuildSettings.w(1);
        }
        ApplePlatform.Type type = sdk.getPlatform().getType();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ApplePlatform.Type.IOS, ApplePlatform.Type.IOS_SIMULATOR -> "IPHONEOS_DEPLOYMENT_TARGET";
            case ApplePlatform.Type.WATCH, ApplePlatform.Type.WATCH_SIMULATOR -> "WATCHOS_DEPLOYMENT_TARGET";
            case ApplePlatform.Type.VISION, ApplePlatform.Type.VISION_SIMULATOR -> "XROS_DEPLOYMENT_TARGET";
            case ApplePlatform.Type.TVOS, ApplePlatform.Type.TVOS_SIMULATOR -> "TVOS_DEPLOYMENT_TARGET";
            case ApplePlatform.Type.MACOS -> "MACOSX_DEPLOYMENT_TARGET";
        };
    }

    @Nullable
    public static ApplePlatform.Type getSdkTypeByDeploymentTargetSettingName(@NotNull String deploymentTargetSettingName) {
        if (deploymentTargetSettingName == null) {
            XCCoreBuildSettings.w(2);
        }
        return switch (deploymentTargetSettingName) {
            case "IPHONEOS_DEPLOYMENT_TARGET" -> ApplePlatform.Type.IOS;
            case "WATCHOS_DEPLOYMENT_TARGET" -> ApplePlatform.Type.WATCH;
            case "XROS_DEPLOYMENT_TARGET" -> ApplePlatform.Type.VISION;
            case "TVOS_DEPLOYMENT_TARGET" -> ApplePlatform.Type.TVOS;
            case "MACOSX_DEPLOYMENT_TARGET" -> ApplePlatform.Type.MACOS;
            default -> null;
        };
    }

    @Override
    @NotNull
    protected abstract XCBuildConfiguration getBuildConfiguration();

    @Override
    @NotNull
    protected PBXProjectFile getProjectFile() {
        PBXProjectFile pBXProjectFile = this.getBuildConfiguration().getFile();
        if (pBXProjectFile == null) {
            XCCoreBuildSettings.w(3);
        }
        return pBXProjectFile;
    }

    @Override
    @Nullable
    protected PBXTarget getTarget() {
        return this.getBuildConfiguration().getTarget();
    }

    @NotNull
    public static XCCoreBuildSettings getRawCoreBuildSettings(final @NotNull XCBuildConfiguration config) {
        if (config == null) {
            XCCoreBuildSettings.w(4);
        }
        return new XCCoreBuildSettings(config.getProject()){

            @Override
            @NotNull
            protected XCBuildConfiguration getBuildConfiguration() {
                XCBuildConfiguration xCBuildConfiguration = config;
                if (xCBuildConfiguration == null) {
                    1.v(0);
                }
                return xCBuildConfiguration;
            }

            @Override
            protected AppleSdk getSdk() {
                return this.getBuildSetting("SDKROOT").getSdk();
            }

            @Override
            @NotNull
            protected Set<ArchitectureValue> getArchitectures() {
                Set<ArchitectureValue> set = this.getBuildSetting("ARCHS").getArchitectures();
                if (set == null) {
                    1.v(1);
                }
                return set;
            }

            @Override
            protected boolean areSdkAndArchitectureOverridden() {
                return false;
            }

            private static /* synthetic */ void v(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/xcode/model/XCCoreBuildSettings$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBuildConfiguration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getArchitectures";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void w(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTargetSettingName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XCCoreBuildSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XCCoreBuildSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentTargetSettingName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSdkTypeByDeploymentTargetSettingName";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRawCoreBuildSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

