/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCConfigurationList
extends PBXObject {
    public XCConfigurationList(PBXProjectFile file2) {
        super(file2);
    }

    @Override
    public String getComment() {
        PBXProjectFile pBXProjectFile = this.getFile();
        PBXProject pBXProject = pBXProjectFile.getProjectObject();
        XCConfigurationList xCConfigurationList = pBXProject.getBuildConfigurationList();
        if (xCConfigurationList == this) {
            return String.format("Build configuration list for PBXProject \"%s\"", pBXProjectFile.getName());
        }
        for (PBXTarget pBXTarget : pBXProject.getTargets()) {
            if (pBXTarget.getBuildConfigurationList() != this) continue;
            return "Build configuration list for " + pBXTarget.getKind() + " \"" + pBXTarget.getName() + "\"";
        }
        return null;
    }

    @NotNull
    public List<XCBuildConfiguration> getConfigurations() {
        List<XCBuildConfiguration> list = this.resolveAttributeList("buildConfigurations", XCBuildConfiguration.class);
        if (list == null) {
            XCConfigurationList.v(0);
        }
        return list;
    }

    @Nullable
    public XCBuildConfiguration getDefaultConfiguration() {
        List<XCBuildConfiguration> list;
        String string = this.getAttribute("defaultConfigurationName", String.class);
        if (string != null && (list = this.findConfiguration(string)) != null) {
            return list;
        }
        list = this.getConfigurations();
        return list.isEmpty() ? null : (XCBuildConfiguration)list.get(0);
    }

    @Nullable
    public XCBuildConfiguration findConfiguration(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (XCBuildConfiguration xCBuildConfiguration : this.getConfigurations()) {
            if (!xCBuildConfiguration.getName().equals(name)) continue;
            return xCBuildConfiguration;
        }
        return null;
    }

    private static /* synthetic */ void v(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/XCConfigurationList", "getConfigurations"));
    }
}

