/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCConfigParser;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.model.PBXAggregateTarget;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XcodeProjectEvent;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XCBuildConfiguration
extends PBXObject
implements BuildSettingValuesProvider,
UserDataHolderEx {
    @NonNls
    public static final String BUILD_SETTINGS_ATTRIBUTE = "buildSettings";
    @NotNull
    private final BuildSettingValuesProvider myXCConfigValuesProvider;
    @NotNull
    private final UserDataHolderEx myDataHolder;

    public XCBuildConfiguration(@NotNull PBXProjectFile file2) {
        if (file2 == null) {
            XCBuildConfiguration.v(0);
        }
        super(file2);
        this.myDataHolder = new UserDataHolderBase();
        this.myXCConfigValuesProvider = new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = XCConfigParser.parseFile(XCBuildConfiguration.this.getFile(), XCBuildConfiguration.this.getXCConfigFile());
                if (dictionary == null) {
                    1.j(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/XCBuildConfiguration$1", "getDeclaredBuildSettingValues"));
            }
        };
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.getNotNullString("name");
        if (string == null) {
            XCBuildConfiguration.v(1);
        }
        return string;
    }

    public boolean isDebug() {
        return StringUtil.containsIgnoreCase((String)this.getName(), (String)"debug");
    }

    @Nullable
    public XCBuildConfiguration getBaseConfiguration() {
        XCBuildConfiguration xCBuildConfiguration = this.getFile().getProjectObject().findBuildConfiguration(this.getName());
        return xCBuildConfiguration == this ? null : xCBuildConfiguration;
    }

    @Deprecated
    @Nullable
    public PBXTarget getTarget() {
        List<PBXTarget> list = this.getTargets();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.stream().filter(pBXTarget -> !(pBXTarget instanceof PBXAggregateTarget)).findFirst().orElse((PBXTarget)ContainerUtil.getFirstItem(list));
    }

    @NotNull
    public List<PBXTarget> getTargets() {
        List<PBXTarget> list = this.getFile().findTargetsFor(this);
        if (list == null) {
            XCBuildConfiguration.v(2);
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.getFile().getProject();
        if (project2 == null) {
            XCBuildConfiguration.v(3);
        }
        return project2;
    }

    public boolean setBuildSetting(@Nullable BuildSetting setting) {
        return this.setBuildSetting(setting, true);
    }

    public boolean setBuildSetting(@Nullable BuildSetting setting, boolean fireNotifications) {
        boolean bl = this.j(setting);
        if (bl && fireNotifications) {
            this.j();
        }
        return bl;
    }

    private boolean j(@Nullable BuildSetting buildSetting) {
        if (buildSetting == null) {
            return false;
        }
        Dictionary dictionary = this.getDictionary(BUILD_SETTINGS_ATTRIBUTE, null);
        if (dictionary == null) {
            dictionary = new PBXDictionary(this.getFile());
            this.setAttribute(BUILD_SETTINGS_ATTRIBUTE, dictionary);
        }
        boolean bl = buildSetting.getUnresolvedValueSource() != null;
        boolean bl2 = buildSetting.isDefinedIn(this);
        boolean bl3 = buildSetting.isModified();
        String string = buildSetting.getName();
        Object object = buildSetting.getUnresolvedValue();
        buildSetting.reset();
        if (!bl && !bl3) {
            return false;
        }
        if (bl2 && !bl3) {
            return false;
        }
        if (!bl2 && object == null && !dictionary.containsKey(string)) {
            return false;
        }
        dictionary.setAttribute(string, object);
        return true;
    }

    private void j() {
        XcodeProjectTrackers.getInstance(this.getProject()).workspaceChanged(XcodeProjectEvent.BUILD_SETTINGS_CHANGED);
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.getDictionary(BUILD_SETTINGS_ATTRIBUTE, EMPTY_DICTIONARY);
        if (dictionary == null) {
            XCBuildConfiguration.v(4);
        }
        return dictionary;
    }

    @Nullable
    public VirtualFile getXCConfigFile() {
        PBXFileReference pBXFileReference = this.j();
        return pBXFileReference == null ? null : pBXFileReference.findFile(this.getFile().getBuildSettingsProvider());
    }

    @Nullable
    public String getXCConfigFilePath() {
        PBXFileReference pBXFileReference = this.j();
        return pBXFileReference == null ? null : pBXFileReference.resolvePath(this.getFile().getBuildSettingsProvider());
    }

    @Nullable
    private PBXFileReference j() {
        return this.resolveAttribute("baseConfigurationReference", PBXFileReference.class);
    }

    @NotNull
    public BuildSettingValuesProvider getXCConfigBuildSettingValuesProvider() {
        BuildSettingValuesProvider buildSettingValuesProvider = this.myXCConfigValuesProvider;
        if (buildSettingValuesProvider == null) {
            XCBuildConfiguration.v(5);
        }
        return buildSettingValuesProvider;
    }

    @Override
    @NonNls
    public String toString() {
        List<PBXTarget> list = this.getTargets();
        return (!list.isEmpty() ? StringUtil.join(list, pBXTarget -> pBXTarget.getName(), (String)",") : "(null)") + " - " + this.getName();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            XCBuildConfiguration.v(6);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            XCBuildConfiguration.v(7);
        }
        this.myDataHolder.putUserData(key, value2);
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            XCBuildConfiguration.v(8);
        }
        return this.myDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value2) {
        if (key == null) {
            XCBuildConfiguration.v(9);
        }
        if (value2 == null) {
            XCBuildConfiguration.v(10);
        }
        Object object = this.myDataHolder.putUserDataIfAbsent(key, value2);
        if (object == null) {
            XCBuildConfiguration.v(11);
        }
        return (T)object;
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 3, 4, 5, 11 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXCConfigBuildSettingValuesProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 11 -> new IllegalStateException(string);
        };
    }
}

