/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbxGroupPsiElement
extends SyntheticFileSystemItem
implements PsiDirectoryContainer {
    private static final Logger LOG = Logger.getInstance(PbxGroupPsiElement.class);
    @NotNull
    private PBXGroup myGroup;

    public PbxGroupPsiElement(@NotNull PBXGroup group) {
        if (group == null) {
            PbxGroupPsiElement.j(0);
        }
        super(group.getFile().getProject());
        this.myGroup = group;
    }

    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.myGroup.getName());
        if (string == null) {
            PbxGroupPsiElement.j(1);
        }
        return string;
    }

    @Nullable
    public PsiFileSystemItem getParent() {
        if (this.myGroup.isMainGroup()) {
            PBXProjectFile pBXProjectFile = this.myGroup.getFile();
            return this.getManager().findDirectory(pBXProjectFile.getPBXProjFile().getParent());
        }
        PBXGroup pBXGroup = this.myGroup.getParent();
        if (pBXGroup != null) {
            return pBXGroup.getGroupPsiElement();
        }
        LOG.warn("Group " + this.myGroup + " has no parent");
        return null;
    }

    @NotNull
    public @NotNull PsiDirectory @NotNull [] getDirectories() {
        PsiDirectory psiDirectory = this.getDirectoryPsiElement();
        if (psiDirectory == null) {
            if (PsiDirectory.EMPTY_ARRAY == null) {
                PbxGroupPsiElement.j(2);
            }
            return PsiDirectory.EMPTY_ARRAY;
        }
        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
        if (psiDirectoryArray == null) {
            PbxGroupPsiElement.j(3);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public @NotNull PsiDirectory @NotNull [] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PbxGroupPsiElement.j(4);
        }
        LOG.assertTrue(scope.getClass().getSimpleName().equals("ModuleWithDependenciesScope"));
        PsiDirectory[] psiDirectoryArray = this.getDirectories();
        if (psiDirectoryArray == null) {
            PbxGroupPsiElement.j(5);
        }
        return psiDirectoryArray;
    }

    public PsiDirectory getDirectoryPsiElement() {
        return this.myGroup.getDirectoryPsiElement();
    }

    public VirtualFile getVirtualFile() {
        return this.myGroup.findFile();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PbxGroupPsiElement.j(6);
        }
        visitor2.visitElement((PsiElement)this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PbxGroupPsiElement.j(7);
        }
        this.processChildren((PsiElementProcessor<? super PsiFileSystemItem>)((PsiElementProcessor)psiFileSystemItem -> {
            psiFileSystemItem.accept(visitor2);
            return true;
        }));
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            PbxGroupPsiElement.j(8);
        }
        for (PBXReference pBXReference : this.myGroup.getChildren()) {
            ProgressManager.checkCanceled();
            PsiFileSystemItem psiFileSystemItem = pBXReference.findPsiElement();
            if (psiFileSystemItem == null || processor.execute((PsiElement)psiFileSystemItem)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PBXGroup getGroup() {
        PBXGroup pBXGroup = this.myGroup;
        if (pBXGroup == null) {
            PbxGroupPsiElement.j(9);
        }
        return pBXGroup;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 3, 5, 9 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PbxGroupPsiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PbxGroupPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 9 -> new IllegalStateException(string);
        };
    }
}

