/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.RWAMap;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.RWAChecker;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXUserFile {
    @NotNull
    private final RWAChecker myRWAChecker;
    @NotNull
    private final PBXProjectFile myProjectFile;
    @NotNull
    private final RWAMap<PbxId, PBXObject> myObjects;

    public PBXUserFile(@NotNull PBXProjectFile projectFile) {
        if (projectFile == null) {
            PBXUserFile.j(0);
        }
        this.myRWAChecker = new RWAChecker();
        this.myProjectFile = projectFile;
        this.myObjects = this.myProjectFile.createRWAObjectsMap();
    }

    public void load() throws IOException {
        CharSequence charSequence;
        this.myRWAChecker.checkWrite();
        VirtualFile virtualFile2 = this.myProjectFile.getPBXProjFile().getParent();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2.findChild(SystemProperties.getUserName() + ".pbxuser");
        if (virtualFile3 == null) {
            return;
        }
        try {
            charSequence = PBXProjectFile.loadFile(virtualFile3);
        }
        catch (IOException iOException) {
            XCLog.LOG.warn("Cannot read PbxUser file", (Throwable)iOException);
            return;
        }
        try {
            LinkedHashMap<PbxId, PBXObject> linkedHashMap = new LinkedHashMap<PbxId, PBXObject>();
            PbxReader.readFile(true, charSequence, this.myProjectFile, linkedHashMap);
            this.myObjects.clear();
            this.myObjects.putAll((Map<PbxId, PBXObject>)linkedHashMap);
        }
        catch (InvalidSpecException invalidSpecException) {
            XCLog.LOG.warn("PbxUser file is invalid: " + virtualFile3, (Throwable)invalidSpecException);
        }
    }

    void finishLoading() {
        this.myRWAChecker.resetModified();
    }

    void lock() {
        this.myRWAChecker.lock();
    }

    boolean isModified() {
        return this.myRWAChecker.isModified();
    }

    @NotNull
    public PBXProjectFile getProjectFile() {
        PBXProjectFile pBXProjectFile = this.myProjectFile;
        if (pBXProjectFile == null) {
            PBXUserFile.j(1);
        }
        return pBXProjectFile;
    }

    @Nullable
    public PBXObject findById(@Nullable PbxId id) {
        this.myRWAChecker.checkRead();
        return id == null ? null : this.myObjects.get(id);
    }

    @Nullable
    public PBXObject findExtensionFor(@Nullable PBXObject object) {
        return object == null ? null : this.findById(object.getId());
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXUserFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXUserFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

