/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXBuildRule;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXCopyFilesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTargetDependency;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCConfigurationList;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXTarget
extends PBXContainerItem {
    public static final PBXTarget[] EMPTY_ARRAY = new PBXTarget[0];

    public PBXTarget(PBXProjectFile file2) {
        super(file2);
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isTool() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isApplicationExtension() {
        return false;
    }

    public boolean isFramework() {
        return false;
    }

    public boolean isStaticLibrary() {
        return false;
    }

    public boolean isXCTestTests() {
        return false;
    }

    public boolean isXCUITestTests() {
        return false;
    }

    public boolean isAnyXCTestTests() {
        return this.isXCTestTests() || this.isXCUITestTests();
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.getNotNullAttribute("name", String.class);
        if (string == null) {
            PBXTarget.v(0);
        }
        return string;
    }

    @NotNull
    public String getProjectName() {
        String string = this.getFile().getName();
        if (string == null) {
            PBXTarget.v(1);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String getProductName() {
        String string = this.getNotNullAttribute("productName", String.class);
        if (string == null) {
            PBXTarget.v(2);
        }
        return string;
    }

    @NotNull
    public XCConfigurationList getBuildConfigurationList() {
        XCConfigurationList xCConfigurationList = this.resolveNotNullAttribute("buildConfigurationList", XCConfigurationList.class);
        if (xCConfigurationList == null) {
            PBXTarget.v(3);
        }
        return xCConfigurationList;
    }

    @NotNull
    public List<XCBuildConfiguration> getBuildConfigurations() {
        List<XCBuildConfiguration> list = this.getBuildConfigurationList().getConfigurations();
        if (list == null) {
            PBXTarget.v(4);
        }
        return list;
    }

    @Nullable
    public XCBuildConfiguration findBuildConfiguration(@Nullable String name) {
        return this.getBuildConfigurationList().findConfiguration(name);
    }

    @Nullable
    public XCBuildConfiguration getPreferredConfiguration() {
        XCBuildConfiguration xCBuildConfiguration = this.getBuildConfigurationList().getDefaultConfiguration();
        if (xCBuildConfiguration != null && xCBuildConfiguration.isDebug()) {
            return xCBuildConfiguration;
        }
        for (XCBuildConfiguration xCBuildConfiguration2 : this.getBuildConfigurations()) {
            if (!xCBuildConfiguration2.isDebug()) continue;
            return xCBuildConfiguration2;
        }
        return xCBuildConfiguration;
    }

    @NotNull
    public List<PBXTargetDependency> getDependencies() {
        List<PBXTargetDependency> list = this.resolveAttributeList("dependencies", PBXTargetDependency.class);
        if (list == null) {
            PBXTarget.v(5);
        }
        return list;
    }

    @NotNull
    public List<PBXTarget> getResolvedDependencies() {
        List list = ContainerUtil.mapNotNull(this.getDependencies(), (Function)((NullableFunction)pBXTargetDependency -> pBXTargetDependency.resolveTarget()));
        if (list == null) {
            PBXTarget.v(6);
        }
        return list;
    }

    @Nullable
    private PBXDictionary j() {
        return this.getFile().getProjectObject().getTargetAttributes(this);
    }

    @Nullable
    public PBXTarget getTestHost() {
        PBXDictionary pBXDictionary = this.j();
        return pBXDictionary != null ? pBXDictionary.resolveAttribute("TestTargetID", PBXTarget.class) : null;
    }

    @NotNull
    public List<PBXBuildRule> getBuildRules() {
        List<PBXBuildRule> list = this.resolveAttributeList("buildRules", PBXBuildRule.class);
        if (list == null) {
            PBXTarget.v(7);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases() {
        List<PBXBuildPhase> list = this.resolveAttributeList("buildPhases", PBXBuildPhase.class);
        if (list == null) {
            PBXTarget.v(8);
        }
        return list;
    }

    @Nullable
    public PBXBuildPhase getBuildPhase(@Nullable PBXBuildPhase.PhaseType type) {
        return (PBXBuildPhase)ContainerUtil.getFirstItem(this.getBuildPhases(type));
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases(@Nullable PBXBuildPhase.PhaseType type) {
        List<PBXBuildPhase> list = this.getBuildPhases(type, null);
        if (list == null) {
            PBXTarget.v(9);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases(@Nullable PBXBuildPhase.PhaseType type, @Nullable Condition<PBXBuildPhase> condition) {
        SmartList smartList = new SmartList();
        for (PBXBuildPhase pBXBuildPhase : this.getBuildPhases()) {
            if (type != null && !type.equals(pBXBuildPhase.getType()) || condition != null && !condition.value((Object)pBXBuildPhase)) continue;
            smartList.add(pBXBuildPhase);
        }
        List<PBXBuildPhase> list = Collections.unmodifiableList(smartList);
        if (list == null) {
            PBXTarget.v(10);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getCopyFilesPhases(@Nullable PBXCopyFilesBuildPhase.DestinationType destination) {
        List<PBXBuildPhase> list = this.getBuildPhases(PBXBuildPhase.Type.COPY_FILES, PBXTarget.j(destination));
        if (list == null) {
            PBXTarget.v(11);
        }
        return list;
    }

    @NotNull
    public List<XCSwiftPackageProductDependency> getSwiftPackageProductDependencies() {
        List<XCSwiftPackageProductDependency> list = this.resolveAttributeList("packageProductDependencies", XCSwiftPackageProductDependency.class);
        if (list == null) {
            PBXTarget.v(12);
        }
        return list;
    }

    @Nullable
    private static Condition<PBXBuildPhase> j(@Nullable PBXCopyFilesBuildPhase.DestinationType destinationType) {
        return destinationType == null ? null : pBXBuildPhase -> pBXBuildPhase instanceof PBXCopyFilesBuildPhase && destinationType.equals((Object)((PBXCopyFilesBuildPhase)pBXBuildPhase).getDestinationType());
    }

    @NotNull
    public List<PBXBuildFile> getBuildFiles(@Nullable PBXBuildPhase.PhaseType type) {
        List<PBXBuildFile> list = this.getBuildFiles(type, null);
        if (list == null) {
            PBXTarget.v(13);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> getBuildFiles(@Nullable PBXBuildPhase.PhaseType type, @Nullable Condition<PBXBuildPhase> phaseCondition) {
        List list = ContainerUtil.flatMap(this.getBuildPhases(type, phaseCondition), pBXBuildPhase -> pBXBuildPhase.getFiles());
        if (list == null) {
            PBXTarget.v(14);
        }
        return list;
    }

    @NotNull
    public List<PBXReference> getSources() {
        return this.j(PBXBuildPhase.Type.SOURCES, null, null);
    }

    @NotNull
    public List<VirtualFile> getSourceFiles() {
        List<VirtualFile> list = this.getSourceFiles(null);
        if (list == null) {
            PBXTarget.v(15);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getSourceFiles(@Nullable BuildSettingsProvider provider) {
        List list = ContainerUtil.mapNotNull(this.getSources(), pBXReference -> provider == null ? pBXReference.findFile() : pBXReference.findFile(provider));
        if (list == null) {
            PBXTarget.v(16);
        }
        return list;
    }

    public List<PBXReference> getHeaders(boolean includeProjectHeaders) {
        return this.j(PBXBuildPhase.Type.HEADERS, null, (Condition<Pair<PBXBuildFile, PBXReference>>)(includeProjectHeaders ? null : pair2 -> {
            @NonNls String string = ((PBXBuildFile)pair2.first).getStringSetting("ATTRIBUTES");
            return string != null && (string.contains("Public") || string.contains("Private"));
        }));
    }

    public List<PBXReference> getCopyFiles() {
        return this.getCopyFiles(null);
    }

    public List<PBXReference> getCopyFiles(@Nullable PBXCopyFilesBuildPhase.DestinationType destination) {
        return this.j(PBXBuildPhase.Type.COPY_FILES, PBXTarget.j(destination), null);
    }

    @NotNull
    public List<PBXReference> getFrameworksAndLibraries() {
        return this.j(PBXBuildPhase.Type.FRAMEWORKS, null, null);
    }

    @NotNull
    public List<PBXReference> getFrameworks() {
        return this.j(PBXBuildPhase.Type.FRAMEWORKS, null, (Condition<Pair<PBXBuildFile, PBXReference>>)((Condition)pair2 -> ((PBXReference)pair2.second).isFramework()));
    }

    @NotNull
    private List<PBXReference> j(@Nullable PBXBuildPhase.PhaseType phaseType, @Nullable Condition<PBXBuildPhase> condition, @Nullable Condition<Pair<PBXBuildFile, PBXReference>> condition2) {
        List<PBXBuildFile> list = this.getBuildFiles(phaseType, condition);
        ArrayList<PBXReference> arrayList = new ArrayList<PBXReference>(list.size());
        for (PBXBuildFile pBXBuildFile : list) {
            PBXReference pBXReference = pBXBuildFile.getFileRef();
            if (pBXReference == null || condition2 != null && !condition2.value((Object)Pair.create((Object)pBXBuildFile, (Object)pBXReference))) continue;
            arrayList.add(pBXReference);
        }
        List<PBXReference> list2 = Collections.unmodifiableList(arrayList);
        if (list2 == null) {
            PBXTarget.v(17);
        }
        return list2;
    }

    @Nullable
    public AppleBuildSystem.Type getBuildSystem() {
        return null;
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor2) {
        if (visitor2 == null) {
            PBXTarget.v(18);
        }
        return visitor2.visitTarget(this);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            PBXTarget.v(19);
        }
        return string;
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 18 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXTarget";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildRules";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPhases";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyFilesPhases";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftPackageProductDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPhaseReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXTarget";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 18 -> new IllegalArgumentException(string);
        };
    }
}

