/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiAwareObject;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.XcodeCoreBundle;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXCompositeGroup;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReferenceBuildSettingProvider;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PBXReference
extends PBXContainerItem
implements PsiAwareObject {
    private static final Key<UpdatingEncodingState> UPDATING_ENCODING_FROM_MODEL = Key.create((String)(PBXReference.class.getSimpleName() + ".UPDATING_ENCODING_FROM_MODEL"));
    private static final ReadWriteLock ourReadWriteLock = new ReentrantReadWriteLock();
    public static final long DEFAULT_ENCODING = 4L;
    @NonNls
    public static final String SOURCE_TREE_ABSOLUTE = "<absolute>";
    @NonNls
    public static final String SOURCE_TREE_GROUP = "<group>";
    @NonNls
    public static final String SOURCE_TREE_SOURCE_ROOT = "SOURCE_ROOT";
    @NonNls
    public static final String SOURCE_TREE_SDKROOT = "SDKROOT";
    @NonNls
    public static final String SOURCE_TREE_DEVELOPER_DIR = "DEVELOPER_DIR";
    @NonNls
    public static final String SOURCE_TREE_BUILT_PRODUCTS_DIR = "BUILT_PRODUCTS_DIR";
    private CachedResolve myCachedResolve;
    private final CachedValue<String> myCachedRealPath;
    private static final ConcurrentMap<Long, Charset> ourCachedCharsets = new ConcurrentHashMap<Long, Charset>();

    public PBXReference(PBXProjectFile file2) {
        super(file2);
        XcodeProjectTrackers xcodeProjectTrackers = XcodeProjectTrackers.getInstance(file2.getProject());
        this.myCachedRealPath = CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.computeRealPath(), (Collection)ContainerUtil.concat(List.of(xcodeProjectTrackers.getReferencesTracker(), xcodeProjectTrackers.getBuildSettingsTracker(), this.myAttributesModificationTracker), PBXReferenceBuildSettingProvider.Companion.getModificationTrackers(file2.getProject()))));
    }

    @Override
    @NotNull
    protected SimpleModificationTracker createAttributesModificationTracker() {
        return new SimpleModificationTracker();
    }

    @Override
    public String getComment() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getPath();
        if (string != null) {
            return string;
        }
        return null;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string != null) {
            String string2 = string;
            if (string2 == null) {
                PBXReference.v(0);
            }
            return string2;
        }
        string = this.getPath();
        String string3 = string != null ? string : XcodeCoreBundle.message("xcode.model.unnamed", new Object[0]);
        if (string3 == null) {
            PBXReference.v(1);
        }
        return string3;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    @NlsSafe
    public String getName() {
        return this.getString("name");
    }

    @Deprecated
    @Nullable
    @NlsSafe
    public String getPath() {
        return this.getString("path");
    }

    @Nullable
    @VisibleForTesting
    String computeRealPath() {
        PBXNativeTarget pBXNativeTarget = this.findOwnerTarget();
        if (pBXNativeTarget != null) {
            BuildSettingsProvider buildSettingsProvider = PBXReferenceBuildSettingProvider.Companion.getBuildSettings(this, pBXNativeTarget);
            if (buildSettingsProvider == null) {
                return this.getPath();
            }
            String string = buildSettingsProvider.getBuildSetting("FULL_PRODUCT_NAME").getString();
            if (string != null) {
                return string;
            }
        }
        return this.getPath();
    }

    @Nullable
    public String getFileName() {
        String string = this.getPath();
        return string == null ? this.getName() : new File(string).getName();
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor2) {
        if (visitor2 == null) {
            PBXReference.v(2);
        }
        return visitor2.visitReference(this);
    }

    @Nullable
    public String getSourceTree() {
        return this.getString("sourceTree");
    }

    @Nullable
    public String getFileTypeId() {
        String string = this.j();
        return string != null ? string : this.getString("lastKnownFileType");
    }

    @Nullable
    private String j() {
        return this.getString("explicitFileType");
    }

    @Nullable
    public AppleFileType getFileType() {
        return AppleFileTypeManager.getInstance().findFileTypeById(this.getFileTypeId());
    }

    public boolean isFramework() {
        AppleFileType appleFileType = this.getFileType();
        return appleFileType != null && appleFileType.isFrameworkWrapper();
    }

    public boolean isLinkedProject() {
        AppleFileType appleFileType = this.getFileType();
        return appleFileType != null && appleFileType.isProjectWrapper();
    }

    @Nullable
    public Long getFileEncoding() {
        String string = this.getString("fileEncoding");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Charset getSuitableCharset() {
        AppleFileType appleFileType = this.getFileType();
        if (appleFileType == null || !appleFileType.isTextFile()) {
            return null;
        }
        Long l3 = this.getFileEncoding();
        if (l3 == null) {
            return null;
        }
        return ourCachedCharsets.computeIfAbsent(l3, l2 -> {
            String string = Foundation.getEncodingName((long)l2);
            try {
                return string == null ? null : Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                return null;
            }
        });
    }

    @Nullable
    public PBXProjectFile getLinkedProject() {
        if (!this.isLinkedProject()) {
            return null;
        }
        CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
        return coreXcodeWorkspace != null ? coreXcodeWorkspace.findProject(this.findFile()) : null;
    }

    @Nullable
    public PBXGroup getParent() {
        return this.getFile().resolveParentObject(this);
    }

    public boolean isDescendantOf(@Nullable PBXReference ancestor) {
        if (!(ancestor instanceof PBXGroup)) {
            return false;
        }
        for (PBXReference pBXReference = this; pBXReference != null; pBXReference = pBXReference.getParent()) {
            if (ancestor != pBXReference) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @NlsSafe
    public String resolvePath() {
        return this.resolvePath(this.j());
    }

    @Nullable
    public String resolvePath(@Nullable BuildSettingsProvider buildSettingsProvider) {
        String string = (String)this.myCachedRealPath.getValue();
        String string2 = this.getSourceTree();
        if (string2 == null) {
            return null;
        }
        if (SOURCE_TREE_ABSOLUTE.equals(string2)) {
            return string;
        }
        String string3 = this.resolveSourceTree(string2, buildSettingsProvider);
        if (string3 == null) {
            return null;
        }
        if (string == null) {
            return string3;
        }
        File file2 = new File(string3);
        while (string.startsWith("..")) {
            if ((file2 = file2.getParentFile()) == null) {
                return null;
            }
            string = string.substring("..".length());
            string = StringUtil.trimStart((String)string, (String)"/");
        }
        String string4 = new File(file2, string).getPath();
        return Normalizer.normalize(string4, Normalizer.Form.NFC);
    }

    @Nullable
    public String resolveSourceTree(@NotNull String sourceTree, @Nullable BuildSettingsProvider buildSettingsProvider) {
        if (sourceTree == null) {
            PBXReference.v(3);
        }
        if (SOURCE_TREE_ABSOLUTE.equals(sourceTree)) {
            return null;
        }
        if (SOURCE_TREE_GROUP.equals(sourceTree)) {
            PBXGroup pBXGroup = this.getParent();
            return pBXGroup != null ? pBXGroup.resolvePath(buildSettingsProvider) : this.getFile().getBaseDir().getPath();
        }
        if (SOURCE_TREE_SOURCE_ROOT.equals(sourceTree)) {
            return this.getFile().getBaseDir().getPath();
        }
        if (SOURCE_TREE_SDKROOT.equals(sourceTree)) {
            AppleSdk appleSdk = buildSettingsProvider == null ? null : buildSettingsProvider.getBuildSetting(sourceTree).getSdk();
            return appleSdk == null ? null : appleSdk.getRoot().getPath();
        }
        return buildSettingsProvider == null ? null : buildSettingsProvider.getBuildSetting(sourceTree).getAbsolutePath();
    }

    @Nullable
    public VirtualFile findFile() {
        return this.findFile(this.j());
    }

    @Nullable
    public PsiElement findElement(@NotNull Project project2) {
        if (project2 == null) {
            PBXReference.v(4);
        }
        return this.findPsiElement();
    }

    @Nullable
    public PsiFileSystemItem findPsiElement() {
        return this.findPsiElementFromVirtualFile();
    }

    @Nullable
    protected final PsiFileSystemItem findPsiElementFromVirtualFile() {
        VirtualFile virtualFile2 = this.findFile();
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getFile().getProject());
        return virtualFile2.isDirectory() ? psiManager.findDirectory(virtualFile2) : psiManager.findFile(virtualFile2);
    }

    @Nullable
    public PBXReference findPhysicalParent() {
        PBXReference pBXReference;
        PBXGroup pBXGroup = this.getFile().getProjectObject().getMainGroup();
        for (pBXReference = this; pBXReference != null && pBXReference.getPath() == null; pBXReference = pBXReference.getParent()) {
            if (!pBXReference.equals(pBXGroup)) continue;
            return pBXReference;
        }
        return pBXReference;
    }

    @Nullable
    public VirtualFile findFile(@Nullable BuildSettingsProvider buildSettingsProvider) {
        return this.j(buildSettingsProvider, false);
    }

    @Nullable
    public VirtualFile refreshAndFindFile() {
        return this.refreshAndFindFile(this.j());
    }

    @Nullable
    public VirtualFile refreshAndFindFile(@Nullable BuildSettingsProvider buildSettingsProvider) {
        return this.j(buildSettingsProvider, true);
    }

    @Nullable
    private VirtualFile j(@Nullable BuildSettingsProvider buildSettingsProvider, boolean bl) {
        long l2 = this.j(buildSettingsProvider);
        CachedResolve cachedResolve = this.myCachedResolve;
        if (cachedResolve != null) {
            return cachedResolve.getResolvedFile();
        }
        VirtualFile virtualFile2 = (VirtualFile)ReadAction.compute(() -> {
            VirtualFile virtualFile2;
            String string = this.resolvePath(buildSettingsProvider);
            VirtualFile virtualFile3 = string == null ? null : (virtualFile2 = bl ? StandardFileSystems.local().refreshAndFindFileByPath(string) : StandardFileSystems.local().findFileByPath(string));
            if (virtualFile2 != null) {
                this.j(virtualFile2);
            }
            return virtualFile2;
        });
        this.myCachedResolve = new CachedResolve(l2, buildSettingsProvider, virtualFile2);
        return virtualFile2;
    }

    private long j(@Nullable BuildSettingsProvider buildSettingsProvider) {
        long l2 = PsiManager.getInstance((Project)this.getFile().getProject()).getModificationTracker().getModificationCount();
        CachedResolve cachedResolve = this.myCachedResolve;
        if (cachedResolve == null) {
            return l2;
        }
        if (cachedResolve.getModificationStamp() != l2 || cachedResolve.getBuildSettingsProvider() != buildSettingsProvider || cachedResolve.getResolvedFile() != null && !cachedResolve.getResolvedFile().isValid()) {
            this.myCachedResolve = null;
        }
        return l2;
    }

    @NotNull
    public <T extends PBXTarget> List<T> findTargets(@Nullable Class<T> clazz) {
        List<T> list = this.getFile().getTargetsFor(this, clazz);
        if (list == null) {
            PBXReference.v(5);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> findBuildFiles() {
        List<PBXBuildFile> list = this.getFile().getBuildFilesFor(this);
        if (list == null) {
            PBXReference.v(6);
        }
        return list;
    }

    @Nullable
    public PBXNativeTarget findTargetForProduct(@Nullable BuildSettingsProvider settingsProvider) {
        return this.getFile().findTargetForProduct(this, settingsProvider);
    }

    @NotNull
    private BuildSettingsProvider j() {
        CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
        BuildSettingsProvider buildSettingsProvider = coreXcodeWorkspace != null ? coreXcodeWorkspace.getPreferredBuildSettingsProvider(this) : null;
        BuildSettingsProvider buildSettingsProvider2 = buildSettingsProvider != null ? buildSettingsProvider : this.getFile().getBuildSettingsProvider();
        if (buildSettingsProvider2 == null) {
            PBXReference.v(7);
        }
        return buildSettingsProvider2;
    }

    public boolean isDirectoryRef() {
        return this instanceof PBXFileReference && "folder".equals(this.getFileTypeId());
    }

    public boolean isProductReference() {
        return null != this.findOwnerTarget();
    }

    @Nullable
    public PBXNativeTarget findOwnerTarget() {
        return (PBXNativeTarget)ContainerUtil.findLast(this.getFile().getTargets(PBXNativeTarget.class), pBXNativeTarget -> pBXNativeTarget.getProductReference() == this);
    }

    public boolean isAssetCatalog() {
        if (!(this instanceof PBXFileReference)) {
            return false;
        }
        VirtualFile virtualFile2 = this.findFile();
        return virtualFile2 != null && virtualFile2.isDirectory() && (FileUtilRt.extensionEquals((String)virtualFile2.getName(), (String)"xcassets") || "folder.assetcatalog".equals(this.j()));
    }

    @NotNull
    public static PBXReference effectiveTargetMember(@NotNull PBXReference ref) {
        if (ref == null) {
            PBXReference.v(8);
        }
        if (ref instanceof PBXCompositeGroup) {
            PBXReference pBXReference = ref;
            if (pBXReference == null) {
                PBXReference.v(9);
            }
            return pBXReference;
        }
        PBXGroup pBXGroup = ref.getParent();
        if (pBXGroup instanceof PBXCompositeGroup) {
            PBXGroup pBXGroup2 = pBXGroup;
            if (pBXGroup2 == null) {
                PBXReference.v(10);
            }
            return pBXGroup2;
        }
        PBXReference pBXReference = ref;
        if (pBXReference == null) {
            PBXReference.v(11);
        }
        return pBXReference;
    }

    public boolean isPhysical() {
        return !this.isVirtual();
    }

    public boolean isVirtual() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j(@NotNull VirtualFile virtualFile2) {
        Charset charset;
        UpdatingEncodingState updatingEncodingState;
        if (virtualFile2 == null) {
            PBXReference.v(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.getFileEncoding() == null) {
            return;
        }
        Project project2 = this.getFile().getProject();
        ourReadWriteLock.readLock().lock();
        try {
            updatingEncodingState = (UpdatingEncodingState)virtualFile2.getUserData(UPDATING_ENCODING_FROM_MODEL);
            if (updatingEncodingState != null && updatingEncodingState.isDifferentProject(project2)) {
                return;
            }
            charset = this.getSuitableCharset();
        }
        finally {
            ourReadWriteLock.readLock().unlock();
        }
        if (charset == null) {
            return;
        }
        ourReadWriteLock.writeLock().lock();
        try {
            updatingEncodingState = (UpdatingEncodingState)virtualFile2.getUserData(UPDATING_ENCODING_FROM_MODEL);
            if (updatingEncodingState != null && updatingEncodingState.isDifferentProject(project2)) {
                return;
            }
            virtualFile2.setCharset(charset, updatingEncodingState == null ? () -> virtualFile2.putUserData(UPDATING_ENCODING_FROM_MODEL, (Object)new UpdatingEncodingState(project2)) : () -> ++updatingEncodingState.myEventCount);
            LoadTextUtil.clearCharsetAutoDetectionReason((VirtualFile)virtualFile2);
        }
        finally {
            ourReadWriteLock.writeLock().unlock();
        }
    }

    @Nullable
    public static UpdatingEncodingState clearUpdatingEncodingFromModel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PBXReference.v(13);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        UpdatingEncodingState updatingEncodingState = (UpdatingEncodingState)file2.getUserData(UPDATING_ENCODING_FROM_MODEL);
        if (updatingEncodingState == null) {
            return null;
        }
        if (--updatingEncodingState.myEventCount == 0) {
            file2.putUserData(UPDATING_ENCODING_FROM_MODEL, null);
        }
        return updatingEncodingState;
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 2, 3, 4, 8, 12, 13 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBuildFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettingsProvider";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "effectiveTargetMember";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "effectiveTargetMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateEncoding";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdatingEncodingFromModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 8, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    private static final class CachedResolve {
        private final long modificationStamp;
        @Nullable
        private final BuildSettingsProvider buildSettingsProvider;
        @Nullable
        private final VirtualFile resolvedFile;

        private CachedResolve(long modificationStamp, @Nullable BuildSettingsProvider buildSettingsProvider, @Nullable VirtualFile resolvedFile) {
            this.modificationStamp = modificationStamp;
            this.resolvedFile = resolvedFile;
            this.buildSettingsProvider = buildSettingsProvider;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Nullable
        public BuildSettingsProvider getBuildSettingsProvider() {
            return this.buildSettingsProvider;
        }

        @Nullable
        public VirtualFile getResolvedFile() {
            return this.resolvedFile;
        }
    }

    public static final class UpdatingEncodingState
    implements Disposable {
        @Nullable
        private volatile Project myProject;
        private volatile int myEventCount;

        private UpdatingEncodingState(@NotNull Project project2) {
            if (project2 == null) {
                UpdatingEncodingState.j(0);
            }
            this.myProject = project2;
            this.myEventCount = 1;
            Disposer.register((Disposable)project2, (Disposable)this);
        }

        public boolean isDifferentProject(@NotNull Project project2) {
            if (project2 == null) {
                UpdatingEncodingState.j(1);
            }
            return this.myProject != project2;
        }

        public void dispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXReference$UpdatingEncodingState";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDifferentProject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

