/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleLanguage;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleProductType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.FileRefTree;
import com.jetbrains.cidr.xcode.model.Notifications;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXCompositeGroup;
import com.jetbrains.cidr.xcode.model.PBXContainerItemProxy;
import com.jetbrains.cidr.xcode.model.PBXCopyFilesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXFrameworksBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXHeadersBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXLegacyTarget;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXReferenceProxy;
import com.jetbrains.cidr.xcode.model.PBXResourcesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXRezBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXShellScriptBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXSourcesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PBXTargetDependency;
import com.jetbrains.cidr.xcode.model.PBXVariantGroup;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCConfigurationList;
import com.jetbrains.cidr.xcode.model.XCCoreBuildSettings;
import com.jetbrains.cidr.xcode.model.XCRemoteSwiftPackageReference;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import com.jetbrains.cidr.xcode.model.XCVersionGroup;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PBXProjectFileManipulator {
    private static final Logger LOG = Logger.getInstance(PBXProjectFileManipulator.class);
    private final PBXProjectFile myProjectFile;
    @Nullable
    private Notifications myNotifications;
    private final boolean autoFireNotifications;

    PBXProjectFileManipulator(@NotNull PBXProjectFile projectFile, boolean fireNotificationsAutomatically) {
        if (projectFile == null) {
            PBXProjectFileManipulator.j(0);
        }
        this.myProjectFile = projectFile;
        this.autoFireNotifications = fireNotificationsAutomatically;
    }

    @NotNull
    public static PBXProjectFile createNewProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull VirtualFile pbxProjectFile, @Nullable PbxId initialId, @Nullable String projectName) {
        if (project2 == null) {
            PBXProjectFileManipulator.j(1);
        }
        if (baseDir == null) {
            PBXProjectFileManipulator.j(2);
        }
        if (pbxProjectFile == null) {
            PBXProjectFileManipulator.j(3);
        }
        PBXProjectFile pBXProjectFile = new PBXProjectFile(project2, baseDir, pbxProjectFile, initialId, projectName);
        pBXProjectFile.setArchiveVersion(1);
        pBXProjectFile.setObjectVersion(46);
        PBXProject pBXProject = new PBXProject(pBXProjectFile);
        pBXProjectFile.addObject(pBXProject, null);
        pBXProjectFile.setProjectObject(pBXProject);
        pBXProject.setAttribute("projectDirPath", "");
        pBXProject.setAttribute("projectRoot", "");
        pBXProjectFile.finishLoading();
        pBXProjectFile.lock();
        XCConfigurationList xCConfigurationList = new XCConfigurationList(pBXProjectFile);
        xCConfigurationList.setAttribute("buildConfigurations", Collections.emptyList());
        xCConfigurationList.setAttribute("defaultConfigurationIsVisible", "0");
        xCConfigurationList.setAttribute("defaultConfigurationName", "Release");
        pBXProjectFile.addObject(xCConfigurationList, null);
        pBXProject.setAttribute("buildConfigurationList", xCConfigurationList.createReference());
        pBXProject.setAttribute("compatibilityVersion", "Xcode 3.2");
        pBXProject.setAttribute("developmentRegion", "English");
        pBXProject.setAttribute("hasScannedForEncodings", "0");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("en");
        pBXProject.setAttribute("knownRegions", arrayList);
        PBXGroup pBXGroup = new PBXGroup(pBXProjectFile);
        pBXGroup.setAttribute("children", Collections.emptyList());
        pBXGroup.setAttribute("sourceTree", "<group>");
        pBXProjectFile.addObject(pBXGroup, null);
        pBXProject.setAttribute("mainGroup", pBXGroup.createReference());
        PBXGroup pBXGroup2 = pBXProjectFile.getManipulator().addGroup("<group>", "Products", null);
        pBXProject.setAttribute("productRefGroup", pBXGroup2.createReference());
        pBXProject.setAttribute("targets", Collections.emptyList());
        PBXProjectFile pBXProjectFile2 = pBXProjectFile;
        if (pBXProjectFile2 == null) {
            PBXProjectFileManipulator.j(4);
        }
        return pBXProjectFile2;
    }

    @NotNull
    public AddResult addFile(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup parentGroup, boolean isGroup) {
        if (path == null) {
            PBXProjectFileManipulator.j(5);
        }
        if (parentGroup == null) {
            PBXProjectFileManipulator.j(6);
        }
        if (targets == null) {
            PBXProjectFileManipulator.j(7);
        }
        AddResult addResult = this.addFile(path, targets, parentGroup, isGroup, null, null, true);
        if (addResult == null) {
            PBXProjectFileManipulator.j(8);
        }
        return addResult;
    }

    @NotNull
    public AddResult addFile(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup parentGroup, boolean isGroup, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType, boolean setFileEncoding) {
        if (path == null) {
            PBXProjectFileManipulator.j(9);
        }
        if (parentGroup == null) {
            PBXProjectFileManipulator.j(10);
        }
        if (targets == null) {
            PBXProjectFileManipulator.j(11);
        }
        AddResult addResult = this.j(this.j(), path, targets, parentGroup, isGroup, sourceTree, buildPhaseType, setFileEncoding, null);
        this.j();
        AddResult addResult2 = addResult;
        if (addResult2 == null) {
            PBXProjectFileManipulator.j(12);
        }
        return addResult2;
    }

    @NotNull
    private AddResult j(@NotNull Notifications notifications, @NotNull String string, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup, boolean bl, @Nullable String string2, @Nullable PBXBuildPhase.PhaseType phaseType, boolean bl2, @Nullable Collection<PBXBuildFile> collection) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(13);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(14);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(15);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(16);
        }
        File file2 = new File(string);
        AppleFileType appleFileType = AppleFileTypeManager.getInstance().findFileTypeByFilename(file2.getName());
        boolean bl3 = false;
        if (file2.isDirectory()) {
            if (appleFileType != null && "wrapper.xcdatamodeld".equals(appleFileType.getId())) {
                return new AddResult(this.j(notifications, string, pBXTargetArray, pBXGroup, string2, collection), appleFileType, true);
            }
            if (bl) {
                PBXGroup pBXGroup2 = this.addGroup(null, file2.getName(), file2.getPath(), pBXGroup);
                return new AddResult(pBXGroup2, appleFileType, false);
            }
            bl3 = true;
        }
        PBXReference pBXReference = this.j(notifications, string, pBXTargetArray, pBXGroup, string2, phaseType, bl2, collection);
        return new AddResult(pBXReference, appleFileType, bl3);
    }

    @NotNull
    private PBXReference j(@NotNull Notifications notifications, @NotNull String string, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup, @Nullable String string2, @Nullable PBXBuildPhase.PhaseType phaseType) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(17);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(18);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(19);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(20);
        }
        return this.j(notifications, string, pBXTargetArray, pBXGroup, string2, phaseType, true);
    }

    @NotNull
    private PBXReference j(@NotNull Notifications notifications, @NotNull String string, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup, @Nullable String string2, @Nullable PBXBuildPhase.PhaseType phaseType, boolean bl) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(21);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(22);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(23);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(24);
        }
        return this.j(notifications, string, pBXTargetArray, pBXGroup, string2, phaseType, bl, null);
    }

    @NotNull
    private PBXReference j(@NotNull Notifications notifications, @NotNull String string, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup, @Nullable String string2, @Nullable PBXBuildPhase.PhaseType phaseType, boolean bl, @Nullable Collection<PBXBuildFile> collection) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(25);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(26);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(27);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(28);
        }
        LOG.assertTrue(pBXGroup.getFile() == this.myProjectFile);
        File file2 = new File(string);
        PBXFileReference pBXFileReference = new PBXFileReference(this.myProjectFile);
        String string3 = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFile(file2);
        pBXFileReference.setAttribute("lastKnownFileType", string3);
        this.j(notifications, pBXFileReference, file2, pBXGroup, pBXTargetArray, string2, phaseType, bl, collection);
        PBXFileReference pBXFileReference2 = pBXFileReference;
        if (pBXFileReference2 == null) {
            PBXProjectFileManipulator.j(29);
        }
        return pBXFileReference2;
    }

    @NotNull
    private static String j(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            PBXProjectFileManipulator.j(30);
        }
        if (string2 == null) {
            PBXProjectFileManipulator.j(31);
        }
        String string3 = FileUtil.isAbsolute((String)string) ? FileUtil.getRelativePath((String)string2, (String)string, (char)File.separatorChar) : string;
        File file2 = string3 == null ? null : new File(string2, string3);
        String string4 = file2 == null ? string : file2.getPath();
        if (string4 == null) {
            PBXProjectFileManipulator.j(32);
        }
        return string4;
    }

    @NotNull
    public PBXReference addCoreDataModel(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree) {
        if (path == null) {
            PBXProjectFileManipulator.j(33);
        }
        if (group == null) {
            PBXProjectFileManipulator.j(34);
        }
        if (targets == null) {
            PBXProjectFileManipulator.j(35);
        }
        PBXReference pBXReference = this.j(this.j(), path, targets, group, sourceTree, (Collection<PBXBuildFile>)null);
        this.j();
        PBXReference pBXReference2 = pBXReference;
        if (pBXReference2 == null) {
            PBXProjectFileManipulator.j(36);
        }
        return pBXReference2;
    }

    @NotNull
    private PBXReference j(@NotNull Notifications notifications, @NotNull String string, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup, @Nullable String string2, @Nullable Collection<PBXBuildFile> collection) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(37);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(38);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(39);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(40);
        }
        LOG.assertTrue(pBXGroup.getFile() == this.myProjectFile);
        File file2 = new File(string);
        LOG.assertTrue(file2.isDirectory());
        String string3 = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFile(file2);
        LOG.assertTrue("wrapper.xcdatamodeld".equals(string3));
        XCVersionGroup xCVersionGroup = new XCVersionGroup(this.myProjectFile);
        if (string2 == null) {
            string2 = "<group>";
        }
        this.j(notifications, xCVersionGroup, file2, pBXGroup, pBXTargetArray, string2, null, false, collection);
        String string4 = xCVersionGroup.resolvePath();
        List<String> list = PBXProjectFileManipulator.j(file2);
        for (String string5 : list) {
            File file3 = new File(string4, string5);
            this.j(notifications, file3.getPath(), PBXTarget.EMPTY_ARRAY, xCVersionGroup, "<group>", null, false);
        }
        XCVersionGroup xCVersionGroup2 = xCVersionGroup;
        if (xCVersionGroup2 == null) {
            PBXProjectFileManipulator.j(41);
        }
        return xCVersionGroup2;
    }

    @NotNull
    private static List<String> j(@NotNull File file2) {
        if (file2 == null) {
            PBXProjectFileManipulator.j(42);
        }
        assert (file2.isDirectory());
        String[] stringArray = file2.list();
        if (stringArray == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PBXProjectFileManipulator.j(43);
            }
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!string.endsWith(".xcdatamodel")) continue;
            arrayList.add(string);
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PBXProjectFileManipulator.j(44);
        }
        return arrayList2;
    }

    private void j(@NotNull Notifications notifications, @NotNull PBXReference pBXReference, @NotNull File file2, @NotNull PBXGroup pBXGroup, PBXTarget[] pBXTargetArray, @Nullable String string, PBXBuildPhase.PhaseType phaseType, boolean bl, @Nullable Collection<PBXBuildFile> collection) {
        PBXReference pBXReference2;
        PBXGroup pBXGroup2;
        if (notifications == null) {
            PBXProjectFileManipulator.j(45);
        }
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(46);
        }
        if (file2 == null) {
            PBXProjectFileManipulator.j(47);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(48);
        }
        String string2 = file2.getParentFile().getName();
        String string3 = file2.getName();
        String string4 = file2.getPath();
        if (FileUtilRt.extensionEquals((String)string2, (String)"lproj")) {
            boolean bl2 = true;
            PBXCompositeGroup pBXCompositeGroup = new PBXVariantGroup(this.myProjectFile);
            for (PBXReference pBXReference3 : pBXGroup.getChildren()) {
                if (!(pBXReference3 instanceof PBXVariantGroup) || !string3.equals(pBXReference3.getName())) continue;
                pBXCompositeGroup = (PBXCompositeGroup)pBXReference3;
                bl2 = false;
                break;
            }
            if (bl2) {
                pBXCompositeGroup.setAttribute("sourceTree", "<group>");
                PBXProjectFileManipulator.j(pBXCompositeGroup, pBXGroup, notifications);
            }
            pBXGroup2 = pBXCompositeGroup;
            pBXReference2 = bl2 ? pBXCompositeGroup : null;
        } else {
            pBXGroup2 = pBXGroup;
            pBXReference2 = pBXReference;
        }
        this.j(pBXReference, pBXGroup2, string3, string4, string);
        if (bl && AppleFileTypeManager.getInstance().isTextFile(string3)) {
            pBXReference.setAttribute("fileEncoding", String.valueOf(4L));
        }
        PBXProjectFileManipulator.j(pBXReference, pBXGroup2, notifications);
        if (pBXGroup2 instanceof XCVersionGroup) {
            pBXGroup2.setAttribute("currentVersion", pBXReference.createReference());
            pBXGroup2.setAttribute("versionGroupType", pBXReference.getAttribute("lastKnownFileType", String.class));
        }
        notifications.referencesChanged();
        if (pBXReference2 != null) {
            this.j(notifications, Arrays.asList(pBXTargetArray), pBXReference2, phaseType, collection);
        }
    }

    private static void j(@NotNull PBXObject pBXObject, @NotNull Notifications notifications) {
        if (pBXObject == null) {
            PBXProjectFileManipulator.j(49);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(50);
        }
        PBXProjectFileManipulator.j(pBXObject, null, notifications);
    }

    private static void j(@NotNull PBXObject pBXObject, @Nullable PBXGroup pBXGroup, @NotNull Notifications notifications) {
        if (pBXObject == null) {
            PBXProjectFileManipulator.j(51);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(52);
        }
        pBXObject.getFile().addObject(pBXObject, pBXGroup);
        PBXProjectFileManipulator.w(pBXObject, notifications);
        PBXProjectFileManipulator.N(pBXObject, notifications);
    }

    private void N(@NotNull Collection<? extends PBXObject> collection, @NotNull Notifications notifications) {
        if (collection == null) {
            PBXProjectFileManipulator.j(53);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(54);
        }
        for (PBXObject pBXObject : collection) {
            PBXProjectFileManipulator.N(pBXObject, notifications);
            PBXProjectFileManipulator.w(pBXObject, notifications);
        }
        this.myProjectFile.removeObjects(collection);
    }

    private static void w(@NotNull PBXObject pBXObject, @NotNull Notifications notifications) {
        String string;
        if (pBXObject == null) {
            PBXProjectFileManipulator.j(55);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(56);
        }
        if (pBXObject instanceof PBXFileReference && (string = ((PBXFileReference)pBXObject).getFileName()) != null) {
            notifications.addInvalidatedFile(string);
        }
    }

    private static void N(@NotNull PBXObject pBXObject, @NotNull Notifications notifications) {
        if (pBXObject == null) {
            PBXProjectFileManipulator.j(57);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(58);
        }
        if (notifications.didChangeReference(pBXObject) || !(pBXObject instanceof PBXReference)) {
            return;
        }
        PBXReference pBXReference = (PBXReference)pBXObject;
        if (pBXReference.getPath() == null) {
            return;
        }
        notifications.addChangedReference(pBXReference);
    }

    @NotNull
    public List<CopyResult> deepCopyReferences(@NotNull List<CopyInfo> copyInfos, @NotNull PBXGroup dstGroup, boolean deleteSource) {
        Object object;
        if (copyInfos == null) {
            PBXProjectFileManipulator.j(59);
        }
        if (dstGroup == null) {
            PBXProjectFileManipulator.j(60);
        }
        LOG.assertTrue(dstGroup.getFile() == this.myProjectFile);
        Notifications notifications = this.j();
        ArrayList<CopyResult> arrayList = new ArrayList<CopyResult>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        arrayList2.add(Pair.create((Object)this.myProjectFile, (Object)this));
        for (CopyInfo copyInfo : copyInfos) {
            object = copyInfo.getReference();
            CopyResult copyResult = this.j(copyInfo, dstGroup, notifications);
            arrayList.add(copyResult);
            boolean bl = copyResult.getReference() != null;
            if (!bl || !deleteSource) continue;
            PBXProjectFile pBXProjectFile = ((PBXObject)object).getFile();
            PBXProjectFileManipulator pBXProjectFileManipulator = null;
            for (Pair pair2 : arrayList2) {
                if (pair2.first != pBXProjectFile) continue;
                pBXProjectFileManipulator = (PBXProjectFileManipulator)pair2.second;
                break;
            }
            if (pBXProjectFileManipulator == null) {
                pBXProjectFileManipulator = pBXProjectFile.getManipulator(false);
                arrayList2.add(Pair.create((Object)pBXProjectFile, (Object)pBXProjectFileManipulator));
            }
            pBXProjectFileManipulator.j(Collections.singletonList(object), notifications);
        }
        for (Pair pair3 : arrayList2) {
            object = (PBXProjectFileManipulator)pair3.second;
            if (object == this) {
                ((PBXProjectFileManipulator)object).j();
                continue;
            }
            ((PBXProjectFileManipulator)object).firePendingNotifications();
        }
        ArrayList<CopyResult> arrayList3 = arrayList;
        if (arrayList3 == null) {
            PBXProjectFileManipulator.j(61);
        }
        return arrayList3;
    }

    @NotNull
    private CopyResult j(@NotNull CopyInfo copyInfo, @NotNull PBXGroup pBXGroup, @NotNull Notifications notifications) {
        PBXReference pBXReference;
        if (copyInfo == null) {
            PBXProjectFileManipulator.j(62);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(63);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(64);
        }
        if (pBXGroup.isDescendantOf(pBXReference = copyInfo.getReference())) {
            return new CopyResult(null, "Trying to copy reference to its descendant");
        }
        ReferenceCopier referenceCopier = new ReferenceCopier(pBXGroup, copyInfo.getPathProvider(), copyInfo.getTargetProvider(), notifications);
        PBXReference pBXReference2 = null;
        String string = null;
        if (pBXReference.accept(referenceCopier)) {
            pBXReference2 = referenceCopier.getResult();
            LOG.assertTrue(pBXReference2 != null);
        } else {
            string = referenceCopier.getErrorMessage();
            LOG.assertTrue(string != null);
        }
        return new CopyResult(pBXReference2, string);
    }

    public void changeTargets(@NotNull PBXReference reference, @NotNull List<PBXTarget> removeFrom, @NotNull List<PBXTarget> addTo) {
        if (reference == null) {
            PBXProjectFileManipulator.j(65);
        }
        if (removeFrom == null) {
            PBXProjectFileManipulator.j(66);
        }
        if (addTo == null) {
            PBXProjectFileManipulator.j(67);
        }
        LOG.assertTrue(reference.getFile() == this.myProjectFile);
        Notifications notifications = this.j();
        ArrayList<PBXBuildFile> arrayList = new ArrayList<PBXBuildFile>(reference.findBuildFiles());
        this.j(arrayList, removeFrom, notifications);
        this.j(notifications, addTo, reference, null, null);
        this.j();
    }

    public void removeFromTargets(@NotNull List<PBXBuildFile> buildFiles, @NotNull List<PBXTarget> removeFrom) {
        if (buildFiles == null) {
            PBXProjectFileManipulator.j(68);
        }
        if (removeFrom == null) {
            PBXProjectFileManipulator.j(69);
        }
        this.j(buildFiles, removeFrom, this.j());
        this.j();
    }

    private void j(@NotNull List<PBXBuildFile> list, @NotNull List<PBXTarget> list2, @NotNull Notifications notifications) {
        if (list == null) {
            PBXProjectFileManipulator.j(70);
        }
        if (list2 == null) {
            PBXProjectFileManipulator.j(71);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(72);
        }
        HashSet<PBXTarget> hashSet = new HashSet<PBXTarget>(list2);
        ArrayList<PBXBuildFile> arrayList = new ArrayList<PBXBuildFile>();
        for (PBXBuildFile pBXBuildFile : list) {
            PBXTarget pBXTarget = pBXBuildFile.getTarget();
            if (pBXTarget == null || !hashSet.contains(pBXTarget)) continue;
            arrayList.add(pBXBuildFile);
        }
        if (!arrayList.isEmpty()) {
            this.N(arrayList, notifications);
            notifications.buildFilesChanged();
        }
    }

    @Nullable
    public static PBXBuildPhase.PhaseType getSuitableBuildPhaseType(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        AppleFileType appleFileType = AppleFileTypeManager.getInstance().findFileTypeByFilename(fileName);
        if (appleFileType != null && !appleFileType.getId().equals("sourcecode.glsl")) {
            if (appleFileType.isSourceCode()) {
                return appleFileType.isHeader() ? PBXBuildPhase.Type.HEADERS : PBXBuildPhase.Type.SOURCES;
            }
            if (appleFileType.isFrameworkWrapper() || appleFileType.isLibrary()) {
                return PBXBuildPhase.Type.FRAMEWORKS;
            }
            if (AppleLanguage.findById(appleFileType.getLanguage()) == AppleLanguage.REZ) {
                return PBXBuildPhase.Type.REZ;
            }
        }
        return PBXBuildPhase.Type.RESOURCES;
    }

    private void j(@NotNull Notifications notifications, @NotNull Collection<PBXTarget> collection, @NotNull PBXReference pBXReference, @Nullable PBXBuildPhase.PhaseType phaseType, @Nullable Collection<PBXBuildFile> collection2) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(73);
        }
        if (collection == null) {
            PBXProjectFileManipulator.j(74);
        }
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(75);
        }
        for (PBXTarget pBXTarget : new LinkedHashSet<PBXTarget>(collection)) {
            this.j(notifications, pBXTarget, pBXReference, phaseType, collection2);
        }
    }

    public void addToTarget(@NotNull PBXTarget target, @NotNull PBXReference reference, @Nullable PBXBuildPhase.PhaseType type) {
        if (target == null) {
            PBXProjectFileManipulator.j(76);
        }
        if (reference == null) {
            PBXProjectFileManipulator.j(77);
        }
        this.j(this.j(), target, reference, type, null);
        this.j();
    }

    private void j(@NotNull Notifications notifications, @NotNull PBXTarget pBXTarget, @NotNull PBXReference pBXReference, @Nullable PBXBuildPhase.PhaseType phaseType, @Nullable Collection<PBXBuildFile> collection) {
        PBXBuildPhase pBXBuildPhase;
        if (notifications == null) {
            PBXProjectFileManipulator.j(78);
        }
        if (pBXTarget == null) {
            PBXProjectFileManipulator.j(79);
        }
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(80);
        }
        if (phaseType == null) {
            phaseType = PBXProjectFileManipulator.getSuitableBuildPhaseType(pBXReference.getFileName());
        }
        PBXBuildPhase pBXBuildPhase2 = pBXBuildPhase = phaseType == null ? null : pBXTarget.getBuildPhase(phaseType);
        if (pBXBuildPhase != null) {
            this.j(notifications, pBXTarget, pBXBuildPhase, pBXReference, collection);
        }
    }

    public PBXBuildFile addToBuildPhase(@NotNull PBXTarget target, @NotNull PBXBuildPhase phase, @NotNull PBXReference reference) {
        if (target == null) {
            PBXProjectFileManipulator.j(81);
        }
        if (phase == null) {
            PBXProjectFileManipulator.j(82);
        }
        if (reference == null) {
            PBXProjectFileManipulator.j(83);
        }
        PBXBuildFile pBXBuildFile = this.j(this.j(), target, phase, reference, null);
        this.j();
        return pBXBuildFile;
    }

    private PBXBuildFile j(@NotNull Notifications notifications, @NotNull PBXTarget pBXTarget, @NotNull PBXBuildPhase pBXBuildPhase, @NotNull PBXReference pBXReference, @Nullable Collection<PBXBuildFile> collection) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(84);
        }
        if (pBXTarget == null) {
            PBXProjectFileManipulator.j(85);
        }
        if (pBXBuildPhase == null) {
            PBXProjectFileManipulator.j(86);
        }
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(87);
        }
        LOG.assertTrue(pBXTarget.getFile() == this.myProjectFile);
        LOG.assertTrue(pBXReference.getFile() == this.myProjectFile);
        PBXBuildFile pBXBuildFile = new PBXBuildFile(this.myProjectFile);
        PBXBuildFile pBXBuildFile2 = PBXProjectFileManipulator.j(pBXBuildPhase.getType(), collection);
        if (pBXBuildFile2 != null) {
            pBXBuildFile.putAll(pBXBuildFile2);
        }
        pBXBuildFile.setAttribute("fileRef", pBXReference.createReference());
        PBXProjectFileManipulator.j(pBXBuildFile, notifications);
        pBXBuildPhase.addFile(pBXBuildFile.createReference());
        this.myProjectFile.updateBuildFile(pBXReference, pBXBuildFile, pBXTarget, pBXBuildPhase);
        if (pBXBuildPhase.getType() == PBXBuildPhase.Type.FRAMEWORKS) {
            notifications.buildSettingsChanged();
        } else {
            notifications.buildFilesChanged();
        }
        return pBXBuildFile;
    }

    @Nullable
    private static PBXBuildFile j(@NotNull PBXBuildPhase.PhaseType phaseType, @Nullable Collection<PBXBuildFile> collection) {
        if (phaseType == null) {
            PBXProjectFileManipulator.j(88);
        }
        if (collection == null) {
            return null;
        }
        for (PBXBuildFile pBXBuildFile : collection) {
            PBXBuildPhase pBXBuildPhase = pBXBuildFile.getPhase();
            if (pBXBuildPhase == null || !phaseType.equals(pBXBuildPhase.getType())) continue;
            return pBXBuildFile;
        }
        return null;
    }

    private void j(@NotNull PBXReference pBXReference, @Nullable PBXReference pBXReference2, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        Object object;
        String string4;
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(89);
        }
        LOG.assertTrue(string != null || string2 != null);
        string2 = string2 == null ? null : FileUtil.toCanonicalPath((String)string2);
        String string5 = string;
        if (string2 != null && pBXReference2 instanceof PBXVariantGroup) {
            string4 = new File(string2).getParentFile().getName();
            string5 = FileUtilRt.getNameWithoutExtension((String)string4);
            pBXReference2.setAttribute("name", new File(string2).getName());
        }
        string4 = string2;
        String string6 = string3;
        if (string2 != null && pBXReference2 != null) {
            object = this.j(pBXReference2, string2, string3);
            string6 = ((PathInfo)object).getSourceTree();
            string4 = ((PathInfo)object).getPath();
            if (string5 == null) {
                string5 = new File(string2).getName();
            }
        }
        if (string5 != null && !string5.equals(string4)) {
            pBXReference.setAttribute("name", string5);
        } else {
            pBXReference.setAttribute("name", null);
        }
        if (string4 != null && !string4.equals(".")) {
            pBXReference.setAttribute("path", string4);
        } else {
            pBXReference.setAttribute("path", null);
        }
        LOG.assertTrue(string6 != null);
        pBXReference.setAttribute("sourceTree", string6);
        if (pBXReference.getAttribute("lastKnownFileType", null) != null && (object = pBXReference.getFileType()) != null && !((AppleFileType)object).isFolder()) {
            String string7 = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFilename(pBXReference.getFileName(), false);
            pBXReference.setAttribute("lastKnownFileType", string7);
        }
    }

    @NotNull
    private PathInfo j(@NotNull PBXReference pBXReference, @NotNull String string, @Nullable String string2) {
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(90);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(91);
        }
        if ("SDKROOT".equals(string2) || "DEVELOPER_DIR".equals(string2) || "BUILT_PRODUCTS_DIR".equals(string2)) {
            return new PathInfo(string2, string);
        }
        if ("SOURCE_ROOT".equals(string2)) {
            if (FileUtil.isAbsolute((String)string)) {
                File file2 = new File(this.myProjectFile.getBaseDir().getPath());
                return PBXProjectFileManipulator.j(new File(string), file2, "SOURCE_ROOT");
            }
            return new PathInfo(string2, string);
        }
        if ("<absolute>".equals(string2)) {
            LOG.assertTrue(FileUtil.isAbsolute((String)string));
            return new PathInfo(string2, string);
        }
        String string3 = pBXReference.resolvePath();
        if (string3 == null) {
            LOG.assertTrue(FileUtil.isAbsolute((String)string));
            return new PathInfo("<absolute>", string);
        }
        boolean bl = "<group>".equals(string2);
        if (bl) {
            string = PBXProjectFileManipulator.j(string, string3);
        }
        File file3 = new File(string3);
        File file4 = new File(string);
        String string4 = string2 = string2 == null ? "<group>" : string2;
        if (bl || VfsUtilCore.isAncestor((File)file3, (File)file4, (boolean)false)) {
            return PBXProjectFileManipulator.j(file4, file3, string2);
        }
        File file5 = new File(this.myProjectFile.getBaseDir().getPath());
        if (VfsUtilCore.isAncestor((File)file5, (File)file4, (boolean)true)) {
            return PBXProjectFileManipulator.j(new File(string), file5, "SOURCE_ROOT");
        }
        return PBXProjectFileManipulator.j(file4, file3, string2);
    }

    public PBXBuildPhase addBuildPhase(@NotNull PBXBuildPhase.PhaseType type, @NotNull Map<String, Object> properties, @Nullable PBXTarget target) {
        if (type == null) {
            PBXProjectFileManipulator.j(92);
        }
        if (properties == null) {
            PBXProjectFileManipulator.j(93);
        }
        return this.addBuildPhase(type, properties, target, -1);
    }

    public PBXBuildPhase addBuildPhase(@NotNull PBXBuildPhase.PhaseType type, @NotNull Map<String, Object> properties, @Nullable PBXTarget target, int index2) {
        PBXBuildPhase pBXBuildPhase;
        Object object;
        PBXBuildPhase.Type type2;
        if (type == null) {
            PBXProjectFileManipulator.j(94);
        }
        if (properties == null) {
            PBXProjectFileManipulator.j(95);
        }
        if ((type2 = PBXBuildPhase.Type.typeFromName(type.getName())) != null) {
            pBXBuildPhase = switch (type2) {
                case PBXBuildPhase.Type.COPY_FILES -> new PBXCopyFilesBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.FRAMEWORKS -> new PBXFrameworksBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.HEADERS -> new PBXHeadersBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.RESOURCES -> new PBXResourcesBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.REZ -> new PBXRezBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.SHELL_SCRIPT -> {
                    object = new PBXShellScriptBuildPhase(this.myProjectFile);
                    ((Dictionary)object).setAttribute("inputPaths", new ArrayList());
                    ((Dictionary)object).setAttribute("outputPaths", new ArrayList());
                    yield object;
                }
                default -> new PBXSourcesBuildPhase(this.myProjectFile);
            };
        } else {
            pBXBuildPhase = new PBXBuildPhase(this.myProjectFile, type);
        }
        pBXBuildPhase.setAttribute("runOnlyForDeploymentPostprocessing", "0");
        for (String string : properties.keySet()) {
            Object object2 = properties.get(string);
            if (object2 instanceof List) {
                ArrayList<ObjectReference> arrayList = new ArrayList<ObjectReference>();
                for (Object e2 : (List)object2) {
                    if (e2 instanceof PbxId) {
                        arrayList.add(new ObjectReference((PbxId)e2, this.myProjectFile));
                        continue;
                    }
                    if (!(e2 instanceof String)) continue;
                    arrayList.add((ObjectReference)e2);
                }
                pBXBuildPhase.setAttribute(string, arrayList);
                continue;
            }
            pBXBuildPhase.setAttribute(string, String.valueOf(object2));
        }
        object = pBXBuildPhase;
        PBXProjectFileManipulator.j((PBXObject)object, this.j());
        if (target != null) {
            if (index2 < 0) {
                target.addToAttributeList("buildPhases", pBXBuildPhase.createReference());
            } else {
                target.addToAttributeList("buildPhases", pBXBuildPhase.createReference(), index2);
            }
        }
        return pBXBuildPhase;
    }

    @NotNull
    private PBXGroup j(@NotNull Notifications notifications) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(96);
        }
        PBXGroup pBXGroup = new PBXGroup(this.myProjectFile);
        pBXGroup.setAttribute("children", Collections.emptyList());
        pBXGroup.setAttribute("sourceTree", "<group>");
        PBXProjectFileManipulator.j((PBXObject)pBXGroup, notifications);
        this.myProjectFile.getProjectObject().setAttribute("mainGroup", pBXGroup.createReference());
        PBXGroup pBXGroup2 = pBXGroup;
        if (pBXGroup2 == null) {
            PBXProjectFileManipulator.j(97);
        }
        return pBXGroup2;
    }

    @NotNull
    public PBXGroup addGroup(@Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable String path) {
        PBXGroup pBXGroup = this.addGroup(sourceTree, name, path, null);
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(98);
        }
        return pBXGroup;
    }

    @NotNull
    private PBXGroup j(@NotNull Notifications notifications, @Nullable @NonNls String string, @Nullable @NonNls String string2, @Nullable @NonNls String string3) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(99);
        }
        return this.j(notifications, string, string2, string3, null, true, false);
    }

    @NotNull
    public PBXGroup addGroup(@Nullable String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent) {
        PBXGroup pBXGroup = this.addGroup(sourceTree, name, path, parent, false);
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(100);
        }
        return pBXGroup;
    }

    @NotNull
    private PBXGroup j(@NotNull Notifications notifications, @Nullable @NonNls String string, @Nullable @NonNls String string2, @Nullable @NonNls String string3, @Nullable PBXGroup pBXGroup) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(101);
        }
        return this.j(notifications, string, string2, string3, pBXGroup, true, false);
    }

    @NotNull
    public PBXGroup addGroup(@Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent, boolean forceAdd) {
        PBXGroup pBXGroup = this.j(this.j(), sourceTree, name, path, parent, true, forceAdd);
        this.j();
        PBXGroup pBXGroup2 = pBXGroup;
        if (pBXGroup2 == null) {
            PBXProjectFileManipulator.j(102);
        }
        return pBXGroup2;
    }

    @NotNull
    private PBXGroup j(@NotNull Notifications notifications, @Nullable @NonNls String string, @Nullable @NonNls String string2, @Nullable @NonNls String string3, @Nullable PBXGroup pBXGroup, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        PBXGroup pBXGroup2;
        if (notifications == null) {
            PBXProjectFileManipulator.j(103);
        }
        if (pBXGroup != null) {
            LOG.assertTrue(pBXGroup.getFile() == this.myProjectFile);
        }
        PBXProject pBXProject = this.myProjectFile.getProjectObject();
        PBXGroup pBXGroup3 = pBXProject.getMainGroup();
        if (pBXGroup == null && pBXGroup3 == null) {
            pBXGroup3 = this.j(notifications);
        }
        PBXGroup pBXGroup4 = pBXGroup2 = pBXGroup == null ? pBXGroup3 : pBXGroup;
        if (!bl2) {
            object2 = pBXGroup2.resolveAttributeList("children", PBXReference.class);
            object = object2.iterator();
            while (object.hasNext()) {
                PBXReference pBXReference = object.next();
                if (!(pBXReference instanceof PBXGroup) || !pBXReference.getDisplayName().equals(string2 == null ? string3 : string2)) continue;
                PBXGroup pBXGroup5 = (PBXGroup)pBXReference;
                if (pBXGroup5 == null) {
                    PBXProjectFileManipulator.j(104);
                }
                return pBXGroup5;
            }
        }
        object2 = new PBXGroup(this.myProjectFile);
        ((Dictionary)object2).setAttribute("children", Collections.emptyList());
        this.j((PBXReference)object2, pBXGroup2, string2, string3, string);
        PBXProjectFileManipulator.j((PBXObject)object2, bl ? pBXGroup2 : null, notifications);
        if ("Products".equals(string2) && ((object = pBXProject.getAttribute("productRefGroup", ObjectReference.class)) == null || ((ObjectReference)object).resolveObject() == null)) {
            pBXProject.setAttribute("productRefGroup", ((PBXObject)object2).createReference());
        }
        notifications.referencesChanged();
        Object object3 = object2;
        if (object3 == null) {
            PBXProjectFileManipulator.j(105);
        }
        return object3;
    }

    public void addFramework(@NotNull String name, @Nullable PBXTarget targetOrNullForAll) {
        PBXTarget[] pBXTargetArray;
        if (name == null) {
            PBXProjectFileManipulator.j(106);
        }
        if (targetOrNullForAll != null) {
            PBXTarget[] pBXTargetArray2 = new PBXTarget[1];
            pBXTargetArray = pBXTargetArray2;
            pBXTargetArray2[0] = targetOrNullForAll;
        } else {
            pBXTargetArray = this.getAllTargets();
        }
        PBXTarget[] pBXTargetArray3 = pBXTargetArray;
        this.addFrameworkOrLibrary(name + ".framework", pBXTargetArray3);
    }

    public void addFrameworkOrLibrary(@NotNull String nameWithExtension, @NotNull PBXTarget[] targets) {
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.j(107);
        }
        if (targets == null) {
            PBXProjectFileManipulator.j(108);
        }
        this.addFrameworkOrLibrary(null, nameWithExtension, targets);
    }

    public void addFrameworkOrLibrary(@Nullable VirtualFile file2, @NotNull String nameWithExtension, @NotNull PBXTarget[] targets) {
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.j(109);
        }
        if (targets == null) {
            PBXProjectFileManipulator.j(110);
        }
        Notifications notifications = this.j();
        PBXGroup pBXGroup = this.j(notifications, "<group>", "Frameworks", (String)null);
        this.j(notifications, nameWithExtension, file2, targets, pBXGroup);
        this.j();
    }

    public void addOtherFramework(@NotNull String name) {
        if (name == null) {
            PBXProjectFileManipulator.j(111);
        }
        Notifications notifications = this.j();
        PBXGroup pBXGroup = this.myProjectFile.findGroupByName("Other Frameworks");
        if (pBXGroup == null) {
            PBXGroup pBXGroup2 = this.myProjectFile.findGroupByName("Frameworks");
            if (pBXGroup2 == null) {
                pBXGroup2 = this.j(notifications, "<group>", "Frameworks", (String)null);
            }
            pBXGroup = this.j(notifications, "<group>", "Other Frameworks", null, pBXGroup2);
        }
        this.j(notifications, name + ".framework", null, PBXTarget.EMPTY_ARRAY, pBXGroup);
        this.j();
    }

    private void j(@NotNull Notifications notifications, @NotNull String string, @Nullable VirtualFile virtualFile2, @NotNull PBXTarget[] pBXTargetArray, @NotNull PBXGroup pBXGroup) {
        Object object;
        Iterator<PBXReference> iterator;
        if (notifications == null) {
            PBXProjectFileManipulator.j(112);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(113);
        }
        if (pBXGroup == null) {
            PBXProjectFileManipulator.j(114);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(115);
        }
        List<PBXReference> list = pBXGroup.resolveAttributeList("children", PBXReference.class);
        PBXReference pBXReference = null;
        if (virtualFile2 == null || virtualFile2.getName().endsWith(".framework") || virtualFile2.getName().endsWith(".dylib")) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!string.equals(((PBXReference)object).getName())) continue;
                pBXReference = object;
                break;
            }
        }
        if (pBXReference != null) {
            this.j(notifications, Arrays.asList(pBXTargetArray), pBXReference, (PBXBuildPhase.PhaseType)PBXBuildPhase.Type.FRAMEWORKS, null);
        } else {
            Object object2 = iterator = virtualFile2 != null ? Couple.of((Object)virtualFile2.getPath(), (Object)"<absolute>") : this.j(pBXTargetArray, string);
            if (iterator != null) {
                this.j(notifications, (String)iterator.getFirst(), pBXTargetArray, pBXGroup, (String)iterator.getSecond(), PBXBuildPhase.Type.FRAMEWORKS);
            } else if (string.endsWith(".framework")) {
                object = String.format("Library/Frameworks/%s", string);
                this.j(notifications, (String)object, pBXTargetArray, pBXGroup, "DEVELOPER_DIR", PBXBuildPhase.Type.FRAMEWORKS);
            }
        }
    }

    @NotNull
    public PBXReference addLinkedProject(@NotNull PBXProjectFile another) {
        if (another == null) {
            PBXProjectFileManipulator.j(116);
        }
        LOG.assertTrue(another != this.myProjectFile);
        VirtualFile virtualFile2 = another.getPBXProjFile().getParent();
        PBXProject pBXProject = this.myProjectFile.getProjectObject();
        Notifications notifications = this.j();
        PBXGroup pBXGroup = pBXProject.getMainGroup();
        if (pBXGroup == null) {
            pBXGroup = this.j(notifications);
        }
        PBXReference pBXReference = this.j(notifications, virtualFile2.getPath(), PBXTarget.EMPTY_ARRAY, pBXGroup, "<group>", (PBXBuildPhase.PhaseType)null);
        PBXGroup pBXGroup2 = this.j(notifications, "<group>", "Products", null, pBXProject.getMainGroup(), false, true);
        List<Map> list = pBXProject.getAttributeListForModification("projectReferences", Map.class);
        PBXDictionary pBXDictionary = new PBXDictionary(this.myProjectFile);
        pBXDictionary.put("ProductGroup", (Object)pBXGroup2.createReference());
        pBXDictionary.put("ProjectRef", (Object)pBXReference.createReference());
        list.add(pBXDictionary);
        pBXProject.setAttribute("projectReferences", list);
        List list2 = another.getTargets(null);
        for (PBXTarget pBXTarget : list2) {
            PBXContainerItemProxy pBXContainerItemProxy = new PBXContainerItemProxy(this.myProjectFile);
            PBXFileReference pBXFileReference = pBXTarget.resolveAttribute("productReference", PBXFileReference.class);
            if (pBXFileReference == null) continue;
            pBXContainerItemProxy.setAttribute("containerPortal", pBXReference.createReference());
            pBXContainerItemProxy.setAttribute("proxyType", "2");
            pBXContainerItemProxy.setAttribute("remoteGlobalIDString", pBXFileReference.createReference());
            pBXContainerItemProxy.setAttribute("remoteInfo", pBXTarget.getDisplayName());
            PBXProjectFileManipulator.j(pBXContainerItemProxy, notifications);
            PBXReferenceProxy pBXReferenceProxy = new PBXReferenceProxy(this.myProjectFile);
            pBXReferenceProxy.setAttribute("fileType", pBXFileReference.getAttribute("explicitFileType", String.class));
            pBXReferenceProxy.setAttribute("path", pBXFileReference.getAttribute("path", String.class));
            pBXReferenceProxy.setAttribute("remoteRef", pBXContainerItemProxy.createReference());
            pBXReferenceProxy.setAttribute("sourceTree", pBXFileReference.getAttribute("sourceTree", String.class));
            PBXProjectFileManipulator.j(pBXReferenceProxy, pBXGroup2, notifications);
        }
        PBXProjectFileManipulator.j(notifications);
        this.j();
        PBXReference pBXReference2 = pBXReference;
        if (pBXReference2 == null) {
            PBXProjectFileManipulator.j(117);
        }
        return pBXReference2;
    }

    @Nullable
    private Couple<String> j(@NotNull PBXTarget[] pBXTargetArray, @NotNull String string) {
        String string2;
        if (string == null) {
            PBXProjectFileManipulator.j(118);
        }
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(119);
        }
        if ((string2 = this.j((AppleSdk)null, string)) != null) {
            return Couple.of((Object)string2, (Object)"DEVELOPER_DIR");
        }
        for (PBXTarget pBXTarget : pBXTargetArray) {
            for (XCBuildConfiguration xCBuildConfiguration : pBXTarget.getBuildConfigurations()) {
                AppleSdk appleSdk = XCCoreBuildSettings.getRawCoreBuildSettings(xCBuildConfiguration).getBaseSdk();
                if (appleSdk == null || (string2 = this.j(appleSdk, string)) == null) continue;
                return Couple.of((Object)string2, (Object)"SDKROOT");
            }
        }
        for (AppleSdk appleSdk : AppleSdkManager.getInstance().getSdks()) {
            string2 = this.j(appleSdk, string);
            if (string2 == null) continue;
            return Couple.of((Object)string2, (Object)"SDKROOT");
        }
        return null;
    }

    @Nullable
    private String j(@Nullable AppleSdk appleSdk, final @NotNull String string) {
        BuildSettingsProvider buildSettingsProvider;
        String string2;
        if (string == null) {
            PBXProjectFileManipulator.j(120);
        }
        CommonProcessors.FindFirstProcessor<VirtualFile> findFirstProcessor = new CommonProcessors.FindFirstProcessor<VirtualFile>(){

            protected boolean accept(VirtualFile virtualFile2) {
                return virtualFile2.getName().equals(string);
            }
        };
        if (appleSdk != null) {
            string2 = appleSdk.getHomePath();
            appleSdk.processFrameworkFiles((Processor<VirtualFile>)findFirstProcessor);
            appleSdk.processLibraryFiles((Processor<VirtualFile>)findFirstProcessor);
        } else {
            buildSettingsProvider = this.myProjectFile.getBuildSettingsProvider();
            string2 = buildSettingsProvider.getBuildSetting("DEVELOPER_DIR").getAbsolutePath();
            AppleSdk.processDeveloperFrameworkFiles(buildSettingsProvider, (Processor<VirtualFile>)findFirstProcessor);
        }
        if (findFirstProcessor.isFound() && string2 != null) {
            buildSettingsProvider = (VirtualFile)findFirstProcessor.getFoundValue();
            String string3 = buildSettingsProvider.getPath().substring(string2.length());
            return string3.charAt(0) == '/' ? string3.substring(1) : string3;
        }
        return null;
    }

    @TestOnly
    @NotNull
    public XCSwiftPackageProductDependency createSwiftPackageProductDependency(@Nullable XCRemoteSwiftPackageReference packageReference, @NotNull String name) {
        if (name == null) {
            PBXProjectFileManipulator.j(121);
        }
        Notifications notifications = this.j();
        XCSwiftPackageProductDependency xCSwiftPackageProductDependency = new XCSwiftPackageProductDependency(this.myProjectFile);
        if (packageReference != null) {
            xCSwiftPackageProductDependency.setAttribute("package", packageReference.createReference());
        }
        xCSwiftPackageProductDependency.setAttribute("productName", name);
        PBXProjectFileManipulator.j((PBXObject)xCSwiftPackageProductDependency, notifications);
        this.j();
        XCSwiftPackageProductDependency xCSwiftPackageProductDependency2 = xCSwiftPackageProductDependency;
        if (xCSwiftPackageProductDependency2 == null) {
            PBXProjectFileManipulator.j(122);
        }
        return xCSwiftPackageProductDependency2;
    }

    @TestOnly
    public void addSwiftPackageProductDependency(@NotNull PBXTarget addTo, @NotNull XCSwiftPackageProductDependency dependency) {
        if (addTo == null) {
            PBXProjectFileManipulator.j(123);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.j(124);
        }
        this.j().buildSettingsChanged();
        addTo.addToAttributeList("packageProductDependencies", dependency.createReference());
        this.j();
    }

    @TestOnly
    public void removeSwiftPackageProductTargetDependency(@NotNull PBXTarget removeFrom, @NotNull XCSwiftPackageProductDependency swiftProductDependency) {
        if (removeFrom == null) {
            PBXProjectFileManipulator.j(125);
        }
        if (swiftProductDependency == null) {
            PBXProjectFileManipulator.j(126);
        }
        this.j().buildSettingsChanged();
        removeFrom.removeFromAttributeList("packageProductDependencies", swiftProductDependency.createReference());
        this.j();
    }

    @NotNull
    public PBXTarget addNativeTarget(@NotNull String name, @NotNull String productTypeId, @NotNull Map<String, Object> buildSettings, @Nullable ApplePlatform platform) {
        PBXFileReference pBXFileReference;
        String string;
        ApplePackageType applePackageType;
        if (name == null) {
            PBXProjectFileManipulator.j(127);
        }
        if (productTypeId == null) {
            PBXProjectFileManipulator.j(128);
        }
        if (buildSettings == null) {
            PBXProjectFileManipulator.j(129);
        }
        Notifications notifications = this.j();
        PBXNativeTarget pBXNativeTarget = new PBXNativeTarget(this.myProjectFile);
        pBXNativeTarget.setAttribute("productType", productTypeId);
        AppleProductType appleProductType = platform == null ? null : platform.findProductType(productTypeId);
        ApplePackageType applePackageType2 = applePackageType = appleProductType == null ? null : appleProductType.getDefaultPackageType();
        if (applePackageType != null) {
            string = applePackageType.getProductReferenceName();
            if (string != null) {
                pBXFileReference = new PBXFileReference(this.myProjectFile);
                PBXGroup pBXGroup = this.j(notifications, "<group>", "Products", (String)null);
                PBXProjectFileManipulator.j(pBXFileReference, pBXGroup, notifications);
                pBXNativeTarget.setAttribute("productReference", pBXFileReference.createReference());
            } else {
                pBXFileReference = null;
            }
        } else {
            pBXFileReference = null;
            string = null;
        }
        this.j(name, pBXNativeTarget, () -> {
            if (pBXFileReference != null) {
                pBXFileReference.setAttribute("explicitFileType", applePackageType.getProductReferenceFileType());
                pBXFileReference.setAttribute("includeInIndex", "0");
                pBXFileReference.setAttribute("path", BuildSettingsResolver.resolveValue(string, this.myProjectFile, pBXNativeTarget, buildSettings, platform));
                pBXFileReference.setAttribute("sourceTree", "BUILT_PRODUCTS_DIR");
            }
        }, notifications);
        this.j();
        PBXNativeTarget pBXNativeTarget2 = pBXNativeTarget;
        if (pBXNativeTarget2 == null) {
            PBXProjectFileManipulator.j(130);
        }
        return pBXNativeTarget2;
    }

    @NotNull
    public PBXTarget addLegacyTarget(@NotNull String name, @NotNull String buildToolPath, @NotNull String buildToolArgsString) {
        if (name == null) {
            PBXProjectFileManipulator.j(131);
        }
        if (buildToolPath == null) {
            PBXProjectFileManipulator.j(132);
        }
        if (buildToolArgsString == null) {
            PBXProjectFileManipulator.j(133);
        }
        Notifications notifications = this.j();
        PBXLegacyTarget pBXLegacyTarget = new PBXLegacyTarget(this.myProjectFile);
        pBXLegacyTarget.setAttribute("buildToolPath", buildToolPath);
        pBXLegacyTarget.setAttribute("buildArgumentsString", buildToolArgsString);
        pBXLegacyTarget.setAttribute("passBuildSettingsInEnvironment", "1");
        this.j(name, pBXLegacyTarget, null, notifications);
        this.j();
        PBXLegacyTarget pBXLegacyTarget2 = pBXLegacyTarget;
        if (pBXLegacyTarget2 == null) {
            PBXProjectFileManipulator.j(134);
        }
        return pBXLegacyTarget2;
    }

    private void j(@NotNull String string, @NotNull PBXTarget pBXTarget, @Nullable Runnable runnable, @NotNull Notifications notifications) {
        if (string == null) {
            PBXProjectFileManipulator.j(135);
        }
        if (pBXTarget == null) {
            PBXProjectFileManipulator.j(136);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(137);
        }
        XCConfigurationList xCConfigurationList = new XCConfigurationList(this.myProjectFile);
        xCConfigurationList.setAttribute("buildConfigurations", Collections.emptyList());
        xCConfigurationList.setAttribute("defaultConfigurationIsVisible", "0");
        PBXProjectFileManipulator.j(xCConfigurationList, notifications);
        pBXTarget.setAttribute("buildConfigurationList", xCConfigurationList.createReference());
        pBXTarget.setAttribute("buildPhases", Collections.emptyList());
        pBXTarget.setAttribute("buildRules", Collections.emptyList());
        pBXTarget.setAttribute("dependencies", Collections.emptyList());
        pBXTarget.setAttribute("name", string);
        pBXTarget.setAttribute("productName", string);
        PBXProjectFileManipulator.j(pBXTarget, notifications);
        this.myProjectFile.getProjectObject().addToAttributeList("targets", pBXTarget.createReference());
        if (runnable != null) {
            runnable.run();
        }
        notifications.referencesChanged();
        notifications.targetsChanged();
    }

    public void removeTarget(@NotNull PBXTarget targetToRemove) {
        Object object;
        Object object222;
        CoreXcodeWorkspace coreXcodeWorkspace;
        if (targetToRemove == null) {
            PBXProjectFileManipulator.j(138);
        }
        List<Object> list = (coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.myProjectFile.getProject())) != null ? coreXcodeWorkspace.getAllProjects() : Collections.emptyList();
        for (Object object222 : list) {
            if (object222 == this.myProjectFile) continue;
            object = ((PBXProjectFile)object222).getManipulator(false);
            for (PBXTargetDependency pBXTargetDependency : PBXProjectFileManipulator.j((PBXProjectFile)object222, targetToRemove)) {
                ((PBXProjectFileManipulator)object).j(pBXTargetDependency, ((PBXProjectFileManipulator)object).j());
            }
            ((PBXProjectFileManipulator)object).firePendingNotifications();
        }
        ArrayList arrayList = new ArrayList();
        object222 = new ArrayList();
        arrayList.add(targetToRemove);
        arrayList.addAll(targetToRemove.getBuildConfigurationList().getConfigurations());
        arrayList.add(targetToRemove.getBuildConfigurationList());
        for (PBXBuildPhase pBXBuildPhase : targetToRemove.getBuildPhases()) {
            arrayList.addAll(pBXBuildPhase.getFiles());
            arrayList.add(pBXBuildPhase);
        }
        arrayList.addAll(targetToRemove.getBuildRules());
        for (PBXTargetDependency pBXTargetDependency : targetToRemove.getDependencies()) {
            PBXProjectFileManipulator.j(pBXTargetDependency, arrayList);
        }
        for (PBXTargetDependency pBXTargetDependency : PBXProjectFileManipulator.j(targetToRemove.getFile(), targetToRemove)) {
            PBXProjectFileManipulator.j(pBXTargetDependency, arrayList);
        }
        if (targetToRemove instanceof PBXNativeTarget) {
            object222.add(((PBXNativeTarget)targetToRemove).getProductReference());
        }
        Collections.reverse(arrayList);
        object = this.j();
        this.j((List<PBXReference>)object222, (Notifications)object);
        this.N(arrayList, (Notifications)object);
        this.j();
    }

    private static List<PBXTargetDependency> j(@NotNull PBXProjectFile pBXProjectFile, @NotNull PBXTarget pBXTarget) {
        if (pBXProjectFile == null) {
            PBXProjectFileManipulator.j(139);
        }
        if (pBXTarget == null) {
            PBXProjectFileManipulator.j(140);
        }
        SmartList smartList = new SmartList();
        for (PBXTarget pBXTarget2 : pBXProjectFile.getTargets(null)) {
            if (pBXTarget2 == pBXTarget) continue;
            for (PBXTargetDependency pBXTargetDependency : pBXTarget2.getDependencies()) {
                if (pBXTargetDependency.resolveTarget() != pBXTarget) continue;
                smartList.add(pBXTargetDependency);
            }
        }
        return smartList;
    }

    @NotNull
    public PBXTargetDependency addTargetDependency(@NotNull PBXTarget addTo, @NotNull PBXTarget dependency) {
        if (addTo == null) {
            PBXProjectFileManipulator.j(141);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.j(142);
        }
        Notifications notifications = this.j();
        PBXContainerItemProxy pBXContainerItemProxy = new PBXContainerItemProxy(this.myProjectFile);
        PBXObject pBXObject = null;
        PBXProjectFile pBXProjectFile = dependency.getFile();
        if (pBXProjectFile == this.myProjectFile) {
            pBXObject = this.myProjectFile.getProjectObject();
        } else {
            for (PBXReference pBXReference : this.myProjectFile.findReferences(pBXProjectFile.getXcodeProjFile())) {
                if (!pBXReference.isLinkedProject()) continue;
                pBXObject = pBXReference;
                break;
            }
            if (pBXObject == null) {
                throw new RuntimeException("Project " + pBXProjectFile + "should be linked to " + this.myProjectFile + " first");
            }
        }
        pBXContainerItemProxy.setAttribute("containerPortal", pBXObject.createReference());
        pBXContainerItemProxy.setAttribute("proxyType", "1");
        pBXContainerItemProxy.setAttribute("remoteGlobalIDString", dependency.getId().asString());
        pBXContainerItemProxy.setAttribute("remoteInfo", dependency.getName());
        PBXProjectFileManipulator.j(pBXContainerItemProxy, notifications);
        PBXTargetDependency pBXTargetDependency = new PBXTargetDependency(this.myProjectFile);
        pBXTargetDependency.setAttribute("target", dependency.createReference());
        pBXTargetDependency.setAttribute("targetProxy", pBXContainerItemProxy.createReference());
        PBXProjectFileManipulator.j((PBXObject)pBXTargetDependency, notifications);
        addTo.addToAttributeList("dependencies", pBXTargetDependency.createReference());
        notifications.referencesChanged();
        this.j();
        PBXTargetDependency pBXTargetDependency2 = pBXTargetDependency;
        if (pBXTargetDependency2 == null) {
            PBXProjectFileManipulator.j(143);
        }
        return pBXTargetDependency2;
    }

    public void removeTargetDependency(@NotNull PBXTargetDependency dependency) {
        if (dependency == null) {
            PBXProjectFileManipulator.j(144);
        }
        Notifications notifications = this.j();
        this.j(dependency, notifications);
        this.j();
    }

    private void j(@NotNull PBXTargetDependency pBXTargetDependency, @NotNull Notifications notifications) {
        if (pBXTargetDependency == null) {
            PBXProjectFileManipulator.j(145);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(146);
        }
        ArrayList<PBXObject> arrayList = new ArrayList<PBXObject>();
        PBXProjectFileManipulator.j(pBXTargetDependency, arrayList);
        this.N(arrayList, notifications);
    }

    private static void j(PBXTargetDependency pBXTargetDependency, List<PBXObject> list) {
        list.add(pBXTargetDependency);
        ContainerUtil.addIfNotNull(list, (Object)pBXTargetDependency.getTargetProxy());
    }

    public void addProductDependency(@NotNull PBXTarget addTo, @NotNull PBXTarget dependency) {
        PBXFileReference pBXFileReference;
        if (addTo == null) {
            PBXProjectFileManipulator.j(147);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.j(148);
        }
        LOG.assertTrue((pBXFileReference = dependency.resolveAttribute("productReference", PBXFileReference.class)) != null, (Object)("Unable to find reference in target: " + dependency));
        this.j(this.j(), Collections.singleton(addTo), (PBXReference)pBXFileReference, null, null);
        this.j();
    }

    @NotNull
    public XCBuildConfiguration addConfiguration(@NotNull String name, @NotNull Map<String, Object> map, @Nullable PBXTarget target) {
        if (name == null) {
            PBXProjectFileManipulator.j(149);
        }
        if (map == null) {
            PBXProjectFileManipulator.j(150);
        }
        Notifications notifications = this.j();
        XCBuildConfiguration xCBuildConfiguration = new XCBuildConfiguration(this.myProjectFile);
        PBXObject pBXObject = new PBXObject(this.myProjectFile);
        pBXObject.putAll((Map<? extends String, ?>)map);
        xCBuildConfiguration.setAttribute("buildSettings", pBXObject);
        xCBuildConfiguration.setAttribute("name", name);
        PBXProjectFileManipulator.j(xCBuildConfiguration, notifications);
        XCConfigurationList xCConfigurationList = target == null ? this.myProjectFile.getProjectObject().getBuildConfigurationList() : target.getBuildConfigurationList();
        xCConfigurationList.addToAttributeList("buildConfigurations", xCBuildConfiguration.createReference());
        notifications.referencesChanged();
        notifications.targetsChanged();
        this.j();
        XCBuildConfiguration xCBuildConfiguration2 = xCBuildConfiguration;
        if (xCBuildConfiguration2 == null) {
            PBXProjectFileManipulator.j(151);
        }
        return xCBuildConfiguration2;
    }

    @Nullable
    private PBXTarget j(@Nullable String string) {
        return this.myProjectFile.findTarget(string, null);
    }

    @NotNull
    public PBXTarget[] getAllTargets() {
        List<PBXTarget> list = this.myProjectFile.getTargets(null);
        PBXTarget[] pBXTargetArray = list.toArray(PBXTarget.EMPTY_ARRAY);
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.j(152);
        }
        return pBXTargetArray;
    }

    @NotNull
    private static PathInfo j(@NotNull File file2, @NotNull File file3, @NotNull String string) {
        if (file2 == null) {
            PBXProjectFileManipulator.j(153);
        }
        if (file3 == null) {
            PBXProjectFileManipulator.j(154);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(155);
        }
        if (!VfsUtilCore.isAncestor((File)file3, (File)file2, (boolean)true) && file2.getPath().startsWith("..")) {
            return new PathInfo(string, file2.getPath());
        }
        String string2 = FileUtil.getRelativePath((String)file3.getAbsolutePath(), (String)file2.getAbsolutePath(), (char)File.separatorChar);
        LOG.assertTrue(string2 != null, (Object)String.format("Unable to find relative path (base='%s', file='%s')", file3.getPath(), file2.getPath()));
        return new PathInfo(string, string2);
    }

    public void updateEncodings(@NotNull Collection<String> paths2) {
        if (paths2 == null) {
            PBXProjectFileManipulator.j(156);
        }
        this.j(paths2, (PairProcessor<PBXReference, String>)((PairProcessor)(pBXReference, string) -> {
            PBXProjectFileManipulator.j(pBXReference, string);
            return false;
        }), false);
    }

    private static void j(@NotNull PBXReference pBXReference, @NotNull String string) {
        VirtualFile virtualFile2;
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(157);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(158);
        }
        if ((virtualFile2 = StandardFileSystems.local().findFileByPath(string)) == null) {
            return;
        }
        Charset charset = virtualFile2.getCharset();
        long l2 = Foundation.getEncodingCode((String)charset.name());
        pBXReference.setAttribute("fileEncoding", l2 == -1L ? null : String.valueOf(l2));
    }

    public void rename(@NotNull PBXReference ref, @NotNull String oldFilePath, @NotNull String newPath, @NotNull String newFileName) {
        if (ref == null) {
            PBXProjectFileManipulator.j(159);
        }
        if (oldFilePath == null) {
            PBXProjectFileManipulator.j(160);
        }
        if (newPath == null) {
            PBXProjectFileManipulator.j(161);
        }
        if (newFileName == null) {
            PBXProjectFileManipulator.j(162);
        }
        HashMap<PBXReference, FSMoveInfo> hashMap = new HashMap<PBXReference, FSMoveInfo>();
        hashMap.put(ref, new FSMoveInfo(newPath, newFileName));
        this.j(this.j(), oldFilePath, newPath, hashMap);
        this.j();
    }

    public void rename(@NotNull Collection<Couple<String>> renames) {
        if (renames == null) {
            PBXProjectFileManipulator.j(163);
        }
        Notifications notifications = this.j();
        for (Couple<String> couple : renames) {
            this.j(notifications, (String)couple.first, (String)couple.second, Collections.emptyMap());
        }
        this.j();
    }

    public void setBuildSetting(@NotNull XCBuildConfiguration buildConfiguration, @Nullable BuildSetting setting) {
        if (buildConfiguration == null) {
            PBXProjectFileManipulator.j(164);
        }
        if (buildConfiguration.setBuildSetting(setting, false)) {
            this.j().buildSettingsChanged();
        }
    }

    private void j(@NotNull Notifications notifications, @NotNull String string, @NotNull String string2, @NotNull Map<PBXReference, FSMoveInfo> map) {
        Object object22;
        FileRefTree fileRefTree2;
        if (notifications == null) {
            PBXProjectFileManipulator.j(165);
        }
        if (string == null) {
            PBXProjectFileManipulator.j(166);
        }
        if (string2 == null) {
            PBXProjectFileManipulator.j(167);
        }
        if (map == null) {
            PBXProjectFileManipulator.j(168);
        }
        if ((fileRefTree2 = (FileRefTree)this.myProjectFile.getFileRefTree().getSubTree(string, false)) == null) {
            return;
        }
        HashMap<PBXReference, FSMoveInfo> hashMap = new HashMap<PBXReference, FSMoveInfo>(map);
        FileRefTree.Processor processor = fileRefTree -> {
            for (PBXReference pBXReference : fileRefTree.getReferences()) {
                String string3;
                String string4;
                if (hashMap.containsKey(pBXReference) || (string4 = pBXReference.resolvePath()) == null || !FileUtil.isAncestor((String)string, (String)string4, (boolean)false) || string4.equals(string3 = StringUtil.replace((String)string4, (String)string, (String)string2, (boolean)true))) continue;
                String string5 = pBXReference.getName();
                String string6 = PBXProjectFileManipulator.N(pBXReference, string5) ? null : string5;
                hashMap.put(pBXReference, new FSMoveInfo(string3, string6));
            }
            return true;
        };
        if (!string.equals(string2)) {
            fileRefTree2.processRecursively(processor);
        }
        if (hashMap.isEmpty()) {
            return;
        }
        for (Object object22 : new ArrayList(hashMap.keySet())) {
            if (!(object22 instanceof PBXGroup)) continue;
            for (PBXReference object3 : ((PBXGroup)object22).getChildren()) {
                String string3;
                if (!"<group>".equals(object3.getSourceTree()) || hashMap.containsKey(object3) || (string3 = FileUtil.toCanonicalPath((String)object3.getPath())) == null || !string3.startsWith("..")) continue;
                String string4 = object3.resolvePath();
                LOG.assertTrue(string4 != null);
                hashMap.put(object3, new FSMoveInfo(string4, null));
            }
        }
        List<PBXReference> list = PBXProjectFileManipulator.j(hashMap.keySet());
        object22 = list.iterator();
        while (object22.hasNext()) {
            PBXReference pBXReference = (PBXReference)object22.next();
            FSMoveInfo fSMoveInfo = (FSMoveInfo)hashMap.get(pBXReference);
            this.j(pBXReference, pBXReference.getParent(), fSMoveInfo.newName, fSMoveInfo.newPath, pBXReference.getSourceTree());
        }
        notifications.referencesChanged();
    }

    private static List<PBXReference> j(@NotNull Collection<PBXReference> collection) {
        if (collection == null) {
            PBXProjectFileManipulator.j(169);
        }
        ArrayList<PBXReference> arrayList = new ArrayList<PBXReference>();
        HashSet<PBXReference> hashSet = new HashSet<PBXReference>(collection);
        HashSet<PBXReference> hashSet2 = new HashSet<PBXReference>();
        for (PBXReference pBXReference : collection) {
            PBXProjectFileManipulator.j(pBXReference, hashSet, hashSet2, arrayList);
        }
        return arrayList;
    }

    private static void j(@Nullable PBXReference pBXReference, @NotNull Set<PBXReference> set, @NotNull Set<PBXReference> set2, @NotNull List<PBXReference> list) {
        if (set == null) {
            PBXProjectFileManipulator.j(170);
        }
        if (set2 == null) {
            PBXProjectFileManipulator.j(171);
        }
        if (list == null) {
            PBXProjectFileManipulator.j(172);
        }
        if (pBXReference == null) {
            return;
        }
        if (set2.contains(pBXReference)) {
            return;
        }
        PBXProjectFileManipulator.j(pBXReference.getParent(), set, set2, list);
        if (set.contains(pBXReference)) {
            list.add(pBXReference);
        }
        set2.add(pBXReference);
    }

    public void remove(String ... paths2) {
        if (paths2 == null) {
            PBXProjectFileManipulator.j(173);
        }
        this.remove(Arrays.asList(paths2));
    }

    public void remove(@NotNull Collection<String> paths2) {
        if (paths2 == null) {
            PBXProjectFileManipulator.j(174);
        }
        this.remove(paths2, false);
    }

    public void remove(@NotNull Collection<String> paths2, boolean deep) {
        if (paths2 == null) {
            PBXProjectFileManipulator.j(175);
        }
        ArrayList<PBXReference> arrayList = new ArrayList<PBXReference>();
        this.gatherReferencesForPaths(paths2, arrayList, deep);
        this.removeReferences(arrayList);
    }

    public void gatherReferencesForPaths(@NotNull Collection<String> paths2, @NotNull Collection<PBXReference> references, boolean deep) {
        if (paths2 == null) {
            PBXProjectFileManipulator.j(176);
        }
        if (references == null) {
            PBXProjectFileManipulator.j(177);
        }
        this.j(paths2, (PairProcessor<PBXReference, String>)((PairProcessor)(pBXReference, string) -> {
            references.add((PBXReference)pBXReference);
            return true;
        }), deep);
    }

    private void j(Collection<String> collection, PairProcessor<PBXReference, String> pairProcessor, boolean bl) {
        if (collection.isEmpty()) {
            return;
        }
        FileRefTree fileRefTree2 = this.myProjectFile.getFileRefTree();
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (String string : collection) {
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            FileRefTree fileRefTree3 = (FileRefTree)fileRefTree2.getSubTree(string, false);
            if (fileRefTree3 == null) continue;
            fileRefTree3.processRecursively(fileRefTree -> {
                for (PBXReference pBXReference : fileRefTree.getReferences()) {
                    pairProcessor.process((Object)pBXReference, (Object)string);
                }
                return bl;
            });
        }
    }

    private static boolean N(@NotNull PBXReference pBXReference, @Nullable String string) {
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(178);
        }
        if (string == null) {
            return false;
        }
        String string2 = pBXReference.getPath();
        return string2 != null && new File(string2).getName().equals(string);
    }

    public void removeReference(@NotNull PBXReference reference) {
        if (reference == null) {
            PBXProjectFileManipulator.j(179);
        }
        this.removeReferences(Collections.singletonList(reference));
    }

    public void removeReferences(@NotNull List<PBXReference> references) {
        if (references == null) {
            PBXProjectFileManipulator.j(180);
        }
        Notifications notifications = this.j();
        this.j(references, notifications);
        this.j();
    }

    private void j(@NotNull List<PBXReference> list, @NotNull Notifications notifications) {
        if (list == null) {
            PBXProjectFileManipulator.j(181);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(182);
        }
        LinkedHashSet<PBXReference> linkedHashSet = new LinkedHashSet<PBXReference>();
        for (PBXReference pBXReference : list) {
            this.j(pBXReference, linkedHashSet, notifications);
        }
        this.j(linkedHashSet, notifications);
    }

    private void j(@NotNull PBXReference pBXReference, @NotNull Set<PBXReference> set, @NotNull Notifications notifications) {
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(183);
        }
        if (set == null) {
            PBXProjectFileManipulator.j(184);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(185);
        }
        LOG.assertTrue(pBXReference.getFile() == this.myProjectFile);
        if (set.contains(pBXReference)) {
            return;
        }
        if (pBXReference.isLinkedProject()) {
            this.j(pBXReference, notifications);
        } else if (pBXReference instanceof PBXGroup) {
            for (PBXReference pBXReference2 : ((PBXGroup)pBXReference).getChildren()) {
                this.j(pBXReference2, set, notifications);
            }
            set.add(pBXReference);
        } else {
            set.add(pBXReference);
        }
    }

    private void j(@NotNull Collection<? extends PBXReference> collection, @NotNull Notifications notifications) {
        if (collection == null) {
            PBXProjectFileManipulator.j(186);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(187);
        }
        if (collection.isEmpty()) {
            return;
        }
        boolean bl = false;
        LinkedList<PBXVariantGroup> linkedList = null;
        for (PBXReference pBXReference : collection) {
            PBXGroup pBXGroup;
            LOG.assertTrue(pBXReference.getFile() == this.myProjectFile);
            if (!bl && !pBXReference.findBuildFiles().isEmpty()) {
                bl = true;
            }
            if (!((pBXGroup = pBXReference.getParent()) instanceof PBXVariantGroup)) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<PBXVariantGroup>();
            }
            linkedList.add((PBXVariantGroup)pBXGroup);
        }
        this.N(collection, notifications);
        if (bl) {
            notifications.buildFilesChanged();
        }
        notifications.referencesChanged();
        if (linkedList == null) {
            return;
        }
        Iterator<PBXReference> iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PBXVariantGroup pBXVariantGroup = (PBXVariantGroup)iterator.next();
            if (pBXVariantGroup.getChildren().isEmpty()) continue;
            iterator.remove();
        }
        this.j((Collection<? extends PBXReference>)linkedList, notifications);
    }

    public void removeLinkedProject(@NotNull PBXReference projectReference) {
        if (projectReference == null) {
            PBXProjectFileManipulator.j(188);
        }
        LOG.assertTrue(projectReference.isLinkedProject());
        this.removeReference(projectReference);
    }

    private void j(@NotNull PBXReference pBXReference, @NotNull Notifications notifications) {
        ArrayList<Object> arrayList;
        if (pBXReference == null) {
            PBXProjectFileManipulator.j(189);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.j(190);
        }
        LOG.assertTrue(pBXReference.isLinkedProject());
        boolean bl = false;
        for (PBXContainerItemProxy object2 : this.myProjectFile.getObjectsReferencing(pBXReference.getId(), PBXContainerItemProxy.class)) {
            arrayList = new ArrayList<PBXObject>(this.myProjectFile.getObjectsReferencing(object2.getId(), PBXObject.class));
            arrayList.add(object2);
            this.N(arrayList, notifications);
            bl = true;
        }
        PBXProject pBXProject = this.myProjectFile.getProjectObject();
        List<Map> list = pBXProject.getAttributeListForModification("projectReferences", Map.class);
        arrayList = new ArrayList();
        for (Map map : list) {
            PBXObject pBXObject;
            Object v10 = map.get("ProjectRef");
            if (!(v10 instanceof ObjectReference) || !pBXReference.getId().equals(((ObjectReference)v10).getId())) continue;
            Object v11 = map.get("ProductGroup");
            if (v11 instanceof ObjectReference && (pBXObject = ((ObjectReference)v11).resolveObject()) instanceof PBXGroup) {
                arrayList.add((PBXReference)pBXObject);
            }
            list.remove(map);
            bl = true;
            break;
        }
        if (list.isEmpty()) {
            pBXProject.remove("projectReferences");
        } else {
            pBXProject.setAttribute("projectReferences", list);
        }
        this.j((List<PBXReference>)arrayList, notifications);
        this.j((Collection<? extends PBXReference>)Collections.singletonList(pBXReference), notifications);
        if (bl) {
            PBXProjectFileManipulator.j(notifications);
        }
    }

    private static void j(@NotNull Notifications notifications) {
        if (notifications == null) {
            PBXProjectFileManipulator.j(191);
        }
        notifications.projectsChanged();
        notifications.targetsChanged();
        notifications.referencesChanged();
        notifications.buildFilesChanged();
    }

    @NotNull
    private Notifications j() {
        if (this.myNotifications == null) {
            this.myNotifications = new Notifications();
        }
        Notifications notifications = this.myNotifications;
        if (notifications == null) {
            PBXProjectFileManipulator.j(192);
        }
        return notifications;
    }

    private void j() {
        if (this.autoFireNotifications) {
            this.firePendingNotifications();
        }
    }

    public void firePendingNotifications() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myNotifications != null) {
            CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.myProjectFile.getProject());
            if (coreXcodeWorkspace != null) {
                coreXcodeWorkspace.fireProjectChangedNotifications(this.myNotifications);
            }
            this.myNotifications = null;
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4, 8, 12, 29, 32, 36, 41, 43, 44, 61, 97, 98, 100, 102, 104, 105, 117, 122, 130, 134, 143, 151, 152, 192 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pbxProjectFile";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 44: 
            case 61: 
            case 97: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 117: 
            case 122: 
            case 130: 
            case 134: 
            case 143: 
            case 151: 
            case 152: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 91: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroup";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 35: 
            case 40: 
            case 108: 
            case 110: 
            case 115: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 64: 
            case 72: 
            case 73: 
            case 78: 
            case 84: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 112: 
            case 137: 
            case 146: 
            case 165: 
            case 182: 
            case 185: 
            case 187: 
            case 190: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifications";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 39: 
            case 48: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroupFilePath";
                break;
            }
            case 42: 
            case 47: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 46: 
            case 65: 
            case 75: 
            case 77: 
            case 80: 
            case 83: 
            case 87: 
            case 89: 
            case 178: 
            case 179: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 49: 
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 55: 
            case 157: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInfos";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstGroup";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInfo";
                break;
            }
            case 66: 
            case 69: 
            case 71: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeFrom";
                break;
            }
            case 67: 
            case 123: 
            case 141: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addToSet";
                break;
            }
            case 76: 
            case 79: 
            case 81: 
            case 85: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phaseType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 106: 
            case 111: 
            case 121: 
            case 127: 
            case 131: 
            case 135: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 107: 
            case 109: 
            case 113: 
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithExtension";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 124: 
            case 142: 
            case 144: 
            case 145: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swiftProductDependency";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productTypeId";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSettings";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolPath";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolArgsString";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetToRemove";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTarget";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTree";
                break;
            }
            case 156: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFilePath";
                break;
            }
            case 161: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mandatoryUpdates";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorted";
                break;
            }
            case 177: 
            case 180: 
            case 181: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsToRemove";
                break;
            }
            case 188: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewProject";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileInternal";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "pathFromGroupPath";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addCoreDataModel";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "coreDataModelVersions";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopyReferences";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "addMainGroup";
                break;
            }
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroup";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "addLinkedProject";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwiftPackageProductDependency";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "addNativeTarget";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "addLegacyTarget";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "addTargetDependency";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "addConfiguration";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTargets";
                break;
            }
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingNotifications";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNewProject";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 44: 
            case 61: 
            case 97: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 117: 
            case 122: 
            case 130: 
            case 134: 
            case 143: 
            case 151: 
            case 152: 
            case 192: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addFileInternal";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "pathFromGroupPath";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addCoreDataModel";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "coreDataModelVersions";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addReference";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addObject";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveObjects";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIncludes";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectRoots";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "deepCopyReferences";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "doDeepCopyReference";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "changeTargets";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeFromTargets";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addToTargets";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addToTarget";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addToBuildPhase";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findPrototypeInPhase";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "updateNamePathSourceTree";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathAgainstSourceTree";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addBuildPhase";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "addMainGroup";
                break;
            }
            case 99: 
            case 101: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "addFramework";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkOrLibrary";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "addOtherFramework";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "doAddFramework";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "addLinkedProject";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkOrLibraryPath";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createSwiftPackageProductDependency";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "addSwiftPackageProductDependency";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "removeSwiftPackageProductTargetDependency";
                break;
            }
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "addNativeTarget";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "addLegacyTarget";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "initTarget";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "removeTarget";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "findTargetDependenciesInProject";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "addTargetDependency";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "removeTargetDependency";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveTargetDependency";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "addProductDependency";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativePath";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "updateEncodings";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "updateEncoding";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "setBuildSetting";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "sortInParentChildOrder";
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "traverseToParent";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "gatherReferencesForPaths";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "isNameDerivedFromPath";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "removeReferences";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveReferences";
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "gatherReferencesToRemove";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveGenericReferences";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "removeLinkedProject";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveLinkedProject";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "appendLinkedProjectEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 12, 29, 32, 36, 41, 43, 44, 61, 97, 98, 100, 102, 104, 105, 117, 122, 130, 134, 143, 151, 152, 192 -> new IllegalStateException(string);
        };
    }

    public static class AddResult
    extends Trinity<PBXReference, AppleFileType, Boolean> {
        public AddResult(@NotNull PBXReference ref, @Nullable AppleFileType type, Boolean childrenProcessed) {
            if (ref == null) {
                AddResult.j(0);
            }
            super((Object)ref, (Object)type, (Object)childrenProcessed);
        }

        @NotNull
        public PBXReference getReference() {
            PBXReference pBXReference = (PBXReference)this.first;
            if (pBXReference == null) {
                AddResult.j(1);
            }
            return pBXReference;
        }

        @Nullable
        public AppleFileType getFileType() {
            return (AppleFileType)this.second;
        }

        public boolean areChildrenProcessed() {
            return (Boolean)this.third;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$AddResult";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$AddResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class CopyInfo {
        @NotNull
        private final PBXReference myReference;
        @NotNull
        private final ReferencePathProvider pathProvider;
        @NotNull
        private final ReferenceTargetProvider targetProvider;

        public CopyInfo(@NotNull PBXReference reference, @NotNull ReferencePathProvider pathProvider, @NotNull ReferenceTargetProvider targetProvider) {
            if (reference == null) {
                CopyInfo.j(0);
            }
            if (pathProvider == null) {
                CopyInfo.j(1);
            }
            if (targetProvider == null) {
                CopyInfo.j(2);
            }
            this.myReference = reference;
            this.pathProvider = pathProvider;
            this.targetProvider = targetProvider;
        }

        @NotNull
        public PBXReference getReference() {
            PBXReference pBXReference = this.myReference;
            if (pBXReference == null) {
                CopyInfo.j(3);
            }
            return pBXReference;
        }

        @NotNull
        public ReferencePathProvider getPathProvider() {
            ReferencePathProvider referencePathProvider = this.pathProvider;
            if (referencePathProvider == null) {
                CopyInfo.j(4);
            }
            return referencePathProvider;
        }

        @NotNull
        public ReferenceTargetProvider getTargetProvider() {
            ReferenceTargetProvider referenceTargetProvider = this.targetProvider;
            if (referenceTargetProvider == null) {
                CopyInfo.j(5);
            }
            return referenceTargetProvider;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$CopyInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$CopyInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetProvider";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class CopyResult {
        @Nullable
        PBXReference myReference;
        @Nullable
        @NonNls
        String myErrorMessage;

        public CopyResult(@Nullable PBXReference reference, @Nullable @NonNls String errorMessage) {
            this.myReference = reference;
            this.myErrorMessage = errorMessage;
        }

        @Nullable
        public PBXReference getReference() {
            return this.myReference;
        }

        @Nullable
        @NonNls
        public String getErrorMessage() {
            return this.myErrorMessage;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class ReferenceCopier
    extends PbxObjectVisitor {
        @NotNull
        private final ReferenceTargetProvider myTargetProvider;
        @NotNull
        private final ReferencePathProvider myPathProvider;
        @NotNull
        private final Notifications myNotifications;
        @Nullable
        PBXReference myResult;
        @Nullable
        @NonNls
        String myErrorMessage;
        @NotNull
        PBXGroup myCurrentGroup;

        ReferenceCopier(@NotNull PBXGroup dstGroup, @NotNull ReferencePathProvider pathProvider, @NotNull ReferenceTargetProvider targetProvider, Notifications notifications) {
            if (dstGroup == null) {
                ReferenceCopier.N(0);
            }
            if (pathProvider == null) {
                ReferenceCopier.N(1);
            }
            if (targetProvider == null) {
                ReferenceCopier.N(2);
            }
            if (notifications == null) {
                ReferenceCopier.N(3);
            }
            this.myCurrentGroup = dstGroup;
            this.myTargetProvider = targetProvider;
            this.myPathProvider = pathProvider;
            this.myNotifications = notifications;
        }

        @Nullable
        public PBXReference getResult() {
            return this.myResult;
        }

        @Nullable
        @NonNls
        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        @Nullable
        private String j(@NotNull PBXReference pBXReference) {
            if (pBXReference == null) {
                ReferenceCopier.N(4);
            }
            return this.myPathProvider.getNewPath(pBXReference);
        }

        private void j(@NotNull PBXReference pBXReference) {
            if (pBXReference == null) {
                ReferenceCopier.N(5);
            }
            if (this.myResult == null) {
                this.myResult = pBXReference;
            }
        }

        @Override
        public boolean visitObject(@NotNull PBXObject object) {
            if (object == null) {
                ReferenceCopier.N(6);
            }
            return this.j(object);
        }

        private boolean j(@NotNull PBXObject pBXObject) {
            if (pBXObject == null) {
                ReferenceCopier.N(7);
            }
            return this.j("unexpected object to copy: " + pBXObject);
        }

        private boolean j(@NotNull @NonNls String string) {
            if (string == null) {
                ReferenceCopier.N(8);
            }
            LOG.error(string);
            this.myResult = null;
            this.myErrorMessage = "Error occurred while preparing to copy objects: " + string;
            return false;
        }

        @Override
        public boolean visitFile(@NotNull PBXFileReference reference) {
            if (reference == null) {
                ReferenceCopier.N(9);
            }
            return this.j(reference);
        }

        @Override
        public boolean visitReferenceProxy(@NotNull PBXReferenceProxy proxy) {
            if (proxy == null) {
                ReferenceCopier.N(10);
            }
            return this.j((PBXObject)proxy);
        }

        @Override
        public boolean visitGroup(@NotNull PBXGroup group) {
            if (group == null) {
                ReferenceCopier.N(11);
            }
            if (group.isMainGroup()) {
                return this.j("copying of projects is not supported");
            }
            String string = group.getName();
            String string2 = group.resolvePath();
            LOG.assertTrue(string2 != null);
            String string3 = this.j(group);
            if (string3 == null) {
                return this.j("can't find new path for " + group);
            }
            PBXGroup pBXGroup = PBXProjectFileManipulator.this.j(this.myNotifications, null, string, string3, this.myCurrentGroup, true, true);
            this.j(pBXGroup);
            for (PBXReference pBXReference : group.getChildren()) {
                this.myCurrentGroup = pBXGroup;
                if (pBXReference.accept(this)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean visitCompositeGroup(@NotNull PBXCompositeGroup group) {
            if (group == null) {
                ReferenceCopier.N(12);
            }
            return this.j((PBXObject)group);
        }

        @Override
        public boolean visitVariantGroup(@NotNull PBXVariantGroup variantGroup) {
            if (variantGroup == null) {
                ReferenceCopier.N(13);
            }
            for (PBXReference pBXReference : variantGroup.getChildren()) {
                if (pBXReference.accept(this)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean visitVersionGroup(@NotNull XCVersionGroup versionGroup) {
            if (versionGroup == null) {
                ReferenceCopier.N(14);
            }
            return this.j(versionGroup);
        }

        private boolean j(@NotNull PBXReference pBXReference) {
            List<PBXBuildFile> list;
            PBXTarget[] pBXTargetArray;
            String string;
            if (pBXReference == null) {
                ReferenceCopier.N(15);
            }
            if ((string = this.j(pBXReference)) == null) {
                return this.j("can't find new path for " + pBXReference);
            }
            PBXGroup pBXGroup = pBXReference.getParent();
            if (pBXGroup instanceof PBXVariantGroup) {
                pBXTargetArray = this.myTargetProvider.getNewTargets(pBXGroup);
                list = pBXGroup.findBuildFiles();
            } else {
                pBXTargetArray = this.myTargetProvider.getNewTargets(pBXReference);
                list = pBXReference.findBuildFiles();
            }
            AddResult addResult = PBXProjectFileManipulator.this.j(this.myNotifications, string, pBXTargetArray, this.myCurrentGroup, false, null, null, true, list);
            this.j(addResult.getReference());
            return true;
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dstGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notifications";
                    break;
                }
                case 4: 
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proxy";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantGroup";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionGroup";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceCopier";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNewPath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateResultIfRequired";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fail";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceProxy";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGroup";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCompositeGroup";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariantGroup";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVersionGroup";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAsFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReferencePathProvider {
        private static final ReferencePathProvider ID = new ReferencePathProvider(){

            @Override
            @Nullable
            public String getNewPath(@NotNull PBXReference reference) {
                if (reference == null) {
                    1.N(0);
                }
                return reference.resolvePath();
            }

            private static /* synthetic */ void N(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider$1", "getNewPath"));
            }
        };

        public static ReferencePathProvider id() {
            return ID;
        }

        public static ReferencePathProvider forCopying(final @NotNull String srcPath, final @NotNull String dstPath) {
            if (srcPath == null) {
                ReferencePathProvider.j(0);
            }
            if (dstPath == null) {
                ReferencePathProvider.j(1);
            }
            return new ReferencePathProvider(){

                @Override
                @Nullable
                public String getNewPath(@NotNull PBXReference reference) {
                    String string;
                    if (reference == null) {
                        2.N(0);
                    }
                    if ((string = reference.resolvePath()) != null && FileUtil.isAncestor((String)srcPath, (String)string, (boolean)false)) {
                        char c2 = File.separatorChar;
                        String string2 = FileUtil.getRelativePath((String)srcPath, (String)string, (char)c2);
                        LOG.assertTrue(string2 != null);
                        string = FileUtil.toCanonicalPath((String)new File(dstPath, string2).getPath(), (char)c2);
                    }
                    return string;
                }

                private static /* synthetic */ void N(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider$2", "getNewPath"));
                }
            };
        }

        @Nullable
        public abstract String getNewPath(@NotNull PBXReference var1);

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "srcPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dstPath";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider";
            objectArray[2] = "forCopying";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReferenceTargetProvider {
        private static final ReferenceTargetProvider ID = new ReferenceTargetProvider(){

            @Override
            @NotNull
            public PBXTarget[] getNewTargets(@NotNull PBXReference reference) {
                if (reference == null) {
                    1.N(0);
                }
                List<PBXTarget> list = reference.findTargets(null);
                PBXTarget[] pBXTargetArray = list.toArray(PBXTarget.EMPTY_ARRAY);
                if (pBXTargetArray == null) {
                    1.N(1);
                }
                return pBXTargetArray;
            }

            private static /* synthetic */ void N(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNewTargets";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNewTargets";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        public static ReferenceTargetProvider id() {
            return ID;
        }

        public static ReferenceTargetProvider forTargets(final @NotNull PBXTarget[] targets) {
            if (targets == null) {
                ReferenceTargetProvider.j(0);
            }
            return new ReferenceTargetProvider(){

                @Override
                @NotNull
                public PBXTarget[] getNewTargets(@NotNull PBXReference reference) {
                    if (reference == null) {
                        2.N(0);
                    }
                    if (targets == null) {
                        2.N(1);
                    }
                    return targets;
                }

                private static /* synthetic */ void N(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n2) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$2";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNewTargets";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNewTargets";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n2) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        public abstract PBXTarget[] getNewTargets(@NotNull PBXReference var1);

        private static /* synthetic */ void j(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider", "forTargets"));
        }
    }

    private static class PathInfo {
        private final String mySourceTree;
        private final String myPath;

        PathInfo(@NotNull @NonNls String sourceTree, @NotNull @NonNls String path) {
            if (sourceTree == null) {
                PathInfo.j(0);
            }
            if (path == null) {
                PathInfo.j(1);
            }
            this.mySourceTree = sourceTree;
            this.myPath = path;
        }

        @NotNull
        @NonNls
        public String getSourceTree() {
            String string = this.mySourceTree;
            if (string == null) {
                PathInfo.j(2);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                PathInfo.j(3);
            }
            return string;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$PathInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$PathInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FSMoveInfo {
        @NotNull
        final String newPath;
        @Nullable
        final String newName;

        private FSMoveInfo(@NotNull String newPath, @Nullable String newName) {
            if (newPath == null) {
                FSMoveInfo.j(0);
            }
            this.newPath = newPath;
            this.newName = newName;
        }

        private static /* synthetic */ void j(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$FSMoveInfo", "<init>"));
        }
    }

    public static class ReferenceRemover {
        @NotNull
        private final HashMap<PBXProjectFile, List<PBXReference>> myMap = new LinkedHashMap<PBXProjectFile, List<PBXReference>>();

        public void addReferencesForPaths(PBXProjectFile projectFile, Collection<String> pathsToRemove) {
            List<PBXReference> list = this.j(projectFile);
            projectFile.getManipulator().gatherReferencesForPaths(pathsToRemove, list, false);
        }

        @NotNull
        private List<PBXReference> j(@NotNull PBXProjectFile pBXProjectFile2) {
            if (pBXProjectFile2 == null) {
                ReferenceRemover.j(0);
            }
            List list = this.myMap.computeIfAbsent(pBXProjectFile2, pBXProjectFile -> new ArrayList());
            if (list == null) {
                ReferenceRemover.j(1);
            }
            return list;
        }

        public void addReference(@NotNull PBXReference ref) {
            if (ref == null) {
                ReferenceRemover.j(2);
            }
            this.j(ref.getFile()).add(ref);
        }

        public void removeAllReferences() {
            for (PBXProjectFile pBXProjectFile : this.myMap.keySet()) {
                pBXProjectFile.getManipulator().removeReferences(this.j(pBXProjectFile));
            }
        }

        public void gatherAllReferences(@NotNull Collection<PBXReference> remove2) {
            if (remove2 == null) {
                ReferenceRemover.j(3);
            }
            for (PBXProjectFile pBXProjectFile : this.myMap.keySet()) {
                remove2.addAll(this.j(pBXProjectFile));
            }
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceRemover";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remove";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceRemover";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferences";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherAllReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

