/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.RWAList;
import com.jetbrains.cidr.xcode.RWAMap;
import com.jetbrains.cidr.xcode.RWASet;
import com.jetbrains.cidr.xcode.RWASupport;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.CachingBuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.FileRefTree;
import com.jetbrains.cidr.xcode.model.IncompatibleVersionException;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFileManipulator;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PBXUserFile;
import com.jetbrains.cidr.xcode.model.ProjectFilesChanges;
import com.jetbrains.cidr.xcode.model.RWAChecker;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCContainer;
import com.jetbrains.cidr.xcode.model.XCLoadable;
import com.jetbrains.cidr.xcode.model.XCRemoteSwiftPackageReference;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxReader;
import com.jetbrains.cidr.xcode.pbxproj.PbxWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PBXProjectFile
implements XCContainer,
XCLoadable,
UserDataHolderEx {
    public static final String PROJECT_FILE = "project.pbxproj";
    public static final Comparator<PBXProjectFile> COMPARATOR = (pBXProjectFile, pBXProjectFile2) -> StringUtil.compare((String)pBXProjectFile.getName(), (String)pBXProjectFile2.getName(), (boolean)true);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myProjectRoot;
    @NotNull
    private final VirtualFile myPBXProjFile;
    private volatile int myArchiveVersion;
    private volatile int myObjectVersion;
    @NotNull
    private VirtualFile myBaseDir;
    private volatile PBXProject myProjectObject;
    private final RWAMap<PbxId, PBXObject> myObjects;
    private final PBXUserFile myUserFile;
    @NotNull
    private final RWAChecker myRWAChecker;
    @NotNull
    private final BuildSettingsProvider myBuildSettingsProvider;
    private final Object myCacheLock;
    @NotNull
    private volatile ReferencesCache myCache;
    @Nullable
    private volatile PbxId myCurrentIdInTests;
    @Nullable
    private final String myPredefinedProjectNameInTests;
    @NotNull
    private final Function<PBXReference, List<PBXBuildFile>> myBuildFilesFunction;
    @NotNull
    private final UserDataHolderEx myDataHolder;

    public PBXProjectFile(@NotNull Project project2, @NotNull VirtualFile projectRoot, @NotNull VirtualFile pbxprojFile) {
        if (project2 == null) {
            PBXProjectFile.j(0);
        }
        if (projectRoot == null) {
            PBXProjectFile.j(1);
        }
        if (pbxprojFile == null) {
            PBXProjectFile.j(2);
        }
        this(project2, projectRoot, pbxprojFile, null, null);
    }

    public PBXProjectFile(@NotNull Project project2, @NotNull VirtualFile projectRoot, @NotNull VirtualFile pbxprojFile, @Nullable PbxId initialId, @Nullable String projectName) {
        if (project2 == null) {
            PBXProjectFile.j(3);
        }
        if (projectRoot == null) {
            PBXProjectFile.j(4);
        }
        if (pbxprojFile == null) {
            PBXProjectFile.j(5);
        }
        this.myArchiveVersion = 1;
        this.myObjectVersion = 45;
        this.myRWAChecker = new RWAChecker();
        this.myCacheLock = new Object();
        this.myCache = new ReferencesCache();
        this.myBuildFilesFunction = pBXReference -> this.getBuildFilesFor((PBXReference)pBXReference);
        this.myDataHolder = new UserDataHolderBase();
        this.myProject = project2;
        this.myProjectRoot = projectRoot;
        this.myPBXProjFile = pbxprojFile;
        this.myObjects = this.createRWAObjectsMap();
        this.myUserFile = new PBXUserFile(this);
        this.myBuildSettingsProvider = new CachingBuildSettingsResolver(project2){

            @Override
            @NotNull
            protected PBXProjectFile getProjectFile() {
                PBXProjectFile pBXProjectFile = PBXProjectFile.this;
                if (pBXProjectFile == null) {
                    1.w(0);
                }
                return pBXProjectFile;
            }

            @Override
            protected PBXTarget getTarget() {
                return null;
            }

            @Override
            protected XCBuildConfiguration getBuildConfiguration() {
                return null;
            }

            @Override
            protected AppleSdk getSdk() {
                return null;
            }

            @Override
            @Nullable
            protected Set<ArchitectureValue> getArchitectures() {
                return null;
            }

            @Override
            protected boolean areSdkAndArchitectureOverridden() {
                return true;
            }

            private static /* synthetic */ void w(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/PBXProjectFile$1", "getProjectFile"));
            }
        };
        this.myCurrentIdInTests = initialId;
        this.myPredefinedProjectNameInTests = projectName;
    }

    @NotNull
    RWAMap<PbxId, PBXObject> createRWAObjectsMap() {
        return new RWAMap<PbxId, PBXObject>(PBXProjectFile.createObjectsMap(), this.myRWAChecker);
    }

    @NotNull
    public static LinkedHashMap<PbxId, PBXObject> createObjectsMap() {
        return new LinkedHashMap<PbxId, PBXObject>();
    }

    @NotNull
    RWASupport.Checker getRWAChecker() {
        RWAChecker rWAChecker = this.myRWAChecker;
        if (rWAChecker == null) {
            PBXProjectFile.j(6);
        }
        return rWAChecker;
    }

    @NonNls
    public String getXCodeURL() {
        return "x-xcodeproj:" + this.myPBXProjFile.getPath();
    }

    @Override
    public void load(@NotNull ProjectFilesChanges changes2) throws IOException {
        boolean bl;
        boolean bl2;
        if (changes2 == null) {
            PBXProjectFile.j(7);
        }
        boolean bl3 = bl2 = this.myProjectObject == null;
        if (!bl2) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        CharSequence charSequence = PBXProjectFile.loadFile(this.myPBXProjFile);
        List<Object> list = Collections.emptyList();
        boolean bl4 = bl = !bl2 && !changes2.areBuildSettingsChanged();
        if (bl) {
            list = this.j();
        }
        this.j(charSequence);
        this.myUserFile.load();
        this.finishLoading();
        if (bl) {
            boolean bl5 = list.equals(this.j());
            changes2.addBuildSettingsChange(!bl5);
        }
    }

    @NotNull
    public static CharSequence loadFile(VirtualFile file2) throws IOException {
        if (!file2.isValid() || file2.isDirectory()) {
            throw new IOException("File not found: " + file2);
        }
        byte @NotNull [] byArray = file2.getInputStream().readAllBytes();
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])byArray, (VirtualFile)file2);
        if (charSequence.length() == 0) {
            throw new IOException("Project file is empty: " + file2);
        }
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            PBXProjectFile.j(8);
        }
        return charSequence2;
    }

    @Override
    public void checkCompatibility() throws IncompatibleVersionException {
        String string = this.getProjectObject().getString("compatibilityVersion", "unknown");
        if (this.myArchiveVersion != 1 || this.myObjectVersion < 45) {
            throw new IncompatibleVersionException("Unsupported project format: '" + string + "' (archiveVersion = " + this.myArchiveVersion + ", objectVersion = " + this.myObjectVersion + ").\nOnly 'Xcode 3.2' or newer format is supported. Please convert it with Xcode.");
        }
    }

    @NotNull
    private List<Object> j() {
        Collection<XCBuildConfiguration> collection = this.getObjects(XCBuildConfiguration.class);
        HashMap<PbxId, List<Dictionary>> hashMap = new HashMap<PbxId, List<Dictionary>>(collection.size());
        for (XCBuildConfiguration xCBuildConfiguration : collection) {
            hashMap.put(xCBuildConfiguration.getId(), Arrays.asList(xCBuildConfiguration.getDeclaredBuildSettingValues(), xCBuildConfiguration.getXCConfigBuildSettingValuesProvider().getDeclaredBuildSettingValues()));
        }
        List<Object> list = Arrays.asList(this.getProjectObject().getUserBuildSettings(), hashMap);
        if (list == null) {
            PBXProjectFile.j(9);
        }
        return list;
    }

    @TestOnly
    public void parseInTests(@NotNull CharSequence text) throws IOException {
        if (text == null) {
            PBXProjectFile.j(10);
        }
        this.j(text);
        this.finishLoading();
    }

    private void j(@NotNull CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            PBXProjectFile.j(11);
        }
        LinkedHashMap<PbxId, PBXObject> linkedHashMap = PBXProjectFile.createObjectsMap();
        PBXDictionary pBXDictionary = PbxReader.readFile(false, charSequence, this, linkedHashMap);
        try {
            this.setArchiveVersion(Integer.parseInt(pBXDictionary.getAttribute("archiveVersion", String.class)));
            this.setObjectVersion(Integer.parseInt(pBXDictionary.getAttribute("objectVersion", String.class)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidSpecException(numberFormatException);
        }
        this.myObjects.clear();
        this.myObjects.putAll((Map<PbxId, PBXObject>)linkedHashMap);
        this.resetReferencesCache();
        this.setProjectObject(pBXDictionary.resolveNotNullAttribute("rootObject", PBXProject.class));
    }

    void finishLoading() {
        this.myBaseDir = this.j();
        this.w();
        this.myRWAChecker.resetModified();
        this.myUserFile.finishLoading();
    }

    private void w() {
        ArrayList<PBXBuildFile> arrayList = new ArrayList<PBXBuildFile>();
        for (PBXBuildFile pBXBuildFile : this.getObjects(PBXBuildFile.class)) {
            if (pBXBuildFile.getFileRefId() != null || this.j(pBXBuildFile)) continue;
            arrayList.add(pBXBuildFile);
        }
        this.removeObjects(arrayList);
    }

    private boolean j(@NotNull PBXBuildFile pBXBuildFile) {
        PbxId pbxId;
        if (pBXBuildFile == null) {
            PBXProjectFile.j(12);
        }
        return (pbxId = pBXBuildFile.getProductRefId()) != null && this.findById(pbxId) instanceof XCSwiftPackageProductDependency;
    }

    @Override
    public void lock() {
        this.myRWAChecker.lock();
        this.myUserFile.lock();
    }

    @NotNull
    private VirtualFile j() {
        String string = this.myProjectObject.getString("projectDirPath");
        if (string != null && !StringUtil.isEmptyOrSpaces((String)string)) {
            VirtualFile virtualFile2;
            if (!FileUtil.isAbsolute((String)string)) {
                string = new File(this.myProjectRoot.getPath(), string).getPath();
            }
            if ((virtualFile2 = StandardFileSystems.local().refreshAndFindFileByPath(string)) != null) {
                VirtualFile virtualFile3 = virtualFile2;
                if (virtualFile3 == null) {
                    PBXProjectFile.j(13);
                }
                return virtualFile3;
            }
        }
        VirtualFile virtualFile4 = this.myProjectRoot;
        if (virtualFile4 == null) {
            PBXProjectFile.j(14);
        }
        return virtualFile4;
    }

    @NotNull
    public PBXProjectFileManipulator getManipulator() {
        PBXProjectFileManipulator pBXProjectFileManipulator = this.getManipulator(true);
        if (pBXProjectFileManipulator == null) {
            PBXProjectFile.j(15);
        }
        return pBXProjectFileManipulator;
    }

    @NotNull
    public PBXProjectFileManipulator getManipulator(boolean fireNotificationsAutomatically) {
        return new PBXProjectFileManipulator(this, fireNotificationsAutomatically);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            PBXProjectFile.j(16);
        }
        return project2;
    }

    @NotNull
    public BuildSettingsProvider getBuildSettingsProvider() {
        BuildSettingsProvider buildSettingsProvider = this.myBuildSettingsProvider;
        if (buildSettingsProvider == null) {
            PBXProjectFile.j(17);
        }
        return buildSettingsProvider;
    }

    void setProjectObject(@NotNull PBXProject project2) {
        if (project2 == null) {
            PBXProjectFile.j(18);
        }
        this.myProjectObject = project2;
    }

    @NotNull
    public PBXProject getProjectObject() {
        PBXProject pBXProject = this.myProjectObject;
        if (pBXProject == null) {
            PBXProjectFile.j(19);
        }
        return pBXProject;
    }

    public int getArchiveVersion() {
        return this.myArchiveVersion;
    }

    void setArchiveVersion(int version) {
        this.myArchiveVersion = version;
    }

    public int getObjectVersion() {
        return this.myObjectVersion;
    }

    void setObjectVersion(int i2) {
        this.myObjectVersion = i2;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myPredefinedProjectNameInTests != null ? this.myPredefinedProjectNameInTests : this.getXcodeProjFile().getNameWithoutExtension();
        if (string == null) {
            PBXProjectFile.j(20);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getLoadableRootFile() {
        VirtualFile virtualFile2 = this.getXcodeProjFile();
        if (virtualFile2 == null) {
            PBXProjectFile.j(21);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile getLoadableDataFile() {
        VirtualFile virtualFile2 = this.getPBXProjFile();
        if (virtualFile2 == null) {
            PBXProjectFile.j(22);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getPBXProjFile() {
        VirtualFile virtualFile2 = this.myPBXProjFile;
        if (virtualFile2 == null) {
            PBXProjectFile.j(23);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getXcodeProjFile() {
        VirtualFile virtualFile2 = this.myPBXProjFile.getParent();
        if (virtualFile2 == null) {
            PBXProjectFile.j(24);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getBaseDir() {
        VirtualFile virtualFile2 = this.myBaseDir;
        if (virtualFile2 == null) {
            PBXProjectFile.j(25);
        }
        return virtualFile2;
    }

    @NotNull
    public String getXcodeProjFileName() {
        String string = this.getXcodeProjFile().getName();
        if (string == null) {
            PBXProjectFile.j(26);
        }
        return string;
    }

    @Override
    @NotNull
    public File getContainerBaseDir() {
        return new File(this.getBaseDir().getPath());
    }

    @Override
    @NotNull
    public File getUserDataDir() {
        File file2 = XCContainer.Helper.getUserDataDir(this.getXcodeProjFile());
        if (file2 == null) {
            PBXProjectFile.j(27);
        }
        return file2;
    }

    @Override
    @NotNull
    public File getSharedDataDir() {
        File file2 = XCContainer.Helper.getSharedDataDir(this.getXcodeProjFile());
        if (file2 == null) {
            PBXProjectFile.j(28);
        }
        return file2;
    }

    @NotNull
    public PBXUserFile getUserFile() {
        PBXUserFile pBXUserFile = this.myUserFile;
        if (pBXUserFile == null) {
            PBXProjectFile.j(29);
        }
        return pBXUserFile;
    }

    @NotNull
    public PbxId generateNextId() {
        if (this.myCurrentIdInTests != null && ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCurrentIdInTests = this.myCurrentIdInTests.nextUniqueId();
            if (this.myCurrentIdInTests == null) {
                PBXProjectFile.j(30);
            }
            return this.myCurrentIdInTests;
        }
        PbxId pbxId = PbxId.newUniqueId();
        if (pbxId == null) {
            PBXProjectFile.j(31);
        }
        return pbxId;
    }

    @TestOnly
    public void setCurrentIdInTests(@Nullable PbxId id) {
        this.myCurrentIdInTests = id;
    }

    @NotNull
    public Collection<PBXObject> getObjects() {
        Collection<PBXObject> collection = this.getObjects(null);
        if (collection == null) {
            PBXProjectFile.j(32);
        }
        return collection;
    }

    @NotNull
    public <T extends PBXObject> Collection<T> getObjects(@Nullable Class<T> klass) {
        if (klass == null) {
            Collection<PBXObject> collection = Collections.unmodifiableCollection(this.myObjects.values());
            if (collection == null) {
                PBXProjectFile.j(33);
            }
            return collection;
        }
        SmartList smartList = new SmartList();
        for (PBXObject pBXObject : this.myObjects.values()) {
            if (!klass.isInstance(pBXObject)) continue;
            smartList.add(pBXObject);
        }
        Collection collection = Collections.unmodifiableCollection(smartList);
        if (collection == null) {
            PBXProjectFile.j(34);
        }
        return collection;
    }

    @NotNull
    public <T extends PBXObject> Collection<T> getObjectsReferencing(@Nullable PbxId id, @Nullable Class<T> klass) {
        if (id == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PBXProjectFile.j(35);
            }
            return list;
        }
        SmartList smartList = new SmartList();
        for (PBXObject pBXObject : this.getObjects(klass)) {
            for (Object object : pBXObject.values()) {
                if (!(object instanceof ObjectReference) || !id.equals(((ObjectReference)object).getId())) continue;
                smartList.add(pBXObject);
            }
        }
        Collection collection = Collections.unmodifiableCollection(smartList);
        if (collection == null) {
            PBXProjectFile.j(36);
        }
        return collection;
    }

    @Nullable
    public PBXObject findById(@Nullable PbxId id) {
        return id == null ? null : this.myObjects.get(id);
    }

    public void regenerateIds(@Nullable PbxId fromId) {
        TreeSet<PbxId> treeSet = new TreeSet<PbxId>(PbxId.COMPARATOR);
        HashMap<PbxId, PbxId> hashMap = new HashMap<PbxId, PbxId>();
        treeSet.addAll(this.myObjects.keySet());
        PbxId pbxId2 = fromId == null ? PbxId.newUniqueId() : fromId;
        for (PbxId object : treeSet) {
            pbxId2 = pbxId2.nextUniqueId();
            PBXObject pBXObject = this.myObjects.remove(object);
            pBXObject.setId(pbxId2);
            this.myObjects.put(pbxId2, pBXObject);
            hashMap.put(object, pbxId2);
        }
        for (PBXObject pBXObject : this.myObjects.values()) {
            pBXObject.convertReferences(hashMap.keySet(), (Function<PbxId, PbxId>)((Function)pbxId -> (PbxId)hashMap.get(pbxId)));
        }
        this.resetReferencesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(@NotNull PBXObject object, @Nullable PBXGroup group) {
        PbxId pbxId;
        if (object == null) {
            PBXProjectFile.j(37);
        }
        this.myRWAChecker.checkWrite();
        if (object.getId() != PbxId.NONE) {
            throw new RuntimeException("Cannot add already added object:\n" + object.getDebugString());
        }
        while (this.myObjects.containsKey(pbxId = this.generateNextId())) {
        }
        object.setId(pbxId);
        this.myObjects.put(pbxId, object);
        Object object2 = this.myCacheLock;
        synchronized (object2) {
            if (object instanceof PBXReference) {
                PBXReference pBXReference = (PBXReference)object;
                if (group != null) {
                    group.appendChild(pBXReference.createReference());
                }
                if (pBXReference.isLinkedProject()) {
                    this.myCache.myDirectlyLinkedProjects = null;
                }
                if (this.myCache.myReferenceToParentGroupMap != null && group != null) {
                    this.myCache.myReferenceToParentGroupMap.put(pBXReference, group);
                }
                VirtualFile virtualFile2 = null;
                if (this.myCache.myFileCachesBuilt) {
                    virtualFile2 = pBXReference.refreshAndFindFile();
                }
                if (this.myCache.myFileCachesBuilt) {
                    PBXProjectFile.j(pBXReference, virtualFile2, this.myCache.myReferences, this.myCache.myFileReferences, this.myCache.myRemoteSwiftPackageReferences, this.myCache.myAllProjectFiles, this.myCache.myReferenceToCacheEntryMap, this.myCache.myPathToReferencesMap, this.myCache.myFileToReferencesMap, this.myCache.myFileNameToFileMap, this.myCache.myFileToAssociatedFilesMap, this.myCache.myFileToAssociatedRootMap, this.myCache.myFileRefTree);
                }
            }
            this.j(object);
        }
    }

    private void j(@NotNull PBXObject pBXObject) {
        if (pBXObject == null) {
            PBXProjectFile.j(38);
        }
        if (pBXObject instanceof PBXTarget) {
            this.myCache.myTargets = null;
            this.myCache.myConfigToTargetMap = null;
            this.myCache.myNameToTargetMap = null;
        } else if (pBXObject instanceof XCBuildConfiguration) {
            this.myCache.myConfigToTargetMap = null;
            this.myCache.myNameToTargetMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBuildFile(@NotNull PBXReference ref, @NotNull PBXBuildFile buildFile, @NotNull PBXTarget target, @NotNull PBXBuildPhase phase) {
        if (ref == null) {
            PBXProjectFile.j(39);
        }
        if (buildFile == null) {
            PBXProjectFile.j(40);
        }
        if (target == null) {
            PBXProjectFile.j(41);
        }
        if (phase == null) {
            PBXProjectFile.j(42);
        }
        Object object = this.myCacheLock;
        synchronized (object) {
            Pair pair2;
            List<Object> list;
            RWAMap<PbxId, List<PBXBuildFile>> rWAMap = this.myCache.myReferenceIdToBuildFilesMap;
            if (rWAMap != null) {
                list = rWAMap.get(ref.getId());
                if (list == null) {
                    list = new RWAList<PbxId>((List<PbxId>)new SmartList(), (RWASupport.Checker)this.myRWAChecker);
                    rWAMap.put(ref.getId(), (List<PBXBuildFile>)list);
                }
                list.add(buildFile);
            }
            if ((list = this.myCache.myReferenceIdToTargetsAndConfigsMap) != null) {
                pair2 = (Pair)((RWAMap)((Object)list)).remove(ref.getId());
                if (pair2 != null) {
                    HashSet hashSet = new HashSet((Collection)pair2.first);
                    for (PBXTarget pBXTarget : this.getTargets(null)) {
                        if (pBXTarget != target && !hashSet.contains(pBXTarget)) continue;
                        this.j(ref, pBXTarget, pBXTarget.getBuildConfigurations(), (Map<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>>)((Object)list), false);
                    }
                    ((RWAMap)((Object)list)).put(ref.getId(), this.j((Pair<List<PBXTarget>, List<XCBuildConfiguration>>)((Pair)((RWAMap)((Object)list)).get(ref.getId()))));
                } else {
                    this.j(ref, target, target.getBuildConfigurations(), (Map<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>>)((Object)list), true);
                }
            }
            if ((pair2 = this.myCache.myBuildFileToTargetAndPhase) != null) {
                pair2.put(buildFile, Pair.create((Object)target, (Object)phase));
            }
        }
    }

    void removeObjects(@NotNull Collection<? extends PBXObject> objects) {
        if (objects == null) {
            PBXProjectFile.j(43);
        }
        HashSet<PbxId> hashSet = new HashSet<PbxId>();
        this.j(objects, hashSet);
        Function function = pbxId -> null;
        for (PBXObject pBXObject : this.myObjects.values()) {
            pBXObject.convertReferences(hashSet, (Function<PbxId, PbxId>)function);
        }
    }

    private void j(Collection<? extends PBXObject> collection, Set<PbxId> set) {
        this.myRWAChecker.checkWrite();
        HashSet<PbxId> hashSet = new HashSet<PbxId>();
        for (PBXObject pBXObject : collection) {
            this.j(pBXObject.getId(), set, hashSet);
        }
        this.j((Set<PbxId>)hashSet, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j(@NotNull PbxId pbxId, @NotNull Set<PbxId> set, @NotNull Set<PbxId> set2) {
        PBXObject pBXObject;
        if (pbxId == null) {
            PBXProjectFile.j(44);
        }
        if (set == null) {
            PBXProjectFile.j(45);
        }
        if (set2 == null) {
            PBXProjectFile.j(46);
        }
        if ((pBXObject = this.j(pbxId, set)) == null) {
            return;
        }
        Object object = this.myCacheLock;
        synchronized (object) {
            if (pBXObject instanceof PBXReference) {
                PBXReference pBXReference = (PBXReference)pBXObject;
                set2.add(pbxId);
                if (pBXReference.isLinkedProject()) {
                    this.myCache.myDirectlyLinkedProjects = null;
                }
                this.j(pBXReference);
            } else if (pBXObject instanceof PBXBuildFile) {
                PBXBuildFile pBXBuildFile = (PBXBuildFile)pBXObject;
                if (this.myCache.myBuildFileCacheBuilt) {
                    PbxId pbxId2;
                    List<PBXBuildFile> list;
                    RWAMap<PbxId, List<PBXBuildFile>> rWAMap = this.myCache.myReferenceIdToBuildFilesMap;
                    RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> rWAMap2 = this.myCache.myReferenceIdToTargetsAndConfigsMap;
                    PBXTarget pBXTarget = null;
                    Pair<PBXTarget, PBXBuildPhase> pair2 = this.myCache.myBuildFileToTargetAndPhase.remove(pBXBuildFile);
                    if (pair2 != null) {
                        pBXTarget = (PBXTarget)pair2.first;
                    }
                    if ((list = rWAMap.get(pbxId2 = pBXBuildFile.getFileRefId())) != null) {
                        list.remove(pBXBuildFile);
                        if (list.isEmpty()) {
                            rWAMap.remove(pbxId2);
                        }
                    }
                    if (pBXTarget != null) {
                        Pair<List<PBXTarget>, List<XCBuildConfiguration>> pair3 = rWAMap2.get(pbxId2);
                        ((List)pair3.first).remove(pBXTarget);
                        if (((List)pair3.first).isEmpty()) {
                            rWAMap2.remove(pbxId2);
                        } else {
                            ((List)pair3.second).removeAll(pBXTarget.getBuildConfigurations());
                        }
                    }
                }
            }
            this.j(pBXObject);
        }
    }

    private PBXObject j(PbxId pbxId, Set<PbxId> set) {
        set.add(pbxId);
        return this.myObjects.remove(pbxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j(@NotNull Set<PbxId> set, @NotNull Set<PbxId> set2) {
        if (set == null) {
            PBXProjectFile.j(47);
        }
        if (set2 == null) {
            PBXProjectFile.j(48);
        }
        if (set.isEmpty()) {
            return;
        }
        Object object = this.myCacheLock;
        synchronized (object) {
            RWAMap<PbxId, List<PBXBuildFile>> rWAMap = this.myCache.myReferenceIdToBuildFilesMap;
            if (rWAMap != null) {
                RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> rWAMap2 = this.myCache.myReferenceIdToTargetsAndConfigsMap;
                RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> rWAMap3 = this.myCache.myBuildFileToTargetAndPhase;
                for (PbxId pbxId : set) {
                    rWAMap2.remove(pbxId);
                    List<PBXBuildFile> list = rWAMap.remove(pbxId);
                    if (list == null) continue;
                    for (PBXBuildFile pBXBuildFile : list) {
                        rWAMap3.remove(pBXBuildFile);
                        this.j(pBXBuildFile.getId(), set2);
                    }
                }
            } else {
                for (PBXBuildFile pBXBuildFile : this.getObjects(PBXBuildFile.class)) {
                    if (!set.contains(pBXBuildFile.getFileRefId())) continue;
                    this.j(pBXBuildFile.getId(), set2);
                }
            }
        }
    }

    public Collection<VirtualFile> getFiles() {
        this.N();
        return Collections.unmodifiableCollection(this.myCache.myAllProjectFiles.keySet());
    }

    public Collection<PBXReference> getAllReferences() {
        this.N();
        return Collections.unmodifiableCollection(this.myCache.myReferences);
    }

    public Collection<PBXFileReference> getFileReferences() {
        this.N();
        return Collections.unmodifiableCollection(this.myCache.myFileReferences);
    }

    public Collection<XCRemoteSwiftPackageReference> getRemoteSwiftPackageReferences() {
        this.N();
        RWASet<XCRemoteSwiftPackageReference> rWASet = this.myCache.myRemoteSwiftPackageReferences;
        return rWASet != null ? Collections.unmodifiableCollection(rWASet) : Collections.emptyList();
    }

    public Collection<VirtualFile> getAssociatedFileRoots() {
        this.N();
        return Collections.unmodifiableCollection(this.myCache.myFileToAssociatedRootMap.keySet());
    }

    public FileRefTree getFileRefTree() {
        this.N();
        return this.myCache.myFileRefTree;
    }

    public boolean containsFile(@Nullable VirtualFile file2) {
        return file2 != null && this.getFiles().contains(file2);
    }

    @NotNull
    public List<VirtualFile> findFilesByName(@Nullable String name) {
        List<VirtualFile> list = name == null ? null : this.t().get(name);
        List<Object> list2 = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            PBXProjectFile.j(49);
        }
        return list2;
    }

    @NotNull
    public List<PBXReference> findReferences(@Nullable Path path) {
        List<PBXReference> list = path == null ? null : this.v().get(path);
        List<Object> list2 = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            PBXProjectFile.j(50);
        }
        return list2;
    }

    @NotNull
    public List<PBXReference> findReferences(@Nullable VirtualFile file2) {
        List<PBXReference> list = file2 == null ? null : this.j().get(file2);
        List<Object> list2 = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            PBXProjectFile.j(51);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T extends PBXTarget> List<T> getTargets(@Nullable Class<T> clazz) {
        List<PBXTarget> list = this.myCache.myTargets;
        if (list == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (this.myCache.myTargets == null) {
                    this.myCache.myTargets = Collections.unmodifiableList(this.getProjectObject().getTargets());
                }
                list = this.myCache.myTargets;
            }
        }
        return PBXProjectFile.selectTargets(list, clazz);
    }

    @NotNull
    public <T extends PBXTarget> List<T> getTargetsFor(@Nullable VirtualFile file2, @Nullable Class<T> targetClass, boolean effectiveValues) {
        List list = ContainerUtil.flatMap(this.findReferences(file2), pBXReference -> this.getTargetsFor(effectiveValues ? PBXReference.effectiveTargetMember(pBXReference) : pBXReference, targetClass));
        if (list == null) {
            PBXProjectFile.j(52);
        }
        return list;
    }

    @NotNull
    public <T extends PBXTarget> List<T> getTargetsFor(@Nullable PBXReference ref, @Nullable Class<T> targetClass) {
        Pair<List<PBXTarget>, List<XCBuildConfiguration>> pair2;
        Pair<List<PBXTarget>, List<XCBuildConfiguration>> pair3 = pair2 = ref == null ? null : this.N().get(ref.getId());
        if (pair2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PBXProjectFile.j(53);
            }
            return list;
        }
        return PBXProjectFile.selectTargets((List)pair2.first, targetClass);
    }

    @NotNull
    static <T extends PBXTarget> List<T> selectTargets(@NotNull List<PBXTarget> all, @Nullable Class<T> clazz) {
        if (all == null) {
            PBXProjectFile.j(54);
        }
        if (clazz == null) {
            List<PBXTarget> list = all;
            if (list == null) {
                PBXProjectFile.j(55);
            }
            return list;
        }
        SmartList smartList = new SmartList();
        for (PBXTarget pBXTarget : all) {
            if (!clazz.isInstance(pBXTarget)) continue;
            smartList.add(pBXTarget);
        }
        List list = Collections.unmodifiableList(smartList);
        if (list == null) {
            PBXProjectFile.j(56);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends PBXTarget> T findTarget(@Nullable String name, @Nullable Class<T> clazz) {
        Object object;
        if (name == null) {
            return null;
        }
        MostlySingularMultiMap mostlySingularMultiMap = this.myCache.myNameToTargetMap;
        if (mostlySingularMultiMap == null) {
            object = this.myCacheLock;
            synchronized (object) {
                mostlySingularMultiMap = this.myCache.myNameToTargetMap;
                if (mostlySingularMultiMap == null) {
                    mostlySingularMultiMap = new MostlySingularMultiMap();
                    for (PBXTarget pBXTarget : this.getTargets(null)) {
                        mostlySingularMultiMap.add((Object)pBXTarget.getName(), (Object)pBXTarget);
                    }
                    this.myCache.myNameToTargetMap = mostlySingularMultiMap;
                }
            }
        }
        object = mostlySingularMultiMap.get((Object)name);
        return (T)(clazz == null ? (PBXTarget)CollectionsKt.firstOrNull((Iterable)object) : (PBXTarget)ContainerUtil.findInstance((Iterable)object, clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PBXTarget> findTargetsFor(@Nullable XCBuildConfiguration config) {
        MostlySingularMultiMap mostlySingularMultiMap = this.myCache.myConfigToTargetMap;
        if (mostlySingularMultiMap == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                mostlySingularMultiMap = this.myCache.myConfigToTargetMap;
                if (mostlySingularMultiMap == null) {
                    mostlySingularMultiMap = new MostlySingularMultiMap();
                    for (PBXTarget pBXTarget : this.getTargets(null)) {
                        for (XCBuildConfiguration xCBuildConfiguration : pBXTarget.getBuildConfigurations()) {
                            mostlySingularMultiMap.add((Object)xCBuildConfiguration, (Object)pBXTarget);
                        }
                    }
                    this.myCache.myConfigToTargetMap = mostlySingularMultiMap;
                }
            }
        }
        List list = (List)mostlySingularMultiMap.get((Object)config);
        if (list == null) {
            PBXProjectFile.j(57);
        }
        return list;
    }

    @Nullable
    public PBXNativeTarget findTargetForProduct(@NotNull PBXReference productFileRef, @Nullable BuildSettingsProvider settingsProvider) {
        if (productFileRef == null) {
            PBXProjectFile.j(58);
        }
        return (PBXNativeTarget)ContainerUtil.find(this.getTargets(PBXNativeTarget.class), pBXNativeTarget -> {
            PBXFileReference pBXFileReference = pBXNativeTarget.getProductReference();
            if (pBXFileReference == null) {
                return false;
            }
            if (productFileRef.equals(pBXFileReference)) {
                return true;
            }
            VirtualFile virtualFile2 = productFileRef.findFile(settingsProvider);
            if (virtualFile2 != null && virtualFile2.equals(pBXFileReference.findFile(settingsProvider))) {
                return true;
            }
            String string = productFileRef.resolvePath(settingsProvider);
            return string != null && FileUtil.pathsEqual((String)string, (String)pBXFileReference.resolvePath(settingsProvider));
        });
    }

    @NotNull
    public List<PBXBuildFile> getBuildFilesFor(@Nullable VirtualFile file2) {
        List list = ContainerUtil.flatMap(this.findReferences(file2), this.myBuildFilesFunction);
        if (list == null) {
            PBXProjectFile.j(59);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> getBuildFilesFor(@Nullable PBXReference ref) {
        List<PBXBuildFile> list = ref == null ? null : this.N().get(ref.getId());
        List<Object> list2 = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            PBXProjectFile.j(60);
        }
        return list2;
    }

    @Nullable
    public Collection<AppleFileType> getTargetSourceFileTypes(@Nullable PBXTarget target) {
        return target == null ? null : this.w().get(target);
    }

    @Nullable
    public Pair<PBXTarget, PBXBuildPhase> getTargetAndPhase(@Nullable PBXBuildFile buildFile) {
        return buildFile == null ? null : this.s().get(buildFile);
    }

    @NotNull
    private RWAMap<Path, List<PBXReference>> v() {
        this.N();
        RWAMap<Path, List<PBXReference>> rWAMap = this.myCache.myPathToReferencesMap;
        if (rWAMap == null) {
            PBXProjectFile.j(61);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<VirtualFile, List<PBXReference>> j() {
        this.N();
        RWAMap<VirtualFile, List<PBXReference>> rWAMap = this.myCache.myFileToReferencesMap;
        if (rWAMap == null) {
            PBXProjectFile.j(62);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<String, List<VirtualFile>> t() {
        this.N();
        RWAMap<String, List<VirtualFile>> rWAMap = this.myCache.myFileNameToFileMap;
        if (rWAMap == null) {
            PBXProjectFile.j(63);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void N() {
        this.myRWAChecker.checkRead();
        if (!this.myCache.myFileCachesBuilt) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (!this.myCache.myFileCachesBuilt) {
                    HashSet<PBXReference> hashSet = new HashSet<PBXReference>();
                    HashSet<PBXFileReference> hashSet2 = new HashSet<PBXFileReference>();
                    HashSet<XCRemoteSwiftPackageReference> hashSet3 = new HashSet<XCRemoteSwiftPackageReference>();
                    HashMap<PBXReference, ReferenceCacheEntry> hashMap = new HashMap<PBXReference, ReferenceCacheEntry>();
                    HashMap<Path, List<PBXReference>> hashMap2 = new HashMap<Path, List<PBXReference>>();
                    HashMap<VirtualFile, List<PBXReference>> hashMap3 = new HashMap<VirtualFile, List<PBXReference>>();
                    HashMap<String, List<VirtualFile>> hashMap4 = new HashMap<String, List<VirtualFile>>();
                    LinkedHashMap<VirtualFile, Integer> linkedHashMap = new LinkedHashMap<VirtualFile, Integer>();
                    HashMap<VirtualFile, Collection<VirtualFile>> hashMap5 = new HashMap<VirtualFile, Collection<VirtualFile>>();
                    HashMap<VirtualFile, List<PBXReference>> hashMap6 = new HashMap<VirtualFile, List<PBXReference>>();
                    FileRefTree fileRefTree = new FileRefTree();
                    for (PBXReference pBXReference : this.getObjects(PBXReference.class)) {
                        VirtualFile virtualFile2 = pBXReference.findFile();
                        PBXProjectFile.j(pBXReference, virtualFile2, hashSet, hashSet2, hashSet3, linkedHashMap, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, hashMap6, fileRefTree);
                    }
                    this.myCache.myAllProjectFiles = new RWAMap(linkedHashMap, this.myRWAChecker);
                    this.myCache.myReferences = new RWASet(hashSet, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myReferenceToCacheEntryMap = new RWAMap<PBXReference, ReferenceCacheEntry>(hashMap, this.myRWAChecker);
                    this.myCache.myFileReferences = new RWASet<PBXFileReference>((Set<PBXFileReference>)hashSet2, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myRemoteSwiftPackageReferences = new RWASet<XCRemoteSwiftPackageReference>((Set<XCRemoteSwiftPackageReference>)hashSet3, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myPathToReferencesMap = new RWAMap<Path, List<PBXReference>>(hashMap2, this.myRWAChecker);
                    this.myCache.myFileToReferencesMap = new RWAMap<VirtualFile, List<PBXReference>>(hashMap3, this.myRWAChecker);
                    this.myCache.myFileNameToFileMap = new RWAMap<String, List<VirtualFile>>(hashMap4, this.myRWAChecker);
                    this.myCache.myFileToAssociatedFilesMap = new RWAMap<VirtualFile, Collection<VirtualFile>>(hashMap5, this.myRWAChecker);
                    this.myCache.myFileToAssociatedRootMap = new RWAMap<VirtualFile, List<PBXReference>>(hashMap6, this.myRWAChecker);
                    this.myCache.myFileRefTree = fileRefTree;
                    this.myCache.myFileCachesBuilt = true;
                }
            }
        }
    }

    private static void j(@NotNull PBXReference pBXReference, @Nullable VirtualFile virtualFile2, @NotNull Set<PBXReference> set, @NotNull Set<PBXFileReference> set2, @NotNull Set<XCRemoteSwiftPackageReference> set3, @NotNull Map<VirtualFile, Integer> map, @NotNull Map<PBXReference, ReferenceCacheEntry> map2, @NotNull Map<Path, List<PBXReference>> map3, @NotNull Map<VirtualFile, List<PBXReference>> map4, @NotNull Map<String, List<VirtualFile>> map5, @NotNull Map<VirtualFile, Collection<VirtualFile>> map6, @NotNull Map<VirtualFile, List<PBXReference>> map7, @NotNull FileRefTree fileRefTree) {
        String string;
        if (pBXReference == null) {
            PBXProjectFile.j(64);
        }
        if (set == null) {
            PBXProjectFile.j(65);
        }
        if (set2 == null) {
            PBXProjectFile.j(66);
        }
        if (set3 == null) {
            PBXProjectFile.j(67);
        }
        if (map == null) {
            PBXProjectFile.j(68);
        }
        if (map2 == null) {
            PBXProjectFile.j(69);
        }
        if (map3 == null) {
            PBXProjectFile.j(70);
        }
        if (map4 == null) {
            PBXProjectFile.j(71);
        }
        if (map5 == null) {
            PBXProjectFile.j(72);
        }
        if (map6 == null) {
            PBXProjectFile.j(73);
        }
        if (map7 == null) {
            PBXProjectFile.j(74);
        }
        if (fileRefTree == null) {
            PBXProjectFile.j(75);
        }
        set.add(pBXReference);
        if (pBXReference instanceof PBXFileReference) {
            set2.add((PBXFileReference)pBXReference);
        }
        if (pBXReference instanceof XCRemoteSwiftPackageReference) {
            set3.add((XCRemoteSwiftPackageReference)pBXReference);
        }
        if (virtualFile2 != null) {
            PBXProjectFile.j(map5, virtualFile2);
            PBXProjectFile.j(map3, pBXReference, virtualFile2);
            PBXProjectFile.j(map4, map, pBXReference, virtualFile2);
            PBXProjectFile.j(pBXReference, virtualFile2, map, map7, map6, fileRefTree);
        }
        String string2 = string = virtualFile2 == null ? pBXReference.resolvePath() : virtualFile2.getPath();
        if (string != null) {
            fileRefTree.addReference(string, pBXReference);
        }
        map2.put(pBXReference, new ReferenceCacheEntry(virtualFile2, string));
    }

    private void j(@NotNull PBXReference pBXReference) {
        if (pBXReference == null) {
            PBXProjectFile.j(76);
        }
        if (this.myCache.myFileCachesBuilt) {
            VirtualFile virtualFile2;
            @NotNull RWAMap<String, List<VirtualFile>> rWAMap = this.myCache.myFileNameToFileMap;
            @NotNull RWAMap<VirtualFile, Integer> rWAMap2 = this.myCache.myAllProjectFiles;
            @NotNull RWAMap<VirtualFile, Collection<VirtualFile>> rWAMap3 = this.myCache.myFileToAssociatedFilesMap;
            @NotNull RWAMap<PBXReference, ReferenceCacheEntry> rWAMap4 = this.myCache.myReferenceToCacheEntryMap;
            @NotNull FileRefTree fileRefTree = this.myCache.myFileRefTree;
            ReferenceCacheEntry referenceCacheEntry = rWAMap4.get(pBXReference);
            String string = referenceCacheEntry == null ? null : referenceCacheEntry.path;
            VirtualFile virtualFile3 = virtualFile2 = referenceCacheEntry == null ? null : referenceCacheEntry.file;
            if (pBXReference instanceof PBXFileReference) {
                this.myCache.myFileReferences.remove(pBXReference);
            }
            this.myCache.myReferences.remove(pBXReference);
            if (virtualFile2 != null) {
                PBXProjectFile.j(this.myCache.myFileToReferencesMap, virtualFile2, pBXReference);
                PBXProjectFile.N(rWAMap2, virtualFile2);
                PBXProjectFile.N(rWAMap, virtualFile2);
                PBXProjectFile.N(pBXReference, virtualFile2, rWAMap2, this.myCache.myFileToAssociatedRootMap, rWAMap3, fileRefTree);
            }
            if (string != null) {
                fileRefTree.removeReference(string, pBXReference);
            }
            rWAMap4.remove(pBXReference);
        }
        if (this.myCache.myReferenceToParentGroupMap != null) {
            this.myCache.myReferenceToParentGroupMap.remove(pBXReference);
        }
    }

    private static void j(@NotNull PBXReference pBXReference, final @NotNull VirtualFile virtualFile2, final @NotNull Map<VirtualFile, Integer> map, @NotNull Map<VirtualFile, List<PBXReference>> map2, @NotNull Map<VirtualFile, Collection<VirtualFile>> map3, final @NotNull FileRefTree fileRefTree) {
        if (pBXReference == null) {
            PBXProjectFile.j(77);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(78);
        }
        if (map == null) {
            PBXProjectFile.j(79);
        }
        if (map2 == null) {
            PBXProjectFile.j(80);
        }
        if (map3 == null) {
            PBXProjectFile.j(81);
        }
        if (fileRefTree == null) {
            PBXProjectFile.j(82);
        }
        if (!PBXProjectFile.N(pBXReference, virtualFile2)) {
            return;
        }
        List<PBXReference> list = map2.get(virtualFile2);
        boolean bl = list == null || list.isEmpty();
        PBXProjectFile.j(map2, virtualFile2, pBXReference);
        if (bl) {
            final ArrayList arrayList = new ArrayList();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile f2) {
                    if (f2 == null) {
                        2.j(0);
                    }
                    if (!virtualFile2.equals(f2) && !map.containsKey(f2)) {
                        String string = f2.getPath();
                        fileRefTree.incAssociatedFiles(string);
                        PBXProjectFile.j(map, f2);
                        arrayList.add(f2);
                    }
                    VirtualFileVisitor.Result result2 = CONTINUE;
                    if (result2 == null) {
                        2.j(1);
                    }
                    return result2;
                }

                private static /* synthetic */ void j(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n2) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "f";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$2";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n2) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            arrayList.trimToSize();
            map3.put(virtualFile2, arrayList);
        }
    }

    private static void N(@NotNull PBXReference pBXReference, @NotNull VirtualFile virtualFile2, @NotNull Map<VirtualFile, Integer> map, @NotNull Map<VirtualFile, List<PBXReference>> map2, @NotNull Map<VirtualFile, Collection<VirtualFile>> map3, @NotNull FileRefTree fileRefTree) {
        if (pBXReference == null) {
            PBXProjectFile.j(83);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(84);
        }
        if (map == null) {
            PBXProjectFile.j(85);
        }
        if (map2 == null) {
            PBXProjectFile.j(86);
        }
        if (map3 == null) {
            PBXProjectFile.j(87);
        }
        if (fileRefTree == null) {
            PBXProjectFile.j(88);
        }
        if (PBXProjectFile.j(map2, virtualFile2, pBXReference) == 0) {
            Collection<VirtualFile> collection = map3.get(virtualFile2);
            if (collection != null) {
                for (VirtualFile virtualFile3 : collection) {
                    PBXProjectFile.N(map, virtualFile3);
                    String string = virtualFile3.getPath();
                    fileRefTree.decAssociatedFiles(string);
                }
            }
            map3.remove(virtualFile2);
        }
    }

    private static void j(@NotNull Map<String, List<VirtualFile>> map, @NotNull VirtualFile virtualFile2) {
        if (map == null) {
            PBXProjectFile.j(89);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(90);
        }
        PBXProjectFile.j(map, virtualFile2.getName(), virtualFile2);
    }

    private static void N(@NotNull Map<String, List<VirtualFile>> map, @NotNull VirtualFile virtualFile2) {
        if (map == null) {
            PBXProjectFile.j(91);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(92);
        }
        PBXProjectFile.j(map, virtualFile2.getName(), virtualFile2);
    }

    private static <T> void j(@NotNull Map<T, Integer> map, @NotNull T t10) {
        Integer n2;
        if (map == null) {
            PBXProjectFile.j(93);
        }
        if (t10 == null) {
            PBXProjectFile.j(94);
        }
        map.put(t10, ((n2 = map.get(t10)) == null ? 0 : n2) + 1);
    }

    private static <T> void N(@NotNull Map<T, Integer> map, @NotNull T t10) {
        Integer n2;
        if (map == null) {
            PBXProjectFile.j(95);
        }
        if (t10 == null) {
            PBXProjectFile.j(96);
        }
        if ((n2 = map.get(t10)) == null) {
            return;
        }
        if (n2 <= 1) {
            map.remove(t10);
        } else {
            map.put(t10, n2 - 1);
        }
    }

    private static <K, V> void j(@NotNull Map<K, List<V>> map, @NotNull K k2, @NotNull V v10) {
        SmartList smartList;
        if (map == null) {
            PBXProjectFile.j(97);
        }
        if (k2 == null) {
            PBXProjectFile.j(98);
        }
        if (v10 == null) {
            PBXProjectFile.j(99);
        }
        if ((smartList = map.get(k2)) == null) {
            smartList = new SmartList();
            map.put(k2, (List<SmartList>)smartList);
        }
        smartList.add(v10);
    }

    private static <K, V> int j(@NotNull Map<K, List<V>> map, @NotNull K k2, @NotNull V v10) {
        List<V> list;
        if (map == null) {
            PBXProjectFile.j(100);
        }
        if (k2 == null) {
            PBXProjectFile.j(101);
        }
        if (v10 == null) {
            PBXProjectFile.j(102);
        }
        if ((list = map.get(k2)) == null) {
            return 0;
        }
        list.remove(v10);
        if (list.isEmpty()) {
            map.remove(k2);
            return 0;
        }
        return list.size();
    }

    private static void j(@NotNull Map<Path, List<PBXReference>> map, @NotNull PBXReference pBXReference, @NotNull VirtualFile virtualFile2) {
        if (map == null) {
            PBXProjectFile.j(103);
        }
        if (pBXReference == null) {
            PBXProjectFile.j(104);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(105);
        }
        PBXProjectFile.j(map, virtualFile2.toNioPath(), pBXReference);
    }

    private static void j(@NotNull Map<VirtualFile, List<PBXReference>> map, @NotNull Map<VirtualFile, Integer> map2, @NotNull PBXReference pBXReference, @NotNull VirtualFile virtualFile2) {
        if (map == null) {
            PBXProjectFile.j(106);
        }
        if (map2 == null) {
            PBXProjectFile.j(107);
        }
        if (pBXReference == null) {
            PBXProjectFile.j(108);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(109);
        }
        PBXProjectFile.j(map, virtualFile2, pBXReference);
        PBXProjectFile.j(map2, virtualFile2);
    }

    private static boolean N(@NotNull PBXReference pBXReference, @NotNull VirtualFile virtualFile2) {
        if (pBXReference == null) {
            PBXProjectFile.j(110);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(111);
        }
        return PBXProjectFile.j(pBXReference, virtualFile2) || pBXReference.isDirectoryRef() || pBXReference.isAssetCatalog();
    }

    private static boolean j(@NotNull PBXReference pBXReference, @NotNull VirtualFile virtualFile2) {
        if (pBXReference == null) {
            PBXProjectFile.j(112);
        }
        if (virtualFile2 == null) {
            PBXProjectFile.j(113);
        }
        return pBXReference instanceof PBXFileReference && virtualFile2.isDirectory() && "xcdatamodel".equals(virtualFile2.getExtension());
    }

    @NotNull
    private RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> N() {
        this.j();
        RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> rWAMap = this.myCache.myReferenceIdToTargetsAndConfigsMap;
        if (rWAMap == null) {
            PBXProjectFile.j(114);
        }
        return rWAMap;
    }

    @NotNull
    private Map<PbxId, List<PBXBuildFile>> N() {
        this.j();
        RWAMap<PbxId, List<PBXBuildFile>> rWAMap = this.myCache.myReferenceIdToBuildFilesMap;
        if (rWAMap == null) {
            PBXProjectFile.j(115);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> s() {
        this.j();
        RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> rWAMap = this.myCache.myBuildFileToTargetAndPhase;
        if (rWAMap == null) {
            PBXProjectFile.j(116);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<PBXTarget, Collection<AppleFileType>> w() {
        this.j();
        RWAMap<PBXTarget, Collection<AppleFileType>> rWAMap = this.myCache.myTargetToSourceFileTypesMap;
        if (rWAMap == null) {
            PBXProjectFile.j(117);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j() {
        this.myRWAChecker.checkRead();
        if (!this.myCache.myBuildFileCacheBuilt) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (!this.myCache.myBuildFileCacheBuilt) {
                    Map<String, Object> map;
                    MultiMap multiMap = new MultiMap();
                    for (PBXBuildFile map22 : this.getObjects(PBXBuildFile.class)) {
                        map = map22.getFileRef();
                        if (map == null) continue;
                        multiMap.putValue((Object)map, (Object)map22);
                    }
                    HashMap hashMap = new HashMap();
                    HashMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> hashMap2 = new HashMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>>();
                    map = new HashMap();
                    for (Iterator iterator : multiMap.keySet()) {
                        hashMap.put(((PBXObject)((Object)iterator)).getId(), new RWAList(new ArrayList(multiMap.get((Object)iterator)), (RWASupport.Checker)this.myRWAChecker));
                    }
                    HashMap hashMap3 = new HashMap();
                    for (PBXTarget pBXTarget : this.getTargets(null)) {
                        List<XCBuildConfiguration> list = pBXTarget.getBuildConfigurations();
                        for (PBXBuildPhase pBXBuildPhase : pBXTarget.getBuildPhases()) {
                            for (PBXBuildFile pBXBuildFile : pBXBuildPhase.getFiles()) {
                                PBXReference pBXReference = pBXBuildFile.getFileRef();
                                if (pBXReference != null) {
                                    this.j(pBXReference, pBXTarget, list, hashMap2, false);
                                }
                                hashMap3.put(pBXBuildFile, Pair.create((Object)pBXTarget, (Object)pBXBuildPhase));
                            }
                        }
                        map.put((String)((Object)pBXTarget), PBXProjectFile.j(pBXTarget));
                    }
                    for (Map.Entry entry2 : hashMap2.entrySet()) {
                        entry2.setValue(this.j((Pair<List<PBXTarget>, List<XCBuildConfiguration>>)((Pair)entry2.getValue())));
                    }
                    this.myCache.myReferenceIdToBuildFilesMap = new RWAMap(hashMap, this.myRWAChecker);
                    this.myCache.myReferenceIdToTargetsAndConfigsMap = new RWAMap(hashMap2, this.myRWAChecker);
                    this.myCache.myBuildFileToTargetAndPhase = new RWAMap(hashMap3, this.myRWAChecker);
                    this.myCache.myTargetToSourceFileTypesMap = new RWAMap<String, Object>(map, this.myRWAChecker);
                    this.myCache.myBuildFileCacheBuilt = true;
                }
            }
        }
    }

    @NotNull
    private static Set<AppleFileType> j(@NotNull PBXTarget pBXTarget) {
        if (pBXTarget == null) {
            PBXProjectFile.j(118);
        }
        Set set = ContainerUtil.map2SetNotNull(pBXTarget.getSources(), pBXReference -> AppleFileTypeManager.getInstance().findFileTypeByFilename(pBXReference.getFileName()));
        if (set == null) {
            PBXProjectFile.j(119);
        }
        return set;
    }

    private void j(@NotNull PBXReference pBXReference, @NotNull PBXTarget pBXTarget, @NotNull List<XCBuildConfiguration> list, @NotNull Map<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> map, boolean bl) {
        Pair pair2;
        if (pBXReference == null) {
            PBXProjectFile.j(120);
        }
        if (pBXTarget == null) {
            PBXProjectFile.j(121);
        }
        if (list == null) {
            PBXProjectFile.j(122);
        }
        if (map == null) {
            PBXProjectFile.j(123);
        }
        if ((pair2 = map.get(pBXReference.getId())) == null) {
            Object object = new SmartList();
            List list2 = new ArrayList(list.size());
            if (bl) {
                object = new RWAList(object, (RWASupport.Checker)this.myRWAChecker);
                list2 = new RWAList(list2, (RWASupport.Checker)this.myRWAChecker);
            }
            pair2 = Pair.create((Object)object, list2);
            map.put(pBXReference.getId(), (Pair<List<PBXTarget>, List<XCBuildConfiguration>>)pair2);
        }
        ((List)pair2.first).add(pBXTarget);
        ((List)pair2.second).addAll(list);
    }

    private Pair<List<PBXTarget>, List<XCBuildConfiguration>> j(Pair<List<PBXTarget>, List<XCBuildConfiguration>> pair2) {
        return new Pair(new RWAList((List)pair2.first, (RWASupport.Checker)this.myRWAChecker), new RWAList((List)pair2.second, (RWASupport.Checker)this.myRWAChecker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    @NotNull
    public List<PBXProjectFile> getDirectlyLinkedProjects() {
        this.myRWAChecker.checkRead();
        Object object = this.myCacheLock;
        // MONITORENTER : object
        ImmutableList immutableList2 = this.myCache.myDirectlyLinkedProjects;
        ImmutableList immutableList = immutableList2 != null ? immutableList2 : (this.myCache.myDirectlyLinkedProjects = ImmutableList.copyOf(this.j()));
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        PBXProjectFile.j(124);
        return immutableList;
    }

    @NotNull
    private Set<PBXProjectFile> j() {
        CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.getProject());
        if (coreXcodeWorkspace == null) {
            Set<PBXProjectFile> set = Collections.emptySet();
            if (set == null) {
                PBXProjectFile.j(125);
            }
            return set;
        }
        LinkedHashSet<PBXProjectFile> linkedHashSet = new LinkedHashSet<PBXProjectFile>();
        for (Pair<VirtualFile, String> pair2 : this.getDirectlyLinkedProjectFilesWithPaths()) {
            ContainerUtil.addIfNotNull(linkedHashSet, (Object)coreXcodeWorkspace.findProject((VirtualFile)pair2.first));
        }
        LinkedHashSet<PBXProjectFile> linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            PBXProjectFile.j(126);
        }
        return linkedHashSet2;
    }

    @NotNull
    public List<Pair<VirtualFile, String>> getDirectlyLinkedProjectFilesWithPaths() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (PBXReference pBXReference : this.getObjects(PBXFileReference.class)) {
            VirtualFile virtualFile2;
            String string;
            if (!pBXReference.isLinkedProject() || (string = (virtualFile2 = pBXReference.findFile(this.getBuildSettingsProvider())) != null ? virtualFile2.getPath() : pBXReference.resolvePath(this.getBuildSettingsProvider())) == null) continue;
            ContainerUtil.addIfNotNull(linkedHashSet, (Object)Pair.create((Object)virtualFile2, (Object)string));
        }
        List<Pair<VirtualFile, String>> list = Collections.unmodifiableList(new SmartList(linkedHashSet));
        if (list == null) {
            PBXProjectFile.j(127);
        }
        return list;
    }

    @Nullable
    public PBXGroup findGroupByName(@Nullable @NonNls String name) {
        return PBXProjectFile.N(name, this.getProjectObject().getMainGroup());
    }

    @Nullable
    private static PBXGroup N(@Nullable String string, @Nullable PBXGroup pBXGroup) {
        if (string == null || pBXGroup == null) {
            return null;
        }
        if (string.equals(pBXGroup.getDisplayName())) {
            return pBXGroup;
        }
        for (PBXReference pBXReference : pBXGroup.getChildren()) {
            PBXGroup pBXGroup2;
            if (!(pBXReference instanceof PBXGroup) || (pBXGroup2 = PBXProjectFile.N(string, (PBXGroup)pBXReference)) == null) continue;
            return pBXGroup2;
        }
        return null;
    }

    @Nullable
    public PBXGroup findGroupByPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        File file2 = new File(path);
        File file3 = new File(this.getBaseDir().getPath());
        do {
            PBXGroup pBXGroup;
            if ((pBXGroup = PBXProjectFile.j(file2.getPath(), this.getProjectObject().getMainGroup())) == null) continue;
            return pBXGroup;
        } while ((file2 = file2.getParentFile()) != null && VfsUtilCore.isAncestor((File)file3, (File)file2, (boolean)true));
        return null;
    }

    @Nullable
    private static PBXGroup j(@Nullable String string, @Nullable PBXGroup pBXGroup) {
        Object object;
        if (string == null || pBXGroup == null) {
            return null;
        }
        if (pBXGroup.isPhysical() && (object = pBXGroup.resolvePath()) != null && FileUtil.pathsEqual((String)object, (String)string)) {
            return pBXGroup;
        }
        for (PBXReference pBXReference : pBXGroup.getChildren()) {
            PBXGroup pBXGroup2;
            if (!(pBXReference instanceof PBXGroup) || (pBXGroup2 = PBXProjectFile.j(string, (PBXGroup)pBXReference)) == null) continue;
            return pBXGroup2;
        }
        return null;
    }

    @Nullable
    PBXGroup resolveParentObject(@Nullable PBXReference object) {
        return object == null ? null : this.j().get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<PBXReference, PBXGroup> j() {
        this.myRWAChecker.checkRead();
        if (this.myCache.myReferenceToParentGroupMap == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (this.myCache.myReferenceToParentGroupMap == null) {
                    HashMap<PBXReference, PBXGroup> hashMap = new HashMap<PBXReference, PBXGroup>();
                    for (PBXGroup pBXGroup : this.getObjects(PBXGroup.class)) {
                        for (PBXReference pBXReference : pBXGroup.getChildren()) {
                            hashMap.put(pBXReference, pBXGroup);
                        }
                    }
                    this.myCache.myReferenceToParentGroupMap = new RWAMap(hashMap, this.myRWAChecker);
                }
            }
        }
        RWAMap<PBXReference, PBXGroup> rWAMap = this.myCache.myReferenceToParentGroupMap;
        if (rWAMap == null) {
            PBXProjectFile.j(128);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReferencesCache() {
        Object object = this.myCacheLock;
        synchronized (object) {
            this.myCache = new ReferencesCache();
        }
    }

    public boolean isModified() {
        this.myRWAChecker.checkRead();
        return this.myRWAChecker.isModified() || this.myUserFile.isModified();
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean alsoSaveIfNotModified) throws IOException {
        this.myRWAChecker.checkRead();
        this.myRWAChecker.assertLocked();
        if (alsoSaveIfNotModified || this.myRWAChecker.isModified()) {
            boolean bl;
            CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.myProject);
            boolean bl2 = bl = coreXcodeWorkspace != null ? coreXcodeWorkspace.ensureFilesWritable(this.myPBXProjFile) : this.myPBXProjFile.isWritable();
            if (!bl) {
                throw new IOException("File is read-only");
            }
            String string = this.buildFileText();
            long l2 = VfsUtilCore.virtualToIoFile((VirtualFile)this.myPBXProjFile).lastModified();
            WriteAction.runAndWait(() -> this.myPBXProjFile.setBinaryContent(string.getBytes(this.myPBXProjFile.getCharset()), -1L, System.currentTimeMillis() - l2 < 1000L ? l2 + 1000L : -1L));
            this.myRWAChecker.resetModified();
        }
    }

    public String buildFileText() {
        PbxWriter pbxWriter = new PbxWriter();
        pbxWriter.write(this);
        return pbxWriter.getResult();
    }

    public String toString() {
        return this.getName();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PBXProjectFile.j(129);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            PBXProjectFile.j(130);
        }
        this.myDataHolder.putUserData(key, value2);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            PBXProjectFile.j(131);
        }
        return this.myDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value2) {
        if (key == null) {
            PBXProjectFile.j(132);
        }
        if (value2 == null) {
            PBXProjectFile.j(133);
        }
        Object object = this.myDataHolder.putUserDataIfAbsent(key, value2);
        if (object == null) {
            PBXProjectFile.j(134);
        }
        return (T)object;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 8, 9, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 49, 50, 51, 52, 53, 55, 56, 57, 59, 60, 61, 62, 63, 114, 115, 116, 117, 119, 124, 125, 126, 127, 128, 134 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pbxprojFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 39: 
            case 64: 
            case 76: 
            case 77: 
            case 83: 
            case 104: 
            case 108: 
            case 110: 
            case 112: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 41: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedRefIds";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedObjectIds";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productFileRef";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefsCache";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFileRefsCache";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSwiftPackageRefs";
                break;
            }
            case 68: 
            case 79: 
            case 85: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCacheEntryCache";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRefsCache";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRefsCache";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToFileCache";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocFilesMapCache";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocFileRootsCache";
                break;
            }
            case 75: 
            case 82: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRefTree";
                break;
            }
            case 78: 
            case 84: 
            case 90: 
            case 92: 
            case 105: 
            case 109: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 80: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associatedRootMap";
                break;
            }
            case 81: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootToAssociatedFilesMap";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToFile";
                break;
            }
            case 93: 
            case 95: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 94: 
            case 96: 
            case 98: 
            case 101: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 99: 
            case 102: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRefs";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRefs";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRWAChecker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBuildSettingsValues";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBaseDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettingsProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectObject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadableRootFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadableDataFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPBXProjFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeProjFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeProjFileName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDataDir";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNextId";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsReferencing";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsFor";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "selectTargets";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetsFor";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesFor";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToReferencesMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToReferencesMap";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToFilesMap";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefIdToTargetsAndConfigsMap";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesMap";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFileToTargetMap";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetToSourceFileTypesMap";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileTypes";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectlyLinkedProjects";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDirectlyLinkedProjects";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectlyLinkedProjectFilesWithPaths";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentsMap";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseInTests";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePbxProjectContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isXCSwiftPackageProductDependency";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setProjectObject";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addObject";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resetTargetConfigCachesOnChange";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateBuildFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeObjects";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveObject";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveBuildFilesForReferences";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findTargetForProduct";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addRefToCaches";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "removeRefFromCaches";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "handleAssociatedRootAddition";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "handleAssociatedRootRemoval";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addToNameToFileMap";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "removeFromNameToFileMap";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addToCountingSet";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "removeFromCountingSet";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addToListMap";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "removeFromListMap";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "addToPathToRefMap";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "addToFileToRefMap";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedFileRoot";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isCoreDataModelPackage";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileTypes";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "addRefTarget";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 49, 50, 51, 52, 53, 55, 56, 57, 59, 60, 61, 62, 63, 114, 115, 116, 117, 119, 124, 125, 126, 127, 128, 134 -> new IllegalStateException(string);
        };
    }

    private static final class ReferencesCache {
        @Nullable
        private volatile RWAMap<PBXReference, PBXGroup> myReferenceToParentGroupMap = null;
        private volatile boolean myFileCachesBuilt;
        @Nullable
        private volatile RWASet<PBXReference> myReferences = null;
        @Nullable
        private volatile RWASet<PBXFileReference> myFileReferences = null;
        @Nullable
        private volatile RWASet<XCRemoteSwiftPackageReference> myRemoteSwiftPackageReferences = null;
        @Nullable
        private volatile List<PBXTarget> myTargets = null;
        @Nullable
        private volatile MostlySingularMultiMap<XCBuildConfiguration, PBXTarget> myConfigToTargetMap;
        @Nullable
        private volatile MostlySingularMultiMap<String, PBXTarget> myNameToTargetMap;
        @Nullable
        private volatile RWAMap<PBXReference, ReferenceCacheEntry> myReferenceToCacheEntryMap = null;
        @Nullable
        private volatile RWAMap<Path, List<PBXReference>> myPathToReferencesMap = null;
        @Nullable
        private volatile RWAMap<VirtualFile, List<PBXReference>> myFileToReferencesMap = null;
        @Nullable
        private volatile RWAMap<String, List<VirtualFile>> myFileNameToFileMap = null;
        @Nullable
        private volatile RWAMap<VirtualFile, Integer> myAllProjectFiles = null;
        @Nullable
        private volatile RWAMap<VirtualFile, Collection<VirtualFile>> myFileToAssociatedFilesMap;
        @Nullable
        private volatile RWAMap<VirtualFile, List<PBXReference>> myFileToAssociatedRootMap;
        @Nullable
        private volatile FileRefTree myFileRefTree;
        private volatile boolean myBuildFileCacheBuilt;
        @Nullable
        private volatile RWAMap<PbxId, List<PBXBuildFile>> myReferenceIdToBuildFilesMap;
        @Nullable
        private volatile RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> myReferenceIdToTargetsAndConfigsMap;
        @Nullable
        private volatile RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> myBuildFileToTargetAndPhase;
        @Nullable
        private volatile RWAMap<PBXTarget, Collection<AppleFileType>> myTargetToSourceFileTypesMap;
        @Nullable
        private List<PBXProjectFile> myDirectlyLinkedProjects = null;

        private ReferencesCache() {
        }
    }

    private static class ReferenceCacheEntry {
        @Nullable
        VirtualFile file;
        @Nullable
        String path;

        ReferenceCacheEntry(@Nullable VirtualFile file2, @Nullable String path) {
            this.file = file2;
            this.path = path;
        }
    }
}

