/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxWriter;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXObject
extends PBXDictionary {
    public static final Comparator<PBXObject> ID_COMPARATOR = (pBXObject, pBXObject2) -> PbxId.COMPARATOR.compare(pBXObject == null ? null : pBXObject.getId(), pBXObject2 == null ? null : pBXObject2.getId());
    @NotNull
    private final PBXProjectFile myFile;
    @NotNull
    private volatile PbxId myId;
    private int hashCodeCache;

    public PBXObject(@NotNull PBXProjectFile file2) {
        if (file2 == null) {
            PBXObject.w(0);
        }
        super(file2);
        this.myId = PbxId.NONE;
        this.hashCodeCache = -1;
        this.myFile = file2;
        Class<?> clazz = this.getClass();
        if (clazz != PBXObject.class) {
            this.setAttribute("isa", clazz.getSimpleName());
        }
    }

    @NotNull
    public PBXProjectFile getFile() {
        PBXProjectFile pBXProjectFile = this.myFile;
        if (pBXProjectFile == null) {
            PBXObject.w(1);
        }
        return pBXProjectFile;
    }

    @Nullable
    public String getKind() {
        return PBXObject.getKind(this);
    }

    @Nullable
    public static String getKind(@Nullable PBXDictionary dict) {
        return dict == null ? null : dict.getAttribute("isa", String.class);
    }

    @NotNull
    public PbxId getId() {
        PbxId pbxId = this.myId;
        if (pbxId == null) {
            PBXObject.w(2);
        }
        return pbxId;
    }

    public void setId(@NotNull PbxId id) {
        if (id == null) {
            PBXObject.w(3);
        }
        this.myId = id;
    }

    @Nullable
    @NonNls
    public String getComment() {
        String string = this.getString("name", null);
        if (string == null) {
            string = this.getString("isa", null);
        }
        return string;
    }

    @NotNull
    public ObjectReference createReference() {
        return new ObjectReference(this.myId, this.myFile);
    }

    public boolean accept(@NotNull PbxObjectVisitor visitor2) {
        if (visitor2 == null) {
            PBXObject.w(4);
        }
        return visitor2.visitObject(this);
    }

    @Nullable
    public PBXObject getUserExtension() {
        return this.myFile.getUserFile().findExtensionFor(this);
    }

    @Override
    public String toString() {
        return this.getDebugString();
    }

    @NotNull
    public String getDebugString() {
        PbxWriter pbxWriter = new PbxWriter();
        pbxWriter.writeObject(this, true);
        String string = pbxWriter.getResult();
        if (string == null) {
            PBXObject.w(5);
        }
        return string;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.hashCodeCache == -1 ? (this.hashCodeCache = System.identityHashCode(this)) : this.hashCodeCache;
    }

    private static /* synthetic */ void w(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

