/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXContainerItemProxy
extends PBXContainerItem {
    public PBXContainerItemProxy(PBXProjectFile file2) {
        super(file2);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.getNotNullAttribute("remoteInfo", String.class);
        if (string == null) {
            PBXContainerItemProxy.v(0);
        }
        return string;
    }

    @NotNull
    public PbxId getGlobalId() {
        Object t10 = this.getNotNullAttribute("remoteGlobalIDString", null);
        if (t10 instanceof String) {
            PbxId pbxId = PbxId.fromString((String)t10);
            if (pbxId == null) {
                PBXContainerItemProxy.v(1);
            }
            return pbxId;
        }
        PbxId pbxId = this.resolveNotNullAttribute("remoteGlobalIDString", PBXObject.class).getId();
        if (pbxId == null) {
            PBXContainerItemProxy.v(2);
        }
        return pbxId;
    }

    @Nullable
    public PBXObject getContainerPortal() {
        return this.resolveAttribute("containerPortal", PBXObject.class);
    }

    @Nullable
    public PBXContainerItem resolve() {
        PBXObject pBXObject = this.getContainerPortal();
        if (pBXObject == this.getFile().getProjectObject()) {
            return (PBXContainerItem)this.getFile().findById(this.getGlobalId());
        }
        if (pBXObject instanceof PBXFileReference) {
            VirtualFile virtualFile2 = ((PBXFileReference)pBXObject).findFile();
            if (virtualFile2 == null) {
                return null;
            }
            CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
            if (coreXcodeWorkspace == null) {
                return null;
            }
            PBXProjectFile pBXProjectFile = coreXcodeWorkspace.findProject(virtualFile2);
            if (pBXProjectFile == null) {
                return null;
            }
            return (PBXContainerItem)pBXProjectFile.findById(this.getGlobalId());
        }
        return null;
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/xcode/model/PBXContainerItemProxy";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

