/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXBuildPhase
extends PBXObject {
    @NotNull
    private final PhaseType myType;

    public PBXBuildPhase(PBXProjectFile file2, @NotNull PhaseType type) {
        if (type == null) {
            PBXBuildPhase.v(0);
        }
        super(file2);
        this.myType = type;
        if (this.getClass() == PBXBuildPhase.class) {
            this.setAttribute("isa", String.format("PBX%sBuildPhase", type.getName()));
        }
    }

    @Override
    public String getComment() {
        String string = this.getString("name", null);
        return string == null ? this.myType.getName() : string;
    }

    @NotNull
    public PhaseType getType() {
        PhaseType phaseType = this.myType;
        if (phaseType == null) {
            PBXBuildPhase.v(1);
        }
        return phaseType;
    }

    @NotNull
    public List<PBXBuildFile> getFiles() {
        List<PBXBuildFile> list = this.resolveAttributeList("files", PBXBuildFile.class);
        if (list == null) {
            PBXBuildPhase.v(2);
        }
        return list;
    }

    public void addFile(@NotNull ObjectReference file2) {
        if (file2 == null) {
            PBXBuildPhase.v(3);
        }
        this.addToAttributeList("files", file2);
    }

    public void removeFile(@NotNull PbxId id) {
        if (id == null) {
            PBXBuildPhase.v(4);
        }
        this.removeFromAttributeList("files", ObjectReference.class, objectReference -> id.equals(objectReference.getId()));
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static interface PhaseType {
        @NotNull
        @NlsSafe
        public String getName();
    }

    private static class UnknownPhaseType
    implements PhaseType {
        @NotNull
        private final String myName;

        UnknownPhaseType(@NotNull String name) {
            if (name == null) {
                UnknownPhaseType.j(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UnknownPhaseType.j(1);
            }
            return string;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            UnknownPhaseType unknownPhaseType = (UnknownPhaseType)o2;
            return this.myName.equals(unknownPhaseType.myName);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$UnknownPhaseType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$UnknownPhaseType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Type
    extends Enum<Type>
    implements PhaseType {
        public static final /* enum */ Type COPY_FILES = new Type("CopyFiles");
        public static final /* enum */ Type FRAMEWORKS = new Type("Frameworks");
        public static final /* enum */ Type HEADERS = new Type("Headers");
        public static final /* enum */ Type RESOURCES = new Type("Resources");
        public static final /* enum */ Type SHELL_SCRIPT = new Type("ShellScript");
        public static final /* enum */ Type APPLE_SCRIPT = new Type("AppleScript");
        public static final /* enum */ Type SOURCES = new Type("Sources");
        public static final /* enum */ Type REZ = new Type("Rez");
        @NotNull
        @NonNls
        private final String myName;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String name) {
            if (name == null) {
                Type.j(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Type.j(1);
            }
            return string;
        }

        @Nullable
        public static Type typeFromName(@NotNull String name) {
            if (name == null) {
                Type.j(2);
            }
            for (Type type : Type.values()) {
                if (!name.equals(type.myName)) continue;
                return type;
            }
            return null;
        }

        public static PhaseType fromName(@NotNull String name) {
            if (name == null) {
                Type.j(3);
            }
            for (Type type : Type.values()) {
                if (!name.equals(type.myName)) continue;
                return type;
            }
            return new UnknownPhaseType(name);
        }

        private static /* synthetic */ Type[] j() {
            return new Type[]{COPY_FILES, FRAMEWORKS, HEADERS, RESOURCES, SHELL_SCRIPT, APPLE_SCRIPT, SOURCES, REZ};
        }

        static {
            $VALUES = Type.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$Type";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "typeFromName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

