/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXReference;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Notifications {
    public static final int PROJECTS_CHANGED = 1;
    public static final int TARGETS_CHANGED = 2;
    public static final int REFS_CHANGED = 4;
    public static final int BUILD_FILES_CHANGED = 8;
    public static final int BUILD_SETTINGS_CHANGED = 16;
    private int myChanges = 0;
    @Nullable
    private Set<String> myChangedFiles;
    @Nullable
    private Set<PBXReference> myChangedReferences;

    public void projectsChanged() {
        this.myChanges |= 1;
    }

    public void targetsChanged() {
        this.myChanges |= 2;
    }

    public void referencesChanged() {
        this.myChanges |= 4;
    }

    public void buildFilesChanged() {
        this.myChanges |= 8;
    }

    public void buildSettingsChanged() {
        this.myChanges |= 0x10;
    }

    public boolean didChangeReference(@NotNull PBXObject object) {
        if (object == null) {
            Notifications.j(0);
        }
        return this.myChangedReferences != null && this.myChangedReferences.contains(object);
    }

    public void addChangedReference(@NotNull PBXReference reference) {
        if (reference == null) {
            Notifications.j(1);
        }
        if (this.myChangedReferences == null) {
            this.myChangedReferences = new HashSet<PBXReference>();
        }
        this.myChangedReferences.add(reference);
    }

    public void addInvalidatedFile(@NotNull String fileName) {
        if (fileName == null) {
            Notifications.j(2);
        }
        if (this.myChangedFiles == null) {
            this.myChangedFiles = CollectionFactory.createFilePathSet();
        }
        this.myChangedFiles.add(fileName);
    }

    public int getChanges() {
        return this.myChanges;
    }

    @Nullable
    public Set<String> getChangedFiles() {
        return this.myChangedFiles;
    }

    @Nullable
    public Set<PBXReference> getChangedReferences() {
        return this.myChangedReferences;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/xcode/model/Notifications";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "didChangeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangedReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addInvalidatedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

