/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolvingContext {
    @NotNull
    private final ResolveKind myResolveKind;
    @NotNull
    private final Set<String> myCurrentlyResolving;
    @NotNull
    private final Set<String> myCurrentlyGettingValue;
    @NotNull
    private final MultiMap<String, BuildSettingValuesProvider> myValueSources;
    private final boolean myShouldEscapeInGroup;

    ResolvingContext() {
        this(ResolveKind.STRING);
    }

    ResolvingContext(boolean shouldEscapeInGroup) {
        this(ResolveKind.STRING, shouldEscapeInGroup);
    }

    ResolvingContext(@NotNull ResolveKind kind) {
        if (kind == null) {
            ResolvingContext.j(0);
        }
        this(kind, false);
    }

    ResolvingContext(@NotNull ResolveKind kind, boolean shouldEscapeInGroup) {
        if (kind == null) {
            ResolvingContext.j(1);
        }
        this(kind, shouldEscapeInGroup, new HashSet<String>(), new HashSet<String>(), (MultiMap<String, BuildSettingValuesProvider>)new MultiMap());
    }

    private ResolvingContext(@NotNull ResolveKind kind, boolean shouldEscapeInGroup, @NotNull Set<String> resolving, @NotNull Set<String> gettingValue, @NotNull MultiMap<String, BuildSettingValuesProvider> valueSources) {
        if (kind == null) {
            ResolvingContext.j(2);
        }
        if (resolving == null) {
            ResolvingContext.j(3);
        }
        if (gettingValue == null) {
            ResolvingContext.j(4);
        }
        if (valueSources == null) {
            ResolvingContext.j(5);
        }
        this.myResolveKind = kind;
        this.myShouldEscapeInGroup = shouldEscapeInGroup;
        this.myCurrentlyResolving = resolving;
        this.myCurrentlyGettingValue = gettingValue;
        this.myValueSources = valueSources;
    }

    @NotNull
    public ResolvingContext childContext(boolean partOfGroup) {
        if (!partOfGroup || !this.myShouldEscapeInGroup) {
            ResolvingContext resolvingContext = this;
            if (resolvingContext == null) {
                ResolvingContext.j(6);
            }
            return resolvingContext;
        }
        return new ResolvingContext(this.myResolveKind, false, this.myCurrentlyResolving, this.myCurrentlyGettingValue, this.myValueSources);
    }

    public boolean shouldEscapeInGroup() {
        return this.myShouldEscapeInGroup;
    }

    @NotNull
    public ResolveKind getResolveKind() {
        ResolveKind resolveKind = this.myResolveKind;
        if (resolveKind == null) {
            ResolvingContext.j(7);
        }
        return resolveKind;
    }

    public void startResolving(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(8);
        }
        this.myCurrentlyResolving.add(settingName);
    }

    public void finishResolving(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(9);
        }
        this.myCurrentlyResolving.remove(settingName);
        List list = (List)this.myValueSources.get((Object)settingName);
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
    }

    public void setValueSource(@NotNull String settingName, @NotNull BuildSettingValuesProvider source) {
        if (settingName == null) {
            ResolvingContext.j(10);
        }
        if (source == null) {
            ResolvingContext.j(11);
        }
        this.myValueSources.putValue((Object)settingName, (Object)source);
    }

    public boolean isTopLevelGetValue(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(12);
        }
        return this.myValueSources.get((Object)settingName).isEmpty();
    }

    public boolean isTopLevelResolve(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(13);
        }
        return (this.myCurrentlyResolving.isEmpty() || this.myCurrentlyResolving.size() == 1 && this.myCurrentlyResolving.contains(settingName)) && this.myCurrentlyGettingValue.isEmpty();
    }

    @Nullable
    public BuildSettingValuesProvider getValueSource(@NotNull String settingName) {
        List list;
        if (settingName == null) {
            ResolvingContext.j(14);
        }
        return (list = (List)this.myValueSources.get((Object)settingName)).isEmpty() ? null : (BuildSettingValuesProvider)list.get(list.size() - 1);
    }

    public void startGettingValue(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(15);
        }
        this.myCurrentlyGettingValue.add(settingName);
    }

    public void finishGettingValue(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(16);
        }
        this.myCurrentlyGettingValue.remove(settingName);
    }

    public boolean isGettingValueOrResolving(@NotNull String settingName) {
        if (settingName == null) {
            ResolvingContext.j(17);
        }
        return this.myCurrentlyResolving.contains(settingName) || this.myCurrentlyGettingValue.contains(settingName);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolving";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gettingValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSources";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ResolvingContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ResolvingContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "childContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveKind";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startResolving";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishResolving";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setValueSource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelGetValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelResolve";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueSource";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startGettingValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "finishGettingValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isGettingValueOrResolving";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class ResolveKind
    extends Enum<ResolveKind> {
        public static final /* enum */ ResolveKind STRING = new ResolveKind();
        public static final /* enum */ ResolveKind PATH = new ResolveKind();
        private static final /* synthetic */ ResolveKind[] $VALUES;

        public static ResolveKind[] values() {
            return (ResolveKind[])$VALUES.clone();
        }

        public static ResolveKind valueOf(String name) {
            return Enum.valueOf(ResolveKind.class, name);
        }

        private static /* synthetic */ ResolveKind[] j() {
            return new ResolveKind[]{STRING, PATH};
        }

        static {
            $VALUES = ResolveKind.j();
        }
    }
}

