/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSelector;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachingBuildSettingsResolver
extends BuildSettingsResolver {
    @NotNull
    private final CachedValue<BuildSettingSelector> mySelectorCache;
    @NotNull
    private final CachedValue<BuildSettingSelector> myArchSelectorCache;
    @NotNull
    private final CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> mySettingSpecsCache;
    @NotNull
    private final CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> mySdkSettingSpecsCache;
    @NotNull
    private final CachedValue<Map<CacheKey, String>> myResolvedValuesCache;
    @NotNull
    private final CachedValue<Map<String, Ref<BuildSettingValueWithSource>>> myUnresolvedValuesCache;
    @NotNull
    private final CachedValue<Map<String, List<BuildSettingsResolver.VariableMatch>>> myExtractedVariablesCache;

    protected CachingBuildSettingsResolver(@NotNull Project project2) {
        Object[] objectArray;
        XcodeProjectTrackers xcodeProjectTrackers;
        if (project2 == null) {
            CachingBuildSettingsResolver.N(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(project2);
        XcodeProjectTrackers xcodeProjectTrackers2 = xcodeProjectTrackers = coreXcodeWorkspace != null ? XcodeProjectTrackers.getInstance(project2) : null;
        if (xcodeProjectTrackers != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = xcodeProjectTrackers.getBuildSettingsTracker();
            objectArray = objectArray2;
            objectArray2[1] = xcodeProjectTrackers.getReferencesTracker();
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = ModificationTracker.NEVER_CHANGED;
        }
        Object[] objectArray4 = objectArray;
        this.mySelectorCache = CachingBuildSettingsResolver.j(project2, objectArray4, () -> BuildSettingSelector.sdk(this.getSdk()).and(BuildSettingSelector.arch(this.getArchitectures())));
        this.myArchSelectorCache = CachingBuildSettingsResolver.j(project2, objectArray4, () -> BuildSettingSelector.sdk(this.getSdk()));
        this.mySettingSpecsCache = this.j(project2, objectArray4, null);
        this.mySdkSettingSpecsCache = this.j(project2, objectArray4, "SDKROOT");
        this.myResolvedValuesCache = CachingBuildSettingsResolver.j(project2, objectArray4, () -> new ConcurrentHashMap());
        this.myUnresolvedValuesCache = CachingBuildSettingsResolver.j(project2, objectArray4, () -> new ConcurrentHashMap());
        this.myExtractedVariablesCache = CachingBuildSettingsResolver.j(project2, new Object[]{ModificationTracker.NEVER_CHANGED}, () -> new ConcurrentHashMap());
    }

    @NotNull
    private static <T> CachedValue<T> j(@NotNull Project project2, @NotNull @NotNull Object @NotNull [] objectArray, @NotNull Computable<T> computable) {
        if (project2 == null) {
            CachingBuildSettingsResolver.N(1);
        }
        if (computable == null) {
            CachingBuildSettingsResolver.N(2);
        }
        if (objectArray == null) {
            CachingBuildSettingsResolver.N(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> CachedValueProvider.Result.create((Object)computable.compute(), (Object[])objectArray), false);
        if (cachedValue == null) {
            CachingBuildSettingsResolver.N(4);
        }
        return cachedValue;
    }

    private CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> j(@NotNull Project project2, @NotNull @NotNull Object @NotNull [] objectArray, @Nullable String string) {
        if (project2 == null) {
            CachingBuildSettingsResolver.N(5);
        }
        if (objectArray == null) {
            CachingBuildSettingsResolver.N(6);
        }
        return CachingBuildSettingsResolver.j(project2, objectArray, () -> this.getSpecsTables(string));
    }

    @Override
    @NotNull
    protected String doResolveValue(@Nullable String settingName, @NotNull String value2, @NotNull ResolvingContext context2) {
        String string;
        CacheKey cacheKey;
        if (value2 == null) {
            CachingBuildSettingsResolver.N(7);
        }
        if (context2 == null) {
            CachingBuildSettingsResolver.N(8);
        }
        if (settingName == null) {
            String string2 = super.doResolveValue(null, value2, context2);
            if (string2 == null) {
                CachingBuildSettingsResolver.N(9);
            }
            return string2;
        }
        boolean bl = context2.isTopLevelResolve(settingName);
        if (bl) {
            cacheKey = new CacheKey(settingName, context2.getResolveKind(), context2.shouldEscapeInGroup());
            string = (String)((Map)this.myResolvedValuesCache.getValue()).get(cacheKey);
            if (string != null) {
                String string3 = string;
                if (string3 == null) {
                    CachingBuildSettingsResolver.N(10);
                }
                return string3;
            }
        } else {
            cacheKey = null;
        }
        string = super.doResolveValue(settingName, value2, context2);
        if (bl) {
            ((Map)this.myResolvedValuesCache.getValue()).put(cacheKey, string);
        }
        String string4 = string;
        if (string4 == null) {
            CachingBuildSettingsResolver.N(11);
        }
        return string4;
    }

    @Override
    @NotNull
    protected List<BuildSettingsResolver.VariableMatch> extractVariables(@NotNull String value2) {
        List<BuildSettingsResolver.VariableMatch> list;
        if (value2 == null) {
            CachingBuildSettingsResolver.N(12);
        }
        if ((list = (List<BuildSettingsResolver.VariableMatch>)((Map)this.myExtractedVariablesCache.getValue()).get(value2)) == null) {
            list = super.extractVariables(value2);
            ((Map)this.myExtractedVariablesCache.getValue()).put(value2, list);
        }
        List<BuildSettingsResolver.VariableMatch> list2 = list;
        if (list2 == null) {
            CachingBuildSettingsResolver.N(13);
        }
        return list2;
    }

    @Override
    @Nullable
    protected BuildSettingValueWithSource doGetUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context2) {
        BuildSettingValueWithSource buildSettingValueWithSource;
        boolean bl;
        if (settingName == null) {
            CachingBuildSettingsResolver.N(14);
        }
        if (context2 == null) {
            CachingBuildSettingsResolver.N(15);
        }
        if ((bl = context2.isTopLevelGetValue(settingName)) && (buildSettingValueWithSource = (Ref)((Map)this.myUnresolvedValuesCache.getValue()).get(settingName)) != null) {
            return (BuildSettingValueWithSource)buildSettingValueWithSource.get();
        }
        buildSettingValueWithSource = super.doGetUnresolvedValueWithSource(settingName, context2);
        if (bl) {
            ((Map)this.myUnresolvedValuesCache.getValue()).put(settingName, Ref.create((Object)buildSettingValueWithSource));
        }
        return buildSettingValueWithSource;
    }

    @Override
    @NotNull
    protected BuildSettingsResolver.BuildSettingSpecsTables getSpecsTables(@NotNull ResolvingContext context2) {
        if (context2 == null) {
            CachingBuildSettingsResolver.N(16);
        }
        BuildSettingsResolver.BuildSettingSpecsTables buildSettingSpecsTables = !this.areSdkAndArchitectureOverridden() && context2.isGettingValueOrResolving("SDKROOT") ? (BuildSettingsResolver.BuildSettingSpecsTables)this.mySdkSettingSpecsCache.getValue() : (BuildSettingsResolver.BuildSettingSpecsTables)this.mySettingSpecsCache.getValue();
        if (buildSettingSpecsTables == null) {
            CachingBuildSettingsResolver.N(17);
        }
        return buildSettingSpecsTables;
    }

    @Override
    @NotNull
    protected final BuildSettingSelector getSelector(@NotNull ResolvingContext context2) {
        if (context2 == null) {
            CachingBuildSettingsResolver.N(18);
        }
        BuildSettingSelector buildSettingSelector = context2.isGettingValueOrResolving("ARCHS") ? (BuildSettingSelector)this.myArchSelectorCache.getValue() : (BuildSettingSelector)this.mySelectorCache.getValue();
        if (buildSettingSelector == null) {
            CachingBuildSettingsResolver.N(19);
        }
        return buildSettingSelector;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4, 9, 10, 11, 13, 17, 19 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheTrackers";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cached";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVariables";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsTables";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cached";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCachedSpecs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doResolveValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractVariables";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetUnresolvedValueWithSource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSpecsTables";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 13, 17, 19 -> new IllegalStateException(string);
        };
    }

    private record CacheKey(String settingName, @NotNull ResolvingContext.ResolveKind kind, boolean shouldEscape) {
        @NotNull
        private final ResolvingContext.ResolveKind kind;

        private CacheKey(String settingName, @NotNull ResolvingContext.ResolveKind kind, boolean shouldEscape) {
            if (kind == null) {
                CacheKey.j(0);
            }
        }

        @NotNull
        public ResolvingContext.ResolveKind kind() {
            ResolvingContext.ResolveKind resolveKind = this.kind;
            if (resolveKind == null) {
                CacheKey.j(1);
            }
            return resolveKind;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver$CacheKey";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver$CacheKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kind";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

