/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"collectConfigurationCompilers", "", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "configuration", "Lcom/jetbrains/cidr/xcode/model/XCBuildConfiguration;", "sdk", "Lcom/jetbrains/cidr/xcode/frameworks/AppleSdk;", "loadDescriptionsLayout", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "layoutFiles", "", "Ljava/io/File;", "([Ljava/io/File;)Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "intellij.cidr.xcodeModel.core"})
@SourceDebugExtension(value={"SMAP\nBuildSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSettingsUtil.kt\ncom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class BuildSettingsUtilKt {
    @NotNull
    public static final Collection<AppleCompiler> collectConfigurationCompilers(@NotNull XCBuildConfiguration configuration, @NotNull AppleSdk sdk) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Object object2 = object = configuration.getTargets();
        boolean bl = false;
        Intrinsics.checkNotNull(object2);
        Object object3 = !((Collection)object2).isEmpty() ? object : null;
        if (object3 == null) {
            return CollectionsKt.emptyList();
        }
        List<PBXTarget> list = object3;
        String string = sdk.getPlatform().getDomain();
        AppleCompiler appleCompiler = sdk.getPlatform().findCompiler("com.apple.compilers.llvm.clang.1_0", string);
        object = sdk.getPlatform().findCompiler("com.apple.compilers.llvm.clang.1_0.analyzer", string);
        object2 = sdk.getPlatform().findCompiler("com.apple.compilers.osacompile", string);
        LinkedHashSet<AppleCompiler> linkedHashSet = new LinkedHashSet<AppleCompiler>();
        Object object4 = new AppleCompiler[]{appleCompiler, object, object2};
        ContainerUtil.addAllNotNull((Collection)linkedHashSet, (Object[])object4);
        PBXProjectFile pBXProjectFile = configuration.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)pBXProjectFile, (String)"getFile(...)");
        object4 = pBXProjectFile;
        Set set = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<PBXTarget, Collection<AppleFileType>>((PBXProjectFile)object4){
            final /* synthetic */ PBXProjectFile $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final Collection<AppleFileType> invoke(PBXTarget it) {
                return this.$project.getTargetSourceFileTypes(it);
            }
        }))));
        for (AppleFileType appleFileType : set) {
            linkedHashSet.addAll(sdk.getPlatform().findCompilersForFileType(appleFileType, string));
        }
        return linkedHashSet;
    }

    @Nullable
    public static final BuildSettingDescriptions loadDescriptionsLayout(File ... layoutFiles) {
        Intrinsics.checkNotNullParameter((Object)layoutFiles, (String)"layoutFiles");
        for (File file2 : layoutFiles) {
            if (!file2.exists() || file2.isDirectory()) continue;
            try {
                return new BuildSettingDescriptions(file2);
            }
            catch (IOException iOException) {
                XCLog.LOG.warn("Cannot read build settings layout file: " + file2, (Throwable)iOException);
            }
        }
        return null;
    }
}

