/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.apple.sdk.AppleSdkBase;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ArchitectureValues;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingEntry;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingFormat;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSelector;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.CachingBuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.model.BuildLocationPaths;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCCoreBuildSettings;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class BuildSettingsResolver
implements BuildSettingsProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + BuildSettingsResolver.class.getPackage().getName()));
    private static final Pattern CONDITIONS_PATTERN = Pattern.compile("(\\w+)=([\\w\\?\\*\\.]+)");
    private static final BuildSettingValuesProvider NO_MORE_PROVIDERS = new BuildSettingValuesProvider(){

        @Override
        @NotNull
        public Dictionary getDeclaredBuildSettingValues() {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    @NotNull
    public BuildSetting getBuildSetting(@NonNls @NotNull String settingName) {
        if (settingName == null) {
            BuildSettingsResolver.j(0);
        }
        PBXProjectFile pBXProjectFile = this.getProjectFile();
        return new BuildSetting(settingName, this, pBXProjectFile.getBaseDir().getPath());
    }

    @NotNull
    public static String resolveValue(@NotNull String value2, final @NotNull PBXProjectFile file2, final @Nullable PBXTarget target, final @NotNull Map<String, Object> configurationSettings, final @Nullable ApplePlatform platform) {
        if (value2 == null) {
            BuildSettingsResolver.j(1);
        }
        if (file2 == null) {
            BuildSettingsResolver.j(2);
        }
        if (configurationSettings == null) {
            BuildSettingsResolver.j(3);
        }
        String string = new CachingBuildSettingsResolver(file2.getProject()){

            @Override
            @NotNull
            protected PBXProjectFile getProjectFile() {
                PBXProjectFile pBXProjectFile = file2;
                if (pBXProjectFile == null) {
                    2.w(0);
                }
                return pBXProjectFile;
            }

            @Override
            @Nullable
            protected PBXTarget getTarget() {
                return target;
            }

            @Override
            @Nullable
            protected XCBuildConfiguration getBuildConfiguration() {
                return null;
            }

            @Override
            @Nullable
            protected ApplePlatform getPlatform() {
                return platform;
            }

            @Override
            @Nullable
            protected AppleSdk getSdk() {
                return null;
            }

            @Override
            @Nullable
            protected Set<ArchitectureValue> getArchitectures() {
                return null;
            }

            @Override
            @NotNull
            protected Map<String, Object> getAdditionalConfigurationSettings() {
                Map map = configurationSettings;
                if (map == null) {
                    2.w(1);
                }
                return map;
            }

            @Override
            protected boolean areSdkAndArchitectureOverridden() {
                return true;
            }

            private static /* synthetic */ void w(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProjectFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalConfigurationSettings";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }.resolveText(value2);
        if (string == null) {
            BuildSettingsResolver.j(4);
        }
        return string;
    }

    @NotNull
    public String resolveText(@NotNull String text) {
        if (text == null) {
            BuildSettingsResolver.j(5);
        }
        String string = this.doResolveValue(null, text, new ResolvingContext(ResolvingContext.ResolveKind.STRING));
        if (string == null) {
            BuildSettingsResolver.j(6);
        }
        return string;
    }

    @NotNull
    public String resolvePath(@NotNull String text) {
        if (text == null) {
            BuildSettingsResolver.j(7);
        }
        String string = this.doResolveValue(null, text, new ResolvingContext(ResolvingContext.ResolveKind.PATH));
        if (string == null) {
            BuildSettingsResolver.j(8);
        }
        return string;
    }

    @Contract(value="_, null, _ -> null")
    public String resolveValue(@NotNull String settingName, @Nullable String value2, @NotNull ResolvingContext context2) {
        if (settingName == null) {
            BuildSettingsResolver.j(9);
        }
        if (context2 == null) {
            BuildSettingsResolver.j(10);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return value2 == null ? null : this.doResolveValue(settingName, value2, context2);
    }

    @NotNull
    protected String doResolveValue(@Nullable String settingName, @NotNull String value2, @NotNull ResolvingContext context2) {
        AppleSdk appleSdk;
        Object object;
        Object object2;
        String string;
        Object object3;
        boolean bl;
        if (value2 == null) {
            BuildSettingsResolver.j(11);
        }
        if (context2 == null) {
            BuildSettingsResolver.j(12);
        }
        do {
            object3 = new StringBuilder();
            int n2 = 0;
            for (VariableMatch object4 : this.extractVariables((String)value2)) {
                string = object4.name;
                if ("inherited".equals(string)) {
                    string = settingName;
                }
                object2 = string == null ? null : this.getBuildSetting(string).getString(context2.childContext(object4.partOfGroup));
                LOG.assertTrue(object4.qualifiers != null);
                for (String string2 : object4.qualifiers) {
                    object2 = BuildSettingFormat.convert((String)object2, string2);
                }
                if (object2 != null && object4.partOfGroup && context2.shouldEscapeInGroup()) {
                    if (object4.currentlyInQuotes) {
                        object2 = StringUtil.escapeChar((String)object2, (char)object4.escapeChar);
                    } else if (StringUtil.containsWhitespaces((CharSequence)object2)) {
                        object2 = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeQuotes((String)object2));
                    }
                }
                ((StringBuilder)object3).append((CharSequence)value2, n2, object4.variableStart);
                if (object2 != null) {
                    ((StringBuilder)object3).append((String)object2);
                }
                n2 = object4.variableEnd;
            }
            ((StringBuilder)object3).append((CharSequence)value2, n2, ((String)value2).length());
            object = ((StringBuilder)object3).toString();
            bl = !((String)object).equals(value2);
            value2 = object;
        } while (bl);
        if (("VALID_ARCHS".equals(settingName) || !this.areArchitecturesOverridden() && "ARCHS".equals(settingName)) && (object3 = this.getSdk()) != null && ((AppleSdk)object3).getPlatformType().isSimulator()) {
            List list = ContainerUtil.map(BuildSetting.splitString((String)value2), ArchitectureValue::new);
            object = ArchitectureValues.getSimulatorBuildArchs(list);
            value2 = BuildSetting.convertToString(object);
        }
        if ("TEST_HOST".equals(settingName) && (appleSdk = this.getSdk()) != null && appleSdk.isMacCatalyst() && (object3 = this.getTarget()) != null && ((PBXTarget)object3).isAnyXCTestTests()) {
            object = value2;
            String string3 = this.getBuildSetting("BUILT_PRODUCTS_DIR").getString(context2.childContext(false));
            if (string3 != null && FileUtil.startsWith((String)object, (String)string3) && (object2 = ContainerUtil.filter((Collection)FileUtil.splitPath((String)(string = ((String)object).substring(string3.length()))), StringUtil::isNotEmpty)).size() == 2) {
                value2 = FileUtil.join((String[])new String[]{string3, (String)object2.get(0), "Contents", "MacOS", (String)object2.get(1)});
            }
        }
        Object object4 = value2;
        if (object4 == null) {
            BuildSettingsResolver.j(13);
        }
        return object4;
    }

    @NotNull
    protected List<VariableMatch> extractVariables(@NotNull String value2) {
        if (value2 == null) {
            BuildSettingsResolver.j(14);
        }
        Matcher matcher2 = null;
        IntRange intRange = null;
        Matcher matcher3 = BuildSetting.VariableExtractor.PATTERN.matcher(value2);
        ArrayList<VariableMatch> arrayList = new ArrayList<VariableMatch>();
        while (matcher3.find()) {
            if (matcher2 == null) {
                matcher2 = BuildSetting.QuotationExtractor.PATTERN.matcher(value2);
                intRange = BuildSetting.QuotationExtractor.findRange(matcher2);
            }
            boolean bl = false;
            while (intRange != null) {
                if (intRange.getEndInclusive() >= matcher3.start()) {
                    if (intRange.getStart() > matcher3.end()) break;
                    bl = true;
                    break;
                }
                intRange = BuildSetting.QuotationExtractor.findRange(matcher2);
            }
            arrayList.add(new VariableMatch(value2, matcher3, bl, bl ? (char)BuildSetting.QuotationExtractor.getChar(matcher2) : (char)' '));
        }
        ArrayList<VariableMatch> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BuildSettingsResolver.j(15);
        }
        return arrayList2;
    }

    @Nullable
    public BuildSettingValueWithSource getUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context2) {
        if (settingName == null) {
            BuildSettingsResolver.j(16);
        }
        if (context2 == null) {
            BuildSettingsResolver.j(17);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        BuildSettingValueWithSource buildSettingValueWithSource = this.j(settingName, context2, true);
        if (buildSettingValueWithSource != null && "SDKROOT".equals(settingName) && context2.getResolveKind() == ResolvingContext.ResolveKind.PATH) {
            AppleSdk appleSdk = AppleSdkManager.getInstance().findSdkBySettingValue(String.valueOf(buildSettingValueWithSource.value));
            buildSettingValueWithSource = appleSdk == null ? null : new BuildSettingValueWithSource(appleSdk.getHomePath(), buildSettingValueWithSource.source);
        }
        return buildSettingValueWithSource;
    }

    @Nullable
    private BuildSettingValueWithSource j(@NotNull String string, @NotNull ResolvingContext resolvingContext, boolean bl) {
        Object object;
        if (string == null) {
            BuildSettingsResolver.j(18);
        }
        if (resolvingContext == null) {
            BuildSettingsResolver.j(19);
        }
        if (this.areSdkAndArchitectureOverridden() && (object = this.getBuildConfiguration()) != null) {
            if ("SDKROOT".equals(string)) {
                AppleSdk appleSdk = this.getSdk();
                return appleSdk == null ? null : new BuildSettingValueWithSource(appleSdk.getName(), (BuildSettingValuesProvider)object);
            }
            if (this.areArchitecturesOverridden()) {
                if ("arch".equals(string)) {
                    String string2 = BuildSettingsResolver.j(this.getArchitectures());
                    return string2 == null ? null : new BuildSettingValueWithSource(string2, (BuildSettingValuesProvider)object);
                }
                if ("ARCHS".equals(string)) {
                    Set<ArchitectureValue> set = this.getArchitectures();
                    return set == null ? null : new BuildSettingValueWithSource(ContainerUtil.map(set, ArchitectureValue::getId), (BuildSettingValuesProvider)object);
                }
            }
        }
        if (bl && (object = this.j(string, resolvingContext)) != null) {
            return object;
        }
        object = this.doGetUnresolvedValueWithSource(string, resolvingContext);
        resolvingContext.setValueSource(string, object == null ? NO_MORE_PROVIDERS : ((BuildSettingValueWithSource)object).source);
        return object;
    }

    @Nullable
    protected BuildSettingValueWithSource doGetUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context2) {
        if (settingName == null) {
            BuildSettingsResolver.j(20);
        }
        if (context2 == null) {
            BuildSettingsResolver.j(21);
        }
        LinkedHashMap<BuildSettingEntry, BuildSettingValuesProvider> linkedHashMap = new LinkedHashMap<BuildSettingEntry, BuildSettingValuesProvider>();
        BuildSettingSpecsTables buildSettingSpecsTables = this.getSpecsTables(context2);
        BuildSettingValuesProvider buildSettingValuesProvider = context2.getValueSource(settingName);
        if (buildSettingValuesProvider != NO_MORE_PROVIDERS) {
            boolean bl = buildSettingValuesProvider == null;
            for (Pair pair2 : buildSettingSpecsTables) {
                BuildSettingValuesProvider buildSettingValuesProvider2 = (BuildSettingValuesProvider)pair2.first;
                MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)pair2.second;
                if (bl && mostlySingularMultiMap.containsKey((Object)settingName)) {
                    for (BuildSettingEntry buildSettingEntry : mostlySingularMultiMap.get((Object)settingName)) {
                        if (linkedHashMap.containsKey(buildSettingEntry)) continue;
                        linkedHashMap.put(buildSettingEntry, buildSettingValuesProvider2);
                    }
                    buildSettingValuesProvider = buildSettingValuesProvider2;
                    continue;
                }
                if (buildSettingValuesProvider2 != buildSettingValuesProvider) continue;
                bl = true;
            }
        }
        BuildSettingEntry buildSettingEntry = BuildSettingsResolver.j(linkedHashMap.keySet()) && !context2.isGettingValueOrResolving("SDKROOT") ? this.getSelector(context2).select(linkedHashMap.keySet()) : (BuildSettingEntry)ContainerUtil.getFirstItem(linkedHashMap.keySet(), null);
        return buildSettingEntry == null ? null : new BuildSettingValueWithSource(buildSettingEntry.getValue(), (BuildSettingValuesProvider)linkedHashMap.get(buildSettingEntry));
    }

    @Nullable
    private BuildSettingValueWithSource j(@NotNull String string, @NotNull ResolvingContext resolvingContext) {
        XCBuildConfiguration xCBuildConfiguration;
        if (string == null) {
            BuildSettingsResolver.j(22);
        }
        if (resolvingContext == null) {
            BuildSettingsResolver.j(23);
        }
        if ((xCBuildConfiguration = this.getBuildConfiguration()) != null) {
            Object object;
            Comparable<AppleSdkBase> comparable;
            PBXTarget pBXTarget = this.getTarget();
            if (pBXTarget != null && "TARGET_BUILD_DIR".equals(string) && pBXTarget.isAnyXCTestTests()) {
                boolean bl;
                comparable = XCCoreBuildSettings.getRawCoreBuildSettings(xCBuildConfiguration).getBuildSetting("TEST_HOST").getAbsoluteFile();
                object = this.getSdk();
                boolean bl2 = bl = object != null && ((AppleSdk)object).getPlatform().isMacOS();
                if (comparable != null) {
                    @NonNls Object object2 = "../PlugIns";
                    if (bl) {
                        object2 = "../" + (String)object2;
                    }
                    return new BuildSettingValueWithSource("$(TEST_HOST)/" + (String)object2, xCBuildConfiguration);
                }
                if (pBXTarget.isXCUITestTests()) {
                    String string2 = "$(CONFIGURATION_BUILD_DIR)/$(TARGET_NAME)-Runner.app/";
                    return new BuildSettingValueWithSource(string2 + (bl ? "Contents/" : "") + "PlugIns", xCBuildConfiguration);
                }
            }
            if ("ARCHS_STANDARD".equals(string)) {
                comparable = this.getSdk();
                Object object3 = object = comparable != null ? this.j(string, resolvingContext, false) : null;
                if (object != null) {
                    String string3 = this.getBuildSetting(XCCoreBuildSettings.getDeploymentTargetSettingName(comparable)).getString(resolvingContext);
                    if (string3 == null) {
                        LOG.warn("Detected recursion when resolving deployment target for ARCHS_STANDARD");
                    } else {
                        ApplePlatform applePlatform = this.getPlatform();
                        if (applePlatform != null && ((BuildSettingValueWithSource)object).value instanceof List) {
                            List list = ((List)((BuildSettingValueWithSource)object).value).stream().map(applePlatform::findArchitectureById).filter(Objects::nonNull).filter(appleArchitecture -> appleArchitecture.matchesDeploymentTarget(string3)).map(AppleArchitecture::getId).collect(Collectors.toList());
                            return new BuildSettingValueWithSource(list, ((BuildSettingValueWithSource)object).source);
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static String j(@Nullable Collection<ArchitectureValue> collection) {
        ArchitectureValue architectureValue = collection == null ? null : (ArchitectureValue)ContainerUtil.getFirstItem(collection);
        return null != architectureValue ? architectureValue.getId() : null;
    }

    private static boolean j(Collection<BuildSettingEntry> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection.size() > 1) {
            return true;
        }
        BuildSettingEntry buildSettingEntry = collection.iterator().next();
        return !buildSettingEntry.getConditions().isEmpty();
    }

    @NotNull
    protected BuildSettingSpecsTables getSpecsTables(@NotNull ResolvingContext context2) {
        if (context2 == null) {
            BuildSettingsResolver.j(24);
        }
        String string = !this.areSdkAndArchitectureOverridden() && context2.isGettingValueOrResolving("SDKROOT") ? "SDKROOT" : null;
        BuildSettingSpecsTables buildSettingSpecsTables = this.getSpecsTables(string);
        if (buildSettingSpecsTables == null) {
            BuildSettingsResolver.j(25);
        }
        return buildSettingSpecsTables;
    }

    @NotNull
    protected BuildSettingSpecsTables getSpecsTables(@Nullable String forSetting) {
        List<BuildSettingValuesProvider> list = this.j(forSetting);
        BuildSettingSpecsTables buildSettingSpecsTables = new BuildSettingSpecsTables(list.size());
        for (BuildSettingValuesProvider buildSettingValuesProvider : list) {
            buildSettingSpecsTables.add(Pair.create((Object)buildSettingValuesProvider, BuildSettingsResolver.j(buildSettingValuesProvider)));
        }
        BuildSettingSpecsTables buildSettingSpecsTables2 = buildSettingSpecsTables;
        if (buildSettingSpecsTables2 == null) {
            BuildSettingsResolver.j(26);
        }
        return buildSettingSpecsTables2;
    }

    @NotNull
    protected BuildSettingSelector getSelector(@NotNull ResolvingContext context2) {
        if (context2 == null) {
            BuildSettingsResolver.j(27);
        }
        BuildSettingSelector buildSettingSelector = context2.isGettingValueOrResolving("ARCHS") ? BuildSettingSelector.sdk(this.getSdk()) : BuildSettingSelector.sdk(this.getSdk()).and(BuildSettingSelector.arch(this.getArchitectures()));
        if (buildSettingSelector == null) {
            BuildSettingsResolver.j(28);
        }
        return buildSettingSelector;
    }

    private static MostlySingularMultiMap<String, BuildSettingEntry> j(@NotNull BuildSettingValuesProvider buildSettingValuesProvider) {
        if (buildSettingValuesProvider == null) {
            BuildSettingsResolver.j(29);
        }
        MostlySingularMultiMap mostlySingularMultiMap = new MostlySingularMultiMap();
        for (Map.Entry<String, Object> entry2 : buildSettingValuesProvider.getDeclaredBuildSettingValues().entrySet()) {
            String string = entry2.getKey();
            Set<BuildSettingEntry.ConditionSpec> set = Collections.emptySet();
            int n2 = string.indexOf("[");
            if (n2 != -1) {
                set = new HashSet(3);
                String string2 = string.substring(n2);
                string = string.substring(0, n2);
                Matcher matcher2 = CONDITIONS_PATTERN.matcher(string2);
                while (matcher2.find()) {
                    set.add(new BuildSettingEntry.ConditionSpec(matcher2.group(1), matcher2.group(2)));
                }
            }
            mostlySingularMultiMap.add((Object)string, (Object)new BuildSettingEntry(string, set, entry2.getValue()));
        }
        return mostlySingularMultiMap;
    }

    @NotNull
    private List<BuildSettingValuesProvider> j(String string) {
        boolean bl = "SDKROOT".equals(string);
        AppleSdk appleSdk = bl ? null : this.getSdk();
        ApplePlatform applePlatform = bl ? null : this.getPlatform();
        PBXProjectFile pBXProjectFile = this.getProjectFile();
        PBXTarget pBXTarget = this.getTarget();
        XCBuildConfiguration xCBuildConfiguration = this.getBuildConfiguration();
        return BuildSettingsResolver.j(pBXProjectFile, pBXTarget, xCBuildConfiguration, this.getAdditionalConfigurationSettings(), appleSdk, applePlatform);
    }

    @NotNull
    private static List<BuildSettingValuesProvider> j(final @NotNull PBXProjectFile pBXProjectFile, final @Nullable PBXTarget pBXTarget, final @Nullable XCBuildConfiguration xCBuildConfiguration, final @NotNull Map<String, Object> map, final @Nullable AppleSdk appleSdk, final @Nullable ApplePlatform applePlatform) {
        Object object;
        Object object2;
        BuildLocationPaths buildLocationPaths;
        if (pBXProjectFile == null) {
            BuildSettingsResolver.j(30);
        }
        if (map == null) {
            BuildSettingsResolver.j(31);
        }
        ArrayList<BuildSettingValuesProvider> arrayList = new ArrayList<BuildSettingValuesProvider>();
        CoreXcodeWorkspace coreXcodeWorkspace = CoreXcodeWorkspace.getInstance(pBXProjectFile.getProject());
        BuildLocationPaths buildLocationPaths2 = buildLocationPaths = coreXcodeWorkspace != null ? coreXcodeWorkspace.getDerivedBuildLocationPaths() : null;
        if (buildLocationPaths != null) {
            object2 = buildLocationPaths.getProductsPath();
            object = buildLocationPaths.getIntermediatesPath();
            if (object2 != null && object != null) {
                arrayList.add(new BuildSettingValuesProvider(){
                    final /* synthetic */ File val$productsBuildDir;
                    final /* synthetic */ File val$intermediatesBuildDir;
                    {
                        this.val$productsBuildDir = file2;
                        this.val$intermediatesBuildDir = file3;
                    }

                    @Override
                    @NotNull
                    public Dictionary getDeclaredBuildSettingValues() {
                        Dictionary dictionary = new Dictionary();
                        dictionary.setAttribute("SYMROOT", this.val$productsBuildDir.getPath());
                        dictionary.setAttribute("OBJROOT", this.val$intermediatesBuildDir.getPath());
                        Dictionary dictionary2 = dictionary;
                        if (dictionary2 == null) {
                            3.j(0);
                        }
                        return dictionary2;
                    }

                    private static /* synthetic */ void j(int n2) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$3", "getDeclaredBuildSettingValues"));
                    }
                });
            }
        }
        if (!map.isEmpty()) {
            arrayList.add(new BuildSettingValuesProvider(){

                @Override
                @NotNull
                public Dictionary getDeclaredBuildSettingValues() {
                    Dictionary dictionary = new Dictionary();
                    dictionary.putAll(map);
                    Dictionary dictionary2 = dictionary;
                    if (dictionary2 == null) {
                        4.j(0);
                    }
                    return dictionary2;
                }

                private static /* synthetic */ void j(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$4", "getDeclaredBuildSettingValues"));
                }
            });
        }
        ContainerUtil.addIfNotNull(arrayList, (Object)xCBuildConfiguration);
        ContainerUtil.addIfNotNull(arrayList, (Object)(xCBuildConfiguration == null ? null : xCBuildConfiguration.getXCConfigBuildSettingValuesProvider()));
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = pBXProjectFile.getProjectObject().getUserBuildSettings();
                if (dictionary == null) {
                    5.j(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$5", "getDeclaredBuildSettingValues"));
            }
        });
        object2 = xCBuildConfiguration == null ? null : xCBuildConfiguration.getBaseConfiguration();
        ContainerUtil.addIfNotNull(arrayList, (Object)object2);
        ContainerUtil.addIfNotNull(arrayList, (Object)(object2 == null ? null : ((XCBuildConfiguration)object2).getXCConfigBuildSettingValuesProvider()));
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = new Dictionary();
                String string = pBXProjectFile.getBaseDir().getPath();
                dictionary.setAttribute("SRCROOT", string);
                dictionary.setAttribute("SOURCE_ROOT", string);
                dictionary.setAttribute("PROJECT", pBXProjectFile.getName());
                dictionary.setAttribute("PROJECT_NAME", pBXProjectFile.getName());
                dictionary.setAttribute("PROJECT_FILE_PATH", pBXProjectFile.getXcodeProjFile().getPath());
                if (pBXTarget != null) {
                    dictionary.setAttribute("TARGET_NAME", pBXTarget.getName());
                    dictionary.setAttribute("TARGETNAME", pBXTarget.getName());
                }
                if (xCBuildConfiguration != null) {
                    dictionary.setAttribute("CONFIGURATION", xCBuildConfiguration.getName());
                }
                Dictionary dictionary2 = dictionary;
                if (dictionary2 == null) {
                    6.j(0);
                }
                return dictionary2;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$6", "getDeclaredBuildSettingValues"));
            }
        });
        if (pBXTarget instanceof PBXNativeTarget) {
            object = (PBXNativeTarget)pBXTarget;
            ContainerUtil.addIfNotNull(arrayList, (Object)((PBXNativeTarget)object).getProductType(applePlatform));
            ContainerUtil.addIfNotNull(arrayList, (Object)((PBXNativeTarget)object).getPackageType(applePlatform));
        }
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = XcodeBase.getInstance().getBuildSettings();
                if (dictionary == null) {
                    7.j(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$7", "getDeclaredBuildSettingValues"));
            }
        });
        ContainerUtil.addIfNotNull(arrayList, (Object)AppleSdkManager.getInstance());
        ContainerUtil.addIfNotNull(arrayList, (Object)appleSdk);
        ContainerUtil.addIfNotNull(arrayList, (Object)applePlatform);
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = new Dictionary();
                if (applePlatform != null) {
                    Object object = appleSdk != null && appleSdk.isMacCatalyst() ? "-maccatalyst" : (applePlatform.isMacOS() ? null : "-" + applePlatform.getName());
                    dictionary.setAttribute("EFFECTIVE_PLATFORM_NAME", object);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (AppleArchitecture appleArchitecture : applePlatform.getArchitectures()) {
                        String string;
                        if (appleArchitecture.isReal()) {
                            arrayList.add(appleArchitecture.getId());
                        }
                        if ((string = appleArchitecture.getArchitectureSetting()) == null) continue;
                        dictionary.setAttribute(string, appleArchitecture.getRealArchitectures());
                    }
                    dictionary.setAttribute("VALID_ARCHS", arrayList);
                    if (XcodeBase.getInstance().getVersion().lessThan(Integer.valueOf(14))) {
                        dictionary.setAttribute("SWIFT_PLATFORM_TARGET_PREFIX", XcodeExtensionsManager.getInstance().getExtendedPlatformInfo(applePlatform.getIdentifier(), "swiftTargetPrefix"));
                    }
                }
                dictionary.setAttribute("NATIVE_ARCH", AppleSdkManager.getStandardNativeArchitectureId(applePlatform));
                dictionary.setAttribute("NATIVE_ARCH_ACTUAL", AppleSdkManager.getActualMacOSNativeArchitectureId());
                Dictionary dictionary2 = dictionary;
                if (dictionary2 == null) {
                    8.j(0);
                }
                return dictionary2;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$8", "getDeclaredBuildSettingValues"));
            }
        });
        if (applePlatform != null) {
            ContainerUtil.addIfNotNull(arrayList, (Object)applePlatform.findBuildSystem(AppleBuildSystem.Type.NATIVE));
        }
        if (xCBuildConfiguration != null && appleSdk != null) {
            arrayList.addAll(BuildSettingsUtilKt.collectConfigurationCompilers(xCBuildConfiguration, appleSdk));
        }
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = new Dictionary();
                dictionary.setAttribute("SYMROOT", "build");
                dictionary.setAttribute("OBJROOT", "build");
                Dictionary dictionary2 = dictionary;
                if (dictionary2 == null) {
                    9.j(0);
                }
                return dictionary2;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$9", "getDeclaredBuildSettingValues"));
            }
        });
        arrayList.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = new Dictionary();
                dictionary.putAll((Map<? extends String, ?>)System.getenv());
                Dictionary dictionary2 = dictionary;
                if (dictionary2 == null) {
                    10.j(0);
                }
                return dictionary2;
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$10", "getDeclaredBuildSettingValues"));
            }
        });
        ArrayList<BuildSettingValuesProvider> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BuildSettingsResolver.j(32);
        }
        return arrayList2;
    }

    @NotNull
    protected final Project getProject() {
        Project project2 = this.getProjectFile().getProject();
        if (project2 == null) {
            BuildSettingsResolver.j(33);
        }
        return project2;
    }

    @NotNull
    protected abstract PBXProjectFile getProjectFile();

    @Nullable
    protected abstract PBXTarget getTarget();

    @Nullable
    protected abstract XCBuildConfiguration getBuildConfiguration();

    @Nullable
    protected ApplePlatform getPlatform() {
        AppleSdk appleSdk = this.getSdk();
        return appleSdk == null ? null : appleSdk.getPlatform();
    }

    @Nullable
    protected abstract AppleSdk getSdk();

    @Nullable
    protected abstract Set<ArchitectureValue> getArchitectures();

    @NotNull
    protected Map<String, Object> getAdditionalConfigurationSettings() {
        Map<String, Object> map = Collections.emptyMap();
        if (map == null) {
            BuildSettingsResolver.j(34);
        }
        return map;
    }

    protected abstract boolean areSdkAndArchitectureOverridden();

    protected boolean areArchitecturesOverridden() {
        return this.areSdkAndArchitectureOverridden();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4, 6, 8, 13, 15, 25, 26, 28, 32, 33, 34 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalBuildSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveValue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVariables";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsTables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalConfigurationSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildSetting";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveValue";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doResolveValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractVariables";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedValueWithSource";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doGetUnresolvedValueWithSource";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleOverriddenSettings";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSpecsTables";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "convertValuesToSpecs";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 13, 15, 25, 26, 28, 32, 33, 34 -> new IllegalStateException(string);
        };
    }

    protected static class VariableMatch {
        private final int variableStart;
        private final int variableEnd;
        @Nullable
        private final String name;
        @Nullable
        private final List<String> qualifiers;
        private final boolean currentlyInQuotes;
        private final boolean partOfGroup;
        private final char escapeChar;

        VariableMatch(@NotNull String value2, @NotNull MatchResult match, boolean currentlyInQuotes, char escapeChar) {
            if (value2 == null) {
                VariableMatch.j(0);
            }
            if (match == null) {
                VariableMatch.j(1);
            }
            this.variableStart = match.start();
            this.variableEnd = match.end();
            Pair<String, List<String>> pair2 = BuildSetting.VariableExtractor.getVariableAndQualifiers(match);
            this.name = pair2 == null ? null : (String)pair2.first;
            this.qualifiers = pair2 == null ? null : (List)pair2.second;
            this.currentlyInQuotes = currentlyInQuotes;
            this.partOfGroup = currentlyInQuotes || this.variableStart > 0 && value2.charAt(this.variableStart - 1) != ' ' || this.variableEnd < value2.length() && value2.charAt(this.variableEnd) != ' ';
            this.escapeChar = escapeChar;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "match";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$VariableMatch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class BuildSettingSpecsTables
    extends ArrayList<Pair<BuildSettingValuesProvider, MostlySingularMultiMap<String, BuildSettingEntry>>> {
        private BuildSettingSpecsTables(int initialCapacity) {
            super(initialCapacity);
        }
    }
}

