/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BuildSettingSelector {
    BuildSettingSelector() {
    }

    @Nullable
    public BuildSettingEntry select(@NotNull Collection<BuildSettingEntry> settings) {
        if (settings == null) {
            BuildSettingSelector.j(0);
        }
        BuildSettingEntry buildSettingEntry = null;
        int n2 = -1;
        for (BuildSettingEntry buildSettingEntry2 : this.retainSuitable(settings)) {
            int n3 = buildSettingEntry2.getWeight();
            if (buildSettingEntry != null && n2 > n3) continue;
            buildSettingEntry = buildSettingEntry2;
            n2 = n3;
        }
        return buildSettingEntry;
    }

    @NotNull
    public BuildSettingSelector and(@Nullable BuildSettingSelector right) {
        return right == null ? this : new AndSelector(this, right);
    }

    protected abstract List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> var1);

    @NotNull
    public static BuildSettingSelector nil() {
        return new LeafSelector(null, Collections.emptyList());
    }

    @NotNull
    public static BuildSettingSelector sdk(@Nullable AppleSdk sdk) {
        return new LeafSelector("sdk", sdk == null ? Collections.emptyList() : Collections.singletonList(sdk.getName()));
    }

    @NotNull
    public static BuildSettingSelector arch(@Nullable Collection<ArchitectureValue> architectures) {
        List<String> list = Collections.emptyList();
        if (architectures != null) {
            list = new ArrayList<String>(architectures.size());
            for (ArchitectureValue architectureValue : architectures) {
                list.add(architectureValue.getId());
            }
        }
        return new LeafSelector("arch", list);
    }

    private static /* synthetic */ void j(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector", "select"));
    }

    private static class AndSelector
    extends BuildSettingSelector {
        private final BuildSettingSelector myLeft;
        private final BuildSettingSelector myRight;

        AndSelector(@NotNull BuildSettingSelector left, @NotNull BuildSettingSelector right) {
            if (left == null) {
                AndSelector.N(0);
            }
            if (right == null) {
                AndSelector.N(1);
            }
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        protected List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> values2) {
            if (values2 == null) {
                AndSelector.N(2);
            }
            return this.myRight.retainSuitable(this.myLeft.retainSuitable(values2));
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector$AndSelector";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retainSuitable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LeafSelector
    extends BuildSettingSelector {
        @Nullable
        private final String myFlavor;
        @NotNull
        private final List<String> myActualValues;

        LeafSelector(@Nullable @NonNls String flavor, @NotNull List<String> actualValues) {
            if (actualValues == null) {
                LeafSelector.N(0);
            }
            this.myFlavor = flavor;
            this.myActualValues = actualValues;
        }

        @Override
        protected List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> values2) {
            if (values2 == null) {
                LeafSelector.N(1);
            }
            ArrayList<BuildSettingEntry> arrayList = new ArrayList<BuildSettingEntry>(values2.size());
            block0: for (BuildSettingEntry buildSettingEntry : values2) {
                for (BuildSettingEntry.ConditionSpec conditionSpec : buildSettingEntry.getConditions()) {
                    if (this.myFlavor != null && !this.myFlavor.equals(conditionSpec.getFlavor())) continue;
                    boolean bl = false;
                    for (String string : this.myActualValues) {
                        if (!conditionSpec.matches(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    continue block0;
                }
                arrayList.add(buildSettingEntry);
            }
            return arrayList;
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actualValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector$LeafSelector";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retainSuitable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

