/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildSettingEntry {
    @NotNull
    private final String mySettingName;
    @NotNull
    private final Set<ConditionSpec> myConditions;
    @NotNull
    private final Object myValue;

    BuildSettingEntry(@NotNull String settingName, @NotNull Set<ConditionSpec> conditions, @NotNull Object value2) {
        if (settingName == null) {
            BuildSettingEntry.j(0);
        }
        if (conditions == null) {
            BuildSettingEntry.j(1);
        }
        if (value2 == null) {
            BuildSettingEntry.j(2);
        }
        this.mySettingName = settingName;
        this.myConditions = conditions;
        this.myValue = value2;
    }

    @NotNull
    public Collection<ConditionSpec> getConditions() {
        Set<ConditionSpec> set = this.myConditions;
        if (set == null) {
            BuildSettingEntry.j(3);
        }
        return set;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            BuildSettingEntry.j(4);
        }
        return object;
    }

    public int getWeight() {
        if (this.myConditions.isEmpty()) {
            return -1;
        }
        int n2 = 0;
        for (ConditionSpec conditionSpec : this.myConditions) {
            for (int i2 = 0; i2 < conditionSpec.myPattern.length(); ++i2) {
                char c2 = conditionSpec.myPattern.charAt(i2);
                if (c2 == '*') continue;
                n2 += c2 == '?' ? 1 : 2;
            }
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mySettingName);
        for (ConditionSpec conditionSpec : this.myConditions) {
            stringBuilder.append("[").append(conditionSpec).append("]");
        }
        stringBuilder.append("=").append(this.myValue);
        return stringBuilder.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BuildSettingEntry buildSettingEntry = (BuildSettingEntry)o2;
        if (!this.mySettingName.equals(buildSettingEntry.mySettingName)) {
            return false;
        }
        return this.myConditions.equals(buildSettingEntry.myConditions);
    }

    public int hashCode() {
        int n2 = this.mySettingName.hashCode();
        n2 = 31 * n2 + this.myConditions.hashCode();
        return n2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class ConditionSpec {
        @NotNull
        private final String myFlavor;
        @NotNull
        private final String myPattern;

        public ConditionSpec(@NotNull String flavor, @NotNull String pattern) {
            if (flavor == null) {
                ConditionSpec.j(0);
            }
            if (pattern == null) {
                ConditionSpec.j(1);
            }
            this.myFlavor = flavor;
            this.myPattern = pattern;
        }

        @NotNull
        public String getFlavor() {
            String string = this.myFlavor;
            if (string == null) {
                ConditionSpec.j(2);
            }
            return string;
        }

        public boolean matches(@Nullable String value2) {
            return StringUtil.notNullize((String)value2).matches(FileUtil.convertAntToRegexp((String)this.myPattern));
        }

        public String toString() {
            return this.myFlavor + "=" + this.myPattern;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ConditionSpec conditionSpec = (ConditionSpec)o2;
            if (!this.myFlavor.equals(conditionSpec.myFlavor)) {
                return false;
            }
            return this.myPattern.equals(conditionSpec.myPattern);
        }

        public int hashCode() {
            int n2 = this.myFlavor.hashCode();
            n2 = 31 * n2 + this.myPattern.hashCode();
            return n2;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry$ConditionSpec";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry$ConditionSpec";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFlavor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

