/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.StringsParser;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildSettingDescriptions {
    private static final Pattern PATTERN = Pattern.compile("\\[(.*)\\]-(?:(category||name||description)||(?:(value||description)-\\[(.*)\\]))");
    private static final Function<Map.Entry<String, Object>, Couple<String>> ENTRY_COUPLE_FUNCTION = entry2 -> {
        if (entry2.getValue() instanceof String) {
            return Couple.of((Object)((String)entry2.getKey()), (Object)((String)entry2.getValue()));
        }
        return null;
    };
    private final Map<String, String> myCategoryDescriptions;
    private final Map<String, BuildSettingDescription> mySettingDescriptions;

    public BuildSettingDescriptions(@NotNull File file2) throws IOException {
        if (file2 == null) {
            BuildSettingDescriptions.j(0);
        }
        this.myCategoryDescriptions = new HashMap<String, String>();
        this.mySettingDescriptions = new HashMap<String, BuildSettingDescription>();
        Object object = BuildSettingDescriptions.j(file2);
        if (object instanceof String) {
            this.j(StringsParser.parse((String)object));
        }
        if (object instanceof Plist) {
            this.j(ContainerUtil.map(((Plist)object).entrySet(), ENTRY_COUPLE_FUNCTION));
        }
    }

    private static Object j(File file2) throws IOException {
        byte[] byArray = FileUtil.loadFileBytes((File)file2);
        Charset charset = CharsetToolkit.guessFromBOM((byte[])byArray);
        if (charset != null) {
            return new String(byArray, charset);
        }
        return PlistDriver.readAnyFormat(file2);
    }

    public BuildSettingDescriptions(@NotNull String text) {
        if (text == null) {
            BuildSettingDescriptions.j(1);
        }
        this.myCategoryDescriptions = new HashMap<String, String>();
        this.mySettingDescriptions = new HashMap<String, BuildSettingDescription>();
        List<Couple<String>> list = StringsParser.parse(text);
        this.j(list);
    }

    private void j(List<Couple<@NonNls String>> list) {
        for (Couple<String> couple : list) {
            BuildSettingDescription.ValueDescription valueDescription;
            Matcher matcher2 = PATTERN.matcher((CharSequence)couple.first);
            if (!matcher2.matches()) continue;
            String string = (String)couple.second;
            String string2 = matcher2.group(1);
            @NonNls String string3 = matcher2.group(2);
            String string4 = matcher2.group(3);
            String string5 = matcher2.group(4);
            if ("category".equals(string3)) {
                this.myCategoryDescriptions.put(string2, string);
                continue;
            }
            BuildSettingDescription buildSettingDescription = this.mySettingDescriptions.get(string2);
            if (buildSettingDescription == null) {
                buildSettingDescription = new BuildSettingDescription();
                this.mySettingDescriptions.put(string2, buildSettingDescription);
            }
            if (string3 != null) {
                if ("name".equals(string3)) {
                    buildSettingDescription.displayName = string;
                    continue;
                }
                if (!"description".equals(string3)) continue;
                buildSettingDescription.displayDescription = string;
                continue;
            }
            if (string4 == null) continue;
            if (buildSettingDescription.valueSpecs == null) {
                buildSettingDescription.valueSpecs = new LinkedHashMap();
            }
            if ((valueDescription = buildSettingDescription.valueSpecs.get(string5)) == null) {
                valueDescription = new BuildSettingDescription.ValueDescription();
                buildSettingDescription.valueSpecs.put(string5, valueDescription);
            }
            if ("value".equals(string4)) {
                valueDescription.displayName = string;
                continue;
            }
            if (!"description".equals(string4)) continue;
            valueDescription.displayDescription = string;
        }
    }

    @Nullable
    public BuildSettingDescription getDescription(@Nullable String buildSetting) {
        return buildSetting == null ? null : this.mySettingDescriptions.get(buildSetting);
    }

    @Nullable
    public String getCategoryDescription(@Nullable String category) {
        return category == null ? null : this.myCategoryDescriptions.get(category);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

